/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResIoGroupTable;

public class IoGroup
extends TResIoGroupTable {
    public static IoGroupCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new IoGroupCursor(dBConnection, hashtable, vector);
    }

    public IoGroup() {
        this.clear();
    }

    public IoGroup(int n, String string, String string2, int n2) {
        this.clear();
        this.m_IoGroupId = n;
        this.m_GroupId = string;
        this.m_Name = string2;
        this.m_SubsystemId = n2;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_IoGroupId != Integer.MIN_VALUE) {
            hashtable.put(IoGroup.getColumnInfo("IO_GROUP_ID"), String.valueOf(this.m_IoGroupId));
        }
        if (this.m_GroupId != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(IoGroup.getColumnInfo("GROUP_ID"), this.m_GroupId);
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_Name == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key NAME not found");
        }
        this.htColsAndValues.put(IoGroup.getColumnInfo("NAME"), this.m_Name);
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htColsAndValues.put(IoGroup.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_IO_GROUP", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(IoGroup.getColumnInfo("NAME")) == null) {
            throw new SQLException(" ERROR: key NAME not found");
        }
        if (hashtable.get(IoGroup.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_IO_GROUP", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_Name == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key NAME not found");
        }
        this.htWhereClause.put(IoGroup.getColumnInfo("NAME"), this.m_Name);
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(IoGroup.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_IO_GROUP", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(IoGroup.getColumnInfo("NAME")) == null) {
            throw new SQLException(" ERROR: key NAME not found");
        }
        this.htWhereClause.put(IoGroup.getColumnInfo("NAME"), hashtable.get(IoGroup.getColumnInfo("NAME")));
        if (hashtable.get(IoGroup.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(IoGroup.getColumnInfo("SUBSYSTEM_ID"), hashtable.get(IoGroup.getColumnInfo("SUBSYSTEM_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_IO_GROUP", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_Name == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key NAME not found");
        }
        this.htWhereClause.put(IoGroup.getColumnInfo("NAME"), this.m_Name);
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(IoGroup.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_IO_GROUP", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(IoGroup.getColumnInfo("NAME")) == null) {
            throw new SQLException(" ERROR: key NAME not found");
        }
        this.htWhereClause.put(IoGroup.getColumnInfo("NAME"), hashtable.get(IoGroup.getColumnInfo("NAME")));
        if (hashtable.get(IoGroup.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(IoGroup.getColumnInfo("SUBSYSTEM_ID"), hashtable.get(IoGroup.getColumnInfo("SUBSYSTEM_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_IO_GROUP", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_Name == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key NAME not found");
        }
        this.htWhereClause.put(IoGroup.getColumnInfo("NAME"), this.m_Name);
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(IoGroup.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_IO_GROUP", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static IoGroup retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        IoGroup ioGroup = null;
        if (hashtable.get(IoGroup.getColumnInfo("NAME")) == null) {
            throw new SQLException(" ERROR: key NAME not found");
        }
        hashtable2.put(IoGroup.getColumnInfo("NAME"), hashtable.get(IoGroup.getColumnInfo("NAME")));
        if (hashtable.get(IoGroup.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        hashtable2.put(IoGroup.getColumnInfo("SUBSYSTEM_ID"), hashtable.get(IoGroup.getColumnInfo("SUBSYSTEM_ID")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_IO_GROUP", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                ioGroup = new IoGroup();
                ioGroup.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return ioGroup;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_IO_GROUP", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_IO_GROUP", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setIoGroupId(dBResultSet.getInt("IO_GROUP_ID"));
        this.setGroupId(dBResultSet.getString("GROUP_ID"));
        this.setName(dBResultSet.getString("NAME"));
        this.setSubsystemId(dBResultSet.getInt("SUBSYSTEM_ID"));
    }

    public static class IoGroupCursor
    extends DBCursor {
        private IoGroup element = new IoGroup();
        private DBConnection con;

        public IoGroupCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_IO_GROUP", dBConnection, hashtable, vector);
            this.con = dBConnection;
        }

        public IoGroup getObject() throws SQLException {
            IoGroup ioGroup = null;
            if (this.DBrs != null) {
                ioGroup = new IoGroup();
                ioGroup.setFields(this.con, this.DBrs);
            }
            return ioGroup;
        }

        public IoGroup getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

