/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResServerTable;

public class Server
extends TResServerTable {
    public static ServerCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new ServerCursor(dBConnection, hashtable, vector);
    }

    public Server() {
        this.clear();
    }

    public Server(int n, String string, double d, int n2, int n3, int n4, String string2) {
        this.clear();
        this.m_ServerId = n;
        this.m_ServerName = string;
        this.m_ServerToken = d;
        this.m_ComputerId = n2;
        this.m_PortNumber = n3;
        this.m_ServerType = n4;
        this.m_Password = string2;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_ServerName != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(Server.getColumnInfo("SERVER_NAME"), this.m_ServerName);
        }
        if (this.m_ServerToken != Double.MIN_VALUE) {
            hashtable.put(Server.getColumnInfo("SERVER_TOKEN"), String.valueOf(this.m_ServerToken));
        }
        if (this.m_ComputerId != Integer.MIN_VALUE) {
            hashtable.put(Server.getColumnInfo("COMPUTER_ID"), String.valueOf(this.m_ComputerId));
        }
        if (this.m_PortNumber != Integer.MIN_VALUE) {
            hashtable.put(Server.getColumnInfo("PORT_NUMBER"), String.valueOf(this.m_PortNumber));
        }
        if (this.m_ServerType != Integer.MIN_VALUE) {
            hashtable.put(Server.getColumnInfo("SERVER_TYPE"), String.valueOf(this.m_ServerType));
        }
        if (this.m_Password != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(Server.getColumnInfo("PASSWORD"), this.m_Password);
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_ServerId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SERVER_ID not found");
        }
        this.htColsAndValues.put(Server.getColumnInfo("SERVER_ID"), String.valueOf(this.m_ServerId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_SERVER", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(Server.getColumnInfo("SERVER_ID")) == null) {
            throw new SQLException(" ERROR: key SERVER_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_SERVER", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_ServerId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SERVER_ID not found");
        }
        this.htWhereClause.put(Server.getColumnInfo("SERVER_ID"), String.valueOf(this.m_ServerId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_SERVER", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(Server.getColumnInfo("SERVER_ID")) == null) {
            throw new SQLException(" ERROR: key SERVER_ID not found");
        }
        this.htWhereClause.put(Server.getColumnInfo("SERVER_ID"), hashtable.get(Server.getColumnInfo("SERVER_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_SERVER", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_ServerId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SERVER_ID not found");
        }
        this.htWhereClause.put(Server.getColumnInfo("SERVER_ID"), String.valueOf(this.m_ServerId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_SERVER", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(Server.getColumnInfo("SERVER_ID")) == null) {
            throw new SQLException(" ERROR: key SERVER_ID not found");
        }
        this.htWhereClause.put(Server.getColumnInfo("SERVER_ID"), hashtable.get(Server.getColumnInfo("SERVER_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_SERVER", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_ServerId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SERVER_ID not found");
        }
        this.htWhereClause.put(Server.getColumnInfo("SERVER_ID"), String.valueOf(this.m_ServerId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_SERVER", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static Server retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        Server server = null;
        if (hashtable.get(Server.getColumnInfo("SERVER_ID")) == null) {
            throw new SQLException(" ERROR: key SERVER_ID not found");
        }
        hashtable2.put(Server.getColumnInfo("SERVER_ID"), hashtable.get(Server.getColumnInfo("SERVER_ID")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_SERVER", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                server = new Server();
                server.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return server;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_SERVER", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_SERVER", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setServerId(dBResultSet.getInt("SERVER_ID"));
        this.setServerName(dBResultSet.getString("SERVER_NAME"));
        this.setServerToken(dBResultSet.getDouble("SERVER_TOKEN"));
        this.setComputerId(dBResultSet.getInt("COMPUTER_ID"));
        this.setPortNumber(dBResultSet.getInt("PORT_NUMBER"));
        this.setServerType(dBResultSet.getInt("SERVER_TYPE"));
        this.setPassword(dBResultSet.getString("PASSWORD"));
    }

    public static class ServerCursor
    extends DBCursor {
        private Server element = new Server();
        private DBConnection con;

        public ServerCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_SERVER", dBConnection, hashtable, vector);
            this.con = dBConnection;
        }

        public Server getObject() throws SQLException {
            Server server = null;
            if (this.DBrs != null) {
                server = new Server();
                server.setFields(this.con, this.DBrs);
            }
            return server;
        }

        public Server getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

