/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResSwitch2portSnapshotTable;

public class Switch2portSnapshot
extends TResSwitch2portSnapshotTable {
    public static Switch2portSnapshotCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new Switch2portSnapshotCursor(dBConnection, hashtable, vector);
    }

    public Switch2portSnapshot() {
        this.clear();
    }

    public Switch2portSnapshot(int n, int n2, String string, int n3, int n4, Timestamp timestamp) {
        this.clear();
        this.m_SnapshotId = n;
        this.m_Switch2portId = n2;
        this.m_SwitchWwn = string;
        this.m_PortId = n3;
        this.m_Detectable = n4;
        this.m_UpdateTimestamp = timestamp;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_Switch2portId != Integer.MIN_VALUE) {
            hashtable.put(Switch2portSnapshot.getColumnInfo("SWITCH2PORT_ID"), String.valueOf(this.m_Switch2portId));
        }
        if (this.m_Detectable != Integer.MIN_VALUE) {
            hashtable.put(Switch2portSnapshot.getColumnInfo("DETECTABLE"), String.valueOf(this.m_Detectable));
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(Switch2portSnapshot.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_SwitchWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SWITCH_WWN not found");
        }
        this.htColsAndValues.put(Switch2portSnapshot.getColumnInfo("SWITCH_WWN"), this.m_SwitchWwn);
        if (this.m_PortId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key PORT_ID not found");
        }
        this.htColsAndValues.put(Switch2portSnapshot.getColumnInfo("PORT_ID"), String.valueOf(this.m_PortId));
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htColsAndValues.put(Switch2portSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_SWITCH2PORT_SNAPSHOT", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(Switch2portSnapshot.getColumnInfo("SWITCH_WWN")) == null) {
            throw new SQLException(" ERROR: key SWITCH_WWN not found");
        }
        if (hashtable.get(Switch2portSnapshot.getColumnInfo("PORT_ID")) == null) {
            throw new SQLException(" ERROR: key PORT_ID not found");
        }
        if (hashtable.get(Switch2portSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_SWITCH2PORT_SNAPSHOT", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_SwitchWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SWITCH_WWN not found");
        }
        this.htWhereClause.put(Switch2portSnapshot.getColumnInfo("SWITCH_WWN"), this.m_SwitchWwn);
        if (this.m_PortId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key PORT_ID not found");
        }
        this.htWhereClause.put(Switch2portSnapshot.getColumnInfo("PORT_ID"), String.valueOf(this.m_PortId));
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(Switch2portSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_SWITCH2PORT_SNAPSHOT", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(Switch2portSnapshot.getColumnInfo("SWITCH_WWN")) == null) {
            throw new SQLException(" ERROR: key SWITCH_WWN not found");
        }
        this.htWhereClause.put(Switch2portSnapshot.getColumnInfo("SWITCH_WWN"), hashtable.get(Switch2portSnapshot.getColumnInfo("SWITCH_WWN")));
        if (hashtable.get(Switch2portSnapshot.getColumnInfo("PORT_ID")) == null) {
            throw new SQLException(" ERROR: key PORT_ID not found");
        }
        this.htWhereClause.put(Switch2portSnapshot.getColumnInfo("PORT_ID"), hashtable.get(Switch2portSnapshot.getColumnInfo("PORT_ID")));
        if (hashtable.get(Switch2portSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(Switch2portSnapshot.getColumnInfo("SNAPSHOT_ID"), hashtable.get(Switch2portSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_SWITCH2PORT_SNAPSHOT", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_SwitchWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SWITCH_WWN not found");
        }
        this.htWhereClause.put(Switch2portSnapshot.getColumnInfo("SWITCH_WWN"), this.m_SwitchWwn);
        if (this.m_PortId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key PORT_ID not found");
        }
        this.htWhereClause.put(Switch2portSnapshot.getColumnInfo("PORT_ID"), String.valueOf(this.m_PortId));
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(Switch2portSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_SWITCH2PORT_SNAPSHOT", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(Switch2portSnapshot.getColumnInfo("SWITCH_WWN")) == null) {
            throw new SQLException(" ERROR: key SWITCH_WWN not found");
        }
        this.htWhereClause.put(Switch2portSnapshot.getColumnInfo("SWITCH_WWN"), hashtable.get(Switch2portSnapshot.getColumnInfo("SWITCH_WWN")));
        if (hashtable.get(Switch2portSnapshot.getColumnInfo("PORT_ID")) == null) {
            throw new SQLException(" ERROR: key PORT_ID not found");
        }
        this.htWhereClause.put(Switch2portSnapshot.getColumnInfo("PORT_ID"), hashtable.get(Switch2portSnapshot.getColumnInfo("PORT_ID")));
        if (hashtable.get(Switch2portSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(Switch2portSnapshot.getColumnInfo("SNAPSHOT_ID"), hashtable.get(Switch2portSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_SWITCH2PORT_SNAPSHOT", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_SwitchWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SWITCH_WWN not found");
        }
        this.htWhereClause.put(Switch2portSnapshot.getColumnInfo("SWITCH_WWN"), this.m_SwitchWwn);
        if (this.m_PortId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key PORT_ID not found");
        }
        this.htWhereClause.put(Switch2portSnapshot.getColumnInfo("PORT_ID"), String.valueOf(this.m_PortId));
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(Switch2portSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_SWITCH2PORT_SNAPSHOT", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static Switch2portSnapshot retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        Switch2portSnapshot switch2portSnapshot = null;
        if (hashtable.get(Switch2portSnapshot.getColumnInfo("SWITCH_WWN")) == null) {
            throw new SQLException(" ERROR: key SWITCH_WWN not found");
        }
        hashtable2.put(Switch2portSnapshot.getColumnInfo("SWITCH_WWN"), hashtable.get(Switch2portSnapshot.getColumnInfo("SWITCH_WWN")));
        if (hashtable.get(Switch2portSnapshot.getColumnInfo("PORT_ID")) == null) {
            throw new SQLException(" ERROR: key PORT_ID not found");
        }
        hashtable2.put(Switch2portSnapshot.getColumnInfo("PORT_ID"), hashtable.get(Switch2portSnapshot.getColumnInfo("PORT_ID")));
        if (hashtable.get(Switch2portSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        hashtable2.put(Switch2portSnapshot.getColumnInfo("SNAPSHOT_ID"), hashtable.get(Switch2portSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_SWITCH2PORT_SNAPSHOT", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                switch2portSnapshot = new Switch2portSnapshot();
                switch2portSnapshot.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return switch2portSnapshot;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_SWITCH2PORT_SNAPSHOT", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_SWITCH2PORT_SNAPSHOT", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setSnapshotId(dBResultSet.getInt("SNAPSHOT_ID"));
        this.setSwitch2portId(dBResultSet.getInt("SWITCH2PORT_ID"));
        this.setSwitchWwn(dBResultSet.getString("SWITCH_WWN"));
        this.setPortId(dBResultSet.getInt("PORT_ID"));
        this.setDetectable(dBResultSet.getInt("DETECTABLE"));
        this.setUpdateTimestamp(dBResultSet.getTimestamp("UPDATE_TIMESTAMP"));
    }

    public static class Switch2portSnapshotCursor
    extends DBCursor {
        private Switch2portSnapshot element = new Switch2portSnapshot();
        private DBConnection con;

        public Switch2portSnapshotCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_SWITCH2PORT_SNAPSHOT", dBConnection, hashtable, vector);
            this.con = dBConnection;
        }

        public Switch2portSnapshot getObject() throws SQLException {
            Switch2portSnapshot switch2portSnapshot = null;
            if (this.DBrs != null) {
                switch2portSnapshot = new Switch2portSnapshot();
                switch2portSnapshot.setFields(this.con, this.DBrs);
            }
            return switch2portSnapshot;
        }

        public Switch2portSnapshot getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

