/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResTapeLibraryTable;

public class TapeLibrary
extends TResTapeLibraryTable {
    private String m_CreationClassNameId_str;

    public void setCreationClassName(String string) {
        this.m_CreationClassNameId_str = string;
    }

    public String getCreationClassName() {
        return this.m_CreationClassNameId_str;
    }

    public static TapeLibraryCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new TapeLibraryCursor(dBConnection, hashtable, vector);
    }

    public TapeLibrary() {
        this.clear();
    }

    public TapeLibrary(int n, String string, short s, short s2, String string2, String string3, String string4, String string5, String string6, short s3, int n2, short s4, short s5, Timestamp timestamp, String string7, int n3, String string8, int n4, int n5, Timestamp timestamp2, String string9, String string10, String string11, String string12) {
        this.clear();
        this.m_TapeLibraryId = n;
        this.m_Name = string;
        this.m_NameFormat = s;
        this.m_CreationClassNameId = s2;
        this.m_ElementName = string2;
        this.m_PrimaryOwnerName = string3;
        this.m_PrimaryOwnerContact = string4;
        this.m_AccessInfo = string5;
        this.m_FirmwareVersion = string6;
        this.m_Detectable = s3;
        this.m_OperationalStatus = n2;
        this.m_ConsolidatedStatus = s4;
        this.m_PropagatedStatus = s5;
        this.m_ChangedTimestamp = timestamp;
        this.m_DisplayName = string7;
        this.m_MaxCartridges = n3;
        this.m_Description = string8;
        this.m_CollectionStatus = n4;
        this.m_GroupId = n5;
        this.m_UpdateTimestamp = timestamp2;
        this.m_UserProvidedName = string9;
        this.m_UserAttrib1 = string10;
        this.m_UserAttrib2 = string11;
        this.m_UserAttrib3 = string12;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_TapeLibraryId != Integer.MIN_VALUE) {
            hashtable.put(TapeLibrary.getColumnInfo("TAPE_LIBRARY_ID"), String.valueOf(this.m_TapeLibraryId));
        }
        if (this.m_CreationClassNameId != Short.MIN_VALUE) {
            hashtable.put(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(this.m_CreationClassNameId));
        }
        if (this.m_ElementName != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(TapeLibrary.getColumnInfo("ELEMENT_NAME"), this.m_ElementName);
        }
        if (this.m_PrimaryOwnerName != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(TapeLibrary.getColumnInfo("PRIMARY_OWNER_NAME"), this.m_PrimaryOwnerName);
        }
        if (this.m_PrimaryOwnerContact != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(TapeLibrary.getColumnInfo("PRIMARY_OWNER_CONTACT"), this.m_PrimaryOwnerContact);
        }
        if (this.m_AccessInfo != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(TapeLibrary.getColumnInfo("ACCESS_INFO"), this.m_AccessInfo);
        }
        if (this.m_FirmwareVersion != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(TapeLibrary.getColumnInfo("FIRMWARE_VERSION"), this.m_FirmwareVersion);
        }
        if (this.m_Detectable != Short.MIN_VALUE) {
            hashtable.put(TapeLibrary.getColumnInfo("DETECTABLE"), String.valueOf(this.m_Detectable));
        }
        if (this.m_OperationalStatus != Integer.MIN_VALUE) {
            hashtable.put(TapeLibrary.getColumnInfo("OPERATIONAL_STATUS"), String.valueOf(this.m_OperationalStatus));
        }
        if (this.m_ConsolidatedStatus != Short.MIN_VALUE) {
            hashtable.put(TapeLibrary.getColumnInfo("CONSOLIDATED_STATUS"), String.valueOf(this.m_ConsolidatedStatus));
        }
        if (this.m_PropagatedStatus != Short.MIN_VALUE) {
            hashtable.put(TapeLibrary.getColumnInfo("PROPAGATED_STATUS"), String.valueOf(this.m_PropagatedStatus));
        }
        if (this.m_ChangedTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(TapeLibrary.getColumnInfo("CHANGED_TIMESTAMP"), this.m_ChangedTimestamp);
        }
        if (this.m_DisplayName != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(TapeLibrary.getColumnInfo("DISPLAY_NAME"), this.m_DisplayName);
        }
        if (this.m_MaxCartridges != Integer.MIN_VALUE) {
            hashtable.put(TapeLibrary.getColumnInfo("MAX_CARTRIDGES"), String.valueOf(this.m_MaxCartridges));
        }
        if (this.m_Description != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(TapeLibrary.getColumnInfo("DESCRIPTION"), this.m_Description);
        }
        if (this.m_CollectionStatus != Integer.MIN_VALUE) {
            hashtable.put(TapeLibrary.getColumnInfo("COLLECTION_STATUS"), String.valueOf(this.m_CollectionStatus));
        }
        if (this.m_GroupId != Integer.MIN_VALUE) {
            hashtable.put(TapeLibrary.getColumnInfo("GROUP_ID"), String.valueOf(this.m_GroupId));
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(TapeLibrary.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
        if (this.m_UserProvidedName != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(TapeLibrary.getColumnInfo("USER_PROVIDED_NAME"), this.m_UserProvidedName);
        }
        if (this.m_UserAttrib1 != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(TapeLibrary.getColumnInfo("USER_ATTRIB1"), this.m_UserAttrib1);
        }
        if (this.m_UserAttrib2 != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(TapeLibrary.getColumnInfo("USER_ATTRIB2"), this.m_UserAttrib2);
        }
        if (this.m_UserAttrib3 != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(TapeLibrary.getColumnInfo("USER_ATTRIB3"), this.m_UserAttrib3);
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_Name == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key NAME not found");
        }
        this.htColsAndValues.put(TapeLibrary.getColumnInfo("NAME"), this.m_Name);
        if (this.m_NameFormat == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key NAME_FORMAT not found");
        }
        this.htColsAndValues.put(TapeLibrary.getColumnInfo("NAME_FORMAT"), String.valueOf(this.m_NameFormat));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_TAPE_LIBRARY", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(TapeLibrary.getColumnInfo("NAME")) == null) {
            throw new SQLException(" ERROR: key NAME not found");
        }
        if (hashtable.get(TapeLibrary.getColumnInfo("NAME_FORMAT")) == null) {
            throw new SQLException(" ERROR: key NAME_FORMAT not found");
        }
        return DBQueryAssistant.performInsert("T_RES_TAPE_LIBRARY", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_Name == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key NAME not found");
        }
        this.htWhereClause.put(TapeLibrary.getColumnInfo("NAME"), this.m_Name);
        if (this.m_NameFormat == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key NAME_FORMAT not found");
        }
        this.htWhereClause.put(TapeLibrary.getColumnInfo("NAME_FORMAT"), String.valueOf(this.m_NameFormat));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_TAPE_LIBRARY", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(TapeLibrary.getColumnInfo("NAME")) == null) {
            throw new SQLException(" ERROR: key NAME not found");
        }
        this.htWhereClause.put(TapeLibrary.getColumnInfo("NAME"), hashtable.get(TapeLibrary.getColumnInfo("NAME")));
        if (hashtable.get(TapeLibrary.getColumnInfo("NAME_FORMAT")) == null) {
            throw new SQLException(" ERROR: key NAME_FORMAT not found");
        }
        this.htWhereClause.put(TapeLibrary.getColumnInfo("NAME_FORMAT"), hashtable.get(TapeLibrary.getColumnInfo("NAME_FORMAT")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_TAPE_LIBRARY", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_Name == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key NAME not found");
        }
        this.htWhereClause.put(TapeLibrary.getColumnInfo("NAME"), this.m_Name);
        if (this.m_NameFormat == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key NAME_FORMAT not found");
        }
        this.htWhereClause.put(TapeLibrary.getColumnInfo("NAME_FORMAT"), String.valueOf(this.m_NameFormat));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_TAPE_LIBRARY", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(TapeLibrary.getColumnInfo("NAME")) == null) {
            throw new SQLException(" ERROR: key NAME not found");
        }
        this.htWhereClause.put(TapeLibrary.getColumnInfo("NAME"), hashtable.get(TapeLibrary.getColumnInfo("NAME")));
        if (hashtable.get(TapeLibrary.getColumnInfo("NAME_FORMAT")) == null) {
            throw new SQLException(" ERROR: key NAME_FORMAT not found");
        }
        this.htWhereClause.put(TapeLibrary.getColumnInfo("NAME_FORMAT"), hashtable.get(TapeLibrary.getColumnInfo("NAME_FORMAT")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_TAPE_LIBRARY", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_Name == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key NAME not found");
        }
        this.htWhereClause.put(TapeLibrary.getColumnInfo("NAME"), this.m_Name);
        if (this.m_NameFormat == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key NAME_FORMAT not found");
        }
        this.htWhereClause.put(TapeLibrary.getColumnInfo("NAME_FORMAT"), String.valueOf(this.m_NameFormat));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_TAPE_LIBRARY", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static TapeLibrary retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        TapeLibrary tapeLibrary = null;
        if (hashtable.get(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(TapeLibrary.getColumnInfo("NAME")) == null) {
            throw new SQLException(" ERROR: key NAME not found");
        }
        hashtable2.put(TapeLibrary.getColumnInfo("NAME"), hashtable.get(TapeLibrary.getColumnInfo("NAME")));
        if (hashtable.get(TapeLibrary.getColumnInfo("NAME_FORMAT")) == null) {
            throw new SQLException(" ERROR: key NAME_FORMAT not found");
        }
        hashtable2.put(TapeLibrary.getColumnInfo("NAME_FORMAT"), hashtable.get(TapeLibrary.getColumnInfo("NAME_FORMAT")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_TAPE_LIBRARY", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                tapeLibrary = new TapeLibrary();
                tapeLibrary.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return tapeLibrary;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable2.get(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable2.put(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable2.get(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_TAPE_LIBRARY", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_TAPE_LIBRARY", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setTapeLibraryId(dBResultSet.getInt("TAPE_LIBRARY_ID"));
        this.setName(dBResultSet.getString("NAME"));
        this.setNameFormat(dBResultSet.getShort("NAME_FORMAT"));
        this.setCreationClassNameId(dBResultSet.getShort("CREATION_CLASS_NAME_ID"));
        this.setCreationClassName(Normalizer.CreationClassNameGetName(dBConnection, this.m_CreationClassNameId));
        this.setElementName(dBResultSet.getString("ELEMENT_NAME"));
        this.setPrimaryOwnerName(dBResultSet.getString("PRIMARY_OWNER_NAME"));
        this.setPrimaryOwnerContact(dBResultSet.getString("PRIMARY_OWNER_CONTACT"));
        this.setAccessInfo(dBResultSet.getString("ACCESS_INFO"));
        this.setFirmwareVersion(dBResultSet.getString("FIRMWARE_VERSION"));
        this.setDetectable(dBResultSet.getShort("DETECTABLE"));
        this.setOperationalStatus(dBResultSet.getInt("OPERATIONAL_STATUS"));
        this.setConsolidatedStatus(dBResultSet.getShort("CONSOLIDATED_STATUS"));
        this.setPropagatedStatus(dBResultSet.getShort("PROPAGATED_STATUS"));
        this.setChangedTimestamp(dBResultSet.getTimestamp("CHANGED_TIMESTAMP"));
        this.setDisplayName(dBResultSet.getString("DISPLAY_NAME"));
        this.setMaxCartridges(dBResultSet.getInt("MAX_CARTRIDGES"));
        this.setDescription(dBResultSet.getString("DESCRIPTION"));
        this.setCollectionStatus(dBResultSet.getInt("COLLECTION_STATUS"));
        this.setGroupId(dBResultSet.getInt("GROUP_ID"));
        this.setUpdateTimestamp(dBResultSet.getTimestamp("UPDATE_TIMESTAMP"));
        this.setUserProvidedName(dBResultSet.getString("USER_PROVIDED_NAME"));
        this.setUserAttrib1(dBResultSet.getString("USER_ATTRIB1"));
        this.setUserAttrib2(dBResultSet.getString("USER_ATTRIB2"));
        this.setUserAttrib3(dBResultSet.getString("USER_ATTRIB3"));
    }

    public static class TapeLibraryCursor
    extends DBCursor {
        private TapeLibrary element = new TapeLibrary();
        private DBConnection con;

        private static Hashtable normalize(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
            if (hashtable == null) {
                return null;
            }
            if (hashtable.get(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
                hashtable.put(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID")))));
            }
            return hashtable;
        }

        public TapeLibraryCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_TAPE_LIBRARY", dBConnection, TapeLibraryCursor.normalize(dBConnection, hashtable), vector);
            this.con = dBConnection;
        }

        public TapeLibrary getObject() throws SQLException {
            TapeLibrary tapeLibrary = null;
            if (this.DBrs != null) {
                tapeLibrary = new TapeLibrary();
                tapeLibrary.setFields(this.con, this.DBrs);
            }
            return tapeLibrary;
        }

        public TapeLibrary getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

