/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.history.snapshot;

import java.sql.Timestamp;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.SnapshotMetadata;
import org.eclipse.aperi.infrastructure.database.sql.SqlSnapshotMetadata;
import org.eclipse.aperi.infrastructure.database.tables.TResSnapshotMetadataTable;
import org.eclipse.aperi.infrastructure.history.snapshot.SnapshotCimom;
import org.eclipse.aperi.infrastructure.history.snapshot.SnapshotStorageSubsystem;
import org.eclipse.aperi.infrastructure.history.snapshot.SnapshotSwitch;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class SnapshotService {
    public static final int TYPE_STORAGE_SUBSYSTEM = 1;
    public static final int TYPE_SWITCH = 2;
    public static final int TYPE_CIMOM = 3;
    public static final int TYPE_HOST = 4;
    public static final int TYPE_FABRIC = 5;
    public static final int CONFIG_DB_SNAPSHOT = 1;
    public static final int REFERENCE_SNAPSHOT = 2;
    private static ILogger traceLogger = null;
    private static String className = SnapshotService.class.getName();
    private static boolean TRACE = false;

    static {
        traceLogger = DBConstants.getLogger();
        if (traceLogger != null) {
            TRACE = traceLogger.isLogging();
        }
    }

    public static int createSnapshot(int n, int n2) throws Exception {
        String string = "createSnapshot (" + n + ", " + n2 + ")";
        int n3 = -1;
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string);
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
        return n3;
    }

    public static void deleteSnapshot(int n) throws Exception {
        String string = "deleteSnapshot(" + n + ")";
        DBConnection dBConnection = null;
        int n2 = -1;
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string);
        }
        try {
            try {
                DBConnPoolDataSource dBConnPoolDataSource = DBConnPoolDataSource.getInstance();
                dBConnection = (DBConnection)dBConnPoolDataSource.getPooledConnection();
                SnapshotMetadata snapshotMetadata = new SnapshotMetadata();
                snapshotMetadata.setSnapshotId(n);
                boolean bl = snapshotMetadata.retrieve(dBConnection);
                if (!bl) {
                    Exception exception = new Exception("Snapshot ID " + n + " does not exist");
                    if (TRACE) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string, exception);
                    }
                    throw exception;
                }
                snapshotMetadata.getSystemId();
                n2 = snapshotMetadata.getSystemType();
                if (n2 == 1) {
                    SnapshotStorageSubsystem.delete(dBConnection, n);
                } else if (n2 == 2) {
                    SnapshotSwitch.delete(dBConnection, n);
                } else if (n2 == 3) {
                    SnapshotCimom.delete(dBConnection, n);
                } else {
                    throw new Exception("Internal error: System type " + n2 + " not supported by Snapshot Service");
                }
                dBConnection.commit();
            }
            catch (Exception exception) {
                if (dBConnection != null) {
                    try {
                        dBConnection.rollback();
                        dBConnection.close();
                    }
                    catch (Exception exception2) {}
                }
                if (TRACE) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string, exception);
                }
                throw exception;
            }
        }
        finally {
            dBConnection.close();
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
    }

    public static void deleteSystemSnapshots(int n, int n2, Timestamp timestamp) throws Exception {
        String string = "deleteSystemSnapshots(" + n + ", " + n2 + ")";
        DBConnection dBConnection = null;
        DBCursor dBCursor = null;
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string);
        }
        try {
            try {
                DBConnPoolDataSource dBConnPoolDataSource = DBConnPoolDataSource.getInstance();
                dBConnection = (DBConnection)dBConnPoolDataSource.getPooledConnection();
                if (n2 != 1 && n2 != 2 && n2 != 3) {
                    Exception exception = new Exception("deleteSystemSnapshots: invalid system type - " + n2);
                    if (TRACE) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string, exception);
                    }
                    throw exception;
                }
                Hashtable<ColumnInfo, Object> hashtable = new Hashtable<ColumnInfo, Object>();
                SnapshotMetadata snapshotMetadata = null;
                hashtable.put(TResSnapshotMetadataTable.getColumnInfo("SYSTEM_ID"), String.valueOf(n));
                hashtable.put(TResSnapshotMetadataTable.getColumnInfo("SYSTEM_TYPE"), String.valueOf(n2));
                hashtable.put(TResSnapshotMetadataTable.getColumnInfo("SNAPSHOT_TYPE"), String.valueOf(1));
                if (timestamp != null) {
                    ColumnInfo columnInfo = TResSnapshotMetadataTable.getColumnInfo("SNAPSHOT_TIME");
                    columnInfo = columnInfo.addOperator("<");
                    hashtable.put(columnInfo, timestamp);
                }
                dBCursor = SnapshotMetadata.getCursor(dBConnection, hashtable, null);
                while (dBCursor.next()) {
                    snapshotMetadata = ((SnapshotMetadata.SnapshotMetadataCursor)dBCursor).getAttributes();
                    SnapshotService.deleteSnapshot(snapshotMetadata.getSnapshotId());
                }
            }
            catch (Exception exception) {
                if (dBConnection != null) {
                    try {
                        dBConnection.rollback();
                        dBConnection.close();
                    }
                    catch (Exception exception2) {}
                }
                if (TRACE) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string, exception);
                }
                throw exception;
            }
        }
        finally {
            dBConnection.close();
            if (dBCursor != null) {
                dBCursor.close();
            }
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
    }

    public static Timestamp snapshotIdToTs(int n) throws Exception {
        String string = "snapshotIdToTs(" + n + ")";
        DBConnection dBConnection = null;
        Timestamp timestamp = null;
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string);
        }
        try {
            try {
                DBConnPoolDataSource dBConnPoolDataSource = DBConnPoolDataSource.getInstance();
                dBConnection = (DBConnection)dBConnPoolDataSource.getPooledConnection();
                SnapshotMetadata snapshotMetadata = new SnapshotMetadata();
                snapshotMetadata.setSnapshotId(n);
                boolean bl = snapshotMetadata.retrieve(dBConnection);
                if (bl) {
                    timestamp = snapshotMetadata.getSnapshotTime();
                }
            }
            catch (Exception exception) {
                if (dBConnection != null) {
                    try {
                        dBConnection.rollback();
                        dBConnection.close();
                    }
                    catch (Exception exception2) {}
                }
                if (TRACE) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string, exception);
                }
                throw exception;
            }
        }
        finally {
            dBConnection.close();
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
        return timestamp;
    }

    public static int tsToSnapshotId(int n, int n2, Timestamp timestamp) throws Exception {
        String string = "tsToSnapshotId(" + n + ", " + n2 + ")";
        DBConnection dBConnection = null;
        DBResultSet dBResultSet = null;
        int n3 = 0;
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string);
        }
        try {
            try {
                DBConnPoolDataSource dBConnPoolDataSource = DBConnPoolDataSource.getInstance();
                dBConnection = (DBConnection)dBConnPoolDataSource.getPooledConnection();
                Hashtable<ColumnInfo, Object> hashtable = new Hashtable<ColumnInfo, Object>();
                hashtable.put(TResSnapshotMetadataTable.getColumnInfo("SYSTEM_ID"), String.valueOf(n));
                hashtable.put(TResSnapshotMetadataTable.getColumnInfo("SYSTEM_TYPE"), String.valueOf(n2));
                if (timestamp == null) {
                    dBResultSet = SqlSnapshotMetadata.sqlQuery(dBConnection, SqlSnapshotMetadata.mostRecentSystemSnapshot, hashtable);
                } else {
                    hashtable.put(TResSnapshotMetadataTable.getColumnInfo("SNAPSHOT_TIME"), timestamp);
                    dBResultSet = SqlSnapshotMetadata.sqlQuery(dBConnection, SqlSnapshotMetadata.mostRecentSystemSnapshotBeforeTimeT, hashtable);
                }
                if (dBResultSet.next()) {
                    n3 = dBResultSet.getInt(1);
                }
            }
            catch (Exception exception) {
                if (dBConnection != null) {
                    try {
                        dBConnection.close();
                    }
                    catch (Exception exception2) {}
                }
                if (TRACE) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string, exception);
                }
                throw exception;
            }
        }
        finally {
            dBConnection.close();
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
        return n3;
    }
}

