/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.history.snapshot;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.AutoIdentifier;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.ParameterizedSql;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyPortSnapshot;
import org.eclipse.aperi.infrastructure.database.objects.CimkeySwitchSnapshot;
import org.eclipse.aperi.infrastructure.database.objects.ModelSnapshot;
import org.eclipse.aperi.infrastructure.database.objects.PortSnapshot;
import org.eclipse.aperi.infrastructure.database.objects.SnapshotMetadata;
import org.eclipse.aperi.infrastructure.database.objects.Switch;
import org.eclipse.aperi.infrastructure.database.objects.Switch2portSnapshot;
import org.eclipse.aperi.infrastructure.database.objects.SwitchSnapshot;
import org.eclipse.aperi.infrastructure.database.objects.VendorSnapshot;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyPortSnapshotTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeySwitchSnapshotTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeySwitchTable;
import org.eclipse.aperi.infrastructure.database.tables.TResModelSnapshotTable;
import org.eclipse.aperi.infrastructure.database.tables.TResPortSnapshotTable;
import org.eclipse.aperi.infrastructure.database.tables.TResSnapshotMetadataTable;
import org.eclipse.aperi.infrastructure.database.tables.TResSwitch2portSnapshotTable;
import org.eclipse.aperi.infrastructure.database.tables.TResSwitch2portTable;
import org.eclipse.aperi.infrastructure.database.tables.TResSwitchSnapshotTable;
import org.eclipse.aperi.infrastructure.database.tables.TResSwitchTable;
import org.eclipse.aperi.infrastructure.database.tables.TResVendorSnapshotTable;
import org.eclipse.aperi.infrastructure.history.snapshot.SnapshotUtil;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class SnapshotSwitch {
    private static String SWITCH_TABLE = "T_RES_SWITCH";
    private static String SWITCH2PORT_TABLE = "T_RES_SWITCH2PORT";
    private static String PORT_TABLE = "T_RES_PORT";
    private static String CIMKEY_SWITCH_TABLE = "T_RES_CIMKEY_SWITCH";
    private static String CIMKEY_PORT_TABLE = "T_RES_CIMKEY_PORT";
    private static String VENDOR_TABLE = "T_RES_VENDOR";
    private static String MODEL_TABLE = "T_RES_MODEL";
    private static ILogger traceLogger = null;
    private static String className = SnapshotSwitch.class.getName();
    private static boolean TRACE = false;

    static {
        traceLogger = DBConstants.getLogger();
        if (traceLogger != null) {
            TRACE = traceLogger.isLogging();
        }
    }

    static int create(DBConnection dBConnection, int n) throws Exception {
        String string = "create(" + n + ")";
        int n2 = -1;
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        Switch switch_ = null;
        DBCursor dBCursor = null;
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string);
        }
        try {
            try {
                hashtable.put(TResSwitchTable.getColumnInfo("SWITCH_ID"), String.valueOf(n));
                dBCursor = Switch.getCursor(dBConnection, hashtable, null);
                if (dBCursor.next()) {
                    switch_ = ((Switch.SwitchCursor)dBCursor).getAttributes();
                }
                if (switch_ == null) {
                    Exception exception = new Exception("Bad system ID: " + n);
                    if (TRACE) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string, exception);
                    }
                    throw exception;
                }
                n2 = AutoIdentifier.getIdentifier(9, 1);
                Timestamp timestamp = CurrentTime.getTimestamp(dBConnection);
                SnapshotUtil.createSnapshotMetadata(dBConnection, n2, timestamp, n, 2, true);
                SnapshotSwitch.createSwitchSnapshot(dBConnection, switch_, n2, SWITCH_TABLE);
                SnapshotSwitch.createCimkeySwitchSnapshot(dBConnection, switch_, n2, CIMKEY_SWITCH_TABLE);
                SnapshotSwitch.createVendorSnapshot(dBConnection, switch_, n2, VENDOR_TABLE);
                SnapshotSwitch.createModelSnapshot(dBConnection, switch_, n2, MODEL_TABLE);
                SnapshotSwitch.createPortSnapshot(dBConnection, switch_, n2, PORT_TABLE);
                SnapshotSwitch.createSwitch2PortSnapshot(dBConnection, switch_, n2, SWITCH2PORT_TABLE);
                SnapshotSwitch.createCimkeyPortSnapshot(dBConnection, switch_, n2, CIMKEY_PORT_TABLE);
            }
            catch (SQLException sQLException) {
                try {
                    dBConnection.rollback();
                }
                catch (SQLException sQLException2) {}
                if (TRACE) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string, sQLException);
                }
                throw sQLException;
            }
        }
        finally {
            if (dBCursor != null) {
                dBCursor.close();
            }
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
        return n2;
    }

    static void delete(DBConnection dBConnection, int n) throws SQLException {
        String string = "delete(" + n + ")";
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string);
        }
        try {
            hashtable.clear();
            hashtable.put(TResCimkeyPortSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(n));
            CimkeyPortSnapshot.deletes(dBConnection, hashtable);
            hashtable.clear();
            hashtable.put(TResSwitch2portSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(n));
            Switch2portSnapshot.deletes(dBConnection, hashtable);
            hashtable.clear();
            hashtable.put(TResPortSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(n));
            PortSnapshot.deletes(dBConnection, hashtable);
            hashtable.clear();
            hashtable.put(TResModelSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(n));
            ModelSnapshot.deletes(dBConnection, hashtable);
            hashtable.clear();
            hashtable.put(TResVendorSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(n));
            VendorSnapshot.deletes(dBConnection, hashtable);
            hashtable.clear();
            hashtable.put(TResCimkeySwitchSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(n));
            CimkeySwitchSnapshot.deletes(dBConnection, hashtable);
            hashtable.put(TResSwitchSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(n));
            SwitchSnapshot.deletes(dBConnection, hashtable);
            hashtable.put(TResSnapshotMetadataTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(n));
            SnapshotMetadata.deletes(dBConnection, hashtable);
        }
        catch (SQLException sQLException) {
            try {
                dBConnection.rollback();
            }
            catch (SQLException sQLException2) {}
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string, sQLException);
            }
            throw sQLException;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
    }

    private static void createSwitchSnapshot(DBConnection dBConnection, Switch switch_, int n, String string) throws SQLException {
        String string2 = "createSwitchSnapshot(" + n + ", " + string + ")";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> hashtable2 = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string2);
        }
        try {
            String string3 = SnapshotUtil.getSnapshotCreationStmt(2, string);
            if (string3 != null) {
                hashtable.put("<<SNAPSHOT_ID>>", String.valueOf(n));
                hashtable2.put(TResSwitchTable.getColumnInfo("SWITCH_WWN"), switch_.getSwitchWwn());
                ParameterizedSql.sqlUpdate(dBConnection, string3, hashtable, hashtable2);
            }
        }
        catch (SQLException sQLException) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, sQLException);
            }
            throw sQLException;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
    }

    private static void createSwitch2PortSnapshot(DBConnection dBConnection, Switch switch_, int n, String string) throws SQLException {
        String string2 = "createSwitch2PortSnapshot(" + n + ", " + string + ")";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> hashtable2 = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string2);
        }
        try {
            String string3 = SnapshotUtil.getSnapshotCreationStmt(2, string);
            if (string3 != null) {
                hashtable.put("<<SNAPSHOT_ID>>", String.valueOf(n));
                hashtable2.put(TResSwitch2portTable.getColumnInfo("SWITCH_WWN"), switch_.getSwitchWwn());
                ParameterizedSql.sqlUpdate(dBConnection, string3, hashtable, hashtable2);
            }
        }
        catch (SQLException sQLException) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, sQLException);
            }
            throw sQLException;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
    }

    private static void createPortSnapshot(DBConnection dBConnection, Switch switch_, int n, String string) throws SQLException {
        String string2 = "createPortSnapshot(" + n + ", " + string + ")";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> hashtable2 = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string2);
        }
        try {
            String string3 = SnapshotUtil.getSnapshotCreationStmt(2, string);
            if (string3 != null) {
                hashtable.put("<<SNAPSHOT_ID>>", String.valueOf(n));
                hashtable2.put(TResSwitch2portTable.getColumnInfo("SWITCH_WWN"), switch_.getSwitchWwn());
                ParameterizedSql.sqlUpdate(dBConnection, string3, hashtable, hashtable2);
            }
        }
        catch (SQLException sQLException) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, sQLException);
            }
            throw sQLException;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
    }

    private static void createCimkeySwitchSnapshot(DBConnection dBConnection, Switch switch_, int n, String string) throws SQLException {
        String string2 = "createCimkeySwitchSnapshot(" + n + ", " + string + ")";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> hashtable2 = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string2);
        }
        try {
            String string3 = SnapshotUtil.getSnapshotCreationStmt(2, string);
            if (string3 != null) {
                hashtable.put("<<SNAPSHOT_ID>>", String.valueOf(n));
                hashtable2.put(TResCimkeySwitchTable.getColumnInfo("SWITCH_WWN"), switch_.getSwitchWwn());
                ParameterizedSql.sqlUpdate(dBConnection, string3, hashtable, hashtable2);
            }
        }
        catch (SQLException sQLException) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, sQLException);
            }
            throw sQLException;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
    }

    private static void createCimkeyPortSnapshot(DBConnection dBConnection, Switch switch_, int n, String string) throws SQLException {
        String string2 = "createCimkeyPortSnapshot(" + n + ", " + string + ")";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> hashtable2 = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string2);
        }
        try {
            String string3 = SnapshotUtil.getSnapshotCreationStmt(2, string);
            if (string3 != null) {
                hashtable.put("<<SNAPSHOT_ID>>", String.valueOf(n));
                hashtable2.put(TResSwitch2portTable.getColumnInfo("SWITCH_WWN"), switch_.getSwitchWwn());
                ParameterizedSql.sqlUpdate(dBConnection, string3, hashtable, hashtable2);
            }
        }
        catch (SQLException sQLException) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, sQLException);
            }
            throw sQLException;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
    }

    private static void createVendorSnapshot(DBConnection dBConnection, Switch switch_, int n, String string) throws SQLException {
        String string2 = "createVendorSnapshot(" + n + ", " + string + ")";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> hashtable2 = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string2);
        }
        try {
            String string3 = SnapshotUtil.getSnapshotCreationStmt(2, string);
            if (string3 != null) {
                hashtable.put("<<SNAPSHOT_ID>>", String.valueOf(n));
                hashtable2.put(TResSwitchTable.getColumnInfo("SWITCH_WWN"), switch_.getSwitchWwn());
                ParameterizedSql.sqlUpdate(dBConnection, string3, hashtable, hashtable2);
            }
        }
        catch (SQLException sQLException) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, sQLException);
            }
            throw sQLException;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
    }

    private static void createModelSnapshot(DBConnection dBConnection, Switch switch_, int n, String string) throws SQLException {
        String string2 = "createModelSnapshot(" + n + ", " + string + ")";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> hashtable2 = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string2);
        }
        try {
            String string3 = SnapshotUtil.getSnapshotCreationStmt(2, string);
            if (string3 != null) {
                hashtable.put("<<SNAPSHOT_ID>>", String.valueOf(n));
                hashtable2.put(TResSwitchTable.getColumnInfo("SWITCH_WWN"), switch_.getSwitchWwn());
                ParameterizedSql.sqlUpdate(dBConnection, string3, hashtable, hashtable2);
            }
        }
        catch (SQLException sQLException) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, sQLException);
            }
            throw sQLException;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
    }
}

