/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.logging;

import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.logging.AuditConfigRequest;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.logging.TraceLoggerFactory;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.LocalizableException;

public class AuditConfigHandler {
    public static void handle(Request request, Response response) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(AuditConfigHandler.class.getName(), "handle", "request, response");
        }
        if (RequestChecker.isDesiredType(AuditConfigRequest.class, request, response)) {
            AuditConfigRequest auditConfigRequest = (AuditConfigRequest)request.requestData;
            try {
                if (auditConfigRequest.doSet) {
                    TraceLoggerFactory.setAuditConfig(auditConfigRequest.configMap, auditConfigRequest.requestCode);
                } else {
                    response.responseData = TraceLoggerFactory.getAuditConfig(auditConfigRequest.requestCode);
                }
                response.status = 0;
            }
            catch (LocalizableException localizableException) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception(AuditConfigHandler.class.getName(), "handle", localizableException);
                }
                response.errorMessage = localizableException.getMessage();
                response.status = (short)12;
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(AuditConfigHandler.class.getName(), "handle");
        }
    }
}

