/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.request;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.MessageLog;

public class SocketRegistry {
    private static boolean isActive;
    private static List registeredSockets;

    static {
        SocketRegistry.activate();
    }

    public static void activate() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(SocketRegistry.class.getName(), "activate", "");
        }
        registeredSockets = new LinkedList();
        isActive = true;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(SocketRegistry.class.getName(), "activate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deactivate() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(SocketRegistry.class.getName(), "deactivate", "");
        }
        if (!isActive) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(SocketRegistry.class.getName(), "deactivate");
            }
            return;
        }
        List list = null;
        Class<SocketRegistry> clazz = SocketRegistry.class;
        synchronized (SocketRegistry.class) {
            boolean bl = isActive;
            if (bl) {
                isActive = false;
                list = registeredSockets;
                registeredSockets = null;
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (bl && list != null) {
                for (Socket socket : list) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {
                        if (!TraceLogger.enableTrace) continue;
                        TraceLogger.exception(SocketRegistry.class.getName(), "deactivate", iOException);
                    }
                }
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(SocketRegistry.class.getName(), "deactivate");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Socket connect(String string, int n) throws UnknownHostException {
        Object object;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(SocketRegistry.class.getName(), "connect", "host, port");
        }
        Socket socket = null;
        if (!isActive) {
            Socket socket2 = socket;
            if (!TraceLogger.enableTrace) return socket2;
            TraceLogger.exit(SocketRegistry.class.getName(), "connect", socket2);
            return socket2;
        }
        try {
            socket = new Socket(string, n);
        }
        catch (UnknownHostException unknownHostException) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(SocketRegistry.class.getName(), "connect", unknownHostException);
            }
            if (!TraceLogger.enableTrace) throw unknownHostException;
            TraceLogger.exit(SocketRegistry.class.getName(), "connect");
            throw unknownHostException;
        }
        catch (IOException iOException) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(SocketRegistry.class.getName(), "connect", iOException);
            }
            MessageLog.logException("GEN0040E", iOException, string, new Integer(n));
        }
        if (socket != null) {
            object = SocketRegistry.class;
            // MONITORENTER : org.eclipse.aperi.request.SocketRegistry.class
            if (isActive) {
                registeredSockets.add(socket);
            } else {
                block15: {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {
                        if (!TraceLogger.enableTrace) break block15;
                        TraceLogger.exception(SocketRegistry.class.getName(), "connect", iOException);
                    }
                }
                socket = null;
            }
            // MONITOREXIT : object
        }
        object = socket;
        if (!TraceLogger.enableTrace) return object;
        TraceLogger.exit(SocketRegistry.class.getName(), "connect", object);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close(Socket socket) throws IOException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(SocketRegistry.class.getName(), "close", "socket");
        }
        Class<SocketRegistry> clazz = SocketRegistry.class;
        synchronized (SocketRegistry.class) {
            if (isActive) {
                registeredSockets.remove(socket);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            socket.close();
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(SocketRegistry.class.getName(), "close");
            }
            return;
        }
    }
}

