/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.logging;

import com.ibm.log.LogComponent;
import com.ibm.log.mgr.LogManager;
import java.util.Vector;

class JLogObjectPool {
    private Vector<LogComponent> pool;
    private LogManager logManager = null;
    private int uniqueKey = 0;
    private String baseName = null;

    JLogObjectPool(LogManager logManager, String string) {
        this.logManager = logManager;
        this.baseName = string;
        this.createPool();
    }

    private void createPool() {
        this.pool = new Vector();
    }

    synchronized LogComponent getLogComponent() {
        LogComponent logComponent = null;
        int n = this.pool.size();
        logComponent = n > 0 ? this.pool.remove(n - 1) : this.getUniqueLogComponent();
        return logComponent;
    }

    synchronized void returnLogComponent(LogComponent logComponent) {
        this.pool.add(logComponent);
    }

    private LogComponent getUniqueLogComponent() {
        int n;
        if ((n = this.uniqueKey++) == Integer.MAX_VALUE) {
            throw new RuntimeException("Last unique key generated");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.baseName);
        stringBuffer.append(".");
        stringBuffer.append(n);
        return this.logManager.getObject(stringBuffer.toString());
    }
}

