/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.request.handler;

import java.util.Vector;

public class ThreadPool {
    private Vector idleThreads = new Vector();
    private Vector threadPool = new Vector();
    private Vector queue = new Vector();
    private static ThreadGroup group = new ThreadGroup("ThreadPoolGroup");
    private long idleTimeout = 5000L;
    private int maxPoolSize = 5;
    private int minPoolSize = 2;
    private int threadCounter = 0;
    private int priority = 5;
    private int cntr = 0;
    private boolean shutdown = false;
    private static ThreadPool instance;

    public ThreadPool() {
        this(2, 5);
    }

    private int getID() {
        ++this.cntr;
        if (this.cntr > 1000000) {
            this.cntr = 0;
        }
        return this.cntr;
    }

    public ThreadPool(int n, int n2) {
        this(n, n2, 5000);
    }

    public ThreadPool(int n, int n2, int n3) {
        this.idleTimeout = n3;
        this.minPoolSize = n;
        this.maxPoolSize = n2;
        int n4 = 0;
        while (n4 < n) {
            Worker worker = new Worker(this, "ThreadPool " + this.getID());
            this.idleThreads.add(worker);
            this.threadPool.add(worker);
            worker.start();
            ++n4;
        }
    }

    public long getIdleTimeOutMs() {
        return this.idleThreads.size() <= this.minPoolSize ? -1L : this.idleTimeout;
    }

    public boolean execute(Runnable runnable) {
        return this.execute(runnable, true);
    }

    public boolean execute(Runnable runnable, boolean bl) {
        return this.execute(runnable, bl, false);
    }

    public synchronized boolean execute(Runnable runnable, boolean bl, boolean bl2) {
        int n = this.idleThreads.size();
        if (n > 0) {
            Worker worker = (Worker)this.idleThreads.remove(n - 1);
            return worker.assignTask(runnable);
        }
        if (this.maxPoolSize == -1 || this.threadPool.size() <= this.maxPoolSize || bl2) {
            Worker worker = new Worker(this, "ThreadPool " + this.getID());
            this.threadPool.add(worker);
            return worker.assignTask(runnable);
        }
        if (!bl) {
            return false;
        }
        this.queue.add(runnable);
        return true;
    }

    public ThreadGroup getGroup() {
        return group;
    }

    public synchronized boolean taskCompleted(Worker worker, boolean bl) {
        if (this.shutdown) {
            return false;
        }
        if (this.queue.size() > 0) {
            this.idleThreads.remove(worker);
            worker.assignTask((Runnable)this.queue.remove(0));
            return true;
        }
        if (bl && this.threadPool.size() > this.minPoolSize) {
            this.idleThreads.remove(worker);
            this.threadPool.remove(worker);
            return false;
        }
        if (this.maxPoolSize == -1 || this.threadPool.size() <= this.maxPoolSize) {
            if (!this.idleThreads.contains(worker)) {
                this.idleThreads.add(worker);
                return true;
            }
            return true;
        }
        return false;
    }

    private synchronized void removeThread(Worker worker) {
        if (worker != null && this.threadPool != null) {
            this.threadPool.remove(worker);
        }
    }

    public synchronized void shutdown() {
        if (!this.shutdown) {
            this.shutdown = true;
            if (this.idleThreads != null) {
                for (Worker worker : this.idleThreads) {
                    worker.kill();
                }
                this.idleThreads = null;
            }
            if (this.threadPool != null) {
                for (Worker worker : this.threadPool) {
                    worker.kill();
                }
                this.threadPool = null;
            }
        }
    }

    private class Worker
    extends Thread {
        private boolean alive;
        private boolean started;
        private ThreadPool pool;
        private Runnable task;

        public Worker(ThreadPool threadPool2) {
            this(threadPool2, "ThreadPool");
        }

        public Worker(ThreadPool threadPool2, String string) {
            super(threadPool2.getGroup(), string);
            this.alive = true;
            this.pool = threadPool2;
            this.setDaemon(true);
        }

        public synchronized void start() {
            if (this.alive) {
                this.started = true;
                super.start();
            }
        }

        public synchronized void kill() {
            this.alive = false;
            this.started = false;
            this.notify();
        }

        public synchronized boolean assignTask(Runnable runnable) {
            if (this.alive) {
                this.task = runnable;
                if (!this.started) {
                    this.start();
                }
                this.notify();
                return true;
            }
            return false;
        }

        private synchronized Runnable waitForTask() {
            boolean bl = false;
            while (this.alive) {
                if (this.task != null) {
                    Runnable runnable = this.task;
                    this.task = null;
                    return runnable;
                }
                this.alive = this.pool.taskCompleted(this, bl);
                if (!this.alive || this.task != null) continue;
                try {
                    long l = this.pool.getIdleTimeOutMs();
                    bl = false;
                    if (l > 0L) {
                        this.wait(l);
                        bl = this.task == null;
                        continue;
                    }
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return null;
        }

        public void run() {
            while (this.alive) {
                Runnable runnable = this.waitForTask();
                if (!this.alive) break;
                if (runnable == null) continue;
                try {
                    runnable.run();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            this.started = false;
            this.pool.removeThread(this);
        }
    }
}

