/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.views;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.model.GraphModelFabricL2;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2Computer;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2Other;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2Subsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2Switch;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2TapeLibrary;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2Computer;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2Other;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2Subsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2Switch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2TapeLibrary;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary;
import org.eclipse.aperi.gui.topo.model.bean.GraphZone;
import org.eclipse.aperi.gui.topo.model.bean.GraphZone2ZoneMember;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneFabric;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneFabric2Zone;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneFabric2ZoneSet;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneMember;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneSet;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneSet2Zone;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.guireq.topology.request.ViewerRequest;
import org.eclipse.aperi.server.guireq.topology.request.ViewerResponse;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSanL0;
import org.eclipse.aperi.server.guireq.topology.views.ViewerServerL2;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSwitchL2;

public class ViewerSanL1
extends ViewerSanL0 {
    private static boolean debug = false;
    public static final String SELECT_SWITCH2SWITCH_FROM_SAN = "SELECT DISTINCT \tSWITCH2SWITCH.SWITCH_PREFIX_ID1,    SWITCH2SWITCH.SWITCH_ID1 SWITCH1_ID, \tSWITCH2SWITCH.SWITCH_PREFIX_ID2,    SWITCH2SWITCH.SWITCH_ID2 SWITCH2_ID, \tSWITCH2SWITCH.PORT2PORT_ID PORT2PORT_ID, \tSWITCH2SWITCH.DETECTABLE DETECTABLE FROM (select \n\t  SWITCH1.PREFIX_ID SWITCH_PREFIX_ID1, \n     SWITCH1.SWITCH_ID SWITCH_ID1, \n     SWITCH2PORT1.PORT_ID SWITCH1_PORT_ID, \n\t  SWITCH2.PREFIX_ID SWITCH_PREFIX_ID2, \n     SWITCH2.SWITCH_ID SWITCH_ID2,\n     SWITCH2PORT2.PORT_ID SWITCH2_PORT_ID, \n\t  PORT2PORT.PORT2PORT_ID PORT2PORT_ID,\n\t  PORT2PORT.DETECTABLE DETECTABLE \nFROM \nT_VIEW_PORT2PORT PORT2PORT, \n     T_VIEW_VSWITCH SWITCH2, T_VIEW_VSWITCH2PORT SWITCH2PORT1, T_VIEW_VSWITCH2PORT SWITCH2PORT2, \n\t  T_VIEW_VSWITCH SWITCH1 left outer join T_VIEW_VSWITCH SWITCH3 on \n     SWITCH1.SWITCH_WWN = SWITCH3.PARENT_SWITCH_WWN \nWHERE \n     SWITCH3.SWITCH_WWN is NULL and \n\t  SWITCH1.PREFIX_ID = SWITCH2PORT1.PREFIX_ID and \n\t  SWITCH1.SWITCH_ID = SWITCH2PORT1.SWITCH_ID and \n     SWITCH2PORT1.PORT_ID = PORT2PORT.PORT_ID1 and \n     PORT2PORT.PORT_ID2 = SWITCH2PORT2.PORT_ID and \n     SWITCH2PORT2.PREFIX_ID = SWITCH2.PREFIX_ID and \n\t  SWITCH2PORT2.SWITCH_ID = SWITCH2.SWITCH_ID \n) SWITCH2SWITCH,T_VIEW_VSWITCH2FABRIC SWITCH2FABRIC1, T_VIEW_VSWITCH2FABRIC SWITCH2FABRIC2 WHERE    SWITCH2FABRIC1.FABRIC_ID = ? and    SWITCH2FABRIC1.SWITCH_ID = SWITCH2SWITCH.SWITCH_ID1 and    SWITCH2FABRIC2.SWITCH_ID = SWITCH2SWITCH.SWITCH_ID2 and    SWITCH2FABRIC1.FABRIC_ID = SWITCH2FABRIC2.FABRIC_ID";
    public static String SELECT_SWITCH_FROM_SAN = "SELECT DISTINCT \t T_RES_SWITCH.PREFIX_ID,     CASE WHEN T_RES_SWITCH.DISPLAY_NAME IS NOT NULL  and RTRIM(T_RES_SWITCH.DISPLAY_NAME) != '' THEN T_RES_SWITCH.DISPLAY_NAME          WHEN T_RES_SWITCH.LOGICAL_NAME IS NOT NULL  and RTRIM(T_RES_SWITCH.LOGICAL_NAME) != '' THEN T_RES_SWITCH.LOGICAL_NAME \t\t  ELSE T_RES_SWITCH.SWITCH_WWN \t END DISPLAY_NAME,     T_RES_SWITCH.SWITCH_ID SWITCH_ID,     T_RES_SWITCH.LOGICAL_NAME LOGICAL_NAME,     T_RES_SWITCH.SWITCH_WWN SWITCH_WWN,     T_RES_SWITCH.SERIAL_NUMBER SERIAL_NUMBER,     T_RES_SWITCH.DESCRIPTION DESCRIPTION,     T_RES_SWITCH.IP_ADDRESS IP_ADDRESS,     T_RES_SWITCH.DOMAIN DOMAIN,     T_RES_SWITCH.VERSION VERSION,     MODEL.MODEL_NAME MODEL,     VENDOR.VENDOR_NAME VENDOR, \t T_RES_SWITCH.PARENT_SWITCH_WWN PARENT_SWITCH_WWN, \t T_RES_SWITCH.MGMT_URL_ADDR DEFAULT_MANAGER, \t T_RES_SWITCH.DETECTABLE DETECTABLE, \t T_RES_SWITCH.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t T_RES_SWITCH.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t T_RES_SWITCH.PROPAGATED_STATUS PROPAGATED_STATUS, \t T_RES_SWITCH.USER_ATTRIB1 USER_ATTRIB1, \t T_RES_SWITCH.USER_ATTRIB2 USER_ATTRIB2, \t T_RES_SWITCH.USER_ATTRIB3 USER_ATTRIB3 FROM    T_VIEW_VSWITCH2FABRIC SWITCH2FABRIC,    T_VIEW_VSWITCH T_RES_SWITCH left outer join T_RES_VENDOR VENDOR on \tT_RES_SWITCH.VENDOR_ID = VENDOR.VENDOR_ID left outer join T_RES_MODEL MODEL on \tT_RES_SWITCH.MODEL_ID = MODEL.MODEL_ID WHERE \tSWITCH2FABRIC.FABRIC_ID = ? and    SWITCH2FABRIC.SWITCH_ID = T_RES_SWITCH.SWITCH_ID and    SWITCH2FABRIC.PREFIX_ID = T_RES_SWITCH.PREFIX_ID";
    public static String SELECT_SAN = "SELECT \t\tT_RES_FABRIC.FABRIC_WWN FABRIC_WWN, \t\tCASE WHEN T_RES_FABRIC.DISPLAY_NAME IS NOT NULL AND RTRIM(T_RES_FABRIC.DISPLAY_NAME) != '' THEN T_RES_FABRIC.DISPLAY_NAME \t\t\tWHEN T_RES_FABRIC.NAME IS NOT NULL THEN RTRIM(T_RES_FABRIC.NAME) \t\t\tWHEN T_RES_FABRIC.SAN_WWN IS NOT NULL THEN RTRIM(T_RES_FABRIC.SAN_WWN) \t\t\tELSE T_RES_FABRIC.FABRIC_WWN \t\tEND DISPLAY_NAME, \t\tT_RES_FABRIC.FABRIC_ID FABRIC_ID, \t\tT_RES_FABRIC.NAME NAME, \t\tT_RES_FABRIC.ACTIVE ACTIVE, \t\tT_RES_FABRIC.IS_PHYSICAL IS_PHYSICAL, \t\tCASE WHEN PARENT.DISPLAY_NAME IS NOT NULL THEN PARENT.DISPLAY_NAME \t\t\tWHEN PARENT.SAN_WWN IS NOT NULL THEN RTRIM(PARENT.SAN_WWN) \t\t\tELSE PARENT.FABRIC_WWN \t\tEND PARENT_DISPLAY_NAME, \t\tT_RES_FABRIC.DETECTABLE DETECTABLE, \t\tT_RES_FABRIC.PROPAGATED_STATUS PROPAGATED_STATUS, \t\tT_RES_FABRIC.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_FABRIC.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_FABRIC.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_FABRIC.USER_ATTRIB3 USER_ATTRIB3 FROM \tT_RES_FABRIC left outer join T_RES_FABRIC PARENT on \tT_RES_FABRIC.PARENT_FABRIC_WWN = PARENT.FABRIC_WWN WHERE \tT_RES_FABRIC.FABRIC_ID = ? ";
    public static String SELECT_HOST_FROM_SAN = "SELECT  \t\tT_RES_HOST.PREFIX_ID, \t    CASE WHEN T_RES_HOST.HOST_NAME IS NOT NULL THEN T_RES_HOST.HOST_NAME \t\t\t WHEN T_RES_HOST.HOST_URL IS NOT NULL THEN T_RES_HOST.HOST_URL \t\t\t ELSE CAST(T_RES_HOST.COMPUTER_ID as CHAR(10)) \t\tEND  DISPLAY_NAME,        T_RES_HOST.DEV_STATUS DEV_STATUS,        T_RES_HOST.DAT_STATUS DAT_STATUS, \t\tT_RES_HOST.HOST_NAME HOST_NAME, \t\tT_RES_HOST.COMPUTER_ID HOST_ID, \t\tT_RES_HOST.GUID GUID, \t\tT_RES_HOST.OS_TYPE OS_TYPE,\t\tT_RES_HOST.OS_VERSION OS_VERSION,\t\tT_RES_HOST.TIME_ZONE TIME_ZONE,\t\tT_RES_HOST.IP_ADDRESS IP_ADDRESS,\t\tT_RES_HOST.DETECTABLE DETECTABLE, \t\tT_RES_HOST.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_HOST.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t\tT_RES_HOST.PROPAGATED_STATUS PROPAGATED_STATUS, \t\tT_RES_HOST.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_HOST.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_HOST.USER_ATTRIB3 USER_ATTRIB3 FROM T_VIEW_VHOST2FABRIC HOST2FABRIC, \tT_VIEW_VHOST T_RES_HOST WHERE \tT_RES_HOST.COMPUTER_ID = HOST2FABRIC.HOST_ID and \tHOST2FABRIC.FABRIC_ID = ? ";
    public static String SELECT_SANS_FROM_HOST_FROM_SAN = "SELECT     HOST2FABRIC1.FABRIC_ID,     HOST2FABRIC1.PREFIX_ID, \t HOST2FABRIC1.HOST_ID FROM T_VIEW_VHOST2FABRIC HOST2FABRIC1,T_VIEW_VHOST2FABRIC HOST2FABRIC2 WHERE     HOST2FABRIC1.PREFIX_ID = HOST2FABRIC2.HOST_ID and \t HOST2FABRIC1.HOST_ID = HOST2FABRIC2.HOST_ID and     HOST2FABRIC2.FABRIC_ID = ?";
    public static String SELECT_ARRAY_FROM_SAN = "SELECT distinct \t\tT_RES_STORAGE_SUBSYSTEM.PREFIX_ID, \t\tT_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID SUBSYSTEM_ID, \t\tCASE WHEN T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME IS NOT NULL AND RTRIM(T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME) != '' THEN T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME \t\t\t WHEN T_RES_STORAGE_SUBSYSTEM.DISPLAY_NAME IS NOT NULL THEN T_RES_STORAGE_SUBSYSTEM.DISPLAY_NAME \t\t\t ELSE T_RES_STORAGE_SUBSYSTEM.NAME \t\tEND  DISPLAY_NAME, \t\tT_RES_STORAGE_SUBSYSTEM.NAME || '+' || RTRIM(CAST(T_RES_STORAGE_SUBSYSTEM.NAME_FORMAT as CHAR(5))) NATURAL_KEY, \t\t(T_RES_STORAGE_SUBSYSTEM.ALLOCATED_CAPACITY*512) ALLOCATED_CAPACITY, \t\t(T_RES_STORAGE_SUBSYSTEM.AVAILABLE_CAPACITY*512) AVAILABLE_CAPACITY, \t\t(T_RES_STORAGE_SUBSYSTEM.BACKEND_STORAGE_CAPACITY*512) BACKEND_STORAGE_CAPACITY, \t\tVENDOR.VENDOR_NAME VENDOR, \t\tMODEL.MODEL_NAME MODEL, \t\tT_RES_STORAGE_SUBSYSTEM.CACHE CACHE, \t\tT_RES_STORAGE_SUBSYSTEM.OS_TYPE OS_TYPE, \t\tT_RES_STORAGE_SUBSYSTEM.TYPE TYPE, \t\tT_RES_STORAGE_SUBSYSTEM.IP_ADDRESS IP_ADDRESS, \t\tT_RES_STORAGE_SUBSYSTEM.CODE_LEVEL CODE_LEVEL,      CASE WHEN T_RES_STORAGE_SUBSYSTEM.SERIAL_NUMBER IS NOT NULL THEN T_RES_STORAGE_SUBSYSTEM.SERIAL_NUMBER           ELSE T_RES_STORAGE_SUBSYSTEM.NAME      END  SERIAL_NUMBER, \t\tT_RES_STORAGE_SUBSYSTEM.DETECTABLE DETECTABLE, \t\tT_RES_STORAGE_SUBSYSTEM.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_STORAGE_SUBSYSTEM.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t\tT_RES_STORAGE_SUBSYSTEM.PROPAGATED_STATUS PROPAGATED_STATUS,\t\tT_RES_STORAGE_SUBSYSTEM.ACCESS_INFO DEFAULT_MANAGER, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB3 USER_ATTRIB3 FROM T_VIEW_VSUBSYSTEM2FABRIC SUBSYSTEM2FABRIC,    T_VIEW_VSTORAGE_SUBSYSTEM T_RES_STORAGE_SUBSYSTEM left outer join T_RES_VENDOR VENDOR on\t T_RES_STORAGE_SUBSYSTEM.VENDOR_ID = VENDOR.VENDOR_ID left outer join T_RES_MODEL MODEL on\t T_RES_STORAGE_SUBSYSTEM.MODEL_ID = MODEL.MODEL_ID WHERE     SUBSYSTEM2FABRIC.FABRIC_ID = ? and     SUBSYSTEM2FABRIC.PREFIX_ID =  T_RES_STORAGE_SUBSYSTEM.PREFIX_ID and \t SUBSYSTEM2FABRIC.SUBSYSTEM_ID = T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID ";
    public static String SELECT_SANS_FROM_ARRAY_FROM_SAN = "SELECT     SUBSYSTEM2FABRIC1.FABRIC_ID,     SUBSYSTEM2FABRIC1.PREFIX_ID,     SUBSYSTEM2FABRIC1.SUBSYSTEM_ID FROM T_VIEW_VSUBSYSTEM2FABRIC SUBSYSTEM2FABRIC1, T_VIEW_VSUBSYSTEM2FABRIC SUBSYSTEM2FABRIC2 WHERE     SUBSYSTEM2FABRIC1.PREFIX_ID = SUBSYSTEM2FABRIC2.SUBSYSTEM_ID and \t SUBSYSTEM2FABRIC1.SUBSYSTEM_ID = SUBSYSTEM2FABRIC2.SUBSYSTEM_ID and     SUBSYSTEM2FABRIC2.FABRIC_ID = ?";
    public static String SELECT_TAPE_FROM_SAN = "SELECT  \t\tT_RES_TAPE_LIBRARY.PREFIX_ID, \t\tT_RES_TAPE_LIBRARY.TAPE_LIBRARY_ID TAPE_LIBRARY_ID, \t\tCASE WHEN T_RES_TAPE_LIBRARY.USER_PROVIDED_NAME IS NOT NULL AND RTRIM(T_RES_TAPE_LIBRARY.USER_PROVIDED_NAME)\t\t!= '' THEN T_RES_TAPE_LIBRARY.USER_PROVIDED_NAME \t\t\t WHEN T_RES_TAPE_LIBRARY.DISPLAY_NAME IS NOT NULL THEN T_RES_TAPE_LIBRARY.DISPLAY_NAME \t\t\t ELSE T_RES_TAPE_LIBRARY.NAME \t\tEND  DISPLAY_NAME, \t\tT_RES_TAPE_LIBRARY.FIRMWARE_VERSION FIRMWARE_VERSION, \t\tT_RES_TAPE_LIBRARY.MAX_CARTRIDGES MAX_CARTRIDGES, \t\tVENDOR.VENDOR_NAME VENDOR, \t\tMODEL.MODEL_NAME MODEL, \t\tT_RES_TAPE_LIBRARY.SERIAL_NUMBER SERIAL_NUMBER, \t\tT_RES_TAPE_LIBRARY.ACCESS_INFO DEFAULT_MANAGER, \t\tT_RES_TAPE_LIBRARY.DETECTABLE DETECTABLE, \t\tT_RES_TAPE_LIBRARY.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_TAPE_LIBRARY.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t\tT_RES_TAPE_LIBRARY.PROPAGATED_STATUS PROPAGATED_STATUS,\t\tT_RES_TAPE_LIBRARY.TOTAL_DRIVES, \t\tT_RES_TAPE_LIBRARY.TOTAL_CARTRIDGES, \t\tT_RES_TAPE_LIBRARY.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_TAPE_LIBRARY.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_TAPE_LIBRARY.USER_ATTRIB3 USER_ATTRIB3 FROM T_VIEW_VTAPE2FABRIC TAPE2FABRIC,    T_VIEW_VTAPE_LIBRARY T_RES_TAPE_LIBRARY left outer join T_RES_VENDOR VENDOR on\t T_RES_TAPE_LIBRARY.VENDOR_ID = VENDOR.VENDOR_ID left outer join T_RES_MODEL MODEL on\t T_RES_TAPE_LIBRARY.MODEL_ID = MODEL.MODEL_ID WHERE     TAPE2FABRIC.FABRIC_ID = ? and     TAPE2FABRIC.PREFIX_ID = T_RES_TAPE_LIBRARY.PREFIX_ID and \t TAPE2FABRIC.TAPE_LIBRARY_ID = T_RES_TAPE_LIBRARY.TAPE_LIBRARY_ID ";
    public static String SELECT_SANS_FROM_TAPE_FROM_SAN = "SELECT     TAPE2FABRIC1.PREFIX_ID PREFIX_ID,     TAPE2FABRIC1.FABRIC_ID FABRIC_ID,     TAPE2FABRIC1.TAPE_LIBRARY_ID TAPE_LIBRARY_ID FROM T_VIEW_VTAPE2FABRIC TAPE2FABRIC1,T_VIEW_VTAPE2FABRIC TAPE2FABRIC2 WHERE     TAPE2FABRIC1.PREFIX_ID = TAPE2FABRIC2.PREFIX_ID and \t TAPE2FABRIC1.TAPE_LIBRARY_ID = TAPE2FABRIC2.TAPE_LIBRARY_ID and     TAPE2FABRIC2.FABRIC_ID = ?";
    public static final String SELECT_HOST2SWITCH_FROM_SAN = "SELECT distinct \t\tSWITCH2HOST.HOST_PREFIX_ID,      SWITCH2HOST.HOST_ID HOST_ID,\t\tSWITCH2HOST.SWITCH_PREFIX_ID, \t\tSWITCH2HOST.SWITCH_ID SWITCH_ID,\t    SWITCH2HOST.PORT2PORT_ID PORT2PORT_ID, \t    SWITCH2HOST.DETECTABLE DETECTABLE FROM T_VIEW_VSWITCH2HOST SWITCH2HOST, T_VIEW_VSWITCH2FABRIC SWITCH2FABRIC WHERE       SWITCH2HOST.SWITCH_PREFIX_ID = SWITCH2FABRIC.PREFIX_ID and \t\t SWITCH2HOST.SWITCH_ID = SWITCH2FABRIC.SWITCH_ID and       SWITCH2FABRIC.FABRIC_ID = ? ";
    public static final String SELECT_SWITCH2STORAGE_FROM_SAN = "SELECT distinct \t\tSWITCH2SUBSYSTEM.SUBSYSTEM_PREFIX_ID, \t\tSWITCH2SUBSYSTEM.SUBSYSTEM_ID SUBSYSTEM_ID,\t\tSWITCH2SUBSYSTEM.SWITCH_PREFIX_ID, \t\tSWITCH2SUBSYSTEM.SWITCH_ID SWITCH_ID,\t    SWITCH2SUBSYSTEM.PORT2PORT_ID PORT2PORT_ID, \t    SWITCH2SUBSYSTEM.DETECTABLE DETECTABLE FROM T_VIEW_VSWITCH2SUBSYSTEM SWITCH2SUBSYSTEM, T_VIEW_VSWITCH2FABRIC SWITCH2FABRIC WHERE      SWITCH2SUBSYSTEM.SWITCH_PREFIX_ID = SWITCH2FABRIC.PREFIX_ID and \t\tSWITCH2SUBSYSTEM.SWITCH_ID = SWITCH2FABRIC.SWITCH_ID and      SWITCH2FABRIC.FABRIC_ID = ? ";
    public static final String SELECT_SWITCH2TAPE_FROM_SAN = "SELECT distinct \t\tSWITCH2TAPE.TAPE_PREFIX_ID, \t\tSWITCH2TAPE.TAPE_LIBRARY_ID TAPE_LIBRARY_ID,\t\tSWITCH2TAPE.SWITCH_PREFIX_ID, \t\tSWITCH2TAPE.SWITCH_ID SWITCH_ID,\t    SWITCH2TAPE.PORT2PORT_ID PORT2PORT_ID, \t    SWITCH2TAPE.DETECTABLE DETECTABLE from T_VIEW_VSWITCH2TAPE SWITCH2TAPE, T_VIEW_VSWITCH2FABRIC SWITCH2FABRIC where      SWITCH2TAPE.SWITCH_PREFIX_ID = SWITCH2FABRIC.PREFIX_ID and \t\tSWITCH2TAPE.SWITCH_ID = SWITCH2FABRIC.SWITCH_ID and      SWITCH2FABRIC.FABRIC_ID = ? ";
    public static final String SELECT_OTHER_FROM_SAN = "SELECT  \tOTHER.PREFIX_ID PREFIX_ID, \tOTHER.OTHER_ID OTHER_ID, \tOTHER.DISPLAY_NAME DISPLAY_NAME, \tOTHER.PROPAGATED_STATUS PROPAGATED_STATUS, \tOTHER.DETECTABLE DETECTABLE, \tMODEL.MODEL_NAME MODEL, \tVENDOR.VENDOR_NAME VENDOR, \tOTHER.SERIAL_NUMBER SERIAL_NUMBER, \tOTHER.OTHER_TYPE DISPLAY_TYPE  FROM T_VIEW_VOTHER2FABRIC OTHER2FABRIC,T_VIEW_VOTHER OTHER left outer join T_RES_MODEL MODEL on OTHER.MODEL_ID = MODEL.MODEL_ID left outer join T_RES_VENDOR VENDOR on OTHER.VENDOR_ID = VENDOR.VENDOR_ID WHERE \tOTHER2FABRIC.FABRIC_ID = ? and \tOTHER2FABRIC.PREFIX_ID = OTHER.PREFIX_ID and \tOTHER2FABRIC.OTHER_ID = OTHER.OTHER_ID ";
    public static final String SELECT_SANS_FROM_OTHER_FROM_SAN = "SELECT \t OTHER2FABRIC1.FABRIC_ID FABRIC_ID, \t OTHER2FABRIC1.PREFIX_ID PREFIX_ID, \t OTHER2FABRIC1.OTHER_ID OTHER_ID FROM T_VIEW_VOTHER2FABRIC OTHER2FABRIC1,T_VIEW_VOTHER2FABRIC OTHER2FABRIC2 WHERE \t OTHER2FABRIC1.PREFIX_ID = OTHER2FABRIC2.PREFIX_ID and     OTHER2FABRIC1.OTHER_ID = OTHER2FABRIC2.OTHER_ID and     OTHER2FABRIC2.FABRIC_ID = ? ";
    public static final String SELECT_SWITCH2OTHER_FROM_SAN = "SELECT distinct     SWITCH2OTHER.OTHER_PREFIX_ID OTHER_PREFIX_ID,     SWITCH2OTHER.OTHER_ID OTHER_ID, \t SWITCH2OTHER.SWITCH_PREFIX_ID SWITCH_PREFIX_ID, \t SWITCH2OTHER.SWITCH_ID SWITCH_ID, \t SWITCH2OTHER.PORT2PORT_ID PORT2PORT_ID,    SWITCH2OTHER.DETECTABLE DETECTABLE FROM T_VIEW_VSWITCH2FABRIC SWITCH2FABRIC, T_VIEW_VSWITCH2OTHER SWITCH2OTHER WHERE \t SWITCH2FABRIC.FABRIC_ID = ? and     SWITCH2FABRIC.PREFIX_ID = SWITCH2FABRIC.PREFIX_ID and \t SWITCH2FABRIC.SWITCH_ID = SWITCH2OTHER.SWITCH_ID ";
    public static final String SELECT_FABRIC_FROM_ZONES_FROM_SAN = "SELECT DISTINCT \t\tT_RES_FABRIC.FABRIC_WWN FABRIC_WWN, \t\tCASE WHEN T_RES_FABRIC.DISPLAY_NAME IS NOT NULL AND RTRIM(T_RES_FABRIC.DISPLAY_NAME) != '' THEN T_RES_FABRIC.DISPLAY_NAME \t\t\tWHEN T_RES_FABRIC.NAME IS NOT NULL THEN RTRIM(T_RES_FABRIC.NAME) \t\t\tWHEN T_RES_FABRIC.SAN_WWN IS NOT NULL THEN RTRIM(T_RES_FABRIC.SAN_WWN) \t\t\tELSE T_RES_FABRIC.FABRIC_WWN \t\tEND DISPLAY_NAME, \t\tT_RES_FABRIC.FABRIC_ID FABRIC_ID, \t\tT_RES_FABRIC.NAME NAME, \t\tT_RES_FABRIC.ACTIVE ACTIVE, \t\tT_RES_FABRIC.IS_PHYSICAL IS_PHYSICAL, \t\tCASE WHEN PARENT.DISPLAY_NAME IS NOT NULL THEN PARENT.DISPLAY_NAME \t\t\tWHEN PARENT.SAN_WWN IS NOT NULL THEN RTRIM(PARENT.SAN_WWN) \t\t\tELSE PARENT.FABRIC_WWN \t\tEND PARENT_DISPLAY_NAME, \t\tT_RES_FABRIC.DETECTABLE DETECTABLE, \t\tT_RES_FABRIC.PROPAGATED_STATUS PROPAGATED_STATUS, \t\tT_RES_FABRIC.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_FABRIC.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_FABRIC.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_FABRIC.USER_ATTRIB3 USER_ATTRIB3 FROM  \t T_RES_FABRIC left outer join T_RES_FABRIC PARENT on \t T_RES_FABRIC.PARENT_FABRIC_WWN = PARENT.FABRIC_WWN WHERE \t T_RES_FABRIC.FABRIC_ID = ?";
    public static final String SELECT_ZONES_FROM_SAN = "SELECT    T_RES_ZONE.ZONE_ID ZONE_ID, \tT_RES_ZONE.ZONE_TYPE ZONE_TYPE, \tT_RES_ZONE.ACTIVE ACTIVE,\tT_RES_ZONE.ZONE_NAME ZONE_NAME, \tT_RES_ZONE.FABRIC_WWN FABRIC_WWN, \tT_RES_ZONE.DESCRIPTION DESCRIPTION,  \tT_RES_ZONE.ZONE_NAME DISPLAY_NAME ,\tFABRIC.FABRIC_ID FABRIC_ID FROM     T_RES_ZONE, T_RES_FABRIC FABRIC WHERE     FABRIC.FABRIC_ID = ? and     FABRIC.FABRIC_WWN = T_RES_ZONE.FABRIC_WWN";
    public static final String SELECT_ZONESET2ZONE_FROM_SAN = "SELECT \t ZONESET2ZONE.ZSET_ID ZSET_ID,\t ZONESET2ZONE.ZONE_ID ZONE_ID FROM     T_RES_ZSET2ZONE ZONESET2ZONE, T_RES_ZSET ZSET, T_RES_FABRIC FABRIC WHERE     FABRIC.FABRIC_ID = ? and     FABRIC.FABRIC_WWN = ZSET.FABRIC_WWN and     ZSET.ZSET_ID = ZONESET2ZONE.ZSET_ID";
    public static final String SELECT_ZONESET_FROM_SAN = "SELECT    T_RES_ZSET.ZSET_ID, \tT_RES_ZSET.ACTIVE ACTIVE,\tT_RES_ZSET.ZSET_NAME ZSET_NAME, \tT_RES_ZSET.FABRIC_WWN FABRIC_WWN, \tT_RES_ZSET.DESCRIPTION DESCRIPTION,    T_RES_ZSET.ZSET_NAME DISPLAY_NAME ,\tFABRIC.FABRIC_ID FABRIC_ID FROM     T_RES_ZSET , T_RES_FABRIC FABRIC WHERE     FABRIC.FABRIC_ID = ? and     FABRIC.FABRIC_WWN = T_RES_ZSET.FABRIC_WWN";
    public static final String SELECT_ZONE2MEMBER_FROM_SAN = "SELECT DISTINCT     PORT2ZONE.ZONE_ID ZONE_ID,     PORT2ZONE.PORT_ID PORT_ID,\t ENTITY_TO_PORT.TYPE, \t ENTITY_TO_PORT.PREFIX_ID, \t ENTITY_TO_PORT.ENTITY_ID, \t ENTITY_TO_PORT.DISPLAY_NAME, \t ENTITY_TO_PORT.PORT_DISPLAY_NAME, \t PORT2ZONE.MEMBER_NAME,\t PORT2ZONE.ZONE_MEMBER_ID,     ENTITY_TO_PORT.PORT_NUMBER FROM  \t T_RES_ZONE ZONE, T_VIEW_PORT2ZONE PORT2ZONE left outer join T_VIEW_ENTITY_TO_PORT ENTITY_TO_PORT on \t PORT2ZONE.PORT_ID = ENTITY_TO_PORT.PORT_ID ,  T_RES_FABRIC FABRIC WHERE  \t PORT2ZONE.ZONE_ID = ZONE.ZONE_ID and \t ZONE.FABRIC_WWN = FABRIC.FABRIC_WWN and \t FABRIC.FABRIC_ID = ? ";
    public static final String INSERT_TMP_HOST = "INSERT INTO T_RES_TMP_TOPOLOGY_ENTITY (PREFIX_ID, ENTITY_ID, ID) VALUES (?,?,?)";
    public static final String DELETE_TMP_HOSTS = "DELETE FROM T_RES_TMP_TOPOLOGY_ENTITY WHERE ID = ?";

    public GraphFabric getSan(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSanL1.class.getName(), "getSan", "");
        }
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("san...");
        }
        GraphFabric graphFabric = null;
        try {
            preparedStatement = connection.prepareStatement(SELECT_SAN);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Integer n2 = (Integer)resultSet.getObject("FABRIC_ID");
                if (n2 == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "getSan", "FABRIC_WWN field is null:");
                    continue;
                }
                String string = "fabric:" + n2;
                if (hashMap == null || hashMap.get(string) == null) {
                    graphFabric = new GraphFabric(string);
                    this.populator.populateSan(resultSet, graphFabric);
                    if (graphModel != null) {
                        graphModel.put(graphFabric);
                    }
                    if (hashMap != null) {
                        hashMap.put(string, graphFabric);
                    }
                    break;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "getSan", "Duplicated san entry:" + string);
            }
        }
        finally {
            block24: {
                block23: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception) {
                        if (!TraceLogger.enableTrace) break block23;
                        TraceLogger.exception(ViewerSanL1.class.getName(), "getSan", exception);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    if (!TraceLogger.enableTrace) break block24;
                    TraceLogger.exception(ViewerSanL1.class.getName(), "getSan", exception);
                }
            }
        }
        if (debug) {
            System.out.println("san totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSanL1.class.getName(), "getSan", "");
        }
        return graphFabric;
    }

    public void getSwitchFromSan(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
        GraphFabric graphFabric;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSanL1.class.getName(), "getSwitchFromSan", "");
        }
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("switches...");
        }
        if ((graphFabric = (GraphFabric)hashMap.get("fabric:" + n)) == null) {
            TraceLogger.traceMessage(1, ViewerSwitchL2.class.getName(), "getHostFromSwitch", "No SAN graph object found: " + n);
            return;
        }
        try {
            preparedStatement = connection.prepareStatement(SELECT_SWITCH_FROM_SAN);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = (String)resultSet.getObject("PREFIX_ID");
                Integer n2 = (Integer)resultSet.getObject("SWITCH_ID");
                if (n2 == null) continue;
                String string2 = String.valueOf(string) + n2;
                if (hashMap.get(string2) == null) {
                    GraphSwitch graphSwitch = new GraphSwitch(string2);
                    this.populator.populateSwitch(resultSet, graphSwitch, true);
                    Vector<GraphEntity.ID> vector = new Vector<GraphEntity.ID>();
                    vector.add(graphFabric.getEntityID());
                    graphModel.put(graphSwitch);
                    hashMap.put(string2, graphSwitch);
                    String string3 = "fabric2switch:" + n + ',' + string2;
                    GraphFabric2Switch graphFabric2Switch = new GraphFabric2Switch(string3);
                    graphFabric2Switch.setSwitchID((GraphSwitch.ID)graphSwitch.getEntityID());
                    graphFabric2Switch.setFabricID((GraphFabric.ID)graphFabric.getEntityID());
                    graphModel.put(graphFabric2Switch);
                    hashMap.put(string3, graphFabric2Switch);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "getSwitchFromSan", "Duplicated switch entry:" + string2);
            }
        }
        finally {
            block22: {
                block21: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception) {
                        if (!TraceLogger.enableTrace) break block21;
                        TraceLogger.exception(ViewerSanL1.class.getName(), "getSwitchFromSan", exception);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    if (!TraceLogger.enableTrace) break block22;
                    TraceLogger.exception(ViewerSanL1.class.getName(), "getSwitchFromSan", exception);
                }
            }
        }
        if (debug) {
            System.out.println("switch totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSanL1.class.getName(), "getSwitchFromSan", "");
        }
    }

    public void getHostFromSan(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
        GraphFabric graphFabric;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSanL1.class.getName(), "getHostFromSan", "");
        }
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("Hosts...");
        }
        if ((graphFabric = (GraphFabric)hashMap.get("fabric:" + n)) == null) {
            TraceLogger.traceMessage(1, ViewerSwitchL2.class.getName(), "getHostFromSan", "No SAN graph object found: " + n);
        }
        try {
            preparedStatement = connection.prepareStatement(SELECT_HOST_FROM_SAN);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = (String)resultSet.getObject("PREFIX_ID");
                Integer n2 = (Integer)resultSet.getObject("HOST_ID");
                if (n2 == null) continue;
                String string2 = String.valueOf(string) + n2;
                if (hashMap.get(string2) == null) {
                    GraphComputer graphComputer = new GraphComputer(string2);
                    this.populator.populateHost(resultSet, graphComputer);
                    hashMap.put(string2, graphComputer);
                    graphModel.put(graphComputer);
                    String string3 = "fabric2server:" + n + ',' + string2;
                    GraphFabric2Computer graphFabric2Computer = new GraphFabric2Computer(string3);
                    graphFabric2Computer.setComputerID((GraphComputer.ID)graphComputer.getEntityID());
                    graphFabric2Computer.setFabricID((GraphFabric.ID)graphFabric.getEntityID());
                    graphModel.put(graphFabric2Computer);
                    hashMap.put(string3, graphFabric2Computer);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "getHostFromSan", "Duplicated host entry:" + string2);
            }
        }
        finally {
            block22: {
                block21: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception) {
                        if (!TraceLogger.enableTrace) break block21;
                        TraceLogger.exception(ViewerSanL1.class.getName(), "getHostFromSan", exception);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    if (!TraceLogger.enableTrace) break block22;
                    TraceLogger.exception(ViewerSanL1.class.getName(), "getHostFromSan", exception);
                }
            }
        }
        if (debug) {
            System.out.println("host totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSanL1.class.getName(), "getHostFromSan", "");
        }
    }

    public void getArrayFromSan(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
        GraphFabric graphFabric;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSanL1.class.getName(), "getArrayFromSan", "");
        }
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("Array...");
        }
        if ((graphFabric = (GraphFabric)hashMap.get("fabric:" + n)) == null) {
            TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "getArrayFromSan", "No SAN graph object found: " + n);
            return;
        }
        try {
            preparedStatement = connection.prepareStatement(SELECT_ARRAY_FROM_SAN);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = (String)resultSet.getObject("PREFIX_ID");
                Integer n2 = (Integer)resultSet.getObject("SUBSYSTEM_ID");
                if (n2 == null) continue;
                String string2 = String.valueOf(string) + n2;
                if (hashMap.get(string2) == null) {
                    GraphSubsystem graphSubsystem = new GraphSubsystem(string2);
                    this.populator.populateSubsystem(resultSet, graphSubsystem);
                    graphModel.put(graphSubsystem);
                    hashMap.put(string2, graphSubsystem);
                    graphModel.put(graphSubsystem);
                    String string3 = "fabric2subsystem:" + n + ',' + string2;
                    GraphFabric2Subsystem graphFabric2Subsystem = new GraphFabric2Subsystem(string3);
                    graphFabric2Subsystem.setSubsystemID((GraphSubsystem.ID)graphSubsystem.getEntityID());
                    graphFabric2Subsystem.setFabricID((GraphFabric.ID)graphFabric.getEntityID());
                    graphModel.put(graphFabric2Subsystem);
                    hashMap.put(string3, graphFabric2Subsystem);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "getArrayFromSan", "Duplicated array entry:" + string2);
            }
        }
        finally {
            block22: {
                block21: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception) {
                        if (!TraceLogger.enableTrace) break block21;
                        TraceLogger.exception(ViewerSanL1.class.getName(), "getArrayFromSan", exception);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    if (!TraceLogger.enableTrace) break block22;
                    TraceLogger.exception(ViewerSanL1.class.getName(), "getArrayFromSan", exception);
                }
            }
        }
        if (debug) {
            System.out.println("Array totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSanL1.class.getName(), "getArrayFromSan", "");
        }
    }

    public void getTapeFromSan(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
        GraphFabric graphFabric;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSanL1.class.getName(), "getTapeFromSan", "");
        }
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("tape...");
        }
        if ((graphFabric = (GraphFabric)hashMap.get("fabric:" + n)) == null) {
            TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "getTapeFromSan", "No SAN graph object found: " + n);
            return;
        }
        try {
            preparedStatement = connection.prepareStatement(SELECT_TAPE_FROM_SAN);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = (String)resultSet.getObject("PREFIX_ID");
                Integer n2 = (Integer)resultSet.getObject("TAPE_LIBRARY_ID");
                if (n2 == null) continue;
                String string2 = String.valueOf(string) + n2;
                if (hashMap.get(string2) == null) {
                    GraphTapeLibrary graphTapeLibrary = new GraphTapeLibrary(string2);
                    this.populator.populateTapeLibrary(resultSet, graphTapeLibrary);
                    graphModel.put(graphTapeLibrary);
                    hashMap.put(string2, graphTapeLibrary);
                    graphModel.put(graphTapeLibrary);
                    String string3 = "fabric2tape:" + n + ',' + string2;
                    GraphFabric2TapeLibrary graphFabric2TapeLibrary = new GraphFabric2TapeLibrary(string3);
                    graphFabric2TapeLibrary.setTapeLibraryID((GraphTapeLibrary.ID)graphTapeLibrary.getEntityID());
                    graphFabric2TapeLibrary.setFabricID((GraphFabric.ID)graphFabric.getEntityID());
                    graphModel.put(graphFabric2TapeLibrary);
                    hashMap.put(string3, graphFabric2TapeLibrary);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "getTapeFromSan", "Duplicated array entry:" + string2);
            }
        }
        finally {
            block22: {
                block21: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception) {
                        if (!TraceLogger.enableTrace) break block21;
                        TraceLogger.exception(ViewerSanL1.class.getName(), "getTapeFromSan", exception);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    if (!TraceLogger.enableTrace) break block22;
                    TraceLogger.exception(ViewerSanL1.class.getName(), "getTapeFromSan", exception);
                }
            }
        }
        if (debug) {
            System.out.println("tape totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSanL1.class.getName(), "getTapeFromSan", "");
        }
    }

    public void getSwitch2SwitchFromSan(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSanL1.class.getName(), "getSwitch2SwitchFromSan", "");
        }
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        l = System.currentTimeMillis();
        if (debug) {
            System.out.println("Switch2Switch...");
        }
        try {
            preparedStatement = connection.prepareStatement(SELECT_SWITCH2SWITCH_FROM_SAN);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = (String)resultSet.getObject("SWITCH_PREFIX_ID1");
                Integer n2 = (Integer)resultSet.getObject("SWITCH1_ID");
                String string2 = (String)resultSet.getObject("SWITCH_PREFIX_ID2");
                Integer n3 = (Integer)resultSet.getObject("SWITCH2_ID");
                Integer n4 = (Integer)resultSet.getObject("PORT2PORT_ID");
                String string3 = String.valueOf(string) + n2;
                String string4 = String.valueOf(string2) + n3;
                GraphSwitch graphSwitch = (GraphSwitch)hashMap.get(string3);
                GraphSwitch graphSwitch2 = (GraphSwitch)hashMap.get(string4);
                if (graphSwitch == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "getSwitch2SwitchFromSan", "Switch element not found: " + string3);
                    continue;
                }
                if (graphSwitch2 == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "getSwitch2SwitchFromSan", "Switch element not found: " + string4);
                    continue;
                }
                String string5 = "port2port:" + n4;
                if (hashMap.get(string5) == null) {
                    GraphSwitch2Switch graphSwitch2Switch = new GraphSwitch2Switch(string5);
                    graphSwitch2Switch.setSwitch1ID((GraphSwitch.ID)graphSwitch.getEntityID());
                    graphSwitch2Switch.setSwitch2ID((GraphSwitch.ID)graphSwitch2.getEntityID());
                    this.populator.populatePort2Port(resultSet, graphSwitch2Switch);
                    graphModel.put(graphSwitch2Switch);
                    hashMap.put(string5, graphSwitch2Switch);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "getSwitch2SwitchFromSan", "Switch2Switch already exists!");
            }
        }
        finally {
            block23: {
                block22: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception) {
                        if (!TraceLogger.enableTrace) break block22;
                        TraceLogger.exception(ViewerSanL1.class.getName(), "getSwitch2SwitchFromSan", exception);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    if (!TraceLogger.enableTrace) break block23;
                    TraceLogger.exception(ViewerSanL1.class.getName(), "getSwitch2SwitchFromSan", exception);
                }
            }
        }
        if (debug) {
            System.out.println("Switch2Switch totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSanL1.class.getName(), "getSwitch2SwitchFromSan", "");
        }
    }

    public void getSwitch2HostFromSan(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSanL1.class.getName(), "getSwitch2HostFromSan", "");
        }
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        l = System.currentTimeMillis();
        if (debug) {
            System.out.println("Switch2Host...");
        }
        try {
            preparedStatement = connection.prepareStatement(SELECT_HOST2SWITCH_FROM_SAN);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = (String)resultSet.getObject("HOST_PREFIX_ID");
                Integer n2 = (Integer)resultSet.getObject("HOST_ID");
                String string2 = (String)resultSet.getObject("SWITCH_PREFIX_ID");
                Integer n3 = (Integer)resultSet.getObject("SWITCH_ID");
                Integer n4 = (Integer)resultSet.getObject("PORT2PORT_ID");
                String string3 = String.valueOf(string2) + n3;
                String string4 = String.valueOf(string) + n2;
                GraphComputer graphComputer = (GraphComputer)hashMap.get(string4);
                GraphSwitch graphSwitch = (GraphSwitch)hashMap.get(string3);
                if (graphComputer != null && graphSwitch != null) {
                    String string5 = "port2port:" + string2 + n3 + ',' + string + n2 + ',' + n4;
                    if (hashMap.get(string5) == null) {
                        GraphSwitch2Computer graphSwitch2Computer = new GraphSwitch2Computer(string5);
                        graphSwitch2Computer.setComputerID((GraphComputer.ID)graphComputer.getEntityID());
                        graphSwitch2Computer.setSwitchID((GraphSwitch.ID)graphSwitch.getEntityID());
                        this.populator.populatePort2Port(resultSet, graphSwitch2Computer);
                        graphModel.put(graphSwitch2Computer);
                        hashMap.put(string5, graphSwitch2Computer);
                        continue;
                    }
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "getSwitch2SwitchFromSan", "Switch2Host already exists!");
                    continue;
                }
                if (graphSwitch == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "getSwitch2SwitchFromSan", "Switch not fould: switch:" + string3);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "getSwitch2SwitchFromSan", "Server not fould: server:" + string4);
            }
        }
        finally {
            block23: {
                block22: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception) {
                        if (!TraceLogger.enableTrace) break block22;
                        TraceLogger.exception(ViewerSanL1.class.getName(), "getSwitch2SwitchFromSan", exception);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    if (!TraceLogger.enableTrace) break block23;
                    TraceLogger.exception(ViewerSanL1.class.getName(), "getSwitch2SwitchFromSan", exception);
                }
            }
        }
        if (debug) {
            System.out.println("Switch2Host totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSanL1.class.getName(), "getSwitch2HostFromSan", "");
        }
    }

    public void getSwitch2ArrayFromSan(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSanL1.class.getName(), "getSwitch2ArrayFromSan", "");
        }
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        l = System.currentTimeMillis();
        if (debug) {
            System.out.println("Switch2Array...");
        }
        try {
            preparedStatement = connection.prepareStatement(SELECT_SWITCH2STORAGE_FROM_SAN);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = (String)resultSet.getObject("SUBSYSTEM_PREFIX_ID");
                Integer n2 = (Integer)resultSet.getObject("SUBSYSTEM_ID");
                String string2 = (String)resultSet.getObject("SWITCH_PREFIX_ID");
                Integer n3 = (Integer)resultSet.getObject("SWITCH_ID");
                Integer n4 = (Integer)resultSet.getObject("PORT2PORT_ID");
                String string3 = String.valueOf(string2) + n3;
                String string4 = String.valueOf(string) + n2;
                GraphSubsystem graphSubsystem = (GraphSubsystem)hashMap.get(string4);
                GraphSwitch graphSwitch = (GraphSwitch)hashMap.get(string3);
                if (graphSubsystem != null && graphSwitch != null) {
                    String string5 = "port2port:" + string2 + n3 + ',' + string + n2 + ',' + n4;
                    if (hashMap.get(string5) == null) {
                        GraphSwitch2Subsystem graphSwitch2Subsystem = new GraphSwitch2Subsystem(string5);
                        graphSwitch2Subsystem.setSubsystemID((GraphSubsystem.ID)graphSubsystem.getEntityID());
                        graphSwitch2Subsystem.setSwitchID((GraphSwitch.ID)graphSwitch.getEntityID());
                        this.populator.populatePort2Port(resultSet, graphSwitch2Subsystem);
                        graphModel.put(graphSwitch2Subsystem);
                        hashMap.put(string5, graphSwitch2Subsystem);
                        continue;
                    }
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "getSwitch2ArrayFromSan", "Switch2Array already exists!");
                    continue;
                }
                if (graphSwitch != null) continue;
                if (TraceLogger.enableTrace) {
                    TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "getSwitch2ArrayFromSan", "Switch not fould: switch:" + n3);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "getSwitch2ArrayFromSan", "Array not fould: array:" + n2);
            }
        }
        finally {
            block23: {
                block22: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception) {
                        if (!TraceLogger.enableTrace) break block22;
                        TraceLogger.exception(ViewerSanL1.class.getName(), "getSwitch2ArrayFromSan", exception);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    if (!TraceLogger.enableTrace) break block23;
                    TraceLogger.exception(ViewerSanL1.class.getName(), "getSwitch2ArrayFromSan", exception);
                }
            }
        }
        if (debug) {
            System.out.println("Switch2Array totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSanL1.class.getName(), "getSwitch2ArrayFromSan", "");
        }
    }

    public void getSansFromSubsystem(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
        this.getSansFromSubsystem(connection, graphModel, hashMap, null, new Integer(n), SELECT_SANS_FROM_ARRAY_FROM_SAN);
    }

    public void getSansFromSubsystem(Connection connection, GraphModel graphModel, HashMap hashMap, String string, Integer n, String string2) throws SQLException {
        Object[] objectArray;
        if (n != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = string;
            objectArray = objectArray2;
            objectArray2[1] = n;
        } else {
            objectArray = null;
        }
        this.getSansFromSubsystem(connection, graphModel, hashMap, objectArray, string2);
    }

    public void getSansFromSubsystem(Connection connection, GraphModel graphModel, HashMap hashMap, Object[] objectArray, String string) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSanL1.class.getName(), "getSansFromSubsystem", "");
        }
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        l = System.currentTimeMillis();
        if (debug) {
            System.out.println("san2subsystem...");
        }
        try {
            preparedStatement = connection.prepareStatement(string);
            if (objectArray != null) {
                int n = 0;
                while (n < objectArray.length) {
                    preparedStatement.setObject(n + 1, objectArray[n]);
                    ++n;
                }
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = (String)resultSet.getObject("PREFIX_ID");
                Integer n = (Integer)resultSet.getObject("SUBSYSTEM_ID");
                Integer n2 = (Integer)resultSet.getObject("FABRIC_ID");
                GraphSubsystem graphSubsystem = new GraphSubsystem(String.valueOf(string2) + n);
                GraphFabric graphFabric = new GraphFabric("fabric:" + n2);
                GraphFabric2Subsystem graphFabric2Subsystem = new GraphFabric2Subsystem("fabric2subsystem:" + n2 + ',' + n);
                graphFabric2Subsystem.setSubsystemID((GraphSubsystem.ID)graphSubsystem.getEntityID());
                graphFabric2Subsystem.setFabricID((GraphFabric.ID)graphFabric.getEntityID());
                graphModel.put(graphFabric2Subsystem);
                graphModel.put(graphSubsystem);
                graphModel.put(graphFabric);
            }
        }
        finally {
            block22: {
                block21: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception) {
                        if (!TraceLogger.enableTrace) break block21;
                        TraceLogger.exception(ViewerSanL1.class.getName(), "getSansFromSubsystem", exception);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    if (!TraceLogger.enableTrace) break block22;
                    TraceLogger.exception(ViewerSanL1.class.getName(), "getSansFromSubsystem", exception);
                }
            }
        }
        if (debug) {
            System.out.println("san2subsystem totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSanL1.class.getName(), "getSansFromSubsystem", "");
        }
    }

    public void getSansFromHost(Connection connection, GraphModel graphModel, HashMap hashMap, String string, int n) throws SQLException {
        this.getSansFromHost(connection, graphModel, hashMap, string, new Integer(n), SELECT_SANS_FROM_HOST_FROM_SAN);
    }

    public void getSansFromHost(Connection connection, GraphModel graphModel, HashMap hashMap, String string, Integer n, String string2) throws SQLException {
        Object[] objectArray;
        if (n != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = string;
            objectArray = objectArray2;
            objectArray2[1] = n;
        } else {
            objectArray = null;
        }
        this.getSansFromHost(connection, graphModel, hashMap, objectArray, string2);
    }

    public void getSansFromHost(Connection connection, GraphModel graphModel, HashMap hashMap, Object[] objectArray, String string) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSanL1.class.getName(), "getSansFromSubsystem", "");
        }
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        l = System.currentTimeMillis();
        if (debug) {
            System.out.println("san2host...");
        }
        try {
            preparedStatement = connection.prepareStatement(string);
            if (objectArray != null) {
                int n = 0;
                while (n < objectArray.length) {
                    preparedStatement.setObject(n + 1, objectArray[n]);
                    ++n;
                }
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = (String)resultSet.getObject("PREFIX_ID");
                Integer n = (Integer)resultSet.getObject("HOST_ID");
                Integer n2 = (Integer)resultSet.getObject("FABRIC_ID");
                GraphComputer graphComputer = new GraphComputer(String.valueOf(string2) + n);
                GraphFabric graphFabric = new GraphFabric("fabric:" + n2);
                GraphFabric2Computer graphFabric2Computer = new GraphFabric2Computer("fabric2server:" + n2 + ',' + n);
                graphFabric2Computer.setFabricID((GraphFabric.ID)graphFabric.getEntityID());
                graphFabric2Computer.setComputerID((GraphComputer.ID)graphComputer.getEntityID());
                graphModel.put(graphComputer);
                graphModel.put(graphFabric);
                graphModel.put(graphFabric2Computer);
            }
        }
        finally {
            block22: {
                block21: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception) {
                        if (!TraceLogger.enableTrace) break block21;
                        TraceLogger.exception(ViewerSanL1.class.getName(), "getSansFromSubsystem", exception);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    if (!TraceLogger.enableTrace) break block22;
                    TraceLogger.exception(ViewerSanL1.class.getName(), "getSansFromSubsystem", exception);
                }
            }
        }
        if (debug) {
            System.out.println("san2host totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSanL1.class.getName(), "getSansFromSubsystem", "");
        }
    }

    public void getZonesFromEntitiesConnectedToEntity(Connection connection, GraphModel graphModel, HashMap hashMap, Object[] objectArray, String[] stringArray) throws SQLException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSwitchL2.class.getName(), "getZonesFROMEntitiesConnectedToEntity", "");
        }
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        if (stringArray[0] != null) {
            l = System.currentTimeMillis();
            if (debug) {
                System.out.println("fabric...");
            }
            try {
                preparedStatement = connection.prepareStatement(stringArray[0]);
                int n = 0;
                while (n < objectArray.length) {
                    preparedStatement.setObject(n + 1, objectArray[n]);
                    ++n;
                }
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    Integer n2 = (Integer)resultSet.getObject("FABRIC_ID");
                    object7 = "fabric:" + n2;
                    object6 = (GraphFabric)hashMap.get(object7);
                    if (object6 == null) {
                        object6 = new GraphFabric((String)object7);
                        this.populator.populateSan(resultSet, (GraphFabric)object6);
                        graphModel.put((GraphEntity)object6);
                        hashMap.put(object7, object6);
                    }
                    if ((object5 = (GraphZoneFabric)hashMap.get(object4 = "zonesan:" + n2)) != null) continue;
                    object5 = new GraphZoneFabric((String)object4);
                    ((GraphEntity)object5).setDisplayName(((GraphEntity)object6).getDisplayName());
                    ((GraphZoneFabric)object5).setFabricID((GraphFabric.ID)((GraphEntity)object6).getEntityID());
                    graphModel.put((GraphEntity)object5);
                    hashMap.put(object4, object5);
                }
            }
            finally {
                block98: {
                    block97: {
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            if (!TraceLogger.enableTrace) break block97;
                            TraceLogger.exception(ViewerSwitchL2.class.getName(), "getZonesFROMEntitiesConnectedToEntity", sQLException);
                        }
                    }
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block98;
                        TraceLogger.exception(ViewerSwitchL2.class.getName(), "getZonesFROMEntitiesConnectedToEntity", sQLException);
                    }
                }
            }
        }
        if (debug) {
            System.out.println("zones totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        l = System.currentTimeMillis();
        preparedStatement = null;
        resultSet = null;
        l = System.currentTimeMillis();
        if (debug) {
            System.out.println("zones...");
        }
        try {
            preparedStatement = connection.prepareStatement(stringArray[1]);
            int n = 0;
            while (n < objectArray.length) {
                preparedStatement.setObject(n + 1, objectArray[n]);
                ++n;
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Integer n3 = (Integer)resultSet.getObject("ZONE_ID");
                object7 = (Integer)resultSet.getObject("FABRIC_ID");
                object6 = "zone:" + n3;
                object4 = (GraphZone)hashMap.get(object6);
                if (object4 == null) {
                    object4 = new GraphZone((String)object6);
                    this.populator.populateZone(resultSet, (GraphZone)object4);
                    graphModel.put((GraphEntity)object4);
                    hashMap.put(object6, object4);
                }
                if ((object3 = (GraphZoneFabric2Zone)hashMap.get(object5 = "zone2san:" + n3)) != null || object7 == null) continue;
                object3 = new GraphZoneFabric2Zone((String)object5);
                object2 = (GraphZoneFabric)hashMap.get("zonesan:" + object7);
                if (object2 == null) continue;
                ((GraphZoneFabric2Zone)object3).setZoneFabricID((GraphZoneFabric.ID)((GraphEntity)object2).getEntityID());
                ((GraphZoneFabric2Zone)object3).setZoneID((GraphZone.ID)((GraphEntity)object4).getEntityID());
                graphModel.put((GraphEntity)object3);
                hashMap.put(object5, object3);
            }
        }
        finally {
            block101: {
                block100: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block100;
                        TraceLogger.exception(ViewerSwitchL2.class.getName(), "getZonesFROMEntitiesConnectedToEntity", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block101;
                    TraceLogger.exception(ViewerSwitchL2.class.getName(), "getZonesFROMEntitiesConnectedToEntity", sQLException);
                }
            }
        }
        if (debug) {
            System.out.println("zones totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        l = System.currentTimeMillis();
        if (debug) {
            System.out.println("zonesets...");
        }
        try {
            preparedStatement = connection.prepareStatement(stringArray[2]);
            int n = 0;
            while (n < objectArray.length) {
                preparedStatement.setObject(n + 1, objectArray[n]);
                ++n;
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Integer n4 = (Integer)resultSet.getObject("ZSET_ID");
                object7 = (Integer)resultSet.getObject("FABRIC_ID");
                object6 = "zset:" + n4;
                object4 = (GraphZoneSet)hashMap.get(object6);
                if (object4 == null) {
                    object4 = new GraphZoneSet((String)object6);
                    this.populator.populateZoneSet(resultSet, (GraphZoneSet)object4);
                    graphModel.put((GraphEntity)object4);
                    hashMap.put(object6, object4);
                }
                if ((object3 = (GraphZoneFabric2ZoneSet)hashMap.get(object5 = "zset2san:" + n4)) != null || object7 == null) continue;
                object3 = new GraphZoneFabric2ZoneSet((String)object5);
                object2 = (GraphZoneFabric)hashMap.get("zonesan:" + object7);
                if (object2 == null) continue;
                ((GraphZoneFabric2ZoneSet)object3).setZoneFabricID((GraphZoneFabric.ID)((GraphEntity)object2).getEntityID());
                ((GraphZoneFabric2ZoneSet)object3).setZoneSetID((GraphZoneSet.ID)((GraphEntity)object4).getEntityID());
                graphModel.put((GraphEntity)object3);
                hashMap.put(object5, object3);
            }
        }
        finally {
            block104: {
                block103: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block103;
                        TraceLogger.exception(ViewerSwitchL2.class.getName(), "getZonesFROMEntitiesConnectedToEntity", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block104;
                    TraceLogger.exception(ViewerSwitchL2.class.getName(), "getZonesFROMEntitiesConnectedToEntity", sQLException);
                }
            }
        }
        if (debug) {
            System.out.println("zonesets totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        l = System.currentTimeMillis();
        if (debug) {
            System.out.println("zset2zone...");
        }
        try {
            preparedStatement = connection.prepareStatement(stringArray[3]);
            int n = 0;
            while (n < objectArray.length) {
                preparedStatement.setObject(n + 1, objectArray[n]);
                ++n;
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Integer n5 = (Integer)resultSet.getObject("ZSET_ID");
                object7 = (Integer)resultSet.getObject("ZONE_ID");
                object6 = "zset:" + n5;
                object4 = "zone:" + object7;
                object5 = "zone2zoneset:" + n5 + ',' + object7;
                object3 = (GraphZoneSet2Zone)hashMap.get(object5);
                if (object3 != null) continue;
                object2 = (GraphZoneSet)hashMap.get(object6);
                object = (GraphZone)hashMap.get(object4);
                if (object2 == null || object == null) continue;
                object3 = new GraphZoneSet2Zone((String)object5);
                ((GraphZoneSet2Zone)object3).setZoneID((GraphZone.ID)((GraphEntity)object).getEntityID());
                ((GraphZoneSet2Zone)object3).setZoneSetID((GraphZoneSet.ID)((GraphEntity)object2).getEntityID());
                graphModel.put((GraphEntity)object3);
                hashMap.put(object5, object3);
            }
        }
        finally {
            block107: {
                block106: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block106;
                        TraceLogger.exception(ViewerSwitchL2.class.getName(), "getZonesFROMEntitiesConnectedToEntity", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block107;
                    TraceLogger.exception(ViewerSwitchL2.class.getName(), "getZonesFROMEntitiesConnectedToEntity", sQLException);
                }
            }
        }
        if (debug) {
            System.out.println("zone2member totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        l = System.currentTimeMillis();
        if (debug) {
            System.out.println("zset2zone...");
        }
        try {
            preparedStatement = connection.prepareStatement(stringArray[4]);
            int n = 0;
            while (n < objectArray.length) {
                preparedStatement.setObject(n + 1, objectArray[n]);
                ++n;
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Integer n6 = (Integer)resultSet.getObject("ZONE_ID");
                object7 = (Integer)resultSet.getObject("PORT_ID");
                String cfr_ignored_0 = (String)resultSet.getObject("TYPE");
                object6 = (String)resultSet.getObject("MEMBER_NAME");
                object4 = (Integer)resultSet.getObject("ZONE_MEMBER_ID");
                object5 = (String)resultSet.getObject("DISPLAY_NAME");
                object3 = (String)resultSet.getObject("PORT_DISPLAY_NAME");
                object2 = (String)resultSet.getObject("PORT_NUMBER");
                object = (String)resultSet.getObject("PREFIX_ID");
                Integer n7 = (Integer)resultSet.getObject("ENTITY_ID");
                String string = String.valueOf(object) + n7;
                String string2 = "zone:" + n6;
                String string3 = object4 + ',' + n6 + ',' + string + ',' + object7;
                String string4 = "zonemember:" + string3;
                GraphZoneMember graphZoneMember = (GraphZoneMember)hashMap.get(string4);
                if (graphZoneMember == null) {
                    graphZoneMember = new GraphZoneMember(string4);
                    GraphEntity graphEntity = (GraphEntity)hashMap.get(string);
                    String string5 = "Port:" + object7;
                    GraphFCPort graphFCPort = (GraphFCPort)hashMap.get(string5);
                    graphZoneMember.setDisplayName((String)object6);
                    if (graphEntity != null) {
                        graphZoneMember.setParentID(graphEntity.getEntityID());
                    } else {
                        graphEntity = null;
                    }
                    graphZoneMember.setParentLabel((String)object5);
                    if (graphFCPort != null) {
                        graphZoneMember.setFCPortID((GraphFCPort.ID)graphFCPort.getEntityID());
                    } else {
                        graphFCPort = null;
                    }
                    graphZoneMember.setFCPortPortNumber((String)object2);
                    graphZoneMember.setFCPortLabel((String)object3);
                    graphZoneMember.setHealthStatus(GraphModelConstant.STATUS_UNKNOWN);
                    graphModel.put(graphZoneMember);
                    hashMap.put(string4, graphZoneMember);
                    string2 = "zone:" + n6;
                    GraphZone graphZone = (GraphZone)hashMap.get(string2);
                    if (graphZone == null) continue;
                    String string6 = "zone2member:" + string3;
                    GraphZone2ZoneMember graphZone2ZoneMember = new GraphZone2ZoneMember(string6);
                    graphZone2ZoneMember.setZoneMemberID((GraphZoneMember.ID)graphZoneMember.getEntityID());
                    graphZone2ZoneMember.setZoneID((GraphZone.ID)graphZone.getEntityID());
                    graphModel.put(graphZone2ZoneMember);
                    hashMap.put(string6, graphZone2ZoneMember);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSwitchL2.class.getName(), "getZonesFROMEntitiesConnectedToEntity", "Zone2Member fould: " + string);
            }
        }
        finally {
            block110: {
                block109: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block109;
                        TraceLogger.exception(ViewerSwitchL2.class.getName(), "getZonesFROMEntitiesConnectedToEntity", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block110;
                    TraceLogger.exception(ViewerSwitchL2.class.getName(), "getZonesFROMEntitiesConnectedToEntity", sQLException);
                }
            }
        }
        if (debug) {
            System.out.println("zone2member totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSwitchL2.class.getName(), "getZonesFROMEntitiesConnectedToEntity", "");
        }
    }

    public void getSansFromSwitch(Connection connection, GraphModel graphModel, HashMap hashMap, String string, Integer n, String string2) throws SQLException {
        Object[] objectArray;
        if (n != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = string;
            objectArray = objectArray2;
            objectArray2[1] = n;
        } else {
            objectArray = null;
        }
        this.getSansFromSwitch(connection, graphModel, hashMap, objectArray, string2);
    }

    public void getSansFromSwitch(Connection connection, GraphModel graphModel, HashMap hashMap, Object[] objectArray, String string) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSanL1.class.getName(), "getSansFromSwitch", "");
        }
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        l = System.currentTimeMillis();
        if (debug) {
            System.out.println("san2switch...");
        }
        try {
            preparedStatement = connection.prepareStatement(string);
            if (objectArray != null) {
                int n = 0;
                while (n < objectArray.length) {
                    preparedStatement.setObject(n + 1, objectArray[n]);
                    ++n;
                }
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = (String)resultSet.getObject("PREFIX_ID");
                Integer n = (Integer)resultSet.getObject("SWITCH_ID");
                Integer n2 = (Integer)resultSet.getObject("FABRIC_ID");
                GraphSwitch graphSwitch = new GraphSwitch(String.valueOf(string2) + n);
                GraphFabric graphFabric = new GraphFabric("fabric:" + n2);
                this.populator.populateSan(resultSet, graphFabric);
                GraphFabric2Switch graphFabric2Switch = new GraphFabric2Switch("fabric2switch:" + n2 + ',' + n);
                graphFabric2Switch.setFabricID((GraphFabric.ID)graphFabric.getEntityID());
                graphFabric2Switch.setSwitchID((GraphSwitch.ID)graphSwitch.getEntityID());
                graphModel.put(graphFabric);
                graphModel.put(graphFabric2Switch);
            }
        }
        finally {
            block22: {
                block21: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception) {
                        if (!TraceLogger.enableTrace) break block21;
                        TraceLogger.exception(ViewerSanL1.class.getName(), "getSansFromSwitch", exception);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    if (!TraceLogger.enableTrace) break block22;
                    TraceLogger.exception(ViewerSanL1.class.getName(), "getSansFromSwitch", exception);
                }
            }
        }
        if (debug) {
            System.out.println("san2switch totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSanL1.class.getName(), "getSansFromSwitch", "");
        }
    }

    public void getSansFromTape(Connection connection, GraphModel graphModel, HashMap hashMap, String string, int n) throws SQLException {
        this.getSansFromTape(connection, graphModel, hashMap, string, new Integer(n), SELECT_SANS_FROM_TAPE_FROM_SAN);
    }

    public void getSansFromTape(Connection connection, GraphModel graphModel, HashMap hashMap, String string, Integer n, String string2) throws SQLException {
        Object[] objectArray;
        if (n != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = string;
            objectArray = objectArray2;
            objectArray2[1] = n;
        } else {
            objectArray = null;
        }
        this.getSansFromTape(connection, graphModel, hashMap, objectArray, string2);
    }

    public void getSansFromTape(Connection connection, GraphModel graphModel, HashMap hashMap, Object[] objectArray, String string) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSanL1.class.getName(), "getSansFromTape", "");
        }
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        l = System.currentTimeMillis();
        if (debug) {
            System.out.println("sans2tape...");
        }
        try {
            preparedStatement = connection.prepareStatement(string);
            if (objectArray != null) {
                int n = 0;
                while (n < objectArray.length) {
                    preparedStatement.setObject(n + 1, objectArray[n]);
                    ++n;
                }
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = (String)resultSet.getObject("PREFIX_ID");
                Integer n = (Integer)resultSet.getObject("TAPE_LIBRARY_ID");
                Integer n2 = (Integer)resultSet.getObject("FABRIC_ID");
                GraphTapeLibrary graphTapeLibrary = new GraphTapeLibrary(String.valueOf(string2) + n);
                GraphFabric graphFabric = new GraphFabric("fabric:" + n2);
                GraphFabric2TapeLibrary graphFabric2TapeLibrary = new GraphFabric2TapeLibrary("fabric2tape:" + n2 + ',' + n);
                graphFabric2TapeLibrary.setFabricID((GraphFabric.ID)graphFabric.getEntityID());
                graphFabric2TapeLibrary.setTapeLibraryID((GraphTapeLibrary.ID)graphTapeLibrary.getEntityID());
                graphModel.put(graphFabric);
                graphModel.put(graphFabric2TapeLibrary);
                graphModel.put(graphTapeLibrary);
            }
        }
        finally {
            block22: {
                block21: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception) {
                        if (!TraceLogger.enableTrace) break block21;
                        TraceLogger.exception(ViewerSanL1.class.getName(), "getSansFromTape", exception);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    if (!TraceLogger.enableTrace) break block22;
                    TraceLogger.exception(ViewerSanL1.class.getName(), "getSansFromTape", exception);
                }
            }
        }
        if (debug) {
            System.out.println("sant22tape totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSanL1.class.getName(), "getSansFromTape", "");
        }
    }

    public void getSansFromUnknown(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
        this.getSansFromUnknown(connection, graphModel, hashMap, new Integer(n), SELECT_SANS_FROM_OTHER_FROM_SAN);
    }

    public void getSansFromUnknown(Connection connection, GraphModel graphModel, HashMap hashMap, Integer n, String string) throws SQLException {
        this.getSansFromUnknown(connection, graphModel, hashMap, new Integer[]{n}, string);
    }

    public void getSansFromUnknown(Connection connection, GraphModel graphModel, HashMap hashMap, Object[] objectArray, String string) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSanL1.class.getName(), "getSansFromUnknown", "");
        }
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        l = System.currentTimeMillis();
        if (debug) {
            System.out.println("sans2unknown...");
        }
        try {
            preparedStatement = connection.prepareStatement(string);
            if (objectArray != null) {
                int n = 0;
                while (n < objectArray.length) {
                    preparedStatement.setObject(n + 1, objectArray[n]);
                    ++n;
                }
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = (String)resultSet.getObject("PREFIX_ID");
                Integer n = (Integer)resultSet.getObject("OTHER_ID");
                Integer n2 = (Integer)resultSet.getObject("FABRIC_ID");
                String string3 = String.valueOf(string2) + n;
                GraphOther graphOther = new GraphOther(string3);
                GraphFabric graphFabric = new GraphFabric("fabric:" + n2);
                GraphFabric2Other graphFabric2Other = new GraphFabric2Other("fabric2other:" + n2 + ',' + string3);
                graphFabric2Other.setOtherID((GraphOther.ID)graphOther.getEntityID());
                graphFabric2Other.setFabricID((GraphFabric.ID)graphFabric.getEntityID());
                graphModel.put(graphFabric2Other);
                graphModel.put(graphFabric);
                graphModel.put(graphOther);
            }
        }
        finally {
            block22: {
                block21: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception) {
                        if (!TraceLogger.enableTrace) break block21;
                        TraceLogger.exception(ViewerSanL1.class.getName(), "getSansFromUnknown", exception);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    if (!TraceLogger.enableTrace) break block22;
                    TraceLogger.exception(ViewerSanL1.class.getName(), "getSansFromUnknown", exception);
                }
            }
        }
        if (debug) {
            System.out.println("sans2unknown totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSanL1.class.getName(), "getSansFromUnknown", "");
        }
    }

    public void getSwitch2TapeFromSan(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSanL1.class.getName(), "getSwitch2TapeFromSan", "");
        }
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        l = System.currentTimeMillis();
        if (debug) {
            System.out.println("Switch2Tape...");
        }
        try {
            preparedStatement = connection.prepareStatement(SELECT_SWITCH2TAPE_FROM_SAN);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = (String)resultSet.getObject("TAPE_PREFIX_ID");
                Integer n2 = (Integer)resultSet.getObject("TAPE_LIBRARY_ID");
                String string2 = (String)resultSet.getObject("SWITCH_PREFIX_ID");
                Integer n3 = (Integer)resultSet.getObject("SWITCH_ID");
                Integer n4 = (Integer)resultSet.getObject("PORT2PORT_ID");
                GraphTapeLibrary graphTapeLibrary = (GraphTapeLibrary)hashMap.get(String.valueOf(string) + n2);
                GraphSwitch graphSwitch = (GraphSwitch)hashMap.get(String.valueOf(string2) + n3);
                if (graphTapeLibrary != null && graphSwitch != null) {
                    String string3 = "port2port:" + string2 + n3 + ',' + string + n2 + ',' + n4;
                    if (hashMap.get(string3) == null) {
                        GraphSwitch2TapeLibrary graphSwitch2TapeLibrary = new GraphSwitch2TapeLibrary(string3);
                        graphSwitch2TapeLibrary.setTapeLibraryID((GraphTapeLibrary.ID)graphTapeLibrary.getEntityID());
                        graphSwitch2TapeLibrary.setSwitchID((GraphSwitch.ID)graphSwitch.getEntityID());
                        this.populator.populatePort2Port(resultSet, graphSwitch2TapeLibrary);
                        graphModel.put(graphSwitch2TapeLibrary);
                        hashMap.put(string3, graphSwitch2TapeLibrary);
                        continue;
                    }
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "getSwitch2TapeFromSan", "Switch2tape already exists!");
                    continue;
                }
                if (graphSwitch != null) continue;
                if (TraceLogger.enableTrace) {
                    TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "getSwitch2TapeFromSan", "Switch not fould: switch:" + n3);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "getSwitch2TapeFromSan", "Tape not fould: tape:" + n2);
            }
        }
        finally {
            block23: {
                block22: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception) {
                        if (!TraceLogger.enableTrace) break block22;
                        TraceLogger.exception(ViewerSanL1.class.getName(), "getSwitch2SwitchFromSan", exception);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    if (!TraceLogger.enableTrace) break block23;
                    TraceLogger.exception(ViewerSanL1.class.getName(), "getSwitch2SwitchFromSan", exception);
                }
            }
        }
        if (debug) {
            System.out.println("Switch2Tape totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSanL1.class.getName(), "getSwitch2TapeFromSan", "");
        }
    }

    public void getSwitch2Unknown(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSanL1.class.getName(), "getwitch2Unknown", "");
        }
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        l = System.currentTimeMillis();
        if (debug) {
            System.out.println("switch2unknown...");
        }
        try {
            preparedStatement = connection.prepareStatement(SELECT_SWITCH2OTHER_FROM_SAN);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Integer n2 = (Integer)resultSet.getObject("OTHER_ID");
                String string = (String)resultSet.getObject("OTHER_PREFIX_ID");
                String string2 = (String)resultSet.getObject("SWITCH_PREFIX_ID");
                Integer n3 = (Integer)resultSet.getObject("SWITCH_ID");
                Integer n4 = (Integer)resultSet.getObject("PORT2PORT_ID");
                String string3 = String.valueOf(string2) + n3;
                String string4 = String.valueOf(string) + n2;
                GraphSwitch graphSwitch = (GraphSwitch)hashMap.get(string3);
                Object v = hashMap.get(string4);
                GraphOther graphOther = (GraphOther)v;
                if (graphSwitch != null && graphOther != null) {
                    String string5 = "port2port:" + string2 + n3 + ',' + string + n2 + ',' + n4;
                    GraphSwitch2Other graphSwitch2Other = new GraphSwitch2Other(string5);
                    graphSwitch2Other.setSwitchID((GraphSwitch.ID)graphSwitch.getEntityID());
                    graphSwitch2Other.setOtherID((GraphOther.ID)graphOther.getEntityID());
                    this.populator.populatePort2Port(resultSet, graphSwitch2Other);
                    graphModel.put(graphSwitch2Other);
                    hashMap.put(string5, graphSwitch2Other);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                if (graphOther == null) {
                    TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "switch2unknown", "Other not found: " + string4);
                    continue;
                }
                TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "switch2unknown", "Switch not found: " + string3);
            }
        }
        finally {
            block22: {
                block21: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception) {
                        if (!TraceLogger.enableTrace) break block21;
                        TraceLogger.exception(ViewerSanL1.class.getName(), "switch2unknown", exception);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    if (!TraceLogger.enableTrace) break block22;
                    TraceLogger.exception(ViewerSanL1.class.getName(), "switch2unknown", exception);
                }
            }
        }
        if (debug) {
            System.out.println("switch2unknown totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSanL1.class.getName(), "getUnknownFromSan", "");
        }
    }

    public void getUnknownFromSan(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSanL1.class.getName(), "getUnknownFromSan", "");
        }
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        l = System.currentTimeMillis();
        if (debug) {
            System.out.println("unknown...");
        }
        try {
            preparedStatement = connection.prepareStatement(SELECT_OTHER_FROM_SAN);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = (String)resultSet.getObject("PREFIX_ID");
                Integer n2 = (Integer)resultSet.getObject("OTHER_ID");
                String string2 = String.valueOf(string) + n2;
                GraphOther graphOther = (GraphOther)hashMap.get(string2);
                if (graphOther != null) continue;
                graphOther = new GraphOther(string2);
                this.populator.populateOther(resultSet, graphOther);
                graphModel.put(graphOther);
                hashMap.put(string2, graphOther);
            }
        }
        finally {
            block20: {
                block19: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception) {
                        if (!TraceLogger.enableTrace) break block19;
                        TraceLogger.exception(ViewerSanL1.class.getName(), "switch2unknown", exception);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    if (!TraceLogger.enableTrace) break block20;
                    TraceLogger.exception(ViewerSanL1.class.getName(), "switch2unknown", exception);
                }
            }
        }
        if (debug) {
            System.out.println("unknown totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSanL1.class.getName(), "getUnknownFromSan", "");
        }
    }

    public void getZonesFromSan(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
        this.getZonesFromEntitiesConnectedToEntity(connection, graphModel, hashMap, new Object[]{new Integer(n)}, new String[]{SELECT_FABRIC_FROM_ZONES_FROM_SAN, SELECT_ZONES_FROM_SAN, SELECT_ZONESET_FROM_SAN, SELECT_ZONESET2ZONE_FROM_SAN, SELECT_ZONE2MEMBER_FROM_SAN});
    }

    public void removeTmpHosts(Connection connection, int n) throws SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(DELETE_TMP_HOSTS);
            preparedStatement.setInt(1, n);
            preparedStatement.executeUpdate();
            this.commit(connection);
        }
        finally {
            block15: {
                block14: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block14;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "removeTmpHosts", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block15;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "removeTmpHosts", sQLException);
                }
            }
        }
    }

    public void setTmpEntity(Connection connection, Vector vector, int n) throws SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(INSERT_TMP_HOST);
            for (GraphEntity.ID iD : vector) {
                String string = (String)iD.getID();
                int n2 = string.indexOf(58);
                String string2 = string.substring(0, n2 + 1);
                string = string.substring(n2 + 1);
                int n3 = Integer.parseInt(string);
                preparedStatement.setString(1, string2);
                preparedStatement.setInt(2, n3);
                preparedStatement.setInt(3, n);
                preparedStatement.executeUpdate();
                this.commit(connection);
            }
        }
        finally {
            block16: {
                block15: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block15;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "setHost", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block16;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "setHost", sQLException);
                }
            }
        }
    }

    public void getView(Connection connection, ViewerRequest viewerRequest, ViewerResponse viewerResponse) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSanL1.class.getName(), "getView", "");
        }
        GraphModelFabricL2 graphModelFabricL2 = null;
        String string = null;
        GraphEntity.ID iD = viewerRequest.getModelID().getFocusEntityID();
        string = (String)iD.getID();
        string = string.substring(string.indexOf(58) + 1);
        int n = Integer.parseInt(string);
        HashMap<String, GraphFabric> hashMap = new HashMap<String, GraphFabric>();
        Timestamp timestamp = viewerRequest.getTimestamp();
        Timestamp timestamp2 = null;
        if (timestamp2 == null || timestamp == null || timestamp2.after(timestamp)) {
            graphModelFabricL2 = new GraphModelFabricL2((GraphModelFabricL2.ID)viewerRequest.getModelID());
            GraphFabric graphFabric = this.getSan(connection, null, null, n);
            if (graphFabric != null) {
                hashMap.put("fabric:" + n, graphFabric);
                graphModelFabricL2.put(graphFabric);
                this.getSwitchFromSan(connection, graphModelFabricL2, hashMap, n);
                this.getHostFromSan(connection, graphModelFabricL2, hashMap, n);
                this.getArrayFromSan(connection, graphModelFabricL2, hashMap, n);
                this.getTapeFromSan(connection, graphModelFabricL2, hashMap, n);
                this.getUnknownFromSan(connection, graphModelFabricL2, hashMap, n);
                this.commit(connection);
                this.getSwitch2SwitchFromSan(connection, graphModelFabricL2, hashMap, n);
                this.getSwitch2ArrayFromSan(connection, graphModelFabricL2, hashMap, n);
                this.getSwitch2HostFromSan(connection, graphModelFabricL2, hashMap, n);
                this.getSwitch2TapeFromSan(connection, graphModelFabricL2, hashMap, n);
                this.getSwitch2Unknown(connection, graphModelFabricL2, hashMap, n);
                this.commit(connection);
                if (viewerRequest.getModelID().isNeedZoneData()) {
                    this.getZonesFromSan(connection, graphModelFabricL2, hashMap, n);
                    this.commit(connection);
                }
                graphModelFabricL2.setWithZoneData(viewerRequest.getModelID().isNeedZoneData());
                viewerResponse.addResponse(0, graphModelFabricL2);
            } else {
                viewerResponse.addResponse(0, graphModelFabricL2);
                if (TraceLogger.enableTrace) {
                    TraceLogger.traceMessage(2, ViewerSanL1.class.getName(), "getSwitch2SwitchFromSan", "gmodel=" + graphModelFabricL2);
                }
            }
        } else {
            viewerResponse.addResponse(0, null);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSanL1.class.getName(), "getView", "");
        }
    }

    public void main(String[] stringArray) {
    }
}

