/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.views;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelComputerL0;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2Computer;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.guireq.topology.request.ViewerRequest;
import org.eclipse.aperi.server.guireq.topology.request.ViewerResponse;
import org.eclipse.aperi.server.guireq.topology.views.ViewerEntityPopulator;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSanL1;
import org.eclipse.aperi.server.guireq.topology.views.ViewerServerL2;

public class ViewerServerL0
extends ViewerSanL1 {
    protected ViewerEntityPopulator populator = new ViewerEntityPopulator();
    public static boolean debug = false;
    public static String SELECT_SERVER = "SELECT \t\tT_RES_HOST.PREFIX_ID, \t    CASE WHEN T_RES_HOST.HOST_NAME IS NOT NULL THEN T_RES_HOST.HOST_NAME \t\t\t WHEN T_RES_HOST.HOST_URL IS NOT NULL THEN T_RES_HOST.HOST_URL \t\t\t ELSE CAST(T_RES_HOST.COMPUTER_ID as CHAR(10)) \t\tEND  DISPLAY_NAME,        T_RES_HOST.DEV_STATUS DEV_STATUS,        T_RES_HOST.DAT_STATUS DAT_STATUS, \t\tT_RES_HOST.HOST_NAME HOST_NAME, \t\tT_RES_HOST.COMPUTER_ID HOST_ID, \t\tT_RES_HOST.GUID GUID, \t\tT_RES_HOST.OS_TYPE OS_TYPE,\t\tT_RES_HOST.OS_VERSION OS_VERSION,\t\tT_RES_HOST.TIME_ZONE TIME_ZONE,\t\tT_RES_HOST.IP_ADDRESS IP_ADDRESS,\t\tT_RES_HOST.DETECTABLE DETECTABLE, \t\tT_RES_HOST.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_HOST.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t\tT_RES_HOST.PROPAGATED_STATUS PROPAGATED_STATUS, \t\tT_RES_HOST.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_HOST.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_HOST.USER_ATTRIB3 USER_ATTRIB3 FROM \tT_VIEW_VHOST T_RES_HOST ";
    public static String SELECT_SANS_FOR_HOST = "select distinct \tHOST2FABRIC.PREFIX_ID, \tHOST2FABRIC.HOST_ID HOST_ID, \tHOST2FABRIC.FABRIC_ID FABRIC_ID from T_VIEW_VHOST2FABRIC HOST2FABRIC";

    public void getHosts(Connection connection, GraphModel graphModel, HashMap hashMap) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerServerL0.class.getName(), "getHosts", "");
        }
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("host...");
        }
        GraphComputer graphComputer = null;
        try {
            preparedStatement = connection.prepareStatement(SELECT_SERVER);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = (String)resultSet.getObject("PREFIX_ID");
                Integer n = (Integer)resultSet.getObject("HOST_ID");
                if (n == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getHosts", "SUBSYSTEM_ID is NULL");
                    continue;
                }
                String string2 = String.valueOf(string) + n;
                if (hashMap == null || hashMap.get(string2) == null) {
                    graphComputer = new GraphComputer(string2);
                    this.populator.populateHost(resultSet, graphComputer);
                    if (graphModel != null) {
                        graphModel.put(graphComputer);
                    }
                    if (hashMap == null) continue;
                    hashMap.put(string2, graphComputer);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getHosts", "Duplicated Host entry:" + string2);
            }
        }
        finally {
            block23: {
                block22: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block22;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getHosts", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block23;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getHosts", sQLException);
                }
            }
        }
        if (debug) {
            System.out.println("host totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerServerL0.class.getName(), "getHosts", "");
        }
    }

    public void getSansFromHost(Connection connection, GraphModel graphModel, HashMap hashMap, Object[] objectArray, String string) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSanL1.class.getName(), "getSansFromSubsystem", "");
        }
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        l = System.currentTimeMillis();
        if (debug) {
            System.out.println("san2host...");
        }
        try {
            preparedStatement = connection.prepareStatement(string);
            if (objectArray != null) {
                int n = 0;
                while (n < objectArray.length) {
                    preparedStatement.setObject(n + 1, objectArray[n]);
                    ++n;
                }
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = (String)resultSet.getObject("PREFIX_ID");
                Integer n = (Integer)resultSet.getObject("HOST_ID");
                Integer n2 = (Integer)resultSet.getObject("FABRIC_ID");
                GraphComputer graphComputer = new GraphComputer(String.valueOf(string2) + n);
                GraphFabric graphFabric = new GraphFabric("fabric:" + n2);
                GraphFabric2Computer graphFabric2Computer = new GraphFabric2Computer("fabric2server:" + n2 + ',' + n);
                graphFabric2Computer.setFabricID((GraphFabric.ID)graphFabric.getEntityID());
                graphFabric2Computer.setComputerID((GraphComputer.ID)graphComputer.getEntityID());
                graphModel.put(graphComputer);
                graphModel.put(graphFabric);
                graphModel.put(graphFabric2Computer);
            }
        }
        finally {
            block22: {
                block21: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception) {
                        if (!TraceLogger.enableTrace) break block21;
                        TraceLogger.exception(ViewerSanL1.class.getName(), "getSansFromSubsystem", exception);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    if (!TraceLogger.enableTrace) break block22;
                    TraceLogger.exception(ViewerSanL1.class.getName(), "getSansFromSubsystem", exception);
                }
            }
        }
        if (debug) {
            System.out.println("san2host totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSanL1.class.getName(), "getSansFromSubsystem", "");
        }
    }

    public void getSansFromHost(Connection connection, GraphModel graphModel, HashMap hashMap) throws SQLException {
        this.getSansFromHost(connection, graphModel, hashMap, null, SELECT_SANS_FOR_HOST);
    }

    public void commit(Connection connection) {
        block2: {
            try {
                connection.commit();
            }
            catch (SQLException sQLException) {
                if (!TraceLogger.enableTrace) break block2;
                TraceLogger.exception(ViewerServerL2.class.getName(), "commit", sQLException);
            }
        }
    }

    public void getView(Connection connection, ViewerRequest viewerRequest, ViewerResponse viewerResponse) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerServerL0.class.getName(), "getView", "");
        }
        HashMap hashMap = new HashMap();
        Timestamp timestamp = viewerRequest.getTimestamp();
        Timestamp timestamp2 = null;
        if (timestamp2 == null || timestamp == null || timestamp2.after(timestamp)) {
            GraphModelComputerL0 graphModelComputerL0 = new GraphModelComputerL0((GraphModelComputerL0.ID)viewerRequest.getModelID());
            this.getHosts(connection, graphModelComputerL0, hashMap);
            viewerResponse.addResponse(0, graphModelComputerL0);
            graphModelComputerL0.setWithZoneData(true);
            this.commit(connection);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerServerL0.class.getName(), "getView", "");
        }
    }

    public void main(String[] stringArray) {
    }
}

