/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.req;

import java.util.HashMap;
import org.eclipse.aperi.agent.req.AgentRequestData;
import org.eclipse.aperi.agent.req.AgentStatusReq;
import org.eclipse.aperi.common.LockResource;
import org.eclipse.aperi.common.ReadLogRequest;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.logging.AuditConfigRequest;
import org.eclipse.aperi.logging.LogConfigRequest;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.StateChangeReq;
import org.eclipse.aperi.sanmgmt.middleware.data.RoleData;
import org.eclipse.aperi.server.guireq.InbandFabricAgentInfo;
import org.eclipse.aperi.server.guireq.UserPreferences;
import org.eclipse.aperi.server.req.AgentCommandReq;
import org.eclipse.aperi.server.req.AgentStateReq;
import org.eclipse.aperi.server.req.ComputerID;
import org.eclipse.aperi.server.req.GuiInfoReq;
import org.eclipse.aperi.server.req.GuiToAgentReq;
import org.eclipse.aperi.server.req.RolesUpdateReq;
import org.eclipse.aperi.server.req.SignonReq;
import org.eclipse.aperi.server.req.UninstallAgentReq;
import org.eclipse.aperi.server.req.UserPrefUpdReq;

public class ServerRequest {
    private static final String CLASSNAME = ServerRequest.class.getName();

    public static void serverRequest(Request request) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "serverRequest", "request");
        }
        request.typeCode = "org.eclipse.aperi.server.svp.ServerSvp";
        request.serviceName = RequestTypeManager.getInternalName("org.eclipse.aperi.server.svp.ServerSvp");
        request.requestData = null;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "serverRequest");
        }
    }

    public static void stateChange(Request request, byte by, String string) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "stateChange", "request, newState, service");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.StateChangeHndlr";
        request.flags = (byte)5;
        StateChangeReq stateChangeReq = new StateChangeReq();
        stateChangeReq.newState = by;
        stateChangeReq.serviceProvider = string;
        request.requestData = stateChangeReq;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "stateChange");
        }
    }

    public static void serverStatus(Request request) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "serverStatus", "request");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.ServerStatusHndlr";
        request.flags = (byte)4;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "serverStatus");
        }
    }

    public static void signon(Request request, String string, String string2) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "signon", "request, id, pwd");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.SignonHndlr";
        request.flags = (byte)4;
        SignonReq signonReq = new SignonReq();
        signonReq.id = string;
        signonReq.pwd = string2;
        request.requestData = signonReq;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "signon");
        }
    }

    public static void userPrefUpd(Request request, String string, UserPreferences userPreferences) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "userPrefUpd", "request, id, prefs");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.UserPrefUpdHndlr";
        request.flags = (byte)4;
        UserPrefUpdReq userPrefUpdReq = new UserPrefUpdReq();
        userPrefUpdReq.id = string;
        userPrefUpdReq.prefs = userPreferences;
        request.requestData = userPrefUpdReq;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "userPrefUpd");
        }
    }

    public static void broadcast(Request request) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "broadcast", "request");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.BroadcastHndlr";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "broadcast");
        }
    }

    public static void lockQuery(Request request, short s, String string) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "", "request, productID, resource");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.LockQueryHndlr";
        request.requestData = LockResource.getLockResource(s, string);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "");
        }
    }

    public static void agentState(Request request, ComputerID computerID, byte by) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "agentState", "request, computerID, state");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.AgentStateHndlr";
        request.flags = (byte)4;
        AgentStateReq agentStateReq = new AgentStateReq();
        agentStateReq.computerID = computerID;
        agentStateReq.state = by;
        request.requestData = agentStateReq;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "agentState");
        }
    }

    public static void guiInfo(Request request, int n, int n2) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "guiInfo", "request, dataRequested, dataFor");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.GuiHndlr";
        request.flags = (byte)4;
        GuiInfoReq guiInfoReq = new GuiInfoReq();
        guiInfoReq.dataRequested = n;
        guiInfoReq.dataFor = n2;
        request.requestData = guiInfoReq;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "guiInfo");
        }
    }

    public static void agentJobs(Request request, int n) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "agentJobs", "request, agentComputerID");
        }
        GuiToAgentReq guiToAgentReq = ServerRequest.guiToAgentReq(request, n);
        guiToAgentReq.requestHandler = "org.eclipse.aperi.agent.handler.status.StatusHandler";
        guiToAgentReq.agentData = new AgentStatusReq(true);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "agentJobs");
        }
    }

    public static void agentStatus(Request request, int n) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "agentStatus", "request, agentComputerID");
        }
        GuiToAgentReq guiToAgentReq = ServerRequest.guiToAgentReq(request, n);
        guiToAgentReq.requestHandler = "org.eclipse.aperi.agent.handler.status.StatusHandler";
        guiToAgentReq.agentData = new AgentStatusReq(false);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "agentStatus");
        }
    }

    private static GuiToAgentReq guiToAgentReq(Request request, int n) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "guiToAgentReq", "request, agentComputerID");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.GuiToAgentHndlr";
        request.flags = (byte)4;
        GuiToAgentReq guiToAgentReq = new GuiToAgentReq();
        guiToAgentReq.computerID = n;
        request.requestData = guiToAgentReq;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "guiToAgentReq", guiToAgentReq);
        }
        return guiToAgentReq;
    }

    public static void agentStop(Request request, int n, byte by) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "agentStop", "request, agentComputerID, stopType");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.GuiToAgentHndlr";
        request.flags = (byte)5;
        GuiToAgentReq guiToAgentReq = new GuiToAgentReq();
        guiToAgentReq.computerID = n;
        guiToAgentReq.requestHandler = "org.eclipse.aperi.agent.handler.state.ShutdownHandler";
        StateChangeReq stateChangeReq = new StateChangeReq();
        stateChangeReq.newState = by;
        guiToAgentReq.agentData = stateChangeReq;
        request.requestData = guiToAgentReq;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "agentStop");
        }
    }

    public static void agentReadConfig(Request request, int n) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "agentReadConfig", "request, agentComputerID");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.GuiToAgentHndlr";
        request.flags = (byte)5;
        GuiToAgentReq guiToAgentReq = new GuiToAgentReq();
        guiToAgentReq.computerID = n;
        guiToAgentReq.requestHandler = "org.eclipse.aperi.agent.handler.config.ReadConfigHandler";
        guiToAgentReq.agentData = new AgentRequestData();
        request.requestData = guiToAgentReq;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "agentReadConfig");
        }
    }

    public static void agentGetAgentHome(Request request, int n) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "agentGetAgentHome", "request, agentComputerID");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.GuiToAgentHndlr";
        request.flags = (byte)5;
        GuiToAgentReq guiToAgentReq = new GuiToAgentReq();
        guiToAgentReq.computerID = n;
        guiToAgentReq.requestHandler = "org.eclipse.aperi.agent.handler.config.GetAgentHomeHandler";
        guiToAgentReq.agentData = new AgentRequestData();
        request.requestData = guiToAgentReq;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "agentGetAgentHome");
        }
    }

    public static void agentReadLog(Request request, int n, ReadLogRequest readLogRequest) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "agentReadLog", "request, agentComputerID, readLogRequest");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.GuiToAgentHndlr";
        request.flags = (byte)5;
        GuiToAgentReq guiToAgentReq = new GuiToAgentReq();
        guiToAgentReq.computerID = n;
        guiToAgentReq.requestHandler = "org.eclipse.aperi.agent.handler.log.DaemonLogFileHandler";
        guiToAgentReq.agentData = readLogRequest;
        request.requestData = guiToAgentReq;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "agentReadLog");
        }
    }

    public static void readInbandAgentLog(Request request, int n, ReadLogRequest readLogRequest) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "readInbandAgentLog", "request, agentComputerID, readLogRequest");
        }
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.gui.fabric.InBandFabricAgentHandler";
        request.flags = (byte)5;
        InbandFabricAgentInfo inbandFabricAgentInfo = new InbandFabricAgentInfo();
        inbandFabricAgentInfo.hostId = n;
        inbandFabricAgentInfo.request_type = 4;
        inbandFabricAgentInfo.agentData = readLogRequest;
        request.requestData = inbandFabricAgentInfo;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "readInbandAgentLog");
        }
    }

    public static void agentReadJobLog(Request request, int n, ReadLogRequest readLogRequest) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "agentReadJobLog", "request, agentComputerID, readLogRequest");
        }
        ServerRequest.serverRequest(request);
        request.flags = (byte)4;
        if (n < 0) {
            request.subType = "org.eclipse.aperi.server.handler.server.ReadJobLogHndlr";
            request.requestData = readLogRequest;
        } else {
            request.subType = "org.eclipse.aperi.server.handler.server.GuiToAgentHndlr";
            GuiToAgentReq guiToAgentReq = new GuiToAgentReq();
            guiToAgentReq.computerID = n;
            guiToAgentReq.requestHandler = "org.eclipse.aperi.agent.handler.log.JobLogFileHandler";
            guiToAgentReq.agentData = readLogRequest;
            request.requestData = guiToAgentReq;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "agentReadJobLog");
        }
    }

    public static void readServiceLog(Request request, ReadLogRequest readLogRequest) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "readServiceLog", "request, readLogRequest");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.GuiHndlr";
        request.flags = (byte)5;
        GuiInfoReq guiInfoReq = new GuiInfoReq();
        guiInfoReq.dataRequested = GuiInfoReq.READ_LOG;
        guiInfoReq.rlRequest = readLogRequest;
        request.requestData = guiInfoReq;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "readServiceLog");
        }
    }

    public static void uninstallAgent(Request request, int n, byte by) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "uninstallAgent", "request, agentComputerID, productCode");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.UninstallAgentHndlr";
        request.flags = (byte)5;
        UninstallAgentReq uninstallAgentReq = new UninstallAgentReq();
        uninstallAgentReq.computerID = n;
        uninstallAgentReq.productCode = by;
        request.requestData = uninstallAgentReq;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "uninstallAgent");
        }
    }

    public static void agentGetTracingConfig(Request request, int n, String string) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "agentGetTracingConfig", "request, agentComputerID, reqCode");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.GuiToAgentHndlr";
        GuiToAgentReq guiToAgentReq = new GuiToAgentReq();
        guiToAgentReq.computerID = n;
        guiToAgentReq.requestHandler = "org.eclipse.aperi.agent.handler.log.config.AgentLogConfigHandler";
        guiToAgentReq.agentData = new LogConfigRequest(false, null, string);
        request.requestData = guiToAgentReq;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "agentGetTracingConfig");
        }
    }

    public static void agentSetTracingConfig(Request request, int n, HashMap hashMap, String string) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "agentSetTracingConfig", "request, agentComputerID, tracingConfigMap, reqCode");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.GuiToAgentHndlr";
        GuiToAgentReq guiToAgentReq = new GuiToAgentReq();
        guiToAgentReq.computerID = n;
        guiToAgentReq.requestHandler = "org.eclipse.aperi.agent.handler.log.config.AgentLogConfigHandler";
        guiToAgentReq.agentData = new LogConfigRequest(true, hashMap, string);
        request.requestData = guiToAgentReq;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "agentSetTracingConfig");
        }
    }

    public static void serverGetTracingConfig(Request request, String string) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "serverGetTracingConfig", "request, reqCode");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.ServerLogConfigHandler";
        request.requestData = new LogConfigRequest(false, null, string);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "serverGetTracingConfig");
        }
    }

    public static void serverSetTracingConfig(Request request, HashMap hashMap, String string) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "serverSetTracingConfig", "request, tracingConfigMap, reqCode");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.ServerLogConfigHandler";
        request.requestData = new LogConfigRequest(true, hashMap, string);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "serverSetTracingConfig");
        }
    }

    public static void serverGetAuditConfig(Request request, String string) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "serverGetAuditConfig", "request, reqCode");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.ServerAuditConfigHandler";
        request.requestData = new AuditConfigRequest(false, null, string);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "serverGetAuditConfig");
        }
    }

    public static void serverSetAuditConfig(Request request, HashMap hashMap, String string) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "serverSetAuditConfig", "request, tracingConfigMap, reqCode");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.ServerAuditConfigHandler";
        request.requestData = new AuditConfigRequest(true, hashMap, string);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "serverSetAuditConfig");
        }
    }

    public static void agentCommand(Request request, Request request2, int[] nArray) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "agentCommand", "request, agentRequest, agentComputerIDs");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.AgentCommandHndlr";
        request.flags = (byte)4;
        AgentCommandReq agentCommandReq = new AgentCommandReq();
        agentCommandReq.acrRequest = request2;
        agentCommandReq.acrAgentIDs = nArray;
        request.requestData = agentCommandReq;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "agentCommand");
        }
    }

    public static void updateGroup2Roles(Request request, byte by, RoleData[] roleDataArray) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "updateGroup2Roles", "request, groupData");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.RolesUpdateHndlr";
        request.flags = (byte)4;
        RolesUpdateReq rolesUpdateReq = new RolesUpdateReq();
        rolesUpdateReq.flags = by;
        rolesUpdateReq.roleData = roleDataArray;
        request.requestData = rolesUpdateReq;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "updateGroup2Roles");
        }
    }

    public static void deviceReadJobLog(Request request, int n, ReadLogRequest readLogRequest) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "deviceReadJobLog", "request, agentComputerID, readLogRequest");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.ReadDeviceLogHndlr";
        request.flags = (byte)4;
        GuiToAgentReq guiToAgentReq = new GuiToAgentReq();
        guiToAgentReq.computerID = n;
        guiToAgentReq.requestHandler = "org.eclipse.aperi.agent.handler.log.JobLogFileHandler";
        guiToAgentReq.agentData = readLogRequest;
        request.requestData = guiToAgentReq;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "deviceReadJobLog");
        }
    }
}

