/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.topology.gui;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.tree.TreeNode;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.topology.gui.TopologyViewerDefinition;
import org.eclipse.aperi.topology.gui.TopologyViewerTreeLabel;
import org.eclipse.aperi.topology.gui.TopologyViewerTreeNode;

public class TopologyViewerTreeDDI
extends DataDisplayInfo
implements ActionListener {
    private static final String clazz = TopologyViewerDefinition.class.getName();
    private boolean usingHandlers = false;
    private JComponent panel1 = null;
    private boolean losingFocus = true;

    public TopologyViewerTreeDDI() {
        super(GuiUtil.getString("TOPO_MSG_TOPOLOGY"));
        this.helpID = null;
        this.displayInScrollPane = false;
    }

    public void printData(Container container) {
        if (this.panel != null) {
            ((TopologyViewerDefinition)this.panel).print(container);
        }
    }

    public String getHelpID() {
        String string = ((TopologyViewerDefinition)this.panel).getCurrentViewType();
        if (string.equals("Overview")) {
            return "bta_dlg_topology_topologyview";
        }
        if (string.equals("FabricL0")) {
            return "bta_dlg_topology_sansl0";
        }
        if (string.equals("FabricL1")) {
            return "bta_dlg_topology_sansl1";
        }
        if (string.equals("ComputerL0")) {
            return "bta_dlg_topology_computersl0";
        }
        if (string.equals("ComputerL1")) {
            return "bta_dlg_topology_computersl1";
        }
        if (string.equals("ComputerL2")) {
            return "bta_dlg_topology_computersl2";
        }
        if (string.equals("SwitchL2")) {
            return "bta_dlg_topology_sansl2_switch";
        }
        if (string.equals("StorageL0")) {
            return "bta_dlg_topology_storagel0";
        }
        if (string.equals("SubsystemL1")) {
            return "bta_dlg_topology_storagel1_subsystems";
        }
        if (string.equals("SubsystemL2")) {
            return "bta_dlg_topology_storagel2_subsystem";
        }
        if (string.equals("TapeLibraryL1")) {
            return "bta_dlg_topology_storagel1_tapelibs";
        }
        if (string.equals("TapeLibraryL2")) {
            return "bta_dlg_topology_storagel2_tapelib";
        }
        if (string.equals("OtherL0")) {
            return "bta_dlg_topology_otherl0";
        }
        if (string.equals("OtherL1")) {
            return "bta_dlg_topology_otherl1";
        }
        if (string.equals("OtherL2")) {
            return "bta_dlg_topology_otherl2";
        }
        return "bta_ovw_topologyviewer";
    }

    public void showPanel() {
        this.show();
    }

    public void show() {
        super.show();
        if (this.panel != null && this.panel.getParent() != null) {
            this.panel.getParent().validate();
        }
    }

    private void constructView(BaseTreeNode baseTreeNode, GraphModel.ID iD) {
        if (this.panel == null) {
            this.losingFocus = true;
            this.panel = new TopologyViewerDefinition();
        }
        if (guiMain == null) {
            guiMain = GuiManager.getGuiManager().getGuiMain();
        }
        guiMain.setSaveActionEnabled(false, false);
        if (!this.usingHandlers) {
            this.usingHandlers = true;
            guiMain.addCancelActionListener(this);
            guiMain.addStopActionListener(this);
        }
        if (this.panel instanceof TopologyViewerDefinition && iD != null) {
            ((TopologyViewerDefinition)this.panel).openView(iD);
        }
        if (baseTreeNode != null) {
            this.treeNode = baseTreeNode;
        }
    }

    public void reDisplay() {
        this.losingFocus = false;
        this.constructView(null, null);
        this.show();
    }

    public void reDisplay(BaseTreeNode baseTreeNode, GraphModel.ID iD) {
        this.losingFocus = false;
        this.constructView(baseTreeNode, iD);
        this.show();
    }

    public void losingFocus() {
        if (guiMain == null) {
            guiMain = GuiManager.getGuiManager().getGuiMain();
        }
        if (this.losingFocus) {
            guiMain.setSaveActionEnabled(false, false);
            guiMain.setSaveActionToolTip(null);
            if (this.usingHandlers) {
                this.usingHandlers = false;
                guiMain.removeCancelActionListener(this);
                guiMain.removeStopActionListener(this);
            }
            if (this.panel instanceof TopologyViewerDefinition) {
                ((TopologyViewerDefinition)this.panel).setConfigOUT();
            }
        }
        this.losingFocus = true;
    }

    public void panelToBeNulled() {
        if (this.panel != null && this.panel instanceof TopologyViewerDefinition) {
            ((TopologyViewerDefinition)this.panel).setConfigOUT();
        }
        this.panel = null;
    }

    public void goingAway() {
        if (this.panel != null && this.panel instanceof TopologyViewerDefinition) {
            ((TopologyViewerDefinition)this.panel).goingAway();
        }
        this.panel = null;
        Enumeration<TreeNode> enumeration = null;
        if (this.treeNode instanceof TopologyViewerTreeLabel) {
            enumeration = this.treeNode.children();
        } else if (this.treeNode instanceof TopologyViewerTreeNode && this.treeNode.getParent() != null) {
            ((BaseTreeNode)this.treeNode.getParent()).ddi = null;
            enumeration = this.treeNode.getParent().children();
        }
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                TopologyViewerTreeNode topologyViewerTreeNode = (TopologyViewerTreeNode)enumeration.nextElement();
                topologyViewerTreeNode.ddi = null;
            }
        }
    }

    public boolean isEditable() {
        return false;
    }

    public boolean changesPending() {
        return false;
    }

    public void saveAndClose() {
        this.save();
        this.remove();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.panel instanceof TopologyViewerDefinition) {
            ((TopologyViewerDefinition)this.panel).actionPerformed(actionEvent);
        }
    }

    private void save() {
        if (this.panel instanceof TopologyViewerDefinition) {
            ((TopologyViewerDefinition)this.panel).save();
        }
    }
}

