/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.xml.util.date;

import com.ibm.icu.util.ULocale;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.birt.report.data.oda.xml.i18n.Messages;
import org.eclipse.birt.report.data.oda.xml.util.date.DateFormatFactory;
import org.eclipse.birt.report.data.oda.xml.util.date.DateFormatISO8601;
import org.eclipse.datatools.connectivity.oda.OdaException;

public final class DateUtil {
    private static ULocale DEFAULT_LOCALE;
    private static int DEFAULT_DATE_STYLE;
    private static SimpleDateFormat[] simpleDateFormatter;
    private static SimpleDateFormat[] simpleTimeFormatter;
    public static long count;

    public static Date toDate(Object source) throws OdaException {
        if (source == null) {
            return null;
        }
        if (source instanceof Date) {
            return new Date(((Date)source).getTime());
        }
        if (source instanceof String) {
            return DateUtil.toDate((String)source);
        }
        throw new OdaException(Messages.getString("DateUtil.ConvertFails") + source.toString());
    }

    public static Date toDate(String source, ULocale locale) throws OdaException {
        if (source == null) {
            return null;
        }
        DateFormat dateFormat = null;
        Date resultDate = null;
        boolean existTime = source.matches(".*[0-9]+:[0-9]+:[0-9]+.*") || source.matches(".*[0-9]+:[0-9]+.*");
        for (int i = DEFAULT_DATE_STYLE; i <= 3; ++i) {
            for (int j = DEFAULT_DATE_STYLE; j <= 3; ++j) {
                dateFormat = DateFormatFactory.getDateTimeInstance(i, j, locale);
                try {
                    resultDate = dateFormat.parse(source);
                    return resultDate;
                }
                catch (ParseException e1) {
                    continue;
                }
            }
            if (existTime) continue;
            dateFormat = DateFormatFactory.getDateInstance(i, locale);
            try {
                resultDate = dateFormat.parse(source);
                return resultDate;
            }
            catch (ParseException e1) {
                // empty catch block
            }
        }
        if (resultDate == null) {
            throw new OdaException(Messages.getString("DateUtil.ConvertFails") + source.toString());
        }
        return resultDate;
    }

    private static Date toDate(String source) throws OdaException {
        try {
            return DateFormatISO8601.parse(source);
        }
        catch (OdaException e) {
            try {
                return DateUtil.toDate(source, ULocale.getDefault());
            }
            catch (OdaException use) {
                return DateUtil.toDate(source, DEFAULT_LOCALE);
            }
        }
    }

    static {
        int i;
        DEFAULT_LOCALE = ULocale.US;
        DEFAULT_DATE_STYLE = 2;
        simpleDateFormatter = null;
        simpleTimeFormatter = null;
        count = 0L;
        String[] dateFormatPattern = new String[]{"yyyy-MM-dd HH:mm:ss.S z", "yyyy-MM-dd HH:mm:ss.Sz", "yyyy-MM-dd HH:mm:ss.S", "yyyy-MM-dd HH:mm:ss z", "yyyy-MM-dd HH:mm:ssz", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm z", "yyyy-MM-dd HH:mmz", "yyyy-MM-dd HH:mm", "yyyy-MM-dd", "yyyy-MM", "yyyy"};
        String[] timeFormatPattern = new String[]{"HH:mm:ss.S z", "HH:mm:ss.Sz", "HH:mm:ss.S", "HH:mm:ss z", "HH:mm:ssz", "HH:mm:ss", "HH:mm z", "HH:mmz", "HH:mm"};
        simpleDateFormatter = new SimpleDateFormat[dateFormatPattern.length];
        for (i = 0; i < dateFormatPattern.length; ++i) {
            DateUtil.simpleDateFormatter[i] = new SimpleDateFormat(dateFormatPattern[i]);
            simpleDateFormatter[i].setLenient(false);
        }
        simpleTimeFormatter = new SimpleDateFormat[dateFormatPattern.length];
        for (i = 0; i < timeFormatPattern.length; ++i) {
            DateUtil.simpleTimeFormatter[i] = new SimpleDateFormat(timeFormatPattern[i]);
            simpleTimeFormatter[i].setLenient(false);
        }
    }
}

