/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.html;

import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.emitter.html.HTMLReportEmitter;
import org.eclipse.birt.report.engine.ir.DimensionType;

public class AttributeBuilder {
    public static String buildPos(DimensionType x, DimensionType y, DimensionType width, DimensionType height) {
        StringBuffer content = new StringBuffer();
        if (x != null || y != null) {
            content.append("position: relative;");
            AttributeBuilder.buildSize(content, "left", x);
            AttributeBuilder.buildSize(content, "top", y);
        }
        AttributeBuilder.buildSize(content, "width", width);
        AttributeBuilder.buildSize(content, "height", height);
        return content.toString();
    }

    public static void buildStyle(StringBuffer content, IStyle style, HTMLReportEmitter emitter, boolean bContainer) {
        if (style == null || style.isEmpty()) {
            return;
        }
        AttributeBuilder.buildFont(content, style);
        AttributeBuilder.buildText(content, style, bContainer);
        AttributeBuilder.buildBox(content, style);
        AttributeBuilder.buildBackground(content, style, emitter);
        AttributeBuilder.buildPagedMedia(content, style);
        AttributeBuilder.buildVisual(content, style);
    }

    public static void buildComputedTextStyle(StringBuffer content, IStyle style, HTMLReportEmitter emitter, boolean bContainer) {
        if (style == null || style.isEmpty()) {
            return;
        }
        if (!bContainer) {
            AttributeBuilder.buildTextDecoration(content, style.getTextLineThrough(), style.getTextUnderline(), style.getTextOverline());
        }
    }

    public static void buildStyle(StringBuffer content, IStyle style, HTMLReportEmitter emitter) {
        AttributeBuilder.buildStyle(content, style, emitter, true);
    }

    public static void buildBackgroundStyle(StringBuffer content, IStyle style, HTMLReportEmitter emitter) {
        if (style == null || style.isEmpty()) {
            return;
        }
        AttributeBuilder.buildBackground(content, style, emitter);
    }

    public static void buildPageStyle(StringBuffer content, IStyle style, HTMLReportEmitter emitter) {
        if (style == null || style.isEmpty()) {
            return;
        }
        AttributeBuilder.buildFont(content, style);
        AttributeBuilder.buildText(content, style, true);
        AttributeBuilder.buildBox(content, style);
        AttributeBuilder.buildPagedMedia(content, style);
        AttributeBuilder.buildVisual(content, style);
    }

    private static void buildVisual(StringBuffer content, IStyle style) {
        AttributeBuilder.buildProperty(content, "line-height", style.getLineHeight());
    }

    private static void buildPagedMedia(StringBuffer content, IStyle style) {
        AttributeBuilder.buildProperty(content, "orphans", style.getOrphans());
        AttributeBuilder.buildProperty(content, "widows", style.getWidows());
        AttributeBuilder.buildProperty(content, "page-break-before", style.getPageBreakBefore());
        AttributeBuilder.buildProperty(content, "page-break-after", style.getPageBreakAfter());
        AttributeBuilder.buildProperty(content, "page-break-inside", style.getPageBreakInside());
    }

    private static void buildBackground(StringBuffer content, IStyle style, HTMLReportEmitter emitter) {
        AttributeBuilder.buildProperty(content, "color", style.getColor());
        AttributeBuilder.buildProperty(content, "background-color", style.getBackgroundColor());
        String image = style.getBackgroundImage();
        if (image == null || "none".equalsIgnoreCase(image)) {
            return;
        }
        if ((image = emitter.handleStyleImage(image)) != null && image.length() > 0) {
            AttributeBuilder.buildURLProperty(content, "background-image", image);
            AttributeBuilder.buildProperty(content, "background-repeat", style.getBackgroundRepeat());
            AttributeBuilder.buildProperty(content, "background-attachment", style.getBackgroundAttachment());
            String x = style.getBackgroundPositionX();
            String y = style.getBackgroundPositionY();
            if (x != null || y != null) {
                if (x == null) {
                    x = "0pt";
                }
                if (y == null) {
                    y = "0pt";
                }
                AttributeBuilder.addPropName(content, "background-position");
                AttributeBuilder.addPropValue(content, x);
                AttributeBuilder.addPropValue(content, y);
                content.append(';');
            }
        }
    }

    private static void buildBox(StringBuffer content, IStyle style) {
        AttributeBuilder.buildProperty(content, "margin-top", style.getMarginTop());
        AttributeBuilder.buildProperty(content, "margin-right", style.getMarginRight());
        AttributeBuilder.buildProperty(content, "margin-bottom", style.getMarginBottom());
        AttributeBuilder.buildProperty(content, "margin-left", style.getMarginLeft());
        AttributeBuilder.buildProperty(content, "padding-top", style.getPaddingTop());
        AttributeBuilder.buildProperty(content, "padding-right", style.getPaddingRight());
        AttributeBuilder.buildProperty(content, "padding-bottom", style.getPaddingBottom());
        AttributeBuilder.buildProperty(content, "padding-left", style.getPaddingLeft());
        AttributeBuilder.buildBorder(content, "border-top", style.getBorderTopWidth(), style.getBorderTopStyle(), style.getBorderTopColor());
        AttributeBuilder.buildBorder(content, "border-right", style.getBorderRightWidth(), style.getBorderRightStyle(), style.getBorderRightColor());
        AttributeBuilder.buildBorder(content, "border-bottom", style.getBorderBottomWidth(), style.getBorderBottomStyle(), style.getBorderBottomColor());
        AttributeBuilder.buildBorder(content, "border-left", style.getBorderLeftWidth(), style.getBorderLeftStyle(), style.getBorderLeftColor());
    }

    private static void buildText(StringBuffer content, IStyle style, boolean bContainer) {
        AttributeBuilder.buildProperty(content, "text-indent", style.getTextIndent());
        if (!bContainer) {
            AttributeBuilder.buildTextDecoration(content, style.getTextLineThrough(), style.getTextUnderline(), style.getTextOverline());
        }
        AttributeBuilder.buildProperty(content, "letter-spacing", style.getLetterSpacing());
        AttributeBuilder.buildProperty(content, "word-spacing", style.getWordSpacing());
        AttributeBuilder.buildProperty(content, "text-transform", style.getTextTransform());
        AttributeBuilder.buildProperty(content, "white-space", style.getWhiteSpace());
    }

    private static void buildFont(StringBuffer content, IStyle style) {
        AttributeBuilder.buildProperty(content, "font-family", style.getFontFamily());
        AttributeBuilder.buildProperty(content, "font-style", style.getFontStyle());
        AttributeBuilder.buildProperty(content, "font-variant", style.getFontVariant());
        AttributeBuilder.buildProperty(content, "font-weight", style.getFontWeight());
        AttributeBuilder.buildProperty(content, "font-size", style.getFontSize());
    }

    public static void checkHyperlinkTextDecoration(IStyle style, StringBuffer content) {
        if (style != null) {
            AttributeBuilder.buildTextDecoration(content, style.getTextLineThrough(), style.getTextUnderline(), style.getTextOverline());
        }
    }

    private static void buildTextDecoration(StringBuffer content, String linethrough, String underline, String overline) {
        int flag = 0;
        if (linethrough != null && "line-through".equalsIgnoreCase(linethrough)) {
            flag = 1;
        }
        if (underline != null && "underline".equalsIgnoreCase(underline)) {
            flag |= 2;
        }
        if (overline != null && "overline".equalsIgnoreCase(overline)) {
            flag |= 4;
        }
        if (flag > 0) {
            content.append(" text-decoration:");
            if ((flag & 1) > 0) {
                AttributeBuilder.addPropValue(content, "line-through");
            }
            if ((flag & 2) > 0) {
                AttributeBuilder.addPropValue(content, "underline");
            }
            if ((flag & 4) > 0) {
                AttributeBuilder.addPropValue(content, "overline");
            }
            content.append(';');
        }
    }

    private static void buildBorder(StringBuffer content, String name, String width, String style, String color) {
        if (style == null || style.length() <= 0) {
            return;
        }
        AttributeBuilder.addPropName(content, name);
        AttributeBuilder.addPropValue(content, width);
        AttributeBuilder.addPropValue(content, style);
        AttributeBuilder.addPropValue(content, color == null ? "black" : color);
        content.append(';');
    }

    public static void buildSize(StringBuffer content, String name, DimensionType value) {
        if (value != null) {
            if ("min-height".equals(name)) {
                AttributeBuilder.addPropName(content, "height");
                AttributeBuilder.addPropValue(content, "auto !important");
                content.append(';');
                AttributeBuilder.addPropName(content, "height");
                AttributeBuilder.addPropValue(content, value.toString());
                content.append(';');
                AttributeBuilder.addPropName(content, "min-height");
                AttributeBuilder.addPropValue(content, value.toString());
                content.append(';');
            } else {
                AttributeBuilder.addPropName(content, name);
                AttributeBuilder.addPropValue(content, value.toString());
                content.append(';');
            }
        }
    }

    private static void buildProperty(StringBuffer content, String name, String value) {
        if (value != null) {
            AttributeBuilder.addPropName(content, name);
            AttributeBuilder.addPropValue(content, value);
            content.append(';');
        }
    }

    private static void buildURLProperty(StringBuffer content, String name, String url) {
        if (url != null) {
            AttributeBuilder.addPropName(content, name);
            AttributeBuilder.addURLValue(content, url);
            content.append(';');
        }
    }

    private static void addPropName(StringBuffer content, String name) {
        content.append(' ');
        content.append(name);
        content.append(':');
    }

    private static void addPropValue(StringBuffer content, String value) {
        if (value != null) {
            content.append(' ');
            content.append(value);
        }
    }

    private static void addURLValue(StringBuffer content, String url) {
        if (url == null) {
            return;
        }
        StringBuffer escapedUrl = null;
        int max = url.length();
        int delta = 0;
        for (int i = 0; i < max; ++i) {
            char c = url.charAt(i);
            String replacement = null;
            if (c == '\\') {
                replacement = "%5c";
            } else if (c == '#') {
                replacement = "%23";
            } else if (c == '%') {
                replacement = "%25";
            } else if (c == '\'') {
                replacement = "%27";
            } else if (c >= '\u0080') {
                replacement = '%' + Integer.toHexString(c);
            }
            if (replacement == null) continue;
            if (escapedUrl == null) {
                escapedUrl = new StringBuffer(url);
            }
            escapedUrl.replace(i + delta, i + delta + 1, replacement);
            delta += replacement.length() - 1;
        }
        if (escapedUrl != null) {
            url = escapedUrl.toString();
        }
        if (url.length() > 0) {
            content.append(" url('");
            content.append(url);
            content.append("')");
        }
    }
}

