/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.html.util;

import java.util.List;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.emitter.html.HTMLWriter;
import org.eclipse.birt.report.engine.ir.DataItemDesign;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.ir.ExtendedItemDesign;
import org.eclipse.birt.report.engine.ir.LabelItemDesign;
import org.eclipse.birt.report.engine.ir.ListItemDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;
import org.eclipse.birt.report.engine.ir.TemplateDesign;

public class HTMLEmitterUtil {
    public static final int DISPLAY_BLOCK = 1;
    public static final int DISPLAY_FLAG_ALL = 65535;
    public static final int DISPLAY_INLINE = 2;
    public static final int DISPLAY_INLINE_BLOCK = 4;
    public static final int DISPLAY_NONE = 8;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static int getElementType(IContent content) {
        return HTMLEmitterUtil.getElementType(content.getX(), content.getY(), content.getWidth(), content.getHeight(), content.getStyle());
    }

    public static String getTagByType(int display, int mask) {
        int flag = display & mask;
        String tag = null;
        if ((flag & 1) > 0) {
            tag = "div";
        }
        if ((flag & 2) > 0) {
            tag = "span";
        }
        return tag;
    }

    public static void setActiveIDTypeIID(HTMLWriter writer, List ouputInstanceIDs, IContent content) {
        String type = HTMLEmitterUtil.getActiveIdType(content);
        if (type != null) {
            InstanceID iid = content.getInstanceID();
            long componentID = iid != null ? iid.getComponentID() : 0L;
            HTMLEmitterUtil.setActiveIDTypeIID(writer, ouputInstanceIDs, content.getBookmark(), type, iid, componentID);
        }
    }

    public static void setActiveIDTypeIID(HTMLWriter writer, List ouputInstanceIDs, String bookmark, String type, InstanceID iid, long elementId) {
        HTMLEmitterUtil.exportElementID(ouputInstanceIDs, bookmark, type, elementId);
        writer.attribute("element_type", type);
        if (iid != null) {
            writer.attribute("iid", iid.toString());
        }
    }

    public static void setBookmark(HTMLWriter writer, String tagName, String bookmark) {
        if (tagName == null || !"a".equalsIgnoreCase(tagName)) {
            writer.attribute("id", bookmark);
        } else {
            writer.attribute("id", bookmark);
            writer.attribute("name", bookmark);
        }
    }

    private static void exportElementID(List ouputInstanceIDs, String bookmark, String type, long componentID) {
        if (ouputInstanceIDs != null && bookmark != null) {
            if (!$assertionsDisabled && type == null) {
                throw new AssertionError();
            }
            String newBookmark = bookmark + "," + type + "," + new Long(componentID).toString();
            ouputInstanceIDs.add(newBookmark);
        }
    }

    private static String getActiveIdType(IContent content) {
        Object genBy = content.getGenerateBy();
        String type = null;
        if (genBy instanceof LabelItemDesign) {
            type = "LABEL";
        } else if (genBy instanceof TemplateDesign) {
            type = "TEMPLATE";
        } else if (genBy instanceof ExtendedItemDesign) {
            type = "EXTENDED";
        } else if (genBy instanceof TableItemDesign) {
            type = "TABLE";
        } else if (genBy instanceof ListItemDesign) {
            type = "LIST";
        } else if (genBy instanceof DataItemDesign) {
            type = "DATA";
        }
        return type;
    }

    private static int getElementType(DimensionType x, DimensionType y, DimensionType width, DimensionType height, IStyle style) {
        int type = 0;
        String display = null;
        if (style != null) {
            display = style.getDisplay();
        }
        if ("none".equalsIgnoreCase(display)) {
            type |= 8;
        }
        if (x != null || y != null) {
            return type | 1;
        }
        if ("inline".equalsIgnoreCase(display)) {
            type |= 2;
            if (width != null || height != null) {
                type |= 4;
            }
            return type;
        }
        return type | 1;
    }

    static {
        $assertionsDisabled = !HTMLEmitterUtil.class.desiredAssertionStatus();
    }
}

