/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.api.UnsupportedFormatException;
import org.eclipse.birt.report.engine.api.impl.EngineTask;
import org.eclipse.birt.report.engine.emitter.CompositeContentEmitter;
import org.eclipse.birt.report.engine.emitter.EngineEmitterServices;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.executor.OnPageBreakLayoutPageHandle;
import org.eclipse.birt.report.engine.executor.ReportExecutor;
import org.eclipse.birt.report.engine.extension.internal.ExtensionManager;
import org.eclipse.birt.report.engine.internal.document.ReportContentLoader;
import org.eclipse.birt.report.engine.internal.executor.doc.ReportPageReader;
import org.eclipse.birt.report.engine.internal.executor.doc.ReportletReader;
import org.eclipse.birt.report.engine.internal.executor.l18n.LocalizedReportExecutor;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.layout.IReportLayoutEngine;
import org.eclipse.birt.report.engine.layout.html.HTMLTableLayoutNestEmitter;

public class RenderTask
extends EngineTask
implements IRenderTask {
    IReportDocument reportDoc;
    String emitterID;
    int paginationType;
    private InnerRender innerRender;

    public RenderTask(IReportEngine engine, IReportRunnable runnable, IReportDocument reportDoc) {
        super(engine, runnable);
        this.executionContext.setFactoryMode(false);
        this.executionContext.setPresentationMode(true);
        this.openReportDocument(reportDoc);
        this.loadDesign();
        this.innerRender = new PageRangeRender(new long[]{1L, this.reportDoc.getPageCount()});
    }

    protected void openReportDocument(IReportDocument reportDoc) {
        this.reportDoc = reportDoc;
        this.executionContext.setReportDocument(reportDoc);
        this.setParameterValues(reportDoc.getParameterValues());
        this.usingParameterValues();
        this.executionContext.registerGlobalBeans(reportDoc.getGlobalVariables(null));
    }

    protected void closeReportDocument() {
    }

    public void render(long pageNumber) throws EngineException {
        this.setPageNumber(pageNumber);
        this.render();
    }

    protected IContentEmitter createContentEmitter() throws EngineException {
        IContentEmitter emitter;
        String format = this.executionContext.getOutputFormat();
        this.paginationType = "html".equalsIgnoreCase(format) ? 1 : 0;
        ExtensionManager extManager = ExtensionManager.getInstance();
        boolean supported = false;
        Collection supportedFormats = extManager.getSupportedFormat();
        Iterator iter = supportedFormats.iterator();
        while (iter.hasNext()) {
            String supportedFormat = (String)iter.next();
            if (supportedFormat == null || !supportedFormat.equalsIgnoreCase(format)) continue;
            supported = true;
            break;
        }
        if (!supported) {
            log.log(Level.SEVERE, "Error.OutputFormatNotSupported", format);
            throw new UnsupportedFormatException("Error.OutputFormatNotSupported", format);
        }
        try {
            emitter = extManager.createEmitter(format, this.emitterID);
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Report engine can not create {0} emitter.", format);
            throw new EngineException("Error.CannotCreateExtensionInstance", t);
        }
        if (emitter == null) {
            log.log(Level.SEVERE, "Report engine can not create {0} emitter.", format);
            throw new EngineException("Error.CannotCreateExtensionInstance");
        }
        if (this.paginationType != 0) {
            emitter = new HTMLTableLayoutNestEmitter(emitter);
        }
        return emitter;
    }

    private void initializeContentEmitter(IContentEmitter emitter, IReportExecutor executor) {
        EngineEmitterServices services = new EngineEmitterServices(this);
        EngineConfig config = this.engine.getConfig();
        if (config != null) {
            services.setEmitterConfig(config.getEmitterConfigs());
        }
        services.setRenderOption(this.renderOptions);
        services.setExecutor(executor);
        services.setRenderContext(this.appContext);
        services.setReportRunnable(this.runnable);
        emitter.initialize(services);
    }

    protected void doRender(long pageNumber) throws EngineException {
        try {
            IContentEmitter emitter = this.createContentEmitter();
            Report reportDesign = this.executionContext.getReport();
            String format = this.executionContext.getOutputFormat();
            if ("pdf".equalsIgnoreCase(format)) {
                IReportExecutor executor = new ReportPageReader(this.executionContext, pageNumber, this.paginationType);
                executor = new LocalizedReportExecutor(this.executionContext, executor);
                this.executionContext.setExecutor(executor);
                this.initializeContentEmitter(emitter, executor);
                IReportLayoutEngine layoutEngine = this.createReportLayoutEngine(format, this.renderOptions);
                OnPageBreakLayoutPageHandle handle = new OnPageBreakLayoutPageHandle(this.executionContext);
                layoutEngine.setPageHandler(handle);
                CompositeContentEmitter outputEmitters = new CompositeContentEmitter(format);
                outputEmitters.addEmitter(emitter);
                outputEmitters.addEmitter(handle.getEmitter());
                this.startRender();
                layoutEngine.layout(executor, outputEmitters, false);
                this.closeRender();
                executor.close();
            } else {
                IReportExecutor executor = new ReportExecutor(this.executionContext, reportDesign, null);
                executor = new LocalizedReportExecutor(this.executionContext, executor);
                this.executionContext.setExecutor(executor);
                this.initializeContentEmitter(emitter, executor);
                ReportContentLoader loader = new ReportContentLoader(this.executionContext);
                this.startRender();
                loader.loadPage(pageNumber, this.paginationType, emitter);
                this.closeRender();
                executor.close();
            }
        }
        catch (EngineException e) {
            log.log(Level.SEVERE, "An error happened while running the report. Cause:", (Throwable)((Object)e));
            throw e;
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "An error happened while running the report. Cause:", ex);
            throw new EngineException("Error happened while running the report", ex);
        }
        catch (OutOfMemoryError err) {
            log.log(Level.SEVERE, "An OutOfMemory error happened while running the report.");
            throw err;
        }
    }

    protected void doRender(List pageSequences) throws EngineException {
        if (pageSequences.size() == 0) {
            return;
        }
        try {
            Report reportDesign = this.executionContext.getReport();
            IContentEmitter emitter = this.createContentEmitter();
            String format = this.executionContext.getOutputFormat();
            if ("pdf".equalsIgnoreCase(format)) {
                IReportExecutor executor = new ReportPageReader(this.executionContext, pageSequences, this.paginationType);
                executor = new LocalizedReportExecutor(this.executionContext, executor);
                this.executionContext.setExecutor(executor);
                this.initializeContentEmitter(emitter, executor);
                IReportLayoutEngine layoutEngine = this.createReportLayoutEngine(format, this.renderOptions);
                OnPageBreakLayoutPageHandle handle = new OnPageBreakLayoutPageHandle(this.executionContext);
                layoutEngine.setPageHandler(handle);
                CompositeContentEmitter outputEmitters = new CompositeContentEmitter(format);
                outputEmitters.addEmitter(emitter);
                outputEmitters.addEmitter(handle.getEmitter());
                this.startRender();
                layoutEngine.layout(executor, outputEmitters, true);
                this.closeRender();
                executor.close();
            } else {
                boolean htmlPagination;
                IReportExecutor executor = new ReportExecutor(this.executionContext, reportDesign, null);
                executor = new LocalizedReportExecutor(this.executionContext, executor);
                this.executionContext.setExecutor(executor);
                this.initializeContentEmitter(emitter, executor);
                ReportContentLoader loader = new ReportContentLoader(this.executionContext);
                this.startRender();
                IRenderOption renderOption = this.executionContext.getRenderOption();
                if (renderOption instanceof HTMLRenderOption && !(htmlPagination = ((HTMLRenderOption)renderOption).getHtmlPagination())) {
                    this.paginationType = 2;
                }
                loader.loadPageRange(pageSequences, this.paginationType, emitter);
                this.closeRender();
                executor.close();
            }
        }
        catch (EngineException e) {
            log.log(Level.SEVERE, "An error happened while running the report. Cause:", (Throwable)((Object)e));
            throw e;
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "An error happened while running the report. Cause:", ex);
            throw new EngineException("Error happened while running the report", ex);
        }
        catch (OutOfMemoryError err) {
            log.log(Level.SEVERE, "An OutOfMemory error happened while running the report.");
            throw err;
        }
    }

    protected void doRenderReportlet(long offset) throws EngineException {
        try {
            if (offset != -1L) {
                IContentEmitter emitter = this.createContentEmitter();
                Report reportDesign = this.executionContext.getReport();
                String format = this.executionContext.getOutputFormat();
                if ("pdf".equalsIgnoreCase(format)) {
                    IReportExecutor executor = new ReportletReader(this.executionContext, offset);
                    executor = new LocalizedReportExecutor(this.executionContext, executor);
                    this.executionContext.setExecutor(executor);
                    this.initializeContentEmitter(emitter, executor);
                    IReportLayoutEngine layoutEngine = this.createReportLayoutEngine(format, this.renderOptions);
                    OnPageBreakLayoutPageHandle handle = new OnPageBreakLayoutPageHandle(this.executionContext);
                    layoutEngine.setPageHandler(handle);
                    CompositeContentEmitter outputEmitters = new CompositeContentEmitter(format);
                    outputEmitters.addEmitter(emitter);
                    outputEmitters.addEmitter(handle.getEmitter());
                    this.startRender();
                    layoutEngine.layout(executor, outputEmitters, false);
                    this.closeRender();
                    executor.close();
                } else {
                    ReportContentLoader loader = new ReportContentLoader(this.executionContext);
                    IReportExecutor executor = new ReportExecutor(this.executionContext, reportDesign, null);
                    executor = new LocalizedReportExecutor(this.executionContext, executor);
                    this.executionContext.setExecutor(executor);
                    this.initializeContentEmitter(emitter, executor);
                    this.startRender();
                    loader.loadReportlet(offset, emitter);
                    this.closeRender();
                    executor.close();
                }
            }
        }
        catch (EngineException e) {
            log.log(Level.SEVERE, "An error happened while running the report. Cause:", (Throwable)((Object)e));
            throw e;
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "An error happened while running the report. Cause:", ex);
            throw new EngineException("Error happened while running the report", ex);
        }
        catch (OutOfMemoryError err) {
            log.log(Level.SEVERE, "An OutOfMemory error happened while running the report.");
            throw err;
        }
    }

    public void setEmitterID(String id) {
        this.emitterID = id;
    }

    public String getEmitterID() {
        return this.emitterID;
    }

    public void close() {
        this.closeReportDocument();
        super.close();
    }

    public void render(String pageRange) throws EngineException {
        this.setPageRange(pageRange);
        this.render();
    }

    private List parsePageSequence(String pageRange, long totalPage) {
        ArrayList<long[]> list = new ArrayList<long[]>();
        if (null == pageRange || "".equals(pageRange) || pageRange.toUpperCase().indexOf("ALL") >= 0) {
            list.add(new long[]{1L, totalPage});
            return list;
        }
        String[] ps = pageRange.split(",");
        for (int i = 0; i < ps.length; ++i) {
            try {
                if (ps[i].indexOf("-") > 0) {
                    String[] psi = ps[i].split("-");
                    if (psi.length == 2) {
                        long start = Long.parseLong(psi[0].trim());
                        long end = Long.parseLong(psi[1].trim());
                        if (end <= start) continue;
                        list.add(new long[]{Math.max(start, 1L), Math.min(end, totalPage)});
                        continue;
                    }
                    log.log(Level.SEVERE, "error page number range: {0}", ps[i]);
                    continue;
                }
                long number = Long.parseLong(ps[i].trim());
                if (number > 0L && number <= totalPage) {
                    list.add(new long[]{number, number});
                    continue;
                }
                log.log(Level.SEVERE, "error page number range: {0}", ps[i]);
                continue;
            }
            catch (NumberFormatException ex) {
                log.log(Level.SEVERE, "error page number rang:", ps[i]);
            }
        }
        return this.sort(list);
    }

    private List sort(List list) {
        for (int i = 0; i < list.size(); ++i) {
            long[] currentI = (long[])list.get(i);
            int minIndex = i;
            long[] min = currentI;
            for (int j = i + 1; j < list.size(); ++j) {
                long[] currentJ = (long[])list.get(j);
                if (currentJ[0] >= min[0]) continue;
                minIndex = j;
                min = currentJ;
            }
            if (minIndex == i) continue;
            list.set(i, min);
            list.set(minIndex, currentI);
        }
        long[] current = null;
        long[] last = null;
        ArrayList<long[]> ret = new ArrayList<long[]>();
        for (int i = 0; i < list.size(); ++i) {
            current = (long[])list.get(i);
            if (last != null) {
                if (current[1] <= last[1]) continue;
                if (current[0] <= last[1]) {
                    current[0] = last[1];
                }
                ret.add(current);
            } else {
                ret.add(current);
            }
            last = current;
        }
        return ret;
    }

    public void render(InstanceID iid) throws EngineException {
        this.setInstanceID(iid);
        this.render();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render() throws EngineException {
        try {
            this.runningStatus = 1;
            if (this.renderOptions == null) {
                throw new EngineException("Render options have to be specified to render a report.");
            }
            if (this.runnable == null) {
                throw new EngineException("Can not find the report design in the report document {0}.", new Object[]{this.reportDoc.getName()});
            }
            this.innerRender.render();
        }
        finally {
            this.runningStatus = 2;
        }
    }

    public void setPageNumber(long pageNumber) throws EngineException {
        long totalPage = this.reportDoc.getPageCount();
        if (pageNumber <= 0L || pageNumber > totalPage) {
            throw new EngineException("Page {0} is not found ", new Long(pageNumber));
        }
        this.innerRender = new PageRender(pageNumber);
    }

    public void setInstanceID(InstanceID iid) throws EngineException {
        this.innerRender = new ReportletRender(iid);
    }

    public void setPageRange(String pageRange) throws EngineException {
        this.innerRender = new PageRangeRender(this.parsePageSequence(pageRange, this.reportDoc.getPageCount()));
    }

    public void setBookmark(String bookmark) throws EngineException {
        long pageNumber = this.reportDoc.getPageNumber(bookmark);
        if (pageNumber <= 0L) {
            throw new EngineException("Can not find bookmark :{0}", bookmark);
        }
        this.innerRender = new PageRender(pageNumber);
    }

    public void setReportlet(String bookmark) throws EngineException {
        this.innerRender = new ReportletRender(bookmark);
    }

    public void setInstanceID(String iid) throws EngineException {
        this.setInstanceID(InstanceID.parse(iid));
    }

    private class ReportletRender
    implements InnerRender {
        private long offset;

        ReportletRender(InstanceID iid) throws EngineException {
            this.offset = RenderTask.this.reportDoc.getInstanceOffset(iid);
            if (this.offset == -1L) {
                throw new EngineException("Invalid instance id :" + iid);
            }
        }

        ReportletRender(String bookmark) throws EngineException {
            this.offset = RenderTask.this.reportDoc.getBookmarkOffset(bookmark);
            if (this.offset == -1L) {
                throw new EngineException("Invalid bookmark :" + bookmark);
            }
        }

        public void render() throws EngineException {
            RenderTask.this.doRenderReportlet(this.offset);
        }
    }

    private class PageRangeRender
    implements InnerRender {
        private List pageRange;

        public PageRangeRender(long[] arrayRange) {
            this.pageRange = new ArrayList();
            this.pageRange.add(arrayRange);
        }

        public PageRangeRender(List pageRange) {
            this.pageRange = pageRange;
        }

        public void render() throws EngineException {
            RenderTask.this.doRender(this.pageRange);
        }
    }

    private class PageRender
    implements InnerRender {
        private long pageNumber;

        public PageRender(long pageNumber) {
            this.pageNumber = pageNumber;
        }

        public void render() throws EngineException {
            RenderTask.this.doRender(this.pageNumber);
        }
    }

    private static interface InnerRender {
        public void render() throws EngineException;
    }
}

