/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.data.dte;

import java.math.BigDecimal;
import java.sql.Blob;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.report.engine.api.DataSetID;
import org.eclipse.birt.report.engine.data.IDataEngine;
import org.eclipse.birt.report.engine.data.IResultSet;
import org.eclipse.birt.report.engine.executor.ExecutionContext;

public class DteResultSet
implements IResultSet {
    protected DteResultSet parent;
    protected DataSetID id;
    protected long rowId = -1L;
    protected IResultIterator rs = null;
    protected long[] rowIdOfGroups;
    protected IDataEngine dataEngine = null;
    private ExecutionContext context;
    private IBaseQueryDefinition queryDefn;
    private IQueryResults queryResults;
    private static IResultMetaData emptyResultMetaData;
    protected static Logger logger;
    String baseRSetID;
    static final /* synthetic */ boolean $assertionsDisabled;

    DteResultSet(IDataEngine dataEngine, ExecutionContext context, IQueryDefinition queryDefn, IQueryResults rsets) throws BirtException {
        this.parent = null;
        this.context = context;
        this.dataEngine = dataEngine;
        this.queryDefn = queryDefn;
        this.id = new DataSetID(rsets.getID());
        this.rs = rsets.getResultIterator();
        this.queryResults = rsets;
        this.initializeRowIdOfGroups(this.getGroupCount());
    }

    DteResultSet(DteResultSet parent, IQueryDefinition queryDefn, IQueryResults rsets) throws BirtException {
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError();
        }
        this.parent = parent;
        this.id = new DataSetID(rsets.getID());
        this.context = parent.context;
        this.dataEngine = parent.dataEngine;
        this.queryDefn = queryDefn;
        this.rs = rsets.getResultIterator();
        this.queryResults = rsets;
        this.initializeRowIdOfGroups(this.getGroupCount());
    }

    DteResultSet(DteResultSet parent, ISubqueryDefinition queryDefn, IResultIterator ri) {
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && queryDefn == null) {
            throw new AssertionError();
        }
        this.parent = parent;
        this.id = new DataSetID(parent.getID(), parent.getCurrentPosition(), queryDefn.getName());
        this.context = parent.context;
        this.dataEngine = parent.dataEngine;
        this.queryDefn = queryDefn;
        this.rs = ri;
        this.initializeRowIdOfGroups(queryDefn.getGroups().size());
    }

    public void close() {
        this.dataEngine.close(this);
        try {
            if (this.queryResults != null) {
                this.queryResults.close();
            }
            if (this.rs != null) {
                this.rs.close();
            }
        }
        catch (BirtException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public IResultSet getParent() {
        return this.parent;
    }

    public int getEndingGroupLevel() {
        try {
            return this.rs.getEndingGroupLevel();
        }
        catch (BirtException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return -1;
        }
    }

    public int getStartingGroupLevel() {
        try {
            return this.rs.getStartingGroupLevel();
        }
        catch (BirtException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return -1;
        }
    }

    public boolean next() {
        try {
            boolean flag;
            boolean bl = flag = this.rs == null ? false : this.rs.next();
            if (flag) {
                ++this.rowId;
                this.updateRowIdOfGroups();
            }
            return flag;
        }
        catch (BirtException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
    }

    public DataSetID getID() {
        if (!$assertionsDisabled && this.id == null) {
            throw new AssertionError();
        }
        return this.id;
    }

    public long getCurrentPosition() {
        return this.rowId;
    }

    public long getRawID() {
        try {
            return this.rs.getRowId();
        }
        catch (BirtException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            return -1L;
        }
    }

    public boolean skipTo(long rows) {
        if (this.rs == null) {
            return false;
        }
        try {
            long oldRowId = this.rowId;
            this.rs.moveTo((int)rows);
            this.rowId = rows;
            this.updateRowIdOfGroupsAfterSkip(oldRowId);
        }
        catch (BirtException ex) {
            logger.log(Level.SEVERE, "Skip to failed", ex);
            return false;
        }
        return true;
    }

    public Object getValue(String column) throws BirtException {
        return this.rs.getValue(column);
    }

    public IResultIterator getResultIterator() {
        return this.rs;
    }

    public IQueryResults getQueryResults() {
        return this.rs.getQueryResults();
    }

    public Boolean getBoolean(String name) throws BirtException {
        return this.rs.getBoolean(name);
    }

    public Integer getInteger(String name) throws BirtException {
        return this.rs.getInteger(name);
    }

    public Double getDouble(String name) throws BirtException {
        return this.rs.getDouble(name);
    }

    public String getString(String name) throws BirtException {
        return this.rs.getString(name);
    }

    public BigDecimal getBigDecimal(String name) throws BirtException {
        return this.rs.getBigDecimal(name);
    }

    public Date getDate(String name) throws BirtException {
        return this.rs.getDate(name);
    }

    public Blob getBlob(String name) throws BirtException {
        return this.rs.getBlob(name);
    }

    public byte[] getBytes(String name) throws BirtException {
        return this.rs.getBytes(name);
    }

    public IResultMetaData getResultMetaData() throws BirtException {
        if (null == this.rs) {
            return emptyResultMetaData;
        }
        return this.rs.getResultMetaData();
    }

    public Object evaluate(String expr) {
        return this.context.evaluate(expr);
    }

    public Object evaluate(IBaseExpression expr) {
        if (expr instanceof IScriptExpression) {
            return this.context.evaluate(((IScriptExpression)expr).getText());
        }
        if (expr instanceof IConditionalExpression) {
            return this.context.evaluateCondExpr((IConditionalExpression)expr);
        }
        return null;
    }

    public String getGroupId(int groupLevel) {
        return String.valueOf(groupLevel) + "." + this.getRowId(groupLevel);
    }

    private void resetRowIdOfGroups() {
        for (int i = 0; i < this.rowIdOfGroups.length; ++i) {
            this.rowIdOfGroups[i] = this.rowId;
        }
    }

    private String getRowId(int groupLevel) {
        if (!$assertionsDisabled && this.rowIdOfGroups.length <= 0) {
            throw new AssertionError();
        }
        int level = groupLevel >= this.rowIdOfGroups.length ? this.rowIdOfGroups.length - 1 : groupLevel;
        level = groupLevel < 0 ? 0 : groupLevel;
        return String.valueOf(this.rowIdOfGroups[level]);
    }

    private void updateRowIdOfGroups() {
        try {
            int startingGroup;
            for (int i = startingGroup = this.rs.getStartingGroupLevel(); i < this.rowIdOfGroups.length; ++i) {
                this.rowIdOfGroups[i] = this.rowId;
            }
        }
        catch (BirtException e) {
            e.printStackTrace();
        }
    }

    private int getGroupCount() {
        if (this.queryDefn != null) {
            List groups = this.queryDefn.getGroups();
            if (!$assertionsDisabled && groups == null) {
                throw new AssertionError();
            }
            return groups.size();
        }
        return 0;
    }

    private void updateRowIdOfGroupsAfterSkip(long oldRowId) {
        long incremetal = this.rowId - oldRowId;
        if (incremetal == 1L) {
            this.updateRowIdOfGroups();
        } else if (incremetal > 1L) {
            this.resetRowIdOfGroups();
        }
    }

    private void initializeRowIdOfGroups(int groupCount) {
        this.rowIdOfGroups = new long[groupCount + 2];
    }

    void setBaseRSetID(String id) {
        this.baseRSetID = id;
    }

    String getBaseRSetID() {
        if (this.baseRSetID == null && this.parent != null) {
            return this.parent.getBaseRSetID();
        }
        return this.baseRSetID;
    }

    static {
        $assertionsDisabled = !DteResultSet.class.desiredAssertionStatus();
        emptyResultMetaData = new EmptyResultMetaData();
        logger = Logger.getLogger(DteResultSet.class.getName());
    }

    private static class EmptyResultMetaData
    implements IResultMetaData {
        private EmptyResultMetaData() {
        }

        public int getColumnCount() {
            return 0;
        }

        public String getColumnName(int index) throws BirtException {
            return null;
        }

        public String getColumnAlias(int index) throws BirtException {
            return null;
        }

        public int getColumnType(int index) throws BirtException {
            return 0;
        }

        public String getColumnTypeName(int index) throws BirtException {
            return null;
        }

        public String getColumnNativeTypeName(int index) throws BirtException {
            return null;
        }

        public String getColumnLabel(int index) throws BirtException {
            return null;
        }

        public boolean isComputedColumn(int index) throws BirtException {
            return false;
        }
    }
}

