/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import java.util.HashMap;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.content.impl.ListGroupContent;
import org.eclipse.birt.report.engine.content.impl.TableGroupContent;
import org.eclipse.birt.report.engine.emitter.ContentEmitterAdapter;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.GridItemDesign;
import org.eclipse.birt.report.engine.ir.MultiLineItemDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;
import org.eclipse.birt.report.engine.ir.TextItemDesign;
import org.eclipse.birt.report.engine.layout.ILayoutPageHandler;
import org.eclipse.birt.report.engine.layout.area.IAreaVisitor;
import org.eclipse.birt.report.engine.layout.area.IContainerArea;
import org.eclipse.birt.report.engine.layout.area.IImageArea;
import org.eclipse.birt.report.engine.layout.area.ITemplateArea;
import org.eclipse.birt.report.engine.layout.area.ITextArea;
import org.eclipse.birt.report.engine.layout.area.impl.PageArea;
import org.eclipse.birt.report.engine.script.internal.CellScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.DataItemScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.DynamicTextScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.GridScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.ImageScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.LabelScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.ListGroupScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.ListScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.RowScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.TableGroupScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.TableScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.TextItemScriptExecutor;

public class OnPageBreakLayoutPageHandle
implements ILayoutPageHandler {
    protected ExecutionContext executionContext;
    protected IContentEmitter emitter;
    protected HashMap designs = new HashMap();
    protected LinkedContent firstContent;
    protected LinkedContent lastContent;

    public OnPageBreakLayoutPageHandle(ExecutionContext executionContext) {
        this.executionContext = executionContext;
        this.emitter = new PageContentEmitter();
        this.firstContent = new LinkedContent();
        this.firstContent.next = this.lastContent = new LinkedContent();
        this.lastContent.prev = this.firstContent;
    }

    public IContentEmitter getEmitter() {
        return this.emitter;
    }

    protected void addContent(IContent content) {
        if (content == null) {
            return;
        }
        Object generateBy = content.getGenerateBy();
        if (!(generateBy instanceof ReportItemDesign)) {
            return;
        }
        ReportItemDesign design = (ReportItemDesign)generateBy;
        if (design.getOnPageBreak() != null || design.getJavaClass() != null) {
            LinkedContent cachedContent = (LinkedContent)this.designs.get(design);
            if (cachedContent != null) {
                LinkedContent next;
                LinkedContent prev = cachedContent.prev;
                prev.next = next = cachedContent.next;
                next.prev = prev;
            } else {
                cachedContent = new LinkedContent();
            }
            cachedContent.content = content;
            cachedContent.prev = this.lastContent.prev;
            this.lastContent.prev.next = cachedContent;
            cachedContent.next = this.lastContent;
            this.lastContent.prev = cachedContent;
            this.designs.put(design, cachedContent);
        }
    }

    public void onPage(long page, Object context) {
        if (this.executionContext == null) {
            return;
        }
        LinkedContent nextContent = this.firstContent.next;
        while (nextContent != this.lastContent) {
            IContent content = nextContent.content;
            nextContent = nextContent.next;
            ReportItemDesign design = (ReportItemDesign)content.getGenerateBy();
            int contentType = content.getContentType();
            switch (contentType) {
                case 1: {
                    CellScriptExecutor.handleOnPageBreak((ICellContent)content, this.executionContext);
                    break;
                }
                case 3: {
                    DataItemScriptExecutor.handleOnPageBreak((IDataContent)content, this.executionContext);
                    break;
                }
                case 4: {
                    if (design instanceof MultiLineItemDesign) {
                        DynamicTextScriptExecutor.handleOnPageBreak((IForeignContent)content, this.executionContext);
                        break;
                    }
                    if (!(design instanceof TextItemDesign)) break;
                    TextItemScriptExecutor.handleOnPageBreak((IForeignContent)content, this.executionContext);
                    break;
                }
                case 5: {
                    ImageScriptExecutor.handleOnPageBreak((IImageContent)content, this.executionContext);
                    break;
                }
                case 6: {
                    if (design instanceof TextItemDesign) {
                        TextItemScriptExecutor.handleOnPageBreak((ITextContent)content, this.executionContext);
                        break;
                    }
                    LabelScriptExecutor.handleOnPageBreak((ILabelContent)content, this.executionContext);
                    break;
                }
                case 8: {
                    RowScriptExecutor.handleOnPageBreak((IRowContent)content, this.executionContext);
                    break;
                }
                case 13: {
                    ListScriptExecutor.handleOnPageBreak((IListContent)content, this.executionContext);
                    break;
                }
                case 10: {
                    if (design instanceof TableItemDesign) {
                        TableScriptExecutor.handleOnPageBreak((ITableContent)content, this.executionContext);
                        break;
                    }
                    if (!(design instanceof GridItemDesign)) break;
                    GridScriptExecutor.handleOnPageBreak((ITableContent)content, this.executionContext);
                    break;
                }
                case 17: {
                    TableGroupScriptExecutor.handleOnPageBreak((TableGroupContent)content, this.executionContext);
                    break;
                }
                case 16: {
                    ListGroupScriptExecutor.handleOnPageBreak((ListGroupContent)content, this.executionContext);
                    break;
                }
                case 11: {
                    TextItemScriptExecutor.handleOnPageBreak((ITextContent)content, this.executionContext);
                }
            }
        }
        this.firstContent.next = this.lastContent;
        this.lastContent.prev = this.firstContent;
        this.designs.clear();
    }

    private class PageBreakContentCollector
    implements IAreaVisitor {
        private PageBreakContentCollector() {
        }

        public void start(IReportContent report) {
        }

        public String getOutputFormat() {
            return null;
        }

        public void initialize(IEmitterServices service) {
        }

        public void visitText(ITextArea textArea) {
            OnPageBreakLayoutPageHandle.this.addContent(textArea.getContent());
        }

        public void visitAutoText(ITemplateArea templateArea) {
            OnPageBreakLayoutPageHandle.this.addContent(templateArea.getContent());
        }

        public void setTotalPage(ITextArea totalPage) {
        }

        public void visitImage(IImageArea imageArea) {
            OnPageBreakLayoutPageHandle.this.addContent(imageArea.getContent());
        }

        public void startContainer(IContainerArea containerArea) {
            OnPageBreakLayoutPageHandle.this.addContent(containerArea.getContent());
        }

        public void endContainer(IContainerArea containerArea) {
        }

        public void end(IReportContent report) {
        }
    }

    private class PageContentEmitter
    extends ContentEmitterAdapter {
        private PageContentEmitter() {
        }

        public void startPage(IPageContent page) {
            Object ext = page.getExtension(1);
            if (ext instanceof PageArea) {
                PageArea pageArea = (PageArea)ext;
                IContainerArea container = pageArea.getBody();
                container.accept(new PageBreakContentCollector());
            }
        }

        public void startContent(IContent content) {
            OnPageBreakLayoutPageHandle.this.addContent(content);
        }
    }

    private class LinkedContent {
        IContent content;
        LinkedContent next;
        LinkedContent prev;

        private LinkedContent() {
        }
    }
}

