/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import java.util.Map;
import org.eclipse.birt.core.script.BaseScriptable;
import org.eclipse.birt.report.engine.api.impl.ParameterAttribute;
import org.eclipse.birt.report.engine.executor.ScriptableParameter;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Wrapper;

public class ScriptableParameters
extends BaseScriptable {
    private Map parameters;
    private final String JS_CLASS_NAME = "ScriptableParameters";

    public ScriptableParameters(Map parameters, Scriptable scope) {
        this.setParentScope(scope);
        this.parameters = parameters;
    }

    public Object get(String name, Scriptable start) {
        Object result = this.getScriptableParameter(name);
        if (result == null) {
            result = NOT_FOUND;
        }
        return result;
    }

    private ScriptableParameter getScriptableParameter(String name) {
        if (this.parameters.containsKey(name)) {
            return new ScriptableParameter(this.parameters, name, this.getParentScope());
        }
        return null;
    }

    public boolean has(String name, Scriptable start) {
        return this.parameters.get(name) != null;
    }

    public void put(String name, Scriptable start, Object value) {
        ParameterAttribute entry = (ParameterAttribute)this.parameters.get(name);
        if (entry == null) {
            entry = new ParameterAttribute();
            this.parameters.put(name, entry);
        }
        if (value instanceof ScriptableParameter) {
            ScriptableParameter scriptableParameter = (ScriptableParameter)((Object)value);
            Object paramValue = scriptableParameter.get("value", (Scriptable)this);
            String displayText = (String)scriptableParameter.get("displayText", (Scriptable)this);
            entry.setValue(paramValue);
            entry.setDisplayText(displayText);
            return;
        }
        if (value instanceof Wrapper) {
            value = ((Wrapper)value).unwrap();
        }
        if (value instanceof ParameterAttribute) {
            ParameterAttribute param = (ParameterAttribute)value;
            entry.setValue(param.getValue());
            entry.setDisplayText(param.getDisplayText());
        } else {
            entry.setValue(value);
        }
    }

    public String getClassName() {
        return "ScriptableParameters";
    }
}

