/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v2;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.internal.document.IPageHintReader;
import org.eclipse.birt.report.engine.presentation.IPageHint;
import org.eclipse.birt.report.engine.presentation.PageHint;

public class PageHintReaderV2
implements IPageHintReader {
    protected IReportDocument document;
    protected RAInputStream indexStream;
    protected RAInputStream hintsStream;
    protected long totalPage = -1L;

    public PageHintReaderV2(IReportDocument reader) {
        this.document = reader;
    }

    public void open() throws IOException {
        IDocArchiveReader reader = this.document.getArchive();
        this.hintsStream = reader.getStream("/pages");
        this.indexStream = reader.getStream("/pages_index");
        if (this.hintsStream == null || this.indexStream == null) {
            this.close();
            throw new IOException("failed to open the index stream");
        }
    }

    public void close() {
        try {
            if (this.hintsStream != null) {
                this.hintsStream.close();
                this.hintsStream = null;
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            if (this.indexStream != null) {
                this.indexStream.close();
                this.indexStream = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized long getTotalPage() throws IOException {
        this.indexStream.refresh();
        this.indexStream.seek(0L);
        this.totalPage = this.indexStream.readLong();
        return this.totalPage;
    }

    public synchronized IPageHint getPageHint(long pageNumber) throws IOException {
        this.indexStream.seek(pageNumber * 8L);
        long offset = this.indexStream.readLong();
        this.hintsStream.seek(offset);
        PageHint hint = new PageHint();
        hint.readObject(new DataInputStream((InputStream)this.hintsStream));
        return hint;
    }

    public synchronized long findPage(long offset) throws IOException {
        this.getTotalPage();
        for (long page = 1L; page <= this.totalPage; ++page) {
            IPageHint pageHint = this.getPageHint(page);
            for (int section = 0; section < pageHint.getSectionCount(); ++section) {
                long start = pageHint.getSectionStart(section);
                long end = pageHint.getSectionEnd(section);
                if (start > offset || offset > end) continue;
                return page;
            }
        }
        return -1L;
    }
}

