/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.executor.doc;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.report.engine.api.DataID;
import org.eclipse.birt.report.engine.api.DataSetID;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.ContentFactory;
import org.eclipse.birt.report.engine.content.ContentVisitorAdapter;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.IBandContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IContentVisitor;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.impl.LabelContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.data.IDataEngine;
import org.eclipse.birt.report.engine.data.IResultSet;
import org.eclipse.birt.report.engine.emitter.ContentEmitterUtil;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.document.v3.CachedReportContentReaderV3;
import org.eclipse.birt.report.engine.internal.executor.doc.ReportItemReaderManager;
import org.eclipse.birt.report.engine.ir.ColumnDesign;
import org.eclipse.birt.report.engine.ir.DataItemDesign;
import org.eclipse.birt.report.engine.ir.GroupDesign;
import org.eclipse.birt.report.engine.ir.ListItemDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportElementDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;
import org.eclipse.birt.report.engine.ir.TemplateDesign;
import org.eclipse.birt.report.engine.toc.DocumentTOCTree;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public abstract class AbstractReportReader
implements IReportExecutor {
    protected static Logger logger;
    protected ExecutionContext context;
    protected IDataEngine dataEngine;
    protected CachedReportContentReaderV3 reader;
    protected Report report;
    protected IReportDocument reportDoc;
    protected ReportContent reportContent;
    protected IContent dummyReportContent;
    ReportItemReaderManager manager;
    protected IContentVisitor initalizeContentVisitor = new ContentVisitorAdapter(){
        static final /* synthetic */ boolean $assertionsDisabled;

        public Object visitLabel(ILabelContent label, Object value) {
            if (label.getGenerateBy() instanceof TemplateDesign) {
                TemplateDesign design = (TemplateDesign)label.getGenerateBy();
                label.setLabelKey(design.getPromptTextKey());
                label.setLabelText(design.getPromptText());
            }
            return value;
        }

        public Object visitAutoText(IAutoTextContent autoText, Object value) {
            if (autoText.getType() == 0) {
                autoText.setText(String.valueOf(AbstractReportReader.this.reportDoc.getPageCount()));
            }
            return value;
        }

        public Object visitTable(ITableContent table, Object value) {
            int colCount = table.getColumnCount();
            for (int i = 0; i < colCount; ++i) {
                IColumn col = table.getColumn(i);
                InstanceID id = col.getInstanceID();
                if (id == null) continue;
                long cid = id.getComponentID();
                ColumnDesign colDesign = (ColumnDesign)AbstractReportReader.this.report.getReportItemByID(cid);
                col.setGenerateBy(colDesign);
            }
            return value;
        }

        public Object visitData(IDataContent data, Object value) {
            IResultSet rset;
            String bindingColumn;
            DataItemDesign design;
            if (data.getGenerateBy() instanceof DataItemDesign && (design = (DataItemDesign)data.getGenerateBy()).getMap() == null && (bindingColumn = design.getBindingColumn()) != null && (rset = AbstractReportReader.this.context.getResultSet()) != null) {
                try {
                    Object dataValue = rset.getValue(bindingColumn);
                    data.setValue(dataValue);
                }
                catch (BirtException ex) {
                    AbstractReportReader.this.context.addException(ex);
                }
            }
            return value;
        }

        public Object visitTableBand(ITableBandContent tableBand, Object value) {
            int bandType = tableBand.getBandType();
            switch (bandType) {
                case 1: {
                    ITableContent table = this.getParentTable(tableBand);
                    Object genObj = table.getGenerateBy();
                    if (!(genObj instanceof TableItemDesign)) break;
                    TableItemDesign tableDesign = (TableItemDesign)genObj;
                    tableBand.setGenerateBy(tableDesign.getHeader());
                    break;
                }
                case 2: {
                    ITableContent table = this.getParentTable(tableBand);
                    Object genObj = table.getGenerateBy();
                    if (!(genObj instanceof TableItemDesign)) break;
                    TableItemDesign tableDesign = (TableItemDesign)genObj;
                    tableBand.setGenerateBy(tableDesign.getFooter());
                    break;
                }
                case 0: {
                    ITableContent table = this.getParentTable(tableBand);
                    Object genObj = table.getGenerateBy();
                    if (!(genObj instanceof TableItemDesign)) break;
                    TableItemDesign tableDesign = (TableItemDesign)genObj;
                    tableBand.setGenerateBy(tableDesign.getDetail());
                    break;
                }
                case 3: 
                case 4: {
                    this.setupGroupBand(tableBand);
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
            return value;
        }

        ITableContent getParentTable(ITableBandContent band) {
            for (IContent parent = (IContent)band.getParent(); parent != null; parent = (IContent)parent.getParent()) {
                if (!(parent instanceof ITableContent)) continue;
                return (ITableContent)parent;
            }
            return null;
        }

        IListContent getParentList(IListBandContent band) {
            for (IContent parent = (IContent)band.getParent(); parent != null; parent = (IContent)parent.getParent()) {
                if (!(parent instanceof IListContent)) continue;
                return (IListContent)parent;
            }
            return null;
        }

        public Object visitListBand(IListBandContent listBand, Object value) {
            int bandType = listBand.getBandType();
            switch (bandType) {
                case 1: {
                    IListContent list = this.getParentList(listBand);
                    Object genObj = list.getGenerateBy();
                    if (!(genObj instanceof ListItemDesign)) break;
                    ListItemDesign listDesign = (ListItemDesign)genObj;
                    listBand.setGenerateBy(listDesign.getHeader());
                    break;
                }
                case 2: {
                    IListContent list = this.getParentList(listBand);
                    Object genObj = list.getGenerateBy();
                    if (!(genObj instanceof ListItemDesign)) break;
                    ListItemDesign listDesign = (ListItemDesign)genObj;
                    listBand.setGenerateBy(listDesign.getFooter());
                    break;
                }
                case 0: {
                    IListContent list = this.getParentList(listBand);
                    Object genObj = list.getGenerateBy();
                    if (!(genObj instanceof ListItemDesign)) break;
                    ListItemDesign listDesign = (ListItemDesign)genObj;
                    listBand.setGenerateBy(listDesign.getDetail());
                    break;
                }
                case 3: 
                case 4: {
                    this.setupGroupBand(listBand);
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
            return value;
        }

        protected void setupGroupBand(IBandContent bandContent) {
            IGroupContent group;
            Object genBy;
            IContent parent = (IContent)bandContent.getParent();
            if (parent instanceof IGroupContent && (genBy = (group = (IGroupContent)parent).getGenerateBy()) instanceof GroupDesign) {
                GroupDesign groupDesign = (GroupDesign)genBy;
                int bandType = bandContent.getBandType();
                if (bandType == 4) {
                    bandContent.setGenerateBy(groupDesign.getHeader());
                } else {
                    bandContent.setGenerateBy(groupDesign.getFooter());
                }
            }
        }

        static {
            $assertionsDisabled = !(class$org$eclipse$birt$report$engine$internal$executor$doc$AbstractReportReader == null ? (class$org$eclipse$birt$report$engine$internal$executor$doc$AbstractReportReader = AbstractReportReader.class$("org.eclipse.birt.report.engine.internal.executor.doc.AbstractReportReader")) : class$org$eclipse$birt$report$engine$internal$executor$doc$AbstractReportReader).desiredAssertionStatus();
        }
    };
    static final /* synthetic */ boolean $assertionsDisabled;

    public AbstractReportReader(ExecutionContext context) {
        if (!$assertionsDisabled && context.getDesign() == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && context.getReportDocument() == null) {
            throw new AssertionError();
        }
        this.context = context;
        this.report = context.getReport();
        this.reportContent = (ReportContent)ContentFactory.createReportContent(this.report);
        context.setReportContent(this.reportContent);
        this.dummyReportContent = new LabelContent(this.reportContent);
        this.dummyReportContent.setStyleClass(this.report.getRootStyleName());
        this.reportDoc = context.getReportDocument();
        DocumentTOCTree tocTree = new DocumentTOCTree(this.reportDoc);
        this.reportContent.setTOCTree(tocTree);
        long totalPage = this.reportDoc.getPageCount();
        context.setTotalPage(totalPage);
        this.reportContent.setTotalPage(totalPage);
        this.dataEngine = context.getDataEngine();
        this.dataEngine.prepare(this.report, context.getAppContext());
        this.manager = new ReportItemReaderManager(this);
    }

    public void close() {
        this.closeReaders();
    }

    IContent loadContent(long offset) {
        try {
            IContent content = this.reader.loadContent(offset);
            if (content != null && content.getParent() == null) {
                content.setParent(this.dummyReportContent);
            }
            return this.reader.loadContent(offset);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Can't load the content", ex);
            return null;
        }
    }

    void unloadContent(long offset) {
        this.reader.unloadContent(offset);
    }

    protected void openReaders() throws IOException {
        IDocArchiveReader archive = this.reportDoc.getArchive();
        RAInputStream in = archive.getStream("/content/content.dat");
        this.reader = new CachedReportContentReaderV3(this.reportContent, in);
    }

    protected void closeReaders() {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    protected void initializeContent(IContent content) {
        long designId;
        content.setReportContent(this.reportContent);
        InstanceID id = content.getInstanceID();
        if (id != null && (designId = id.getComponentID()) != -1L) {
            ReportElementDesign generateBy = this.report.getReportItemByID(designId);
            content.setGenerateBy(generateBy);
            if (generateBy instanceof ReportItemDesign) {
                this.context.setItemDesign((ReportItemDesign)generateBy);
            }
        }
        this.context.setContent(content);
    }

    protected IResultSet openQuery(IResultSet rset, IContent content) {
        DataID dataId;
        InstanceID iid;
        ReportItemDesign design;
        IBaseQueryDefinition query;
        Object generateBy = content.getGenerateBy();
        if (generateBy instanceof ReportItemDesign && (query = (design = (ReportItemDesign)generateBy).getQuery()) != null) {
            DataSetID dataSetId;
            DataID dataId2;
            InstanceID iid2 = content.getInstanceID();
            if (iid2 != null && (dataId2 = iid2.getDataID()) != null && (dataSetId = dataId2.getDataSetID()) != null) {
                DataSetID parentSetId = dataSetId.getParentID();
                long parentRowId = dataSetId.getRowID();
                if (parentSetId != null && parentRowId != -1L && rset != null && parentRowId != rset.getCurrentPosition()) {
                    rset.skipTo(parentRowId);
                }
            }
            try {
                rset = this.context.executeQuery(rset, query);
            }
            catch (BirtException ex) {
                this.context.addException(ex);
            }
        }
        if ((iid = content.getInstanceID()) != null && (dataId = iid.getDataID()) != null && rset != null) {
            long rowId = dataId.getRowID();
            if (rowId == -1L) {
                rset.next();
            }
            if (rowId != -1L && rowId != rset.getCurrentPosition()) {
                rset.skipTo(rowId);
            }
        }
        return rset;
    }

    protected void closeQuery(IResultSet rset) {
        if (rset != null) {
            rset.close();
        }
    }

    public void execute(ReportDesignHandle reportDesign, IContentEmitter emitter) {
        IReportContent reportContent = this.execute();
        if (emitter != null) {
            emitter.start(reportContent);
        }
        while (this.hasNextChild()) {
            IReportItemExecutor executor = this.getNextChild();
            this.execute(executor, emitter);
        }
        if (emitter != null) {
            emitter.end(reportContent);
        }
        this.close();
    }

    protected void execute(IReportItemExecutor executor, IContentEmitter emitter) {
        IContent content = executor.execute();
        if (emitter != null) {
            ContentEmitterUtil.startContent(content, emitter);
        }
        while (executor.hasNextChild()) {
            IReportItemExecutor child = executor.getNextChild();
            this.execute(child, emitter);
        }
        if (emitter != null) {
            ContentEmitterUtil.endContent(content, emitter);
        }
    }

    static {
        $assertionsDisabled = !AbstractReportReader.class.desiredAssertionStatus();
        logger = Logger.getLogger(AbstractReportReader.class.getName());
    }
}

