/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.executor.doc;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ListIterator;

class Segment {
    LinkedList edges = new LinkedList();
    long[][] sections;
    private static final long UNCLOSE_EDGE = -1L;
    private static final long LEFT_MOST_EDGE = Long.MIN_VALUE;
    private static final long RIGHT_MOST_EDGE = Long.MAX_VALUE;
    private static final int STATUS_INIT = 0;
    private static final int STATUS_START = 1;
    private static final int STATUS_CLOSE = 2;

    Segment() {
    }

    void startSegment(long left) {
        this.addEdge(left, true);
    }

    void endSegment(long right) {
        this.addEdge(right, false);
    }

    boolean inSegment(long offset) {
        if (this.sections == null) {
            this.normalize();
        }
        for (int i = 0; i < this.sections.length; ++i) {
            long[] sect = this.sections[i];
            if (sect[0] > offset || sect[1] < offset) continue;
            return true;
        }
        return false;
    }

    private void addEdge(long offset, boolean left) {
        this.sections = null;
        SegmentEdge edge = null;
        ListIterator<SegmentEdge> iter = this.edges.listIterator(this.edges.size());
        while (iter.hasPrevious()) {
            SegmentEdge next = (SegmentEdge)iter.previous();
            if (next.offset > offset) continue;
            edge = new SegmentEdge(offset, left);
            iter.next();
            iter.add(edge);
            return;
        }
        if (edge == null) {
            edge = new SegmentEdge(offset, left);
            this.edges.addFirst(edge);
        }
    }

    public void normalize() {
        int i;
        if (!this.edges.isEmpty()) {
            SegmentEdge start = (SegmentEdge)this.edges.getFirst();
            if (!start.leftEdge) {
                start = new SegmentEdge(Long.MIN_VALUE, true);
                this.edges.addFirst(start);
            }
            SegmentEdge end = (SegmentEdge)this.edges.getLast();
            if (end.leftEdge) {
                end = new SegmentEdge(Long.MAX_VALUE, false);
                this.edges.addLast(end);
            }
        }
        ArrayList<long[]> sects = new ArrayList<long[]>();
        long leftEdge = -1L;
        long rightEdge = -1L;
        int status = 0;
        block9: for (i = 0; i < this.edges.size(); ++i) {
            SegmentEdge edge = (SegmentEdge)this.edges.get(i);
            switch (status) {
                case 0: {
                    if (edge.leftEdge) {
                        leftEdge = edge.offset;
                        rightEdge = -1L;
                        status = 1;
                        continue block9;
                    }
                    leftEdge = Long.MIN_VALUE;
                    rightEdge = edge.offset;
                    status = 2;
                    continue block9;
                }
                case 1: {
                    if (edge.leftEdge) continue block9;
                    rightEdge = edge.offset;
                    status = 2;
                    continue block9;
                }
                case 2: {
                    if (edge.leftEdge) {
                        if (edge.offset == rightEdge) {
                            rightEdge = -1L;
                        } else {
                            sects.add(new long[]{leftEdge, rightEdge});
                            leftEdge = edge.offset;
                            rightEdge = -1L;
                        }
                        status = 1;
                        continue block9;
                    }
                    rightEdge = edge.offset;
                }
            }
        }
        switch (status) {
            case 1: {
                sects.add(new long[]{leftEdge, Long.MAX_VALUE});
                break;
            }
            case 2: {
                sects.add(new long[]{leftEdge, rightEdge});
            }
        }
        this.sections = new long[sects.size()][];
        for (i = 0; i < sects.size(); ++i) {
            this.sections[i] = (long[])sects.get(i);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.sections == null) {
            this.normalize();
        }
        if (this.sections.length == 0) {
            return "[NONE]";
        }
        for (int i = 0; i < this.sections.length; ++i) {
            long[] seg = this.sections[i];
            buffer.append("[");
            if (seg[0] == Long.MIN_VALUE && seg[1] == Long.MAX_VALUE) {
                buffer.append("ALL");
            } else if (seg[0] == Long.MIN_VALUE && seg[1] == Long.MIN_VALUE) {
                buffer.append("NONE");
            } else {
                if (seg[0] != Long.MIN_VALUE) {
                    buffer.append(seg[0]);
                }
                buffer.append("-");
                if (seg[1] != Long.MAX_VALUE) {
                    buffer.append(seg[1]);
                }
            }
            buffer.append("]");
        }
        return buffer.toString();
    }

    class SegmentEdge {
        long offset;
        boolean leftEdge;

        SegmentEdge(long offset, boolean leftEdge) {
            this.offset = offset;
            this.leftEdge = leftEdge;
        }
    }
}

