/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html;

import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.emitter.BufferedReportEmitter;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.layout.html.HTMLTableLayoutEmitter;

public class HTMLTableLayoutNoNestEmitter
extends HTMLTableLayoutEmitter {
    int nestTableCount = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    public HTMLTableLayoutNoNestEmitter(IContentEmitter emitter) {
        super(emitter);
    }

    private boolean isNestTable() {
        return this.nestTableCount > 1;
    }

    public void startTable(ITableContent table) {
        ++this.nestTableCount;
        if (this.cellEmitter != null) {
            this.cellEmitter.startTable(table);
        } else {
            if (!this.isNestTable()) {
                this.initLayout(table);
            }
            this.emitter.startTable(table);
        }
    }

    public void endTable(ITableContent table) {
        if (this.cellEmitter != null) {
            this.cellEmitter.endTable(table);
        } else {
            if (!this.isNestTable()) {
                this.resolveAll();
                this.flush();
            }
            this.emitter.endTable(table);
        }
        --this.nestTableCount;
    }

    public void startTableGroup(ITableGroupContent group) {
        if (this.cellEmitter != null) {
            this.cellEmitter.startTableGroup(group);
        } else {
            if (!this.isNestTable()) {
                int groupLevel = group.getGroupLevel();
                this.groupStack.push(new Integer(groupLevel));
                if (this.hasDropCell()) {
                    this.layoutEvents.push(new HTMLTableLayoutEmitter.LayoutEvent(0, group));
                    return;
                }
            }
            this.emitter.startTableGroup(group);
        }
    }

    public void endTableGroup(ITableGroupContent group) {
        if (this.cellEmitter != null) {
            this.cellEmitter.endTableGroup(group);
        } else {
            if (!this.isNestTable()) {
                int groupLevel = this.getGroupLevel();
                this.resolveCellsOfDrop(groupLevel, false);
                this.resolveCellsOfDrop(groupLevel, true);
                if (!$assertionsDisabled && this.groupStack.isEmpty()) {
                    throw new AssertionError();
                }
                this.groupStack.pop();
                if (this.hasDropCell()) {
                    this.layoutEvents.push(new HTMLTableLayoutEmitter.LayoutEvent(2, group));
                    return;
                }
                this.flush();
            }
            this.emitter.endTableGroup(group);
        }
    }

    public void startTableBand(ITableBandContent band) {
        if (this.cellEmitter != null) {
            this.cellEmitter.startTableBand(band);
        } else {
            if (!this.isNestTable()) {
                if (band.getBandType() == 4) {
                    int groupLevel = this.getGroupLevel();
                    this.resolveCellsOfDrop(groupLevel, false);
                }
                if (this.hasDropCell()) {
                    this.layoutEvents.push(new HTMLTableLayoutEmitter.LayoutEvent(1, band));
                    return;
                }
                this.flush();
            }
            this.emitter.startTableBand(band);
        }
    }

    public void endTableBand(ITableBandContent band) {
        if (this.cellEmitter != null) {
            this.cellEmitter.endTableBand(band);
        } else {
            if (!this.isNestTable()) {
                if (band.getBandType() == 4) {
                    int groupLevel = this.getGroupLevel();
                    this.resolveCellsOfDrop(groupLevel, true);
                }
                if (this.hasDropCell()) {
                    this.layoutEvents.push(new HTMLTableLayoutEmitter.LayoutEvent(3, band));
                    return;
                }
                this.flush();
            }
            this.emitter.endTableBand(band);
        }
    }

    public void startRow(IRowContent row) {
        if (this.cellEmitter != null) {
            this.cellEmitter.startRow(row);
        } else {
            if (!this.isNestTable()) {
                this.layout.createRow(row);
                if (this.hasDropCell()) {
                    this.layoutEvents.push(new HTMLTableLayoutEmitter.LayoutEvent(4, new Integer(this.layout.getRowCount() - 1)));
                    return;
                }
            }
            this.emitter.startRow(row);
        }
    }

    public void endRow(IRowContent row) {
        if (this.cellEmitter != null) {
            this.cellEmitter.endRow(row);
        } else {
            if (!this.isNestTable()) {
                if (this.hasDropCell()) {
                    return;
                }
                this.flush();
            }
            this.emitter.endRow(row);
        }
    }

    public void startCell(ICellContent cell) {
        if (this.cellEmitter != null) {
            this.cellEmitter.startCell(cell);
        } else {
            if (!this.isNestTable()) {
                String dropType;
                BufferedReportEmitter buffer = null;
                int colId = cell.getColumn();
                int colSpan = cell.getColSpan();
                int rowSpan = cell.getRowSpan();
                CellDesign cellDesign = (CellDesign)cell.getGenerateBy();
                if (cellDesign != null && (dropType = cellDesign.getDrop()) != null && !"none".equals(dropType)) {
                    rowSpan = this.createDropID(this.getGroupLevel(), dropType);
                }
                if (!this.hasDropCell() && rowSpan < 0) {
                    this.layoutEvents.push(new HTMLTableLayoutEmitter.LayoutEvent(5, new Integer(this.layout.getRowCount() - 1)));
                }
                if (this.hasDropCell() || rowSpan < 0) {
                    buffer = new BufferedReportEmitter(this.emitter);
                    this.cellEmitter = buffer;
                }
                this.createCell(colId, rowSpan, colSpan, new HTMLTableLayoutEmitter.CellContent(cell, buffer));
                if (this.hasDropCell()) {
                    return;
                }
            }
            this.emitter.startCell(cell);
        }
    }

    public void endCell(ICellContent cell) {
        if (!this.isNestTable()) {
            if (this.cellEmitter != null) {
                this.cellEmitter = null;
                return;
            }
            this.emitter.endCell(cell);
        } else if (this.cellEmitter != null) {
            this.cellEmitter.endCell(cell);
        } else {
            this.emitter.endCell(cell);
        }
    }

    static {
        $assertionsDisabled = !HTMLTableLayoutNoNestEmitter.class.desiredAssertionStatus();
    }
}

