/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.presentation;

import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.ContentEmitterAdapter;
import org.eclipse.birt.report.engine.emitter.ContentEmitterUtil;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.presentation.LocalizedContentVisitor;

public class LocalizedEmitter
extends ContentEmitterAdapter {
    private ExecutionContext context;
    protected LocalizedContentVisitor l18nVisitor;
    protected IContentEmitter emitter;

    public LocalizedEmitter(ExecutionContext context) {
        this(context, null);
    }

    public LocalizedEmitter(ExecutionContext context, IContentEmitter emitter) {
        this.emitter = emitter;
        this.context = context;
    }

    public String getOutputFormat() {
        if (this.emitter != null) {
            return this.emitter.getOutputFormat();
        }
        return null;
    }

    public void initialize(IEmitterServices services) {
        super.initialize(services);
        if (this.emitter != null) {
            this.emitter.initialize(services);
        }
    }

    public void start(IReportContent reportContent) {
        super.start(reportContent);
        this.l18nVisitor = new LocalizedContentVisitor(this.context);
        if (this.emitter != null) {
            this.emitter.start(reportContent);
        }
    }

    public void end(IReportContent report) {
        super.end(report);
        if (this.emitter != null) {
            this.emitter.end(report);
        }
    }

    public void startContent(IContent content) {
        content = this.l18nVisitor.localize(content);
        if (this.emitter != null) {
            ContentEmitterUtil.startContent(content, this.emitter);
        }
    }

    public void endContent(IContent content) {
        if (this.emitter != null) {
            ContentEmitterUtil.endContent(content, this.emitter);
        }
    }
}

