
sqlcount=527

##########################################################################
# Non dbms specific repository creation script. 
# Processed by TrelliSoft.install.RepositoryInstall
# 
# This file must have the following format:
# 1) The first line of the file must contain a count of the sql stmts
#    included in the line. This info is used to update a progress bar
#    as the sql file is being processed. This line should be in the
#    format:
#        sqlcount = <n>
#    where <n> represents the # of statements contained in the file
#
# 2) Each sql statement must be terminated by a ';' as the first char
#    of a new line. Everything else on the terminator line is ignored.
#
# 3) Comments are denoted by a '#' as the first char of a line. Everything
#    on a comment line is ignored
#
# Parm    Oracle        MSSQL                      DB2
# ----    ------        -----                      ---
# {0}     decimal(10)   integer                    integer
# {1}     decimal(5)    smallint                   smallint
# {2}     raw(20)       varbinary(20)              varchar(20) for bit data
# {3}     date          datetime                   timestamp
# {4}     long          text                       long varchar
# {5}     long raw      image                      long varchar for bit data
# {6}     <empty>       case_mask varbinary(8)     <empty>
#                         default 0x00 not null,
# {7}     <empty>       case_mask varbinary(64)    <empty>
#                         default 0x00 not null,
# {8}     sysdate       current_timestamp          current timestamp
# {9}     '20'          ' '                        ' '
# {10}    <empty>       , case_mask                <empty>
# {11}    <empty>       0x00,                      <empty>
# {12}    float         float                      float
# {13}    raw(60)       varbinary(60)              varchar(60) for bit data
# {14}    <empty>       t_res_stat_dir.            <empty>
# {15}    modify        alter column               alter
# {16}    <empty>       <empty>                    set data type
# {17}    <empty>       not null                   <empty>
# {18}    column        column                     <empty>
# {19}    '4e'          0x4e                       x'4e'
# {20}    partition     partition                  "partition"
# {21}    default null  null                       <empty>
# {22}    <empty>       <empty>                    IN <tablspace>
# {110}   '00'          0x00                        x'00'
# {111}   -             -                           bigint
###########################################################################


------------------------------------------------
-- DDL Statements for table "T_UPGRADE_LOG"
------------------------------------------------
 
 CREATE TABLE "T_UPGRADE_LOG"  (
 			"VENDOR" CHAR(1),
		  "VERSN" {1}, 
		  "RELEASE" {1}, 
		  "MODIFICATION" {1}, 
		  "SUBMODIFICATION" {1}, 
		  "STATEMENT_NUMBER" {0}  )   {22}
; 

------------------------------------------------
-- DDL Statements for table "T_IDENTIFIER"
------------------------------------------------
 
 CREATE TABLE "T_IDENTIFIER"  (
		  "ID_TYPE" {0} NOT NULL , 
		  "IDENTIFIER" {0} NOT NULL )   {22}
; 

-- DDL Statements for primary key on Table "T_IDENTIFIER"

ALTER TABLE "T_IDENTIFIER" 
	ADD PRIMARY KEY
		("ID_TYPE")
;



------------------------------------------------
-- DDL Statements for table "T_GROUP"
------------------------------------------------
 
 CREATE TABLE "T_GROUP"  (
		  "GROUP_ID" {0} NOT NULL , 
		  "CREATOR" VARCHAR(32) NOT NULL , 
		  "NAME" VARCHAR(64) NOT NULL , 
		  "DESCRIPTION" VARCHAR(128) NOT NULL , 
		  "LAST_MODIFIED" DECIMAL(13,0) NOT NULL , 
		  "LAST_MOD_USER" VARCHAR(32) NOT NULL , 
		  "SHARE_MODE" CHAR(1) NOT NULL , 
		  "GROUP_TYPE" {1} NOT NULL , 
		  "FLAGS" {0} NOT NULL )   {22}
; 
-- DDL Statements for indexes on Table "T_GROUP"

CREATE UNIQUE INDEX "T_GROUP_IX" ON "T_GROUP" 
		("CREATOR" ASC,
		 "NAME" ASC)
;




------------------------------------------------
-- DDL Statements for table "T_RES_COMPUTER"
------------------------------------------------
 
 CREATE TABLE "T_RES_COMPUTER"  (
		  "COMPUTER_ID" {0} NOT NULL , 
		  "TRELLISOFT_NAME" VARCHAR(250) NOT NULL , 
		  "LOCAL_HOSTNAME" VARCHAR(255) NOT NULL , 
		  "OS_TYPE" {1} NOT NULL , 
		  "NETWORK_NAME" VARCHAR(255) NOT NULL , 
		  "DOMAIN_NAME" VARCHAR(255) NOT NULL , 
		  "IP_ADDRESS" VARCHAR(15) NOT NULL , 
		  "HARDWARE_ID" {2} NOT NULL , 
		  "MANUFACTURER" VARCHAR(64) NOT NULL , 
		  "TIMEZONE" VARCHAR(64) NOT NULL , 
		  "DISCOVERED_TIME" {3} NOT NULL , 
		  "PRODUCT_STATES" {2} NOT NULL WITH DEFAULT {19} , 
		  "GUID" CHAR(47) , 
		  "CPU_ARCHITECTURE" {1} NOT NULL WITH DEFAULT 0 , 
		  "ORIGINAL_ALIAS" VARCHAR(255) NOT NULL WITH DEFAULT {9} )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_COMPUTER"

CREATE UNIQUE INDEX "T_RES_COMP_IX1" ON "T_RES_COMPUTER" 
		("TRELLISOFT_NAME" ASC)
;

-- DDL Statements for indexes on Table "T_RES_COMPUTER"

CREATE UNIQUE INDEX "T_RES_COMP_IX2" ON "T_RES_COMPUTER" 
		("MANUFACTURER" ASC,
		 "HARDWARE_ID" ASC)
;

-- DDL Statements for indexes on Table "T_RES_COMPUTER"

CREATE UNIQUE INDEX "T_RES_COMP_IX3" ON "T_RES_COMPUTER" 
		("COMPUTER_ID" ASC)
;




------------------------------------------------
-- DDL Statements for table "T_RES_SERVER"
------------------------------------------------
 
 CREATE TABLE "T_RES_SERVER"  (
		  "SERVER_ID" {0} NOT NULL , 
		  "SERVER_NAME" VARCHAR(255) NOT NULL , 
		  "SERVER_TOKEN" DECIMAL(13,0) NOT NULL , 
		  "COMPUTER_ID" {0} NOT NULL , 
		  "PORT_NUMBER" {0} NOT NULL , 
		  "SERVER_TYPE" {0} , 
		  "PASSWORD" VARCHAR(255) )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_SERVER"

ALTER TABLE "T_RES_SERVER" 
	ADD PRIMARY KEY
		("SERVER_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_AGENT"
------------------------------------------------
 
 CREATE TABLE "T_RES_AGENT"  (
		  "COMPUTER_ID" {0} NOT NULL , 
		  "PORT_NUMBER" {0} NOT NULL , 
		  "SERVER_ID" {0} NOT NULL , 
		  "STATE" CHAR(1) NOT NULL , 
		  "TIME_STAMP" {3} NOT NULL , 
		  "PROCESSOR_TYPE" CHAR(1) NOT NULL , 
		  "PROCESSOR_NUMBER" {1} NOT NULL , 
		  "MODIFICATION" CHAR(1) NOT NULL , 
		  "PRODUCT_STATES" {2} NOT NULL , 
		  "PRODUCT_VERSIONS" {13} NOT NULL , 
		  "FEATURE_SET" {2} NOT NULL WITH DEFAULT {110} )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_AGENT"

CREATE INDEX "T_RES_AGENT_IX" ON "T_RES_AGENT" 
		("COMPUTER_ID" ASC)
;




------------------------------------------------
-- DDL Statements for table "T_CONFIG_SETTINGS"
------------------------------------------------
 
 CREATE TABLE "T_CONFIG_SETTINGS"  (
		  "SNMP_SERVER" VARCHAR(128) NOT NULL , 
		  "SNMP_PORT" {0} NOT NULL , 
		  "SNMP_COMMUNITY" VARCHAR(64) NOT NULL , 
		  "SMTP_SERVER" VARCHAR(128) NOT NULL , 
		  "SMTP_PORT" {0} NOT NULL , 
		  "SMTP_REPLY_TO" VARCHAR(128) NOT NULL , 
		  "SMTP_RETURN" VARCHAR(128) NOT NULL , 
		  "SMTP_DFLT_DOMAIN" VARCHAR(128) NOT NULL , 
		  "RETAIN_COPIES" {0} NOT NULL , 
		  "RETAIN_DAYS" {0} NOT NULL , 
		  "DELLOG_AFTER_DAYS" {0} NOT NULL WITH DEFAULT 90 , 
		  "TEC_SERVER" VARCHAR(128) NOT NULL WITH DEFAULT 'host.com' , 
		  "TEC_PORT" {0} NOT NULL WITH DEFAULT 5529 , 
		  "SNMP2_SERVER" VARCHAR(128) NOT NULL WITH DEFAULT {9} , 
		  "SNMP2_PORT" {0} NOT NULL WITH DEFAULT 0 , 
		  "SNMP2_COMMUNITY" VARCHAR(64) NOT NULL WITH DEFAULT {9} )   {22}
; 



------------------------------------------------
-- DDL Statements for table "T_ALERT_LOG"
------------------------------------------------
 
 CREATE TABLE "T_ALERT_LOG"  (
		  "ALERT_LOG_ID" {0} NOT NULL , 
		  "ALERT_ID" {0} NOT NULL , 
		  "NOTIFY_USER" VARCHAR(32) NOT NULL , 
		  "PRODUCT_ID" {0} NOT NULL , 
		  "COMPUTER_ID" {0} NOT NULL , 
		  "RESOURCE_ID" {0} NOT NULL , 
		  "RESOURCE_TYPE" {1} NOT NULL , 
		  "ALERT_CONDITION" {1} NOT NULL , 
		  "THRESHOLD_TYPE" CHAR(1) NOT NULL , 
		  "THRESHOLD_VALUE" {0} NOT NULL , 
		  "VIOLATING_VALUE" {0} NOT NULL , 
		  "PREVIOUS_VALUE" {0} NOT NULL , 
		  "VIOLATOR_ID" {0} NOT NULL , 
		  "VIOLATOR_TYPE" {1} NOT NULL , 
		  "FIRST_ALERT_TIME" {3} NOT NULL , 
		  "LAST_ALERT_TIME" {3} NOT NULL , 
		  "ALERT_COUNT" {0} NOT NULL , 
		  "STATE" CHAR(1) NOT NULL , 
		  "SCRIPT_COMPUTER_ID" {0} NOT NULL , 
		  "SCRIPT_LOG_FILE" VARCHAR(256) NOT NULL , 
		  "SCRIPT_NAME" VARCHAR(64) NOT NULL , 
		  "MSG" VARCHAR(512) NOT NULL , 
		  "DBMS_TYPE" CHAR(1) NOT NULL WITH DEFAULT '0' , 
		  "PARENT_ID" {0} NOT NULL WITH DEFAULT -1 , 
		  "JOB_LOG_FILE" VARCHAR(256) NOT NULL WITH DEFAULT {9} )   {22}
; 
-- DDL Statements for indexes on Table "T_ALERT_LOG"

CREATE INDEX "T_ALERT_LOG_IX" ON "T_ALERT_LOG" 
		("ALERT_ID" ASC,
		 "COMPUTER_ID" ASC,
		 "RESOURCE_ID" ASC,
		 "RESOURCE_TYPE" ASC,
		 "ALERT_CONDITION" ASC,
		 "VIOLATOR_ID" ASC,
		 "VIOLATOR_TYPE" ASC)
;

-- DDL Statements for indexes on Table "T_ALERT_LOG"

CREATE UNIQUE INDEX "T_ALERT_LOG_IX2" ON "T_ALERT_LOG" 
		("ALERT_LOG_ID" ASC)
;




------------------------------------------------
-- DDL Statements for table "T_ALERT_DEFINITION"
------------------------------------------------
 
 CREATE TABLE "T_ALERT_DEFINITION"  (
		  "ALERT_ID" {0} NOT NULL , 
		  "CREATOR" VARCHAR(32) NOT NULL , 
		  "NAME" VARCHAR(64) NOT NULL , 
		  "DESCRIPTION" VARCHAR(64) NOT NULL , 
		  "LAST_MODIFIED" DECIMAL(13,0) NOT NULL , 
		  "LAST_MOD_USER" VARCHAR(32) NOT NULL , 
		  "ENABLED" CHAR(1) NOT NULL , 
		  "PRODUCT_ID" {1} NOT NULL , 
		  "ALERT_TYPE" {1} NOT NULL , 
		  "CONDITION" {1} NOT NULL , 
		  "THRESHOLD_TYPE" CHAR(1) NOT NULL , 
		  "THRESHOLD_VALUE" {0} NOT NULL , 
		  "SNMP_TRAP" CHAR(1) NOT NULL , 
		  "OS_LOG" CHAR(1) NOT NULL , 
		  "OS_LOG_SEVERITY" CHAR(1) NOT NULL , 
		  "SYSLOG_FACILITY" CHAR(1) NOT NULL , 
		  "EMAIL" CHAR(1) NOT NULL , 
		  "NOTIFY_ON_LOGIN" VARCHAR(32) NOT NULL , 
		  "SCRIPT_COMPUTER_ID" {0} NOT NULL , 
		  "SCRIPT_NAME" VARCHAR(64) NOT NULL , 
		  "DBMS_TYPE" CHAR(1) NOT NULL WITH DEFAULT '0' , 
		  "TEC_EVENT" CHAR(1) NOT NULL WITH DEFAULT '0' )   {22}
; 
-- DDL Statements for indexes on Table "T_ALERT_DEFINITION"

CREATE UNIQUE INDEX "T_ALERT_DEF_IX" ON "T_ALERT_DEFINITION" 
		("ALERT_TYPE" ASC,
		 "CREATOR" ASC,
		 "NAME" ASC)
;




------------------------------------------------
-- DDL Statements for table "T_ALERT_EMAIL"
------------------------------------------------
 
 CREATE TABLE "T_ALERT_EMAIL"  (
		  "ALERT_ID" {0} NOT NULL , 
		  "SUBJECT" VARCHAR(256) NOT NULL , 
		  "TEXT" {4} NOT NULL , 
		  "RECIPIENTS" VARCHAR(512) NOT NULL , 
		  "QUOTA_VIOLATOR" CHAR(1) NOT NULL )   {22}
; 



------------------------------------------------
-- DDL Statements for table "T_RES_ATTRIBUTE"
------------------------------------------------
 
 CREATE TABLE "T_RES_ATTRIBUTE"  (
		  "RESOURCE_ID" {0} NOT NULL , 
		  "RESOURCE_TYPE" {1} NOT NULL , 
		  "ATTRIBUTE_ID" {0} NOT NULL , 
		  "ATTRIBUTE_TYPE" {1} NOT NULL , 
		  "EXCLUDE" CHAR(1) NOT NULL , 
		  "SNAPSHOTTED" {1} NOT NULL WITH DEFAULT 0 )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_ATTRIBUTE"

CREATE INDEX "T_RES_ATTR_IX" ON "T_RES_ATTRIBUTE" 
		("RESOURCE_ID" ASC,
		 "RESOURCE_TYPE" ASC)
;

-- DDL Statements for indexes on Table "T_RES_ATTRIBUTE"

CREATE INDEX "T_RES_ATTR_IX2" ON "T_RES_ATTRIBUTE" 
		("ATTRIBUTE_ID" ASC,
		 "ATTRIBUTE_TYPE" ASC)
;




------------------------------------------------
-- DDL Statements for table "T_SCHEDULE"
------------------------------------------------
 
 CREATE TABLE "T_SCHEDULE"  (
		  "SCHEDULE_ID" {0} NOT NULL , 
		  "CREATOR" VARCHAR(32) NOT NULL , 
		  "NAME" VARCHAR(64) NOT NULL , 
		  "DESCRIPTION" VARCHAR(128) NOT NULL , 
		  "LAST_MODIFIED" DECIMAL(13,0) NOT NULL , 
		  "LAST_MOD_USER" VARCHAR(32) NOT NULL , 
		  "ENABLED" CHAR(1) NOT NULL , 
		  "SCHEDULE_TYPE" CHAR(1) NOT NULL , 
		  "START_YEAR" DECIMAL(4,0) NOT NULL , 
		  "START_MONTH" DECIMAL(4,0) NOT NULL , 
		  "START_DAY" DECIMAL(4,0) NOT NULL , 
		  "START_HOUR" DECIMAL(4,0) NOT NULL , 
		  "START_MINUTE" DECIMAL(4,0) NOT NULL , 
		  "REPEAT_TYPE" CHAR(1) NOT NULL , 
		  "INTERVAL_TYPE" CHAR(1) NOT NULL , 
		  "INTERVAL_NUMBER" DECIMAL(3,0) NOT NULL , 
		  "RUN_SUNDAY" CHAR(1) NOT NULL , 
		  "RUN_MONDAY" CHAR(1) NOT NULL , 
		  "RUN_TUESDAY" CHAR(1) NOT NULL , 
		  "RUN_WEDNESDAY" CHAR(1) NOT NULL , 
		  "RUN_THURSDAY" CHAR(1) NOT NULL , 
		  "RUN_FRIDAY" CHAR(1) NOT NULL , 
		  "RUN_SATURDAY" CHAR(1) NOT NULL , 
		  "TIMEZONE_TYPE" CHAR(1) NOT NULL , 
		  "GLOBAL_TYPE" CHAR(1) NOT NULL , 
		  "TIMEZONE" VARCHAR(99) NOT NULL , 
		  "ARGUMENTS" VARCHAR(99) NOT NULL , 
		  "ALERT_ID" {0} NOT NULL , 
		  "JOB_TYPE" CHAR(1) NOT NULL , 
		  "HIGH_RUN_NUMBER" {0} NOT NULL , 
		  "COMPUTER_ID" {0} NOT NULL )   {22}
; 
-- DDL Statements for indexes on Table "T_SCHEDULE"

CREATE UNIQUE INDEX "T_SCHEDULE_IX" ON "T_SCHEDULE" 
		("JOB_TYPE" ASC,
		 "CREATOR" ASC,
		 "NAME" ASC)
;

-- DDL Statements for indexes on Table "T_SCHEDULE"

CREATE UNIQUE INDEX "T_SCHEDULE_IX2" ON "T_SCHEDULE" 
		("SCHEDULE_ID" ASC)
;




------------------------------------------------
-- DDL Statements for table "T_RUNS"
------------------------------------------------
 
 CREATE TABLE "T_RUNS"  (
		  "TIME_STAMP" DECIMAL(13,0) NOT NULL , 
		  "SCHEDULE_ID" {0} NOT NULL , 
		  "RUN_NUMBER" {0} NOT NULL , 
		  "NUMBER_JOBS" {0} NOT NULL , 
		  "SUCCESSFUL_JOBS" {0} NOT NULL WITH DEFAULT -1 , 
		  "FINISH_TIME" DECIMAL(13,0) NOT NULL WITH DEFAULT -1 , 
		  "STATUS" CHAR(1) NOT NULL WITH DEFAULT '2' , 
		  "DEVICE_SERVER_RUN_ID" {0} NOT NULL WITH DEFAULT -1 , 
		  "DEVICE_SERVER_ID" {0} NOT NULL WITH DEFAULT -1 )   {22}
; 

-- DDL Statements for primary key on Table "T_RUNS"

ALTER TABLE "T_RUNS" 
	ADD PRIMARY KEY
		("RUN_NUMBER",
		 "SCHEDULE_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RUN_JOBS"
------------------------------------------------
 
 CREATE TABLE "T_RUN_JOBS"  (
		  "TIME_STAMP" DECIMAL(13,0) NOT NULL , 
		  "SCHEDULE_ID" {0} NOT NULL , 
		  "SID_RUN_NUMBER" {0} NOT NULL , 
		  "COMPUTER_ID" {0} NOT NULL , 
		  "JOB_RUN_NUMBER" {0} NOT NULL , 
		  "SUBMIT_STATUS" {0} NOT NULL WITH DEFAULT -1 , 
		  "RETURN_CODE" {0} NOT NULL WITH DEFAULT -1 , 
		  "PROCESS_ID" {0} NOT NULL WITH DEFAULT -1 , 
		  "START_TIME" DECIMAL(13,0) NOT NULL WITH DEFAULT -1 , 
		  "FINISH_TIME" DECIMAL(13,0) NOT NULL WITH DEFAULT -1 , 
		  "LOG_FILE_NAME" VARCHAR(256) NOT NULL WITH DEFAULT {9} , 
		  "SUBMIT_MILLIS" DECIMAL(13,0) NOT NULL WITH DEFAULT 0 , 
		  "DEVICE_SERVER_RUN_ID" {0} NOT NULL WITH DEFAULT -1 , 
		  "RESOURCE_TYPE" {1} NOT NULL WITH DEFAULT 1 )   {22}
; 
-- DDL Statements for indexes on Table "T_RUN_JOBS"

CREATE INDEX "T_RUN_JOBS_IX" ON "T_RUN_JOBS" 
		("SCHEDULE_ID" ASC,
		 "SID_RUN_NUMBER" ASC)
;


-- DDL Statements for primary key on Table "T_RUN_JOBS"

ALTER TABLE "T_RUN_JOBS" 
	ADD PRIMARY KEY
		("JOB_RUN_NUMBER")
;



------------------------------------------------
-- DDL Statements for table "T_USER_PREFERENCES"
------------------------------------------------
 
 CREATE TABLE "T_USER_PREFERENCES"  (
		  "USER_ID" VARCHAR(32) NOT NULL , 
		  "LOOK_AND_FEEL" VARCHAR(64) NOT NULL , 
		  "MAX_PANEL_CHAIN" {0} NOT NULL , 
		  "MAX_PANELS" {0} NOT NULL , 
		  "SHOW_LOGIN_ALERTS" CHAR(1) NOT NULL , 
		  "TAB_TO_DISPLAY" CHAR(1) NOT NULL , 
		  "EXPORT_PATH" VARCHAR(256) NOT NULL WITH DEFAULT {9} , 
		  "SPACE_UNITS" CHAR(1) NOT NULL WITH DEFAULT '0' )   {22}
; 
-- DDL Statements for indexes on Table "T_USER_PREFERENCES"

CREATE UNIQUE INDEX "T_USER_PREFS_IX" ON "T_USER_PREFERENCES" 
		("USER_ID" ASC)
;

------------------------------------------------
-- DDL Statements for table "T_STORM_SETTINGS"
------------------------------------------------
 
 CREATE TABLE "T_STORM_SETTINGS"  (
		  "KEEP_REMOVED_COMP" {1} NOT NULL , 
		  "KEEP_REMOVED_FS" {1} NOT NULL , 
		  "KEEP_REMOVED_DIR" {1} NOT NULL , 
		  "KEEP_REMOVED_DEV" {1} NOT NULL , 
		  "DISK_DAILY_HIST" {1} NOT NULL , 
		  "DISK_WEEKLY_HIST" {1} NOT NULL , 
		  "DISK_MONTHLY_HIST" {1} NOT NULL , 
		  "DIR_DAILY_HIST" {1} NOT NULL , 
		  "DIR_WEEKLY_HIST" {1} NOT NULL , 
		  "DIR_MONTHLY_HIST" {1} NOT NULL , 
		  "PING_DAILY_HIST" {1} NOT NULL , 
		  "PING_WEEKLY_HIST" {1} NOT NULL , 
		  "PING_MONTHLY_HIST" {1} NOT NULL , 
		  "COMP_DAILY_HIST" {1} NOT NULL , 
		  "COMP_WEEKLY_HIST" {1} NOT NULL , 
		  "COMP_MONTHLY_HIST" {1} NOT NULL , 
		  "FS_DAILY_HIST" {1} NOT NULL , 
		  "FS_WEEKLY_HIST" {1} NOT NULL , 
		  "FS_MONTHLY_HIST" {1} NOT NULL , 
		  "DISK_AWRE" CHAR(1) NOT NULL , 
		  "DISK_ARRE" CHAR(1) NOT NULL , 
		  "DISK_NOERRRCVRY" CHAR(1) NOT NULL , 
		  "EMAIL_ADDR_RULES" VARCHAR(128) NOT NULL , 
		  "KEEP_REMOVED_DB" {1} NOT NULL WITH DEFAULT 7 , 
		  "KEEP_REMOVED_TS" {1} NOT NULL WITH DEFAULT 7 , 
		  "KEEP_REMOVED_TB" {1} NOT NULL WITH DEFAULT 7 , 
		  "TS_DAILY_HIST" {1} NOT NULL WITH DEFAULT 6 , 
		  "TS_WEEKLY_HIST" {1} NOT NULL WITH DEFAULT 4 , 
		  "TS_MONTHLY_HIST" {1} NOT NULL WITH DEFAULT 2 , 
		  "TB_DAILY_HIST" {1} NOT NULL WITH DEFAULT 6 , 
		  "TB_WEEKLY_HIST" {1} NOT NULL WITH DEFAULT 4 , 
		  "TB_MONTHLY_HIST" {1} NOT NULL WITH DEFAULT 2 , 
		  "NO_WKSTA_DISCOVERY" CHAR(1) NOT NULL WITH DEFAULT '1' , 
		  "PM_TASK_HIST" {1} NOT NULL WITH DEFAULT 14 , 
		  "KEEP_REMOVED_FILERS" {1} NOT NULL WITH DEFAULT 14 , 
		  "KEEP_REMOVED_SUBSYSTEMS" {1} NOT NULL WITH DEFAULT 14 , 
		  "KEEP_REMOVED_FABRIC" {1} NOT NULL WITH DEFAULT 14 , 
		  "PM_HOURLY_HIST" {1} NOT NULL WITH DEFAULT 30 , 
		  "PM_DAILY_HIST" {1} NOT NULL WITH DEFAULT 90 , 
		  "TV_REFRESH_TIMEOUT" {1} NOT NULL WITH DEFAULT 300 , 
		  "KEEP_REMOVED_TAPE" {1} NOT NULL WITH DEFAULT 14 )   {22}
; 



------------------------------------------------
-- DDL Statements for table "T_RES_CONTROLLER"
------------------------------------------------
 
 CREATE TABLE "T_RES_CONTROLLER"  (
		  "CONTROLLER_ID" {0} NOT NULL , 
		  "COMPUTER_ID" {0} NOT NULL , 
		  "INSTANCE_NUMBER" {1} NOT NULL , 
		  "BUS_NUMBER" {1} NOT NULL , 
		  "DRIVER_NAME" VARCHAR(255) NOT NULL , 
		  "DRIVER_DESCRIPTION" VARCHAR(128) NOT NULL , 
		  "TARGET" {1} NOT NULL , 
		  "CONTROLLER_TYPE" {1} NOT NULL , 
		  "LOOP" VARCHAR(256) NOT NULL WITH DEFAULT {9} , 
		  "ADAPTER_PAIR" VARCHAR(256) NOT NULL WITH DEFAULT {9} , 
		  "ARRAY" VARCHAR(256) NOT NULL WITH DEFAULT {9} , 
		  "WWN" {111} NOT NULL WITH DEFAULT -1 , 
		  "WWN_STR" VARCHAR(255) )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_CONTROLLER"

CREATE INDEX "I_CTRLR_WWNSTR" ON "T_RES_CONTROLLER" 
		("WWN_STR" ASC)
;

-- DDL Statements for indexes on Table "T_RES_CONTROLLER"

CREATE UNIQUE INDEX "T_RES_CTLR_IX" ON "T_RES_CONTROLLER" 
		("COMPUTER_ID" ASC,
		 "CONTROLLER_ID" ASC)
;

-- DDL Statements for indexes on Table "T_RES_CONTROLLER"

CREATE INDEX "T_RES_CTLR_IX5" ON "T_RES_CONTROLLER" 
		("WWN" ASC)
;




------------------------------------------------
-- DDL Statements for table "T_RES_DEV_ACCESS"
------------------------------------------------
 
 CREATE TABLE "T_RES_DEV_ACCESS"  (
		  "CONTROLLER_ID" {0} NOT NULL , 
		  "DEVICE_ID" {0} NOT NULL , 
		  "TARGET" {1} NOT NULL , 
		  "LUN" {1} NOT NULL , 
		  "PATH" VARCHAR(256) NOT NULL , 
		  "IN_ACTIVE" CHAR(1) NOT NULL WITH DEFAULT '0' )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_DEV_ACCESS"

CREATE INDEX "T_RES_DA_IX" ON "T_RES_DEV_ACCESS" 
		("CONTROLLER_ID" ASC)
;




------------------------------------------------
-- DDL Statements for table "T_RES_DEVICE"
------------------------------------------------
 
 CREATE TABLE "T_RES_DEVICE"  (
		  "DEVICE_ID" {0} NOT NULL , 
		  "MANUFACTURER" VARCHAR(42) NOT NULL , 
		  "MODEL" VARCHAR(40) NOT NULL , 
		  "SERIAL_NUMBER" VARCHAR(255) NOT NULL , 
		  "FIRMWARE_REV" VARCHAR(8) NOT NULL , 
		  "MANUFACTURE_DATE" {3} NOT NULL , 
		  "USE_COUNT" {1} NOT NULL , 
		  "DEVICE_TYPE" {1} NOT NULL , 
		  "UNSUPPORTED_MODEL" CHAR(1) NOT NULL , 
		  "FLAGS" {1} NOT NULL , 
		  "REMOVABLE_MEDIUM" CHAR(1) NOT NULL , 
		  "MULTI_PORT" CHAR(1) NOT NULL , 
		  "DISCOVERED_TIME" {3} NOT NULL , 
		  "STORAGE_SYSTEM_TYPE" {1} NOT NULL WITH DEFAULT 0 )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_DEVICE"

CREATE UNIQUE INDEX "T_RES_DEV_IX" ON "T_RES_DEVICE" 
		("DEVICE_ID" ASC)
;

-- DDL Statements for indexes on Table "T_RES_DEVICE"

CREATE UNIQUE INDEX "T_RES_DEV_IX2" ON "T_RES_DEVICE" 
		("MANUFACTURER" ASC,
		 "SERIAL_NUMBER" ASC)
;




------------------------------------------------
-- DDL Statements for table "T_STAT_DISK"
------------------------------------------------
 
 CREATE TABLE "T_STAT_DISK"  (
		  "DISK_ID" {0} NOT NULL , 
		  "HEADS" {0} NOT NULL , 
		  "CYLINDERS" {0} NOT NULL , 
		  "RPM" {0} NOT NULL , 
		  "SECTOR_SIZE" {0} NOT NULL , 
		  "SECTORS_AVG_TRACK" {0} NOT NULL , 
		  "SECTORS_OUTR_TRACK" {0} NOT NULL , 
		  "SECTORS_INNR_TRACK" {0} NOT NULL , 
		  "LOGICAL_BLOCK_SIZE" {0} NOT NULL , 
		  "MINUTES_POWERED_ON" {0} NOT NULL , 
		  "WRITE_PROTECTED" CHAR(1) NOT NULL , 
		  "WRITE_CACHE_ENABLE" CHAR(1) NOT NULL , 
		  "READ_CACHE_DISABLE" CHAR(1) NOT NULL , 
		  "AUTO_WRITE_REALLOC" CHAR(1) NOT NULL , 
		  "AUTO_READ_REALLOC" CHAR(1) NOT NULL , 
		  "NO_ERROR_RECOVERY" CHAR(1) NOT NULL , 
		  "FAILURE_PREDICTED" CHAR(1) NOT NULL , 
		  "CAPACITY" DECIMAL(13,0) NOT NULL , 
		  "SPARE_BLOCKS" {0} NOT NULL , 
		  "VOLGROUP_ID" {0} NOT NULL , 
		  "DESIRED_AWRE" CHAR(1) NOT NULL , 
		  "DESIRED_ARRE" CHAR(1) NOT NULL , 
		  "DESIRED_NOERRRCVRY" CHAR(1) NOT NULL , 
		  "LOGICAL_DISK_ID" {0} NOT NULL WITH DEFAULT -1 , 
		  "DISK_IDENTITY" CHAR(1) NOT NULL WITH DEFAULT '0' )   {22}
; 
-- DDL Statements for indexes on Table "T_STAT_DISK"

CREATE UNIQUE INDEX "T_STAT_DISK_IX" ON "T_STAT_DISK" 
		("DISK_ID" ASC)
;

-- DDL Statements for indexes on Table "T_STAT_DISK"

CREATE INDEX "T_STAT_DISK_IX5" ON "T_STAT_DISK" 
		("LOGICAL_DISK_ID" ASC)
;




------------------------------------------------
-- DDL Statements for table "T_STAT_DISK_HIST"
------------------------------------------------
 
 CREATE TABLE "T_STAT_DISK_HIST"  (
		  "DISK_ID" {0} NOT NULL , 
		  "STATISTIC_TIME" {3} NOT NULL , 
		  "STATISTIC_TYPE" CHAR(1) NOT NULL , 
		  "PRIMARY_DEFECTS" {0} NOT NULL , 
		  "GROWN_DEFECTS" {0} NOT NULL , 
		  "RECOVRD_WRT_ERRS" {0} NOT NULL , 
		  "UNRECOVRD_WRT_ERRS" {0} NOT NULL , 
		  "BYTES_WRITTEN" DOUBLE NOT NULL , 
		  "RECOVRD_RD_ERRS" {0} NOT NULL , 
		  "UNRECOVRD_RD_ERRS" {0} NOT NULL , 
		  "BYTES_READ" DOUBLE NOT NULL , 
		  "RECOVRD_VFY_ERRS" {0} NOT NULL , 
		  "UNRECOVRD_VFY_ERRS" {0} NOT NULL , 
		  "NON_MEDIUM_ERRS" {0} NOT NULL , 
		  "CAPACITY" DECIMAL(13,0) NOT NULL , 
		  "FREE_SPACE" DECIMAL(13,0) NOT NULL , 
		  "TEMPERATURE" {1} NOT NULL )   {22}
; 
-- DDL Statements for indexes on Table "T_STAT_DISK_HIST"

CREATE INDEX "T_DISK_HIST_IX" ON "T_STAT_DISK_HIST" 
		("DISK_ID" ASC,
		 "STATISTIC_TYPE" ASC)
;




------------------------------------------------
-- DDL Statements for table "T_RES_LOGICAL_DISK"
------------------------------------------------
 
 CREATE TABLE "T_RES_LOGICAL_DISK"  (
		  "LOGICAL_DISK_ID" {0} NOT NULL , 
		  "PARENT_LOGDISK_ID" {0} NOT NULL , 
		  "LOGICAL_DISK_TYPE" CHAR(1) NOT NULL , 
		  "CAPACITY" DECIMAL(13,0) NOT NULL , 
		  "MIRROR_COUNT" {1} NOT NULL , 
		  "IS_SWAP" CHAR(1) NOT NULL , 
		  "USE_COUNT" {1} NOT NULL , 
		  "SNAP_SOURCE_ID" {0} NOT NULL WITH DEFAULT -1 , 
		  "IS_VCMDB" CHAR(1) NOT NULL WITH DEFAULT '0' , 
		  "REPLICATION_MODE" CHAR(1) NOT NULL WITH DEFAULT '0' , 
		  "NOT_EXPOSED" CHAR(1) NOT NULL WITH DEFAULT '0' , 
		  "OVERHEAD" DECIMAL(13,0) NOT NULL WITH DEFAULT 0 , 
		  "VOLGROUP_ID" {0} NOT NULL WITH DEFAULT -1 , 
		  "LUN_IDENTITY" CHAR(1) NOT NULL WITH DEFAULT '0' , 
		  "SSRAIDL" {0} NOT NULL WITH DEFAULT -1 , 
		  "STORAGE_TYPE" {1} NOT NULL WITH DEFAULT -1 )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_LOGICAL_DISK"

CREATE UNIQUE INDEX "T_RES_LOGDISK_IX" ON "T_RES_LOGICAL_DISK" 
		("LOGICAL_DISK_ID" ASC,
		 "PARENT_LOGDISK_ID" ASC)
;




------------------------------------------------
-- DDL Statements for table "T_RES_CHUNK_CLLCTN"
------------------------------------------------
 
 CREATE TABLE "T_RES_CHUNK_CLLCTN"  (
		  "COLLECTION_ID" {0} NOT NULL , 
		  "LOGICAL_DISK_ID" {0} NOT NULL , 
		  "COLLECTION_TYPE" CHAR(1) NOT NULL , 
		  "SEQNO" {1} NOT NULL , 
		  "STRIPING_SIZE" {0} NOT NULL )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_CHUNK_CLLCTN"

CREATE UNIQUE INDEX "T_RES_COLL_IX" ON "T_RES_CHUNK_CLLCTN" 
		("COLLECTION_ID" ASC)
;




------------------------------------------------
-- DDL Statements for table "T_RES_CHUNK"
------------------------------------------------
 
 CREATE TABLE "T_RES_CHUNK"  (
		  "DISK_ID" {0} NOT NULL , 
		  "COLLECTION_ID" {0} NOT NULL , 
		  "LOGICAL_DISK_ID" {0} NOT NULL , 
		  {20} {1} NOT NULL , 
		  "SEQNO" {1} NOT NULL , 
		  "HAS_DB" CHAR(1) NOT NULL , 
		  "UNIT_SIZE" {0} NOT NULL , 
		  "CHUNK_SIZE" DECIMAL(13,0) NOT NULL , 
		  "OFFSET" DECIMAL(13,0) NOT NULL )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_CHUNK"

CREATE INDEX "T_RES_CHUNK_IX1" ON "T_RES_CHUNK" 
		("LOGICAL_DISK_ID" ASC,
		 "COLLECTION_ID" ASC)
;

-- DDL Statements for indexes on Table "T_RES_CHUNK"

CREATE INDEX "T_RES_CHUNK_IX2" ON "T_RES_CHUNK" 
		("DISK_ID" ASC,
		 "OFFSET" ASC)
;

-- DDL Statements for indexes on Table "T_RES_CHUNK"

CREATE INDEX "T_RES_CHUNK_IX3" ON "T_RES_CHUNK" 
		("COLLECTION_ID" ASC)
;




------------------------------------------------
-- DDL Statements for table "T_RES_SHARE"
------------------------------------------------
 
 CREATE TABLE "T_RES_SHARE"  (
		  "COMPUTER_ID" {0} NOT NULL , 
		  "RESOURCE_ID" {0} NOT NULL , 
		  "RESOURCE_TYPE" {1} NOT NULL , 
		  "SCAN_TIME" {3} NOT NULL , 
		  "REMOVED_TIME" {3} NOT NULL , 
		  "PATH" VARCHAR(256) NOT NULL , 
		  "NAME" VARCHAR(64) )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_SHARE"

CREATE UNIQUE INDEX "T_RES_SHARE_IX" ON "T_RES_SHARE" 
		("COMPUTER_ID" ASC,
		 "RESOURCE_TYPE" ASC,
		 "RESOURCE_ID" ASC)
;




------------------------------------------------
-- DDL Statements for table "T_RES_EXPORT"
------------------------------------------------
 
 CREATE TABLE "T_RES_EXPORT"  (
		  "EXPORT_ID" {0} NOT NULL , 
		  "COMPUTER_ID" {0} NOT NULL , 
		  "PROTOCOL" CHAR(1) NOT NULL , 
		  "PATH" VARCHAR(256) NOT NULL , 
		  "EXPORT_NAME" VARCHAR(256) NOT NULL , 
		  "DISCOVERED_TIME" {3} NOT NULL )   {22}
; 


------------------------------------------------
-- DDL Statements for table "T_RES_FILESYSTEM"
------------------------------------------------
 
 CREATE TABLE "T_RES_FILESYSTEM"  (
		  "FILESYSTEM_ID" {0} NOT NULL , 
		  "COMPUTER_ID" {0} NOT NULL , 
		  "GROUP_ID" {0} NOT NULL , 
		  "LOGICAL_DISK_ID" {0} NOT NULL , 
		  "LOG_DISK_ID" {0} NOT NULL , 
		  "MAXFILES" {0} NOT NULL , 
		  "USED_INODES" DECIMAL(12,0) NOT NULL , 
		  "FREE_INODES" DECIMAL(12,0) NOT NULL , 
		  "PHYSICAL_SIZE" DECIMAL(13,0) NOT NULL , 
		  "CAPACITY" DECIMAL(13,0) NOT NULL , 
		  "USED_SPACE" DECIMAL(13,0) NOT NULL , 
		  "FREE_SPACE" DECIMAL(13,0) NOT NULL , 
		  "FILE_COUNT" DECIMAL(12,0) NOT NULL , 
		  "DIRECTORY_COUNT" DECIMAL(12,0) NOT NULL , 
		  "LAST_SCAN_TIME" {3} NOT NULL , 
		  "FILESYSTEM_TYPE" {1} NOT NULL , 
		  "USE_COUNT" {1} NOT NULL , 
		  "MOUNT_POINT" VARCHAR(256) NOT NULL , 
		  "DISCOVERED_TIME" {3} NOT NULL , 
		  "SCANNING_COMP_ID" {0} NOT NULL WITH DEFAULT -1 , 
		  "EXPORT_NAME" VARCHAR(256) NOT NULL WITH DEFAULT {9} )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_FILESYSTEM"

CREATE UNIQUE INDEX "T_RES_FS_IX" ON "T_RES_FILESYSTEM" 
		("FILESYSTEM_ID" ASC)
;

-- DDL Statements for indexes on Table "T_RES_FILESYSTEM"

CREATE INDEX "T_RES_FS_IX2" ON "T_RES_FILESYSTEM" 
		("GROUP_ID" ASC)
;

-- DDL Statements for indexes on Table "T_RES_FILESYSTEM"

CREATE INDEX "T_RES_FS_IX3" ON "T_RES_FILESYSTEM" 
		("LOGICAL_DISK_ID" ASC)
;

-- DDL Statements for indexes on Table "T_RES_FILESYSTEM"

CREATE INDEX "T_RES_FS_IX4" ON "T_RES_FILESYSTEM" 
		("COMPUTER_ID" ASC)
;


------------------------------------------------
-- DDL Statements for table "T_RES_DOMAIN"
------------------------------------------------
 
 CREATE TABLE "T_RES_DOMAIN"  (
		  "DOMAIN_ID" {0} NOT NULL , 
		  "NAME" VARCHAR(128) NOT NULL , 
		  "TREE_ID" {0} NOT NULL WITH DEFAULT -1 )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_DOMAIN"

CREATE UNIQUE INDEX "T_RES_DOMAIN_IX" ON "T_RES_DOMAIN" 
		("NAME" ASC)
;




------------------------------------------------
-- DDL Statements for table "T_STAT_COMPUTER"
------------------------------------------------
 
 CREATE TABLE "T_STAT_COMPUTER"  (
		  "COMPUTER_ID" {0} NOT NULL , 
		  "DOMAIN_ID" {0} NOT NULL , 
		  "GROUP_ID" {0} NOT NULL , 
		  "MANUFACTURER" VARCHAR(64) NOT NULL , 
		  "MODEL" VARCHAR(64) NOT NULL , 
		  "SERIAL_NUMBER" VARCHAR(64) NOT NULL , 
		  "OS_TYPE" {1} NOT NULL , 
		  "OS_VERSION" VARCHAR(32) NOT NULL , 
		  "PROCESSOR_TYPE" VARCHAR(32) NOT NULL , 
		  "PROCESSOR_COUNT" {1} NOT NULL , 
		  "PROCESSOR_SPEED" {1} NOT NULL , 
		  "RAM" {0} NOT NULL , 
		  "SWAP_SPACE" {0} NOT NULL , 
		  "DISK_CAPACITY" DECIMAL(13,0) NOT NULL , 
		  "FS_FREE_SPACE" DECIMAL(13,0) NOT NULL , 
		  "DISK_FREE_SPACE" DECIMAL(13,0) NOT NULL , 
		  "LAST_BOOT_TIME" {3} NOT NULL , 
		  "PROBE_STATUS" CHAR(1) NOT NULL , 
		  "LAST_PROBE_TIME" {3} NOT NULL , 
		  "OWNED_DISK_CAP" DECIMAL(13,0) NOT NULL WITH DEFAULT -1 , 
		  "OWNED_DISK_FREE_SP" DECIMAL(13,0) NOT NULL WITH DEFAULT -1 , 
		  "CLUSTER_ID" {0} NOT NULL WITH DEFAULT 0 , 
		  "NODE_HOSTED_ID" {0} NOT NULL WITH DEFAULT 0 , 
		  "CPU_ARCHITECTURE" {1} NOT NULL WITH DEFAULT 0 )   {22}
; 
-- DDL Statements for indexes on Table "T_STAT_COMPUTER"

CREATE UNIQUE INDEX "T_STAT_CMP_IX" ON "T_STAT_COMPUTER" 
		("COMPUTER_ID" ASC)
;




------------------------------------------------
-- DDL Statements for table "T_STAT_PING_HIST"
------------------------------------------------
 
 CREATE TABLE "T_STAT_PING_HIST"  (
		  "COMPUTER_ID" {0} NOT NULL , 
		  "STATISTIC_TYPE" CHAR(1) NOT NULL , 
		  "MONITOR_START" {3} NOT NULL , 
		  "MONITOR_END" {3} NOT NULL , 
		  "TRANSMITTED" {0} NOT NULL , 
		  "RECEIVED" {0} NOT NULL , 
		  "DAMAGED" {0} NOT NULL , 
		  "MIN_TRANSIT_TIME" {0} NOT NULL , 
		  "MAX_TRANSIT_TIME" {0} NOT NULL , 
		  "AVG_TRANSIT_TIME" DECIMAL(13,0) NOT NULL )   {22}
; 
-- DDL Statements for indexes on Table "T_STAT_PING_HIST"

CREATE INDEX "T_PING_HIST_IX" ON "T_STAT_PING_HIST" 
		("COMPUTER_ID" ASC,
		 "STATISTIC_TYPE" ASC)
;




------------------------------------------------
-- DDL Statements for table "T_STAT_COMP_HIST"
------------------------------------------------
 
 CREATE TABLE "T_STAT_COMP_HIST"  (
		  "COMPUTER_ID" {0} NOT NULL , 
		  "STATISTIC_TYPE" CHAR(1) NOT NULL , 
		  "MONITOR_START" {3} NOT NULL , 
		  "MONITOR_END" {3} NOT NULL , 
		  "POWER_CYCLES" {0} NOT NULL , 
		  "DOWN_TIME" {0} NOT NULL )   {22}
; 
-- DDL Statements for indexes on Table "T_STAT_COMP_HIST"

CREATE INDEX "T_COMP_HIST_IX" ON "T_STAT_COMP_HIST" 
		("COMPUTER_ID" ASC,
		 "STATISTIC_TYPE" ASC)
;

------------------------------------------------
-- DDL Statements for table "T_STAT_SPACE_HIST"
------------------------------------------------
 
 CREATE TABLE "T_STAT_SPACE_HIST"  (
		  "FILESYSTEM_ID" {0} NOT NULL , 
		  "STATISTIC_ID" {0} NOT NULL , 
		  "STATISTIC_TYPE" CHAR(1) NOT NULL , 
		  "STATISTIC_TIME" {3} NOT NULL , 
		  "ACCUM_COUNT" {1} NOT NULL , 
		  "FILE_COUNT" DECIMAL(18,0) NOT NULL , 
		  "TOTAL_SIZE" DECIMAL(18,0) NOT NULL )   {22}
; 
-- DDL Statements for indexes on Table "T_STAT_SPACE_HIST"

CREATE INDEX "T_STAT_SP_HIST_IX" ON "T_STAT_SPACE_HIST" 
		("FILESYSTEM_ID" ASC,
		 "STATISTIC_ID" ASC,
		 "STATISTIC_TYPE" ASC)
;




------------------------------------------------
-- DDL Statements for table "T_STAT_FS_HIST"
------------------------------------------------
 
 CREATE TABLE "T_STAT_FS_HIST"  (
		  "FILESYSTEM_ID" {0} NOT NULL , 
		  "STATISTIC_TYPE" CHAR(1) NOT NULL , 
		  "STATISTIC_TIME" {3} NOT NULL , 
		  "ACCUM_COUNT" {1} NOT NULL , 
		  "FILE_COUNT" DECIMAL(18,0) NOT NULL , 
		  "CAPACITY" DECIMAL(18,0) NOT NULL , 
		  "FREE_SPACE" DECIMAL(18,0) NOT NULL , 
		  "PRODUCT_ID" {0} NOT NULL WITH DEFAULT 1 , 
		  "USED_SPACE" DECIMAL(18,0) NOT NULL WITH DEFAULT 0 )   {22}
; 
-- DDL Statements for indexes on Table "T_STAT_FS_HIST"

CREATE INDEX "T_STAT_FS_HIST_IX" ON "T_STAT_FS_HIST" 
		("FILESYSTEM_ID" ASC,
		 "STATISTIC_TYPE" ASC)
;


------------------------------------------------
-- DDL Statements for table "T_REPORT_PREFS"
------------------------------------------------
 
 CREATE TABLE "T_REPORT_PREFS"  (
		  "TRELLISOFT_USER" VARCHAR(32) NOT NULL , 
		  "REPORT_TYPE" {0} NOT NULL , 
		  "PROFILE_ID" {0} NOT NULL , 
		  "FS_MAX_ROWS" {0} NOT NULL , 
		  "FS_GRP_MAX_ROWS" {0} NOT NULL , 
		  "DIR_MAX_ROWS" {0} NOT NULL , 
		  "DIR_GRP_MAX_ROWS" {0} NOT NULL , 
		  "COMPUTER_MAX_ROWS" {0} NOT NULL , 
		  "COMP_GRP_MAX_ROWS" {0} NOT NULL , 
		  "USER_MAX_ROWS" {0} NOT NULL , 
		  "GROUP_MAX_ROWS" {0} NOT NULL , 
		  "DOMAIN_MAX_ROWS" {0} NOT NULL WITH DEFAULT 2147483647 , 
		  "NETWORK_MAX_ROWS" {0} NOT NULL WITH DEFAULT 2147483647 , 
		  "QUOTA_MAX_ROWS" {0} NOT NULL WITH DEFAULT 2147483647 , 
		  "DATAFILE_MAX_ROWS" {0} NOT NULL WITH DEFAULT 2147483647 , 
		  "TS_MAX_ROWS" {0} NOT NULL WITH DEFAULT 2147483647 , 
		  "TS_GRP_MAX_ROWS" {0} NOT NULL WITH DEFAULT 2147483647 , 
		  "DATABASE_MAX_ROWS" {0} NOT NULL WITH DEFAULT 2147483647 , 
		  "INSTANCE_MAX_ROWS" {0} NOT NULL WITH DEFAULT 2147483647 , 
		  "TB_MAX_ROWS" {0} NOT NULL WITH DEFAULT 2147483647 , 
		  "TB_GRP_MAX_ROWS" {0} NOT NULL WITH DEFAULT 2147483647 )   {22}
; 
-- DDL Statements for indexes on Table "T_REPORT_PREFS"

CREATE UNIQUE INDEX "T_REPORT_PREFS_IX" ON "T_REPORT_PREFS" 
		("TRELLISOFT_USER" ASC,
		 "REPORT_TYPE" ASC)
;




------------------------------------------------
-- DDL Statements for table "T_FOUND_COMPUTER"
------------------------------------------------
 
 CREATE TABLE "T_FOUND_COMPUTER"  (
		  "FOUND_COMPUTER_ID" {0} NOT NULL , 
		  "NAME" VARCHAR(64) NOT NULL , 
		  "DOMAIN_NAME" VARCHAR(128) NOT NULL , 
		  "IP_ADDRESS" VARCHAR(255) NOT NULL , 
		  "OS_TYPE" {1} NOT NULL , 
		  "DISCOVERY_METHOD" {1} NOT NULL , 
		  "NAME_IS_LOCAL" CHAR(1) NOT NULL , 
		  "WHEN_DISCOVERED" {3} NOT NULL , 
		  "TIMES_MISSING" {1} NOT NULL )   {22}
; 



------------------------------------------------
-- DDL Statements for table "T_AGGREGATOR"
------------------------------------------------
 
 CREATE TABLE "T_AGGREGATOR"  (
		  "LAST_WEEKLY" {3} NOT NULL , 
		  "LAST_MONTHLY" {3} NOT NULL )   {22}
; 



------------------------------------------------
-- DDL Statements for table "T_SAVED_REPORT"
------------------------------------------------
 
 CREATE TABLE "T_SAVED_REPORT"  (
		  "REPORT_ID" {0} NOT NULL , 
		  "CREATOR" VARCHAR(32) NOT NULL , 
		  "NAME" VARCHAR(64) NOT NULL , 
		  "DESCRIPTION" VARCHAR(64) NOT NULL , 
		  "LAST_MODIFIED" DECIMAL(13,0) NOT NULL , 
		  "LAST_MOD_USER" VARCHAR(32) NOT NULL , 
		  "DEFINITION" {5} NOT NULL , 
		  "PRODUCT_CODE" CHAR(1) NOT NULL WITH DEFAULT '1' )   {22}
; 
-- DDL Statements for indexes on Table "T_SAVED_REPORT"

CREATE UNIQUE INDEX "T_SAVED_REPORT_IX" ON "T_SAVED_REPORT" 
		("CREATOR" ASC,
		 "NAME" ASC)
;

-- DDL Statements for indexes on Table "T_SAVED_REPORT"

CREATE INDEX "T_SAVED_REPORT_IX2" ON "T_SAVED_REPORT" 
		("REPORT_ID" ASC)
;




------------------------------------------------
-- DDL Statements for table "T_BATCH_REPORT"
------------------------------------------------
 
 CREATE TABLE "T_BATCH_REPORT"  (
		  "REPORT_ID" {0} NOT NULL , 
		  "FILE_MASK" VARCHAR(128) NOT NULL , 
		  "REPORT_TYPE" CHAR(1) NOT NULL , 
		  "SCRIPT_NAME" VARCHAR(64) NOT NULL , 
		  "DEFINITION" {5} NOT NULL , 
		  "HEADERS" CHAR(1) NOT NULL WITH DEFAULT '0' , 
		  "TOTALS" CHAR(1) NOT NULL WITH DEFAULT '0' , 
		  "HISTORY_HEADER" VARCHAR(128) NOT NULL WITH DEFAULT {9} , 
		  "SPACE_UNITS" CHAR(1) NOT NULL WITH DEFAULT '0' )   {22}
; 
-- DDL Statements for indexes on Table "T_BATCH_REPORT"

CREATE INDEX "T_BATCH_REPORT_IX" ON "T_BATCH_REPORT" 
		("REPORT_ID" ASC)
;


------------------------------------------------
-- DDL Statements for table "T_RES_LDAP_TREE"
------------------------------------------------
 
 CREATE TABLE "T_RES_LDAP_TREE"  (
		  "TREE_ID" {0} NOT NULL , 
		  "NAME" VARCHAR(64) NOT NULL , 
		  "COMPUTER_ID" {0} NOT NULL )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_LDAP_TREE"

CREATE UNIQUE INDEX "T_RES_LDAP_TREE_IX" ON "T_RES_LDAP_TREE" 
		("NAME" ASC)
;




------------------------------------------------
-- DDL Statements for table "T_SCRIPT"
------------------------------------------------
 
 CREATE TABLE "T_SCRIPT"  (
		  "SCRIPT_ID" {0} NOT NULL , 
		  "SCRIPT_NAME" VARCHAR(256) NOT NULL )   {22}
; 



------------------------------------------------
-- DDL Statements for table "T_RES_PWD"
------------------------------------------------
 
 CREATE TABLE "T_RES_PWD"  (
		  "RESOURCE_ID" {0} NOT NULL , 
		  "USER_NAME" VARCHAR(64) NOT NULL , 
		  "PWD" VARCHAR(128) NOT NULL )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_PWD"

CREATE UNIQUE INDEX "T_RES_PWD_IX" ON "T_RES_PWD" 
		("RESOURCE_ID" ASC)
;




------------------------------------------------
-- DDL Statements for table "T_SNMP_COMMUNITY"
------------------------------------------------
 
 CREATE TABLE "T_SNMP_COMMUNITY"  (
		  "COMMUNITY_ID" {0} NOT NULL , 
		  "SNMP_COMMUNITY" VARCHAR(64) NOT NULL )   {22}
; 
-- DDL Statements for indexes on Table "T_SNMP_COMMUNITY"

CREATE UNIQUE INDEX "T_SNMP_IX" ON "T_SNMP_COMMUNITY" 
		("SNMP_COMMUNITY" ASC)
;




------------------------------------------------
-- DDL Statements for table "T_FOUND_FILESYSTEM"
------------------------------------------------
 
 CREATE TABLE "T_FOUND_FILESYSTEM"  (
		  "COMPUTER_ID" {0} NOT NULL , 
		  "FILESYSTEM_ID" {0} NOT NULL , 
		  "SCANNING_COMP_ID" {0} NOT NULL , 
		  "MOUNT_POINT" VARCHAR(256) NOT NULL , 
		  "NON_ROOT" CHAR(1) NOT NULL WITH DEFAULT '0' )   {22}
; 
-- DDL Statements for indexes on Table "T_FOUND_FILESYSTEM"

CREATE UNIQUE INDEX "T_FOUND_FS_IX" ON "T_FOUND_FILESYSTEM" 
		("COMPUTER_ID" ASC,
		 "FILESYSTEM_ID" ASC)
;

------------------------------------------------
-- DDL Statements for table "T_RES_DISK_ARRAY"
------------------------------------------------
 
 CREATE TABLE "T_RES_DISK_ARRAY"  (
		  "DISK_ARRAY_ID" {0} NOT NULL , 
		  "MANUFACTURER" VARCHAR(64) NOT NULL , 
		  "MODEL" VARCHAR(128) NOT NULL , 
		  "FIRMWARE_REVISION" VARCHAR(128) NOT NULL , 
		  "CACHE_MB" {0} NOT NULL , 
		  "DISK_CAPACITY" DECIMAL(13,0) NOT NULL , 
		  "DISK_FREE_SPACE" DECIMAL(13,0) NOT NULL , 
		  "N_DISKS" {0} NOT NULL , 
		  "N_LUNS" {0} NOT NULL , 
		  "LUN_CAPACITY" DECIMAL(13,0) NOT NULL , 
		  "LAST_PROBE_TIME" {3} NOT NULL , 
		  "PROBE_STATUS" CHAR(1) NOT NULL , 
		  "GROUP_ID" {0} NOT NULL , 
		  "PROBING_COMP_ID" {0} NOT NULL , 
		  "NVS_MB" {0} NOT NULL WITH DEFAULT 0 , 
		  "VS_CAPACITY" DECIMAL(13,0) NOT NULL WITH DEFAULT -1 , 
		  "VS_FREESPACE" DECIMAL(13,0) NOT NULL WITH DEFAULT -1 , 
		  "DG_FREECAP" DECIMAL(13,0) NOT NULL WITH DEFAULT -1 , 
		  "LGLDISK_ASSIGNED_CAPACITY" DECIMAL(13,0) NOT NULL WITH DEFAULT -1 , 
		  "LUN_CAPACITY_ZOS" DECIMAL(13,0) NOT NULL WITH DEFAULT -1 )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_DISK_ARRAY"

CREATE UNIQUE INDEX "T_RES_DISKARR_IX1" ON "T_RES_DISK_ARRAY" 
		("DISK_ARRAY_ID" ASC)
;




------------------------------------------------
-- DDL Statements for table "T_RES_CIMOM"
------------------------------------------------
 
 CREATE TABLE "T_RES_CIMOM"  (
		  "CIMOM_ID" {0} NOT NULL , 
		  "HOST" VARCHAR(128) NOT NULL , 
		  "PORT" {0} NOT NULL , 
		  "PROTOCOL" CHAR(1) NOT NULL , 
		  "USER_NAME" VARCHAR(128) , 
		  "PASSWORD" VARCHAR(128) , 
		  "CERTIFICATE" VARCHAR(256) , 
		  "INAMESPACE" VARCHAR(256) NOT NULL WITH DEFAULT {9} )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_CIMOM"

CREATE UNIQUE INDEX "T_RES_CIMOM_IX1" ON "T_RES_CIMOM" 
		("HOST" ASC,
		 "PORT" ASC)
;

-- DDL Statements for indexes on Table "T_RES_CIMOM"

CREATE UNIQUE INDEX "T_RES_CIMOM_IX2" ON "T_RES_CIMOM" 
		("CIMOM_ID" ASC)
;


------------------------------------------------
-- DDL Statements for table "T_RES_VOLGROUP"
------------------------------------------------
 
 CREATE TABLE "T_RES_VOLGROUP"  (
		  "VOLGROUP_ID" {0} NOT NULL , 
		  "NAME" VARCHAR(128) , 
		  "COMPUTER_ID" {0} NOT NULL , 
		  "FREESPACE" DECIMAL(13,0) NOT NULL , 
		  "CAPACITY" DECIMAL(13,0) NOT NULL , 
		  "VOLGROUP_TYPE" {1} NOT NULL , 
		  "LSS" CHAR(2) NOT NULL , 
		  "CONFIG" {1} NOT NULL , 
		  "NBRVOLUMES" {0} NOT NULL , 
		  "DISK_GROUP" VARCHAR(10) NOT NULL , 
		  "STATUS" {1} NOT NULL , 
		  "FORMAT" {1} NOT NULL , 
		  "SURF_LUN_CAP" DECIMAL(13,0) NOT NULL , 
		  "UNSURF_LUN_CAP" DECIMAL(13,0) NOT NULL , 
		  "NBRDISKS" {0} NOT NULL WITH DEFAULT -1 , 
		  "DISCOVERED_TIME" {3} , 
		  "LAST_PROBE_TIME" {3} , 
		  "RANK_ID" VARCHAR(256) NOT NULL WITH DEFAULT {9} , 
		  "RAID_ID" VARCHAR(256) NOT NULL WITH DEFAULT {9} )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_VOLGROUP"

CREATE UNIQUE INDEX "T_RES_VOLGROUP_IX" ON "T_RES_VOLGROUP" 
		("VOLGROUP_ID" ASC)
;

-- DDL Statements for indexes on Table "T_RES_VOLGROUP"

CREATE INDEX "T_RES_VOLGROUP_IX2" ON "T_RES_VOLGROUP" 
		("COMPUTER_ID" ASC)
;




------------------------------------------------
-- DDL Statements for table "T_GROUP2RES"
------------------------------------------------
 
 CREATE TABLE "T_GROUP2RES"  (
		  "RESOURCE_ID" {0} NOT NULL , 
		  "GROUP_ID" {0} NOT NULL , 
		  "PARENT_ID" {0} NOT NULL , 
		  "RES_TYPE" {1} NOT NULL , 
		  "RES_INDICATOR" {1} NOT NULL , 
		  "ANCESTORS" VARCHAR(128) NOT NULL )   {22}
; 
-- DDL Statements for indexes on Table "T_GROUP2RES"

CREATE UNIQUE INDEX "T_GROUP2RES_IX1" ON "T_GROUP2RES" 
		("RESOURCE_ID" ASC,
		 "GROUP_ID" ASC,
		 "ANCESTORS" ASC,
		 "RES_INDICATOR" ASC)
;




------------------------------------------------
-- DDL Statements for table "T_GROUP2MASK"
------------------------------------------------
 
 CREATE TABLE "T_GROUP2MASK"  (
		  "GROUP_ID" {0} NOT NULL , 
		  "MASKTYPE" {1} NOT NULL , 
		  "MASK" VARCHAR(128) NOT NULL )   {22}
; 
-- DDL Statements for indexes on Table "T_GROUP2MASK"

CREATE UNIQUE INDEX "T_GROUP2MASK_IX1" ON "T_GROUP2MASK" 
		("GROUP_ID" ASC,
		 "MASK" ASC)
;



------------------------------------------------
-- DDL Statements for table "T_CHART_SETTINGS"
------------------------------------------------
 
 CREATE TABLE "T_CHART_SETTINGS"  (
		  "REPORT_ID" {0} NOT NULL , 
		  "REPORT_SUBTYPE" {0} NOT NULL , 
		  "CHART_ID" {0} NOT NULL , 
		  "CHART_SUBTYPE" {0} NOT NULL , 
		  "BATCH_ID" {0} NOT NULL , 
		  "CHART_TYPE" {1} NOT NULL , 
		  "MAX_CHARTS" {0} NOT NULL , 
		  "MAX_SERIES" {0} NOT NULL , 
		  "TREND_DATA" CHAR(1) NOT NULL , 
		  "HOVER_TEXT" CHAR(1) NOT NULL , 
		  "X_AXIS" {1} NOT NULL , 
		  "CREATOR" VARCHAR(32) NOT NULL , 
		  "TITLE" VARCHAR(96) NOT NULL )   {22}
; 



------------------------------------------------
-- DDL Statements for table "T_RES_LUN_WWN"
------------------------------------------------
 
 CREATE TABLE "T_RES_LUN_WWN"  (
		  "COMPUTER_ID" {0} NOT NULL , 
		  "LUN_ID" {0} NOT NULL , 
		  "WWN" {111} NOT NULL , 
		  "SWWN" VARCHAR(32) NOT NULL , 
		  "HOST" VARCHAR(256) NOT NULL )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_LUN_WWN"

CREATE INDEX "T_RES_LUN_WWN_IX" ON "T_RES_LUN_WWN" 
		("COMPUTER_ID" ASC,
		 "LUN_ID" ASC)
;




------------------------------------------------
-- DDL Statements for table "T_RES_ENTITY_WWPN"
------------------------------------------------
 
 CREATE TABLE "T_RES_ENTITY_WWPN"  (
		  "ENTITY_ID" {0} NOT NULL , 
		  "ENTITY_TYPE" CHAR(1) NOT NULL , 
		  "WWPN" {111} NOT NULL , 
		  "SWWPN" VARCHAR(32) NOT NULL )   {22}
; 



------------------------------------------------
-- DDL Statements for table "T_RES_STOR_EXTENT"
------------------------------------------------
 
 CREATE TABLE "T_RES_STOR_EXTENT"  (
		  "OTHER_NAME" VARCHAR(64) NOT NULL , 
		  "NAME" VARCHAR(32) NOT NULL , 
		  "SIZE_EXTENT" DECIMAL(13,0) NOT NULL , 
		  "STOREXT_ID" {0} NOT NULL , 
		  "STATUS" VARCHAR(32) NOT NULL , 
		  "CONFIG" VARCHAR(32) NOT NULL , 
		  "TYPE" VARCHAR(64) NOT NULL , 
		  "VOLGROUP_ID" {0} NOT NULL , 
		  "ARRAYS" VARCHAR(256) NOT NULL , 
		  "GROUP_ID" VARCHAR(32) NOT NULL , 
		  "COMPUTER_ID" {0} NOT NULL )   {22}
; 



------------------------------------------------
-- DDL Statements for table "T_RES_EXT_CTRLR"
------------------------------------------------
 
 CREATE TABLE "T_RES_EXT_CTRLR"  (
		  "STOREXT_ID" {0} NOT NULL , 
		  "CONTROLLER_ID" {0} NOT NULL )   {22}
; 



------------------------------------------------
-- DDL Statements for table "T_RES_HOST"
------------------------------------------------
 
 CREATE TABLE "T_RES_HOST"  (
		  "GUID" CHAR(47) , 
		  "HOST_URL" VARCHAR(255) , 
		  "OS_TYPE" {1} NOT NULL WITH DEFAULT 0 , 
		  "OS_VERSION" VARCHAR(255) , 
		  "NETWORK_NAME" VARCHAR(255) , 
		  "DOMAIN_NAME" VARCHAR(128) , 
		  "COMPUTER_ID" {0} NOT NULL , 
		  "HOST_NAME" VARCHAR(250) , 
		  "HARDWARE_ID" {2} , 
		  "VENDOR_ID" {1} NOT NULL WITH DEFAULT 0 , 
		  "TIME_ZONE" VARCHAR(64) , 
		  "DISCOVERED_TIME" {3} , 
		  "PRODUCT_STATES" {2} NOT NULL WITH DEFAULT {19} , 
		  "CPU_ARCHITECTURE" {1} NOT NULL WITH DEFAULT 0 , 
		  "ORIGINAL_ALIAS" VARCHAR(255) NOT NULL WITH DEFAULT {9} , 
		  "IP_ADDRESS" VARCHAR(255) , 
		  "DETECTABLE" {1} , 
		  "OPERATIONAL_STATUS" {0} , 
		  "CONSOLIDATED_STATUS" {1} , 
		  "PROPAGATED_STATUS" {1} , 
		  "CHANGED_TIMESTAMP" {3} , 
		  "UPDATE_TIMESTAMP" {3} , 
		  "USER_ATTRIB1" VARCHAR(255) , 
		  "USER_ATTRIB2" VARCHAR(255) , 
		  "USER_ATTRIB3" VARCHAR(255) )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_HOST"

CREATE INDEX "I_HOST_CHGTSP" ON "T_RES_HOST" 
		("CHANGED_TIMESTAMP" ASC)
;

-- DDL Statements for indexes on Table "T_RES_HOST"

CREATE UNIQUE INDEX "I_HOST_HOSTNAME" ON "T_RES_HOST" 
		("HOST_NAME" ASC)
;


-- DDL Statements for primary key on Table "T_RES_HOST"

ALTER TABLE "T_RES_HOST" 
	ADD PRIMARY KEY
		("COMPUTER_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_HOST_ATTRIBUTE_SNAPSHOT"
------------------------------------------------
 
 CREATE TABLE "T_RES_HOST_ATTRIBUTE_SNAPSHOT"  (
		  "COMPUTER_ID" {0} NOT NULL , 
		  "DETECTABLE" {1} , 
		  "OPERATIONAL_STATUS" {0} )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_HOST_ATTRIBUTE_SNAPSHOT"

ALTER TABLE "T_RES_HOST_ATTRIBUTE_SNAPSHOT" 
	ADD PRIMARY KEY
		("COMPUTER_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_SWITCH"
------------------------------------------------
 
 CREATE TABLE "T_RES_SWITCH"  (
		  "SWITCH_WWN" CHAR(16) NOT NULL , 
		  "SWITCH_ID" {0} NOT NULL , 
		  "VENDOR_ID" {1} NOT NULL WITH DEFAULT 0 , 
		  "MODEL_ID" {1} NOT NULL WITH DEFAULT 0 , 
		  "PARENT_SWITCH_WWN" CHAR(16) , 
		  "SERIAL_NUMBER" VARCHAR(255) , 
		  "DESCRIPTION" VARCHAR(255) , 
		  "CONTACT" VARCHAR(255) , 
		  "LOCATION" VARCHAR(255) , 
		  "IP_ADDRESS" VARCHAR(255) , 
		  "DISPLAY_NAME" VARCHAR(64) , 
		  "LOGICAL_NAME" VARCHAR(255) , 
		  "DOMAIN" VARCHAR(128) , 
		  "MANAGEMENT_ID" VARCHAR(128) , 
		  "MGMT_TEL_ADDR" VARCHAR(255) , 
		  "MGMT_SNMP_ADDR" VARCHAR(255) , 
		  "MGMT_URL_ADDR" VARCHAR(255) , 
		  "VERSION" VARCHAR(255) , 
		  "DETECTABLE" {1} , 
		  "OPERATIONAL_STATUS" {0} , 
		  "CONSOLIDATED_STATUS" {1} , 
		  "PROPAGATED_STATUS" {1} , 
		  "CHANGED_TIMESTAMP" {3} , 
		  "UPDATE_TIMESTAMP" {3} , 
		  "USER_ATTRIB1" VARCHAR(255) , 
		  "USER_ATTRIB2" VARCHAR(255) , 
		  "USER_ATTRIB3" VARCHAR(255) )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_SWITCH"

CREATE INDEX "I_SWITCH_CHGTSP" ON "T_RES_SWITCH" 
		("CHANGED_TIMESTAMP" ASC)
;

-- DDL Statements for indexes on Table "T_RES_SWITCH"

CREATE UNIQUE INDEX "I_SWITCH_SWITCHID" ON "T_RES_SWITCH" 
		("SWITCH_ID" ASC)
;


-- DDL Statements for primary key on Table "T_RES_SWITCH"

ALTER TABLE "T_RES_SWITCH" 
	ADD PRIMARY KEY
		("SWITCH_WWN")
;



------------------------------------------------
-- DDL Statements for table "T_RES_SWITCH_ATTRIBUTE_SNAPSHOT"
------------------------------------------------
 
 CREATE TABLE "T_RES_SWITCH_ATTRIBUTE_SNAPSHOT"  (
		  "SWITCH_WWN" CHAR(16) NOT NULL , 
		  "VERSION" VARCHAR(255) , 
		  "DETECTABLE" {1} , 
		  "OPERATIONAL_STATUS" {0} )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_SWITCH_ATTRIBUTE_SNAPSHOT"

ALTER TABLE "T_RES_SWITCH_ATTRIBUTE_SNAPSHOT" 
	ADD PRIMARY KEY
		("SWITCH_WWN")
;



------------------------------------------------
-- DDL Statements for table "T_RES_HBA"
------------------------------------------------
 
 CREATE TABLE "T_RES_HBA"  (
		  "VENDOR_ID" {1} NOT NULL WITH DEFAULT 0 , 
		  "MODEL_ID" {1} NOT NULL WITH DEFAULT 0 , 
		  "API_VERSION" {1} , 
		  "HBA_WWN" CHAR(16) NOT NULL , 
		  "HBA_ID" {0} NOT NULL , 
		  "NAME" VARCHAR(255) NOT NULL , 
		  "SERIAL_NUMBER" VARCHAR(255) , 
		  "DRIVER_VERSION" VARCHAR(255) , 
		  "DRIVER_NAME" VARCHAR(255) , 
		  "ROM_VERSION" VARCHAR(255) , 
		  "HW_VERSION" VARCHAR(255) , 
		  "FIRMWARE_VERSION" VARCHAR(255) , 
		  "HOST_ID" {0} NOT NULL , 
		  "LPAR_ID" {0} , 
		  "IO_ENCLOSURE_ID" {0} , 
		  "DETECTABLE" {1} , 
		  "OPERATIONAL_STATUS" {0} , 
		  "CONSOLIDATED_STATUS" {1} , 
		  "PROPAGATED_STATUS" {1} , 
		  "UPDATE_TIMESTAMP" {3} )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_HBA"

CREATE UNIQUE INDEX "I_HBA_HBAID" ON "T_RES_HBA" 
		("HBA_ID" ASC)
;


-- DDL Statements for primary key on Table "T_RES_HBA"

ALTER TABLE "T_RES_HBA" 
	ADD PRIMARY KEY
		("HBA_WWN",
		 "HOST_ID",
		 "NAME")
;



------------------------------------------------
-- DDL Statements for table "T_RES_HBA_ATTRIBUTE_SNAPSHOT"
------------------------------------------------
 
 CREATE TABLE "T_RES_HBA_ATTRIBUTE_SNAPSHOT"  (
		  "HBA_ID" {0} NOT NULL , 
		  "DRIVER_VERSION" VARCHAR(255) , 
		  "FIRMWARE_VERSION" VARCHAR(255) , 
		  "DETECTABLE" {1} , 
		  "OPERATIONAL_STATUS" {0} )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_HBA_ATTRIBUTE_SNAPSHOT"

ALTER TABLE "T_RES_HBA_ATTRIBUTE_SNAPSHOT" 
	ADD PRIMARY KEY
		("HBA_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_NODE"
------------------------------------------------
 
 CREATE TABLE "T_RES_NODE"  (
		  "SCSI_SUPPORT" {1} NOT NULL WITH DEFAULT 1 , 
		  "NODE_ID" {0} NOT NULL , 
		  "NAME" VARCHAR(255) NOT NULL , 
		  "NAME_FORMAT" {1} NOT NULL , 
		  "OTHER_NAME" VARCHAR(64) , 
		  "PLATFORM_TYPE" {1} NOT NULL WITH DEFAULT 1 , 
		  "RNID_TYPE" {1} NOT NULL WITH DEFAULT 1 , 
		  "SYSTEM_ID" {0} , 
		  "TAPE_LIBRARY_ID" {0} , 
		  "BLADE_ID" {0} , 
		  "DISPLAY_NAME" VARCHAR(64) , 
		  "DISPLAY_ICON_TYPE" {1} , 
		  "MGMT_URL_ADDR" VARCHAR(255) , 
		  "MGMT_TEL_ADDR" VARCHAR(255) , 
		  "MGMT_SNMP_ADDR" VARCHAR(255) , 
		  "DETECTABLE" {1} , 
		  "OPERATIONAL_STATUS" {0} , 
		  "CONSOLIDATED_STATUS" {1} , 
		  "PROPAGATED_STATUS" {1} , 
		  "UPDATE_TIMESTAMP" {3} )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_NODE"

CREATE UNIQUE INDEX "I_NODE_NODEID" ON "T_RES_NODE" 
		("NODE_ID" ASC)
;


-- DDL Statements for primary key on Table "T_RES_NODE"

ALTER TABLE "T_RES_NODE" 
	ADD PRIMARY KEY
		("NAME",
		 "NAME_FORMAT")
;



------------------------------------------------
-- DDL Statements for table "T_RES_NODE_ATTRIBUTE_SNAPSHOT"
------------------------------------------------
 
 CREATE TABLE "T_RES_NODE_ATTRIBUTE_SNAPSHOT"  (
		  "NODE_ID" {0} NOT NULL , 
		  "DETECTABLE" {1} , 
		  "OPERATIONAL_STATUS" {0} )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_NODE_ATTRIBUTE_SNAPSHOT"

ALTER TABLE "T_RES_NODE_ATTRIBUTE_SNAPSHOT" 
	ADD PRIMARY KEY
		("NODE_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_FABRIC"
------------------------------------------------
 
 CREATE TABLE "T_RES_FABRIC"  (
		  "FABRIC_WWN" CHAR(16) NOT NULL , 
		  "FABRIC_ID" {0} NOT NULL , 
		  "SAN_WWN" CHAR(16) , 
		  "SUPPORTS_ZONING" {1} NOT NULL WITH DEFAULT 0 , 
		  "ACTIVE" {1} , 
		  "PARENT_FABRIC_WWN" CHAR(16) , 
		  "IS_PHYSICAL" {1} , 
		  "DISPLAY_NAME" VARCHAR(64) , 
		  "CREATION_CLASS_NAME_ID" {1} , 
		  "DETECTABLE" {1} , 
		  "OPERATIONAL_STATUS" {0} , 
		  "CONSOLIDATED_STATUS" {1} , 
		  "PROPAGATED_STATUS" {1} , 
		  "CHANGED_TIMESTAMP" {3} , 
		  "USER_ATTRIB1" VARCHAR(255) , 
		  "USER_ATTRIB2" VARCHAR(255) , 
		  "USER_ATTRIB3" VARCHAR(255) , 
		  "NAME" CHAR(32) , 
		  "UPDATE_TIMESTAMP" {3} , 
		  "GROUP_ID" {0} NOT NULL WITH DEFAULT 9 )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_FABRIC"

CREATE INDEX "I_FABRIC_CHGTSP" ON "T_RES_FABRIC" 
		("CHANGED_TIMESTAMP" ASC)
;

-- DDL Statements for indexes on Table "T_RES_FABRIC"

CREATE UNIQUE INDEX "I_FABRIC_FABRICID" ON "T_RES_FABRIC" 
		("FABRIC_ID" ASC)
;


-- DDL Statements for primary key on Table "T_RES_FABRIC"

ALTER TABLE "T_RES_FABRIC" 
	ADD PRIMARY KEY
		("FABRIC_WWN")
;



------------------------------------------------
-- DDL Statements for table "T_RES_FABRIC_ATTRIBUTE_SNAPSHOT"
------------------------------------------------
 
 CREATE TABLE "T_RES_FABRIC_ATTRIBUTE_SNAPSHOT"  (
		  "FABRIC_WWN" CHAR(16) NOT NULL , 
		  "ACTIVE" {1} , 
		  "DETECTABLE" {1} , 
		  "OPERATIONAL_STATUS" {0} )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_FABRIC_ATTRIBUTE_SNAPSHOT"

ALTER TABLE "T_RES_FABRIC_ATTRIBUTE_SNAPSHOT" 
	ADD PRIMARY KEY
		("FABRIC_WWN")
;



------------------------------------------------
-- DDL Statements for table "T_RES_ZONE"
------------------------------------------------
 
 CREATE TABLE "T_RES_ZONE"  (
		  "ZONE_ID" {0} NOT NULL , 
		  "FABRIC_WWN" CHAR(16) NOT NULL , 
		  "ZONE_TYPE" {1} NOT NULL WITH DEFAULT 1 , 
		  "ACTIVE" {1} NOT NULL WITH DEFAULT 0 , 
		  "ZONE_NAME" VARCHAR(255) NOT NULL , 
		  "ZONE_SUBTYPE" {1} , 
		  "VENDOR_TYPE" {1} , 
		  "VENDOR_SUBTYPE" {1} , 
		  "DESCRIPTION" VARCHAR(255) )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_ZONE"

CREATE INDEX "I_ZONE_ZNAME" ON "T_RES_ZONE" 
		("ZONE_NAME" ASC)
;

-- DDL Statements for indexes on Table "T_RES_ZONE"

CREATE UNIQUE INDEX "I_ZONE_ZONEID" ON "T_RES_ZONE" 
		("ZONE_ID" ASC)
;


-- DDL Statements for primary key on Table "T_RES_ZONE"

ALTER TABLE "T_RES_ZONE" 
	ADD PRIMARY KEY
		("FABRIC_WWN",
		 "ZONE_NAME",
		 "ACTIVE")
;



------------------------------------------------
-- DDL Statements for table "T_RES_ZONE_ATTRIBUTE_SNAPSHOT"
------------------------------------------------
 
 CREATE TABLE "T_RES_ZONE_ATTRIBUTE_SNAPSHOT"  (
		  "ZONE_ID" {0} NOT NULL , 
		  "ACTIVE" {1} )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_ZONE_ATTRIBUTE_SNAPSHOT"

ALTER TABLE "T_RES_ZONE_ATTRIBUTE_SNAPSHOT" 
	ADD PRIMARY KEY
		("ZONE_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_ZONE_MEMBER"
------------------------------------------------
 
 CREATE TABLE "T_RES_ZONE_MEMBER"  (
		  "ZONE_MEMBER_ID" {0} NOT NULL , 
		  "MEMBER_NAME" VARCHAR(255) NOT NULL , 
		  "TYPE" {1} NOT NULL WITH DEFAULT 0 , 
		  "VENDOR_TYPE" {1} NOT NULL WITH DEFAULT 0 , 
		  "DESCRIPTION" VARCHAR(255) )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_ZONE_MEMBER"

CREATE UNIQUE INDEX "I_ZMEM_ZMEMID" ON "T_RES_ZONE_MEMBER" 
		("ZONE_MEMBER_ID" ASC)
;


-- DDL Statements for primary key on Table "T_RES_ZONE_MEMBER"

ALTER TABLE "T_RES_ZONE_MEMBER" 
	ADD PRIMARY KEY
		("MEMBER_NAME")
;



------------------------------------------------
-- DDL Statements for table "T_RES_ZSET"
------------------------------------------------
 
 CREATE TABLE "T_RES_ZSET"  (
		  "ZSET_ID" {0} NOT NULL , 
		  "FABRIC_WWN" CHAR(16) NOT NULL , 
		  "ACTIVE" {1} NOT NULL WITH DEFAULT 0 , 
		  "DESCRIPTION" VARCHAR(255) , 
		  "ZSET_NAME" VARCHAR(237) NOT NULL )   {22}
; 

-- DDL Statements for indexes on Table "T_RES_ZSET"

CREATE UNIQUE INDEX "I_ZSET_ZSETID" ON "T_RES_ZSET" 
		("ZSET_ID" ASC)
;

-- DDL Statements for indexes on Table "T_RES_ZSET"

CREATE INDEX "I_ZSET_ZSETNAME" ON "T_RES_ZSET" 
		("ZSET_NAME" ASC)
;


-- DDL Statements for primary key on Table "T_RES_ZSET"

ALTER TABLE "T_RES_ZSET" 
	ADD PRIMARY KEY
		("FABRIC_WWN",
		 "ZSET_NAME",
		 "ACTIVE")
;



------------------------------------------------
-- DDL Statements for table "T_RES_ZSET_ATTRIBUTE_SNAPSHOT"
------------------------------------------------
 
 CREATE TABLE "T_RES_ZSET_ATTRIBUTE_SNAPSHOT"  (
		  "ZSET_ID" {0} NOT NULL , 
		  "ACTIVE" {1} )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_ZSET_ATTRIBUTE_SNAPSHOT"

ALTER TABLE "T_RES_ZSET_ATTRIBUTE_SNAPSHOT" 
	ADD PRIMARY KEY
		("ZSET_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_PHY_PE"
------------------------------------------------
 
 CREATE TABLE "T_RES_PHY_PE"  (
		  "PHY_PE_ID" {0} NOT NULL , 
		  "PE_NAME" VARCHAR(255) NOT NULL , 
		  "SERIAL_NUMBER" VARCHAR(255) , 
		  "VENDOR_ID" {1} NOT NULL WITH DEFAULT 0 , 
		  "MODEL_ID" {1} NOT NULL WITH DEFAULT 0 , 
		  "FIRMWARE_REVISION" VARCHAR(12) , 
		  "MGMT_TEL_ADDR" VARCHAR(255) , 
		  "MGMT_SNMP_ADDR" VARCHAR(255) , 
		  "MGMT_URL_ADDR" VARCHAR(255) , 
		  "SCSI_TYPE" {1} , 
		  "PLATFORM_TYPE" {1} NOT NULL WITH DEFAULT 1 , 
		  "RNID_TYPE" {1} NOT NULL WITH DEFAULT 1 , 
		  "SCSI_SUPPORT" {1} NOT NULL WITH DEFAULT 1 , 
		  "DISPLAY_NAME" VARCHAR(64) , 
		  "UPDATE_TIMESTAMP" {3} , 
		  "DETECTABLE" {1} )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_PHY_PE"

CREATE UNIQUE INDEX "I_PE_PEID" ON "T_RES_PHY_PE" 
		("PHY_PE_ID" ASC)
;

-- DDL Statements for indexes on Table "T_RES_PHY_PE"

CREATE INDEX "I_PE_SERNO" ON "T_RES_PHY_PE" 
		("SERIAL_NUMBER" ASC)
;


-- DDL Statements for primary key on Table "T_RES_PHY_PE"

ALTER TABLE "T_RES_PHY_PE" 
	ADD PRIMARY KEY
		("PE_NAME")
;



------------------------------------------------
-- DDL Statements for table "T_RES_PHY_PE_ATTRIBUTE_SNAPSHOT"
------------------------------------------------
 
 CREATE TABLE "T_RES_PHY_PE_ATTRIBUTE_SNAPSHOT"  (
		  "PHY_PE_ID" {0} NOT NULL , 
		  "DETECTABLE" {1} , 
		  "FIRMWARE_REVISION" VARCHAR(12) )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_PHY_PE_ATTRIBUTE_SNAPSHOT"

ALTER TABLE "T_RES_PHY_PE_ATTRIBUTE_SNAPSHOT" 
	ADD PRIMARY KEY
		("PHY_PE_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_TOKEN"
------------------------------------------------
 
 CREATE TABLE "T_RES_TOKEN"  (
		  "TOKEN_ID" {0} NOT NULL , 
		  "TSTAMP" {3} NOT NULL WITH DEFAULT {8}  , 
		  "RES_TYPE" CHAR(5) NOT NULL , 
		  "RES_ID" VARCHAR(255) NOT NULL )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_TOKEN"

CREATE UNIQUE INDEX "I_TOKEN_TOKENID" ON "T_RES_TOKEN" 
		("TOKEN_ID" ASC)
;


-- DDL Statements for primary key on Table "T_RES_TOKEN"

ALTER TABLE "T_RES_TOKEN" 
	ADD PRIMARY KEY
		("RES_TYPE",
		 "RES_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_ALIAS"
------------------------------------------------
 
 CREATE TABLE "T_RES_ALIAS"  (
		  "ALIAS_ID" {0} NOT NULL , 
		  "FABRIC_WWN" CHAR(16) NOT NULL , 
		  "ALIAS_NAME" VARCHAR(255) NOT NULL , 
		  "DESCRIPTION" VARCHAR(255) )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_ALIAS"

CREATE UNIQUE INDEX "I_ALIAS_ALIASID" ON "T_RES_ALIAS" 
		("ALIAS_ID" ASC)
;

-- DDL Statements for indexes on Table "T_RES_ALIAS"

CREATE INDEX "I_ALIAS_ALIASNAME" ON "T_RES_ALIAS" 
		("ALIAS_NAME" ASC)
;


-- DDL Statements for primary key on Table "T_RES_ALIAS"

ALTER TABLE "T_RES_ALIAS" 
	ADD PRIMARY KEY
		("FABRIC_WWN",
		 "ALIAS_NAME")
;



------------------------------------------------
-- DDL Statements for table "T_RES_STORAGE_SUBSYSTEM"
------------------------------------------------
 
 CREATE TABLE "T_RES_STORAGE_SUBSYSTEM"  (
		  "SUBSYSTEM_ID" {0} NOT NULL , 
		  "ALLOCATED_CAPACITY" {111} , 
		  "AVAILABLE_CAPACITY" {111} , 
		  "BACKEND_STORAGE_CAPACITY" {111} , 
		  "VENDOR_ID" {1} NOT NULL WITH DEFAULT 0 , 
		  "MODEL_ID" {1} NOT NULL WITH DEFAULT 0 , 
		  "NAME" VARCHAR(255) NOT NULL , 
		  "NAME_FORMAT" {1} NOT NULL , 
		  "CACHE" {111} , 
		  "NVS" {111} , 
		  "DG_FREESPACE" {111} , 
		  "N_DISKS" {0} , 
		  "N_LUNS" {0} , 
		  "LAST_PROBE_TIME" {3} , 
		  "PROBE_STATUS" CHAR(5) , 
		  "GROUP_ID" {0} NOT NULL WITH DEFAULT 8 , 
		  "PROBING_HOST_ID" {0} , 
		  "VG_CAPACITY" {111} , 
		  "VG_FREESPACE" {111} , 
		  "OS_TYPE" {1} , 
		  "PRODUCT_STATES" VARCHAR(20) , 
		  "TYPE" VARCHAR(255) , 
		  "IP_ADDRESS" VARCHAR(255) , 
		  "CODE_LEVEL" VARCHAR(255) , 
		  "SERIAL_NUMBER" VARCHAR(255) , 
		  "PHYSICAL_PACKAGE_ID" {0} , 
		  "LGLDISK_ASSIGNED_CAPACITY" DECIMAL(13,0) NOT NULL WITH DEFAULT -1 , 
		  "LUN_CAPACITY_ZOS" DECIMAL(13,0) NOT NULL WITH DEFAULT -1 , 
		  "DISPLAY_NAME" VARCHAR(128) , 
		  "DETECTABLE" {1} , 
		  "OPERATIONAL_STATUS" {0} , 
		  "CONSOLIDATED_STATUS" {1} , 
		  "PROPAGATED_STATUS" {1} , 
		  "USER_ATTRIB1" VARCHAR(255) , 
		  "USER_ATTRIB2" VARCHAR(255) , 
		  "USER_ATTRIB3" VARCHAR(255) , 
		  "CHANGED_TIMESTAMP" {3} , 
		  "ACCESS_INFO" VARCHAR(255) , 
		  "USER_PROVIDED_NAME" VARCHAR(255) , 
		  "USER_PROVIDED_LOCATION" VARCHAR(255) , 
		  "COLLECTION_STATUS" {0} , 
		  "UPDATE_TIMESTAMP" {3} , 
		  "TIME_ZONE" VARCHAR(64) )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_STORAGE_SUBSYSTEM"

CREATE INDEX "I_SS_CHGTSP" ON "T_RES_STORAGE_SUBSYSTEM" 
		("CHANGED_TIMESTAMP" ASC)
;

-- DDL Statements for indexes on Table "T_RES_STORAGE_SUBSYSTEM"

CREATE INDEX "I_SS_SERNO" ON "T_RES_STORAGE_SUBSYSTEM" 
		("SERIAL_NUMBER" ASC)
;

-- DDL Statements for indexes on Table "T_RES_STORAGE_SUBSYSTEM"

CREATE UNIQUE INDEX "I_SS_SSID" ON "T_RES_STORAGE_SUBSYSTEM" 
		("SUBSYSTEM_ID" ASC)
;


-- DDL Statements for primary key on Table "T_RES_STORAGE_SUBSYSTEM"

ALTER TABLE "T_RES_STORAGE_SUBSYSTEM" 
	ADD PRIMARY KEY
		("NAME",
		 "NAME_FORMAT")
;



------------------------------------------------
-- DDL Statements for table "T_RES_STORAGE_SUBSYSTEM_ATTRIBUTE_SNAPSHOT"
------------------------------------------------
 
 CREATE TABLE "T_RES_STORAGE_SUBSYSTEM_ATTRIBUTE_SNAPSHOT"  (
		  "SUBSYSTEM_ID" {0} NOT NULL , 
		  "CACHE" {111} , 
		  "CODE_LEVEL" VARCHAR(255) , 
		  "ALLOCATED_CAPACITY" {111} , 
		  "AVAILABLE_CAPACITY" {111} , 
		  "BACKEND_STORAGE_CAPACITY" {111} , 
		  "DETECTABLE" {1} , 
		  "OPERATIONAL_STATUS" {0} )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_STORAGE_SUBSYSTEM_ATTRIBUTE_SNAPSHOT"

ALTER TABLE "T_RES_STORAGE_SUBSYSTEM_ATTRIBUTE_SNAPSHOT" 
	ADD PRIMARY KEY
		("SUBSYSTEM_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_STORAGE_VOLUME"
------------------------------------------------
 
 CREATE TABLE "T_RES_STORAGE_VOLUME"  (
		  "SVID" {0} NOT NULL , 
		  "CAPACITY" {111} , 
		  "PACKAGE_REDUNDANCY" {1} , 
		  "DATA_REDUNDANCY" {1} , 
		  "SIZE_ALLOCATED" REAL , 
		  "BLOCK_SIZE" {111} , 
		  "CONSUMABLE_BLOCKS" {111} , 
		  "NATIVE_STATUS" {1} , 
		  "NUMBER_OF_BLOCKS" {111} , 
		  "THROTTLE" {111} , 
		  "VDISK_TYPE" {1} , 
		  "NAME" VARCHAR(255) NOT NULL , 
		  "NAME_FORMAT" {1} NOT NULL , 
		  "SUBSYSTEM_ID" {0} NOT NULL , 
		  "POOL_ID" {0} , 
		  "LOGICAL_DISK_TYPE" CHAR(5) , 
		  "MIRROR_COUNT" {1} , 
		  "IS_SWAP" CHAR(5) , 
		  "USE_COUNT" {1} , 
		  "SNAP_SOURCE_ID" {0} WITH DEFAULT -1 , 
		  "IS_VCMDB" CHAR(5) WITH DEFAULT '0' , 
		  "REPLICATION_MODE" CHAR(5) WITH DEFAULT '0' , 
		  "NOT_EXPOSED" CHAR(5) , 
		  "OVERHEAD" {111} , 
		  "LUN_IDENTITY" CHAR(5) NOT NULL WITH DEFAULT '0' , 
		  "LSS" {0} , 
		  "SERIAL_NUMBER" VARCHAR(255) , 
		  "DISPLAY_NAME" VARCHAR(128) , 
		  "VCID" {0} , 
		  "DETECTABLE" {1} , 
		  "OPERATIONAL_STATUS" {0} , 
		  "CONSOLIDATED_STATUS" {1} , 
		  "USER_ATTRIB1" VARCHAR(255) , 
		  "USER_ATTRIB2" VARCHAR(255) , 
		  "USER_ATTRIB3" VARCHAR(255) , 
		  "UPDATE_TIMESTAMP" {3} , 
		  "UNDERLYING_REDUNDANCY" {1} , 
		  "DELTA_RESERVATION" {0} , 
		  "IO_GROUP_ID" {0} , 
		  "REDUNDANCY" {1} , 
		  "LOGICAL_CAPACITY" {111} , 
		  "LOGICAL_FREE" {111} , 
		  "FORMAT" {1} , 
		  "IS_ASSIGNED" {1} , 
		  "FLASH_COPY_ID" VARCHAR(64) , 
		  "FLASH_COPY_NAME" VARCHAR(64) , 
		  "METRO_MIRROR_ID" VARCHAR(64) , 
		  "METRO_MIRROR_NAME" VARCHAR(64) , 
		  "FAST_WRITE_STATE" {0} , 
		  "PREFERRED_NODE" VARCHAR(64) , 
		  "UNIQUE_ID" VARCHAR(255) , 
		  "MDISK_ID" {0} , 
		  "IS_FORMATTED" {1} , 
		  "ELEMENT_NAME" VARCHAR(255) , 
		  "NO_SINGLE_PT_FAILURE" {1} , 
		  "VOLUME_NUMBER" {1} )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_STORAGE_VOLUME"

CREATE UNIQUE INDEX "I_SV_SVID" ON "T_RES_STORAGE_VOLUME" 
		("SVID" ASC)
;


-- DDL Statements for primary key on Table "T_RES_STORAGE_VOLUME"

ALTER TABLE "T_RES_STORAGE_VOLUME" 
	ADD PRIMARY KEY
		("NAME",
		 "NAME_FORMAT",
		 "SUBSYSTEM_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_STORAGE_VOLUME_ATTRIBUTE_SNAPSHOT"
------------------------------------------------
 
 CREATE TABLE "T_RES_STORAGE_VOLUME_ATTRIBUTE_SNAPSHOT"  (
		  "SVID" {0} NOT NULL , 
		  "DETECTABLE" {1} , 
		  "OPERATIONAL_STATUS" {0} , 
		  "CAPACITY" {111} )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_STORAGE_VOLUME_ATTRIBUTE_SNAPSHOT"

ALTER TABLE "T_RES_STORAGE_VOLUME_ATTRIBUTE_SNAPSHOT" 
	ADD PRIMARY KEY
		("SVID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_IO_GROUP"
------------------------------------------------
 
 CREATE TABLE "T_RES_IO_GROUP"  (
		  "IO_GROUP_ID" {0} NOT NULL , 
		  "GROUP_ID" VARCHAR(255) , 
		  "NAME" VARCHAR(255) NOT NULL , 
		  "SUBSYSTEM_ID" {0} NOT NULL )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_IO_GROUP"

CREATE UNIQUE INDEX "I_IOG_IOGID" ON "T_RES_IO_GROUP" 
		("IO_GROUP_ID" ASC)
;


-- DDL Statements for primary key on Table "T_RES_IO_GROUP"

ALTER TABLE "T_RES_IO_GROUP" 
	ADD PRIMARY KEY
		("NAME",
		 "SUBSYSTEM_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_STORAGE_POOL"
------------------------------------------------
 
 CREATE TABLE "T_RES_STORAGE_POOL"  (
		  "POOL_ID" {0} NOT NULL , 
		  "TOTAL_MANAGED_SPACE" {111} , 
		  "REMAINING_MANAGED_SPACE" {111} , 
		  "PRIMORDIAL" {1} , 
		  "CAPACITY" DOUBLE , 
		  "EXTENT_SIZE" {0} , 
		  "NATIVE_STATUS" {1} , 
		  "NUMBER_OF_BACKEND_VOLUMES" {0} , 
		  "NUMBER_OF_STORAGE_VOLUMES" {0} , 
		  "TOTAL_AVAILABLE_SPACE" {111} , 
		  "ELEMENT_TYPE" {1} , 
		  "RAID_LEVEL" VARCHAR(32) , 
		  "INSTANCE_ID" VARCHAR(255) NOT NULL , 
		  "SUBSYSTEM_ID" {0} NOT NULL , 
		  "VOL_GROUP_TYPE" {1} , 
		  "LSS" {0} , 
		  "CONFIG" {1} , 
		  "DISK_GROUP_ID" {0} , 
		  "FORMAT" {1} , 
		  "SURFACED_LUN_CAP" {111} , 
		  "UNSURFACED_LUN_CAP" {111} , 
		  "DISCOVERED_TIME" {3} , 
		  "LAST_PROBE_TIME" {3} , 
		  "DETECTABLE" {1} , 
		  "OPERATIONAL_STATUS" {0} , 
		  "CONSOLIDATED_STATUS" {1} , 
		  "PROPAGATED_STATUS" {1} , 
		  "USER_ATTRIB1" VARCHAR(255) , 
		  "USER_ATTRIB2" VARCHAR(255) , 
		  "USER_ATTRIB3" VARCHAR(255) , 
		  "UPDATE_TIMESTAMP" {3} , 
		  "NAME" VARCHAR(255) , 
		  "DATA_REDUNDANCY_MIN" {0} , 
		  "DATA_REDUNDANCY_MAX" {0} , 
		  "DATA_REDUNDANCY_DEF" {0} , 
		  "PCK_REDUNDANCY_MIN" {0} , 
		  "PCK_REDUNDANCY_MAX" {0} , 
		  "PCK_REDUNDANCY_DEF" {0} , 
		  "DELTA_RES_MIN" {0} , 
		  "DELTA_RES_MAX" {0} , 
		  "DELTA_RES_DEF" {0} , 
		  "DISPLAY_NAME" VARCHAR(255) , 
		  "RANK_GROUP" {1} , 
		  "CLASS_NAME_ID" {1} NOT NULL )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_STORAGE_POOL"

CREATE UNIQUE INDEX "I_SP_SPID" ON "T_RES_STORAGE_POOL" 
		("POOL_ID" ASC)
;


-- DDL Statements for primary key on Table "T_RES_STORAGE_POOL"

ALTER TABLE "T_RES_STORAGE_POOL" 
	ADD PRIMARY KEY
		("SUBSYSTEM_ID",
		 "INSTANCE_ID",
		 "CLASS_NAME_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_STORAGE_POOL_ATTRIBUTE_SNAPSHOT"
------------------------------------------------
 
 CREATE TABLE "T_RES_STORAGE_POOL_ATTRIBUTE_SNAPSHOT"  (
		  "POOL_ID" {0} NOT NULL , 
		  "CAPACITY" DOUBLE , 
		  "TOTAL_AVAILABLE_SPACE" {111} , 
		  "DETECTABLE" {1} , 
		  "OPERATIONAL_STATUS" {0} )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_STORAGE_POOL_ATTRIBUTE_SNAPSHOT"

ALTER TABLE "T_RES_STORAGE_POOL_ATTRIBUTE_SNAPSHOT" 
	ADD PRIMARY KEY
		("POOL_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_DISK_GROUP"
------------------------------------------------
 
 CREATE TABLE "T_RES_DISK_GROUP"  (
		  "DISK_GROUP_ID" {0} NOT NULL , 
		  "NAME" VARCHAR(255) , 
		  "DESCRIPTION" VARCHAR(128) , 
		  "RAID_LEVEL" VARCHAR(32) , 
		  "LOOP" VARCHAR(256) , 
		  "ARRAY" VARCHAR(256) , 
		  "SUBSYSTEM_ID" {0} , 
		  "WIDTH" {1} , 
		  "STORAGE_EXTENT_ID" {0} , 
		  "DEVICE_ADAPTER1" VARCHAR(32) , 
		  "DEVICE_ADAPTER2" VARCHAR(32) , 
		  "DA_PAIR_ID" {0} , 
		  "DDM_CAP" DOUBLE , 
		  "DDM_SPEED" VARCHAR(255) , 
		  "UPDATE_TIMESTAMP" {3} , 
		  "TAG" VARCHAR(255) NOT NULL , 
		  "DISK_GROUP_NUMBER" {1} , 
		  "CREATION_CLASS_NAME_ID" {1} )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_DISK_GROUP"

CREATE UNIQUE INDEX "I_DG_DGID" ON "T_RES_DISK_GROUP" 
		("DISK_GROUP_ID" ASC)
;


-- DDL Statements for primary key on Table "T_RES_DISK_GROUP"

ALTER TABLE "T_RES_DISK_GROUP" 
	ADD PRIMARY KEY
		("TAG")
;



------------------------------------------------
-- DDL Statements for table "T_RES_STORAGE_EXTENT"
------------------------------------------------
 
 CREATE TABLE "T_RES_STORAGE_EXTENT"  (
		  "STORAGE_EXTENT_ID" {0} NOT NULL , 
		  "NUM_EXTENTS" {0} , 
		  "EXTENT_TYPE" {0} , 
		  "POOL_ID" {0} , 
		  "TOTAL_CAPACITY" DOUBLE , 
		  "FREE_SPACE" DOUBLE , 
		  "VOLS_IN_STORAGE_EXTENT" {0} , 
		  "NAME" VARCHAR(255) , 
		  "ELEMENT_NAME" VARCHAR(255) , 
		  "OTHER_NAME" VARCHAR(64) , 
		  "RANK_ID" VARCHAR(255) , 
		  "CONFIG" VARCHAR(32) , 
		  "VOL_GROUP_ID" {0} , 
		  "GROUP_ID" VARCHAR(32) , 
		  "DEVICE_ID" VARCHAR(255) NOT NULL , 
		  "CREATION_CLASS_NAME_ID" {1} , 
		  "SYSTEM_CREATION_CLASS_NAME_ID" {1} , 
		  "SYSTEM_NAMES_ID" {1} NOT NULL , 
		  "SUBSYSTEM_ID" {0} NOT NULL , 
		  "BLOCK_SIZE" {0} , 
		  "NUM_OF_BLOCKS" DOUBLE , 
		  "CONSUMABLE_BLOCKS" DOUBLE , 
		  "OPERATIONAL_STATUS" {0} , 
		  "NATIVE_STATUS" {1} , 
		  "MODE" {0} , 
		  "DISPLAY_NAME" VARCHAR(255) , 
		  "UPDATE_TIMESTAMP" {3} , 
		  "BACKEND_CONTROLLER_ID" {0} , 
		  "SERIAL_NUMBER" VARCHAR(255) , 
		  "ARRAY_IDS" VARCHAR(32) , 
		  "REDUNDANCY" {0} )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_STORAGE_EXTENT"

CREATE UNIQUE INDEX "I_SE_SEID" ON "T_RES_STORAGE_EXTENT" 
		("STORAGE_EXTENT_ID" ASC)
;


-- DDL Statements for primary key on Table "T_RES_STORAGE_EXTENT"

ALTER TABLE "T_RES_STORAGE_EXTENT" 
	ADD PRIMARY KEY
		("DEVICE_ID",
		 "SUBSYSTEM_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_PHYSICALVOLUME2EXTENT"
------------------------------------------------
 
 CREATE TABLE "T_RES_PHYSICALVOLUME2EXTENT"  (
		  "PHYSICAL_VOLUME_ID" {0} NOT NULL , 
		  "STORAGE_EXTENT_ID" {0} NOT NULL , 
		  "UPDATE_TIMESTAMP" {3} )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_PHYSICALVOLUME2EXTENT"

ALTER TABLE "T_RES_PHYSICALVOLUME2EXTENT" 
	ADD PRIMARY KEY
		("PHYSICAL_VOLUME_ID",
		 "STORAGE_EXTENT_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_VOLUME2EXTENT"
------------------------------------------------
 
 CREATE TABLE "T_RES_VOLUME2EXTENT"  (
		  "VOLUME_ID" {0} NOT NULL , 
		  "STORAGE_EXTENT_ID" {0} NOT NULL , 
		  "TOTAL_NUM_EXTENTS" {0} , 
		  "UPDATE_TIMESTAMP" {3} )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_VOLUME2EXTENT"

ALTER TABLE "T_RES_VOLUME2EXTENT" 
	ADD PRIMARY KEY
		("VOLUME_ID",
		 "STORAGE_EXTENT_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_PORT"
------------------------------------------------
 
 CREATE TABLE "T_RES_PORT"  (
		  "PORT_ID" {0} NOT NULL , 
		  "NAME" VARCHAR(255) NOT NULL , 
		  "NAME_FORMAT" {1} NOT NULL , 
		  "PORT_NUMBER" VARCHAR(8) , 
		  "TYPE" {1} NOT NULL WITH DEFAULT 1 , 
		  "NODE_ID" {0} , 
		  "DISPLAY_NAME" VARCHAR(64) , 
		  "DISPLAY_ICON_TYPE" {1} , 
		  "RIO_LOOP_ID" {0} , 
		  "DETECTABLE" {1} , 
		  "OPERATIONAL_STATUS" {0} , 
		  "CONSOLIDATED_STATUS" {1} , 
		  "UPDATE_TIMESTAMP" {3} , 
		  "NETWORK_ADDRESSES" VARCHAR(255) , 
		  "PORT_SPEED" {111} , 
		  "FC_PORT_ID" {0} , 
		  "HOST_URL_BY_SUBSYSTEM" VARCHAR(255) , 
		  "SUBSYSTEM_ID" {0} , 
		  "HBA_ID" {0} )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_PORT"

CREATE UNIQUE INDEX "I_PORT_PORTID" ON "T_RES_PORT" 
		("PORT_ID" ASC)
;


-- DDL Statements for primary key on Table "T_RES_PORT"

ALTER TABLE "T_RES_PORT" 
	ADD PRIMARY KEY
		("NAME",
		 "NAME_FORMAT")
;



------------------------------------------------
-- DDL Statements for table "T_RES_DATA_PATH"
------------------------------------------------
 
 CREATE TABLE "T_RES_DATA_PATH"  (
		  "DATA_PATH_ID" {0} NOT NULL , 
		  "HOST_LUN_ID" {0} , 
		  "DEVICE_LUN_ID" {0} , 
		  "INITIATOR_PORT_ID" {0} NOT NULL , 
		  "TARGET_PORT_ID" {0} NOT NULL , 
		  "VOLUME_ID" {0} NOT NULL , 
		  "UNKNOWN_HOST_NAME" VARCHAR(255) , 
		  "UPDATE_TIMESTAMP" {3} , 
		  "MASKING_INFO_ID" {0} , 
		  "SUBSYSTEM_ID" {0} )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_DATA_PATH"

ALTER TABLE "T_RES_DATA_PATH" 
	ADD PRIMARY KEY
		("INITIATOR_PORT_ID",
		 "TARGET_PORT_ID",
		 "VOLUME_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_PHYSICAL_PACKAGE"
------------------------------------------------
 
 CREATE TABLE "T_RES_PHYSICAL_PACKAGE"  (
		  "PACKAGE_ID" {0} NOT NULL , 
		  "REMOVAL_CONDITIONS" {0} , 
		  "REMOVABLE" {1} , 
		  "REPLACEABLE" {1} , 
		  "HOT_SWAPPABLE" {1} , 
		  "HEIGHT" REAL , 
		  "DEPTH" REAL , 
		  "WIDTH" REAL , 
		  "WEIGHT" REAL , 
		  "ELEMENT_NAME" VARCHAR(255) , 
		  "VENDOR_ID" {1} NOT NULL WITH DEFAULT 0 , 
		  "MODEL_ID" {1} NOT NULL WITH DEFAULT 0 , 
		  "OTHER_IDENTIFYING_INFO" VARCHAR(255) , 
		  "POWERED_ON" {1} , 
		  "LOCATION" VARCHAR(255) , 
		  "UPDATE_TIMESTAMP" {3} )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_PHYSICAL_PACKAGE"

ALTER TABLE "T_RES_PHYSICAL_PACKAGE" 
	ADD PRIMARY KEY
		("PACKAGE_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_LPAR"
------------------------------------------------
 
 CREATE TABLE "T_RES_LPAR"  (
		  "LPAR_ID" {0} NOT NULL , 
		  "REDUNDANCY_ID" {0} , 
		  "VIRTUAL_MEMORY" {0} , 
		  "NUM_IO_SLOTS" {0} , 
		  "NUM_PROCS" {0} , 
		  "SUBSYSTEM_ID" {0} , 
		  "STORAGE_FACILITY_ID" {0} , 
		  "UPDATE_TIMESTAMP" {3} )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_LPAR"

ALTER TABLE "T_RES_LPAR" 
	ADD PRIMARY KEY
		("LPAR_ID")
;


------------------------------------------------
-- DDL Statements for table "T_RES_AUTH_ROLES"
------------------------------------------------
 
 CREATE TABLE "T_RES_AUTH_ROLES"  (
		  "ROLE_ID" {0} NOT NULL , 
		  "ROLE_NAME" VARCHAR(255) NOT NULL , 
		  "GROUP_NAME" VARCHAR(255) , 
		  "GROUP_TYPE" {1} )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_AUTH_ROLES"

ALTER TABLE "T_RES_AUTH_ROLES" 
	ADD PRIMARY KEY
		("ROLE_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_REGISTERED_CIMOM"
------------------------------------------------
 
 CREATE TABLE "T_RES_REGISTERED_CIMOM"  (
		  "REG_CIMOM_ID" {0} NOT NULL , 
		  "SERVICE_URL" VARCHAR(255) NOT NULL , 
		  "HI_NAME" VARCHAR(255) , 
		  "DESCRIPTION" VARCHAR(255) , 
		  "SOFTWARE_LEVEL" VARCHAR(128) , 
		  "PROTOCOL_VERSION" VARCHAR(25) , 
		  "AUTHENTICATION_MECHANISM" VARCHAR(25) , 
		  "USER_ID" VARCHAR(128) , 
		  "PASSWORD" VARCHAR(128) , 
		  "TRUST_STORE_LOCATION" VARCHAR(50) , 
		  "TRUST_STORE_PASSPHRASE" VARCHAR(50) , 
		  "INTEROP_SCHEMA_NAMESPACE" VARCHAR(255) , 
		  "PROTOCOL" VARCHAR(25) NOT NULL WITH DEFAULT 'cim#xml' , 
		  "DISPLAY_NAME" VARCHAR(255) , 
		  "STATUS" {1} , 
		  "STATUS_TIMESTAMP" {3} )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_REGISTERED_CIMOM"

CREATE UNIQUE INDEX "I_CIMOM_CIMONID" ON "T_RES_REGISTERED_CIMOM" 
		("REG_CIMOM_ID" ASC)
;


-- DDL Statements for primary key on Table "T_RES_REGISTERED_CIMOM"

ALTER TABLE "T_RES_REGISTERED_CIMOM" 
	ADD PRIMARY KEY
		("SERVICE_URL")
;



------------------------------------------------
-- DDL Statements for table "T_RES_SLP_ATTRIBUTES"
------------------------------------------------
 
 CREATE TABLE "T_RES_SLP_ATTRIBUTES"  (
		  "ATTRIBUTE_NAME" VARCHAR(255) , 
		  "VALUE" VARCHAR(255) , 
		  "REG_CIMOM_ID" {0} )   {22}
; 



------------------------------------------------
-- DDL Statements for table "T_RES_NODE2HBA"
------------------------------------------------
 
 CREATE TABLE "T_RES_NODE2HBA"  (
		  "NODE2HBA_ID" {0} NOT NULL , 
		  "NODE_ID" {0} NOT NULL , 
		  "HBA_ID" {0} NOT NULL , 
		  "UPDATE_TIMESTAMP" {3} , 
		  "DETECTABLE" {1} , 
		  "OPERATIONAL_STATUS" {0} , 
		  "CONSOLIDATED_STATUS" {1} )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_NODE2HBA"

CREATE INDEX "I_N2H_HBAWWN" ON "T_RES_NODE2HBA" 
		("HBA_ID" ASC)
;

-- DDL Statements for indexes on Table "T_RES_NODE2HBA"

CREATE UNIQUE INDEX "I_N2H_N2HID" ON "T_RES_NODE2HBA" 
		("NODE2HBA_ID" ASC)
;

-- DDL Statements for indexes on Table "T_RES_NODE2HBA"

CREATE INDEX "I_N2H_NODEID" ON "T_RES_NODE2HBA" 
		("NODE_ID" ASC)
;


-- DDL Statements for primary key on Table "T_RES_NODE2HBA"

ALTER TABLE "T_RES_NODE2HBA" 
	ADD PRIMARY KEY
		("NODE_ID",
		 "HBA_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_PORT2PORT"
------------------------------------------------
 
 CREATE TABLE "T_RES_PORT2PORT"  (
		  "PORT2PORT_ID" {0} NOT NULL , 
		  "PORT_ID1" {0} NOT NULL , 
		  "PORT_ID2" {0} NOT NULL , 
		  "UPDATE_TIMESTAMP" {3} , 
		  "DETECTABLE" {1} , 
		  "OPERATIONAL_STATUS" {0} , 
		  "CONSOLIDATED_STATUS" {1} )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_PORT2PORT"

CREATE UNIQUE INDEX "I_P2P_P2PID" ON "T_RES_PORT2PORT" 
		("PORT2PORT_ID" ASC)
;

-- DDL Statements for indexes on Table "T_RES_PORT2PORT"

CREATE INDEX "I_P2P_PORTID1" ON "T_RES_PORT2PORT" 
		("PORT_ID1" ASC)
;

-- DDL Statements for indexes on Table "T_RES_PORT2PORT"

CREATE INDEX "I_P2P_PORTID2" ON "T_RES_PORT2PORT" 
		("PORT_ID2" ASC)
;


-- DDL Statements for primary key on Table "T_RES_PORT2PORT"

ALTER TABLE "T_RES_PORT2PORT" 
	ADD PRIMARY KEY
		("PORT_ID1",
		 "PORT_ID2")
;



------------------------------------------------
-- DDL Statements for table "T_RES_FABRIC2SWITCH"
------------------------------------------------
 
 CREATE TABLE "T_RES_FABRIC2SWITCH"  (
		  "FABRIC2SWITCH_ID" {0} NOT NULL , 
		  "FABRIC_WWN" CHAR(16) NOT NULL , 
		  "SWITCH_WWN" CHAR(16) NOT NULL , 
		  "UPDATE_TIMESTAMP" {3} , 
		  "DETECTABLE" {1} , 
		  "OPERATIONAL_STATUS" {0} , 
		  "CONSOLIDATED_STATUS" {1} )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_FABRIC2SWITCH"

CREATE UNIQUE INDEX "I_F2S_F2SID" ON "T_RES_FABRIC2SWITCH" 
		("FABRIC2SWITCH_ID" ASC)
;

-- DDL Statements for indexes on Table "T_RES_FABRIC2SWITCH"

CREATE INDEX "I_F2S_SWITCHWWN" ON "T_RES_FABRIC2SWITCH" 
		("SWITCH_WWN" ASC)
;


-- DDL Statements for primary key on Table "T_RES_FABRIC2SWITCH"

ALTER TABLE "T_RES_FABRIC2SWITCH" 
	ADD PRIMARY KEY
		("FABRIC_WWN",
		 "SWITCH_WWN")
;



------------------------------------------------
-- DDL Statements for table "T_RES_FABRIC2SWITCH_ATTRIBUTE_SNAPSHOT"
------------------------------------------------
 
 CREATE TABLE "T_RES_FABRIC2SWITCH_ATTRIBUTE_SNAPSHOT"  (
		  "FABRIC2SWITCH_ID" {0} NOT NULL , 
		  "DETECTABLE" {1} )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_FABRIC2SWITCH_ATTRIBUTE_SNAPSHOT"

ALTER TABLE "T_RES_FABRIC2SWITCH_ATTRIBUTE_SNAPSHOT" 
	ADD PRIMARY KEY
		("FABRIC2SWITCH_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_ZONE2MEMBER"
------------------------------------------------
 
 CREATE TABLE "T_RES_ZONE2MEMBER"  (
		  "ZONE2MEMBER_ID" {0} NOT NULL , 
		  "ZONE_MEMBER_ID" {0} NOT NULL , 
		  "ZONE_ID" {0} NOT NULL )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_ZONE2MEMBER"

CREATE INDEX "I_Z2M_Z2MID" ON "T_RES_ZONE2MEMBER" 
		("ZONE2MEMBER_ID" ASC)
;

-- DDL Statements for indexes on Table "T_RES_ZONE2MEMBER"

CREATE INDEX "I_Z2M_ZONEID" ON "T_RES_ZONE2MEMBER" 
		("ZONE_ID" ASC)
;


-- DDL Statements for primary key on Table "T_RES_ZONE2MEMBER"

ALTER TABLE "T_RES_ZONE2MEMBER" 
	ADD PRIMARY KEY
		("ZONE_MEMBER_ID",
		 "ZONE_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_ZSET2ZONE"
------------------------------------------------
 
 CREATE TABLE "T_RES_ZSET2ZONE"  (
		  "ZSET2ZONE_ID" {0} NOT NULL , 
		  "ZONE_ID" {0} NOT NULL , 
		  "ZSET_ID" {0} NOT NULL )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_ZSET2ZONE"

CREATE UNIQUE INDEX "I_Z2Z_Z2ZID" ON "T_RES_ZSET2ZONE" 
		("ZSET2ZONE_ID" ASC)
;

-- DDL Statements for indexes on Table "T_RES_ZSET2ZONE"

CREATE INDEX "I_Z2Z_ZSETID" ON "T_RES_ZSET2ZONE" 
		("ZSET_ID" ASC)
;


-- DDL Statements for primary key on Table "T_RES_ZSET2ZONE"

ALTER TABLE "T_RES_ZSET2ZONE" 
	ADD PRIMARY KEY
		("ZONE_ID",
		 "ZSET_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_SWITCH2PORT"
------------------------------------------------
 
 CREATE TABLE "T_RES_SWITCH2PORT"  (
		  "SWITCH2PORT_ID" {0} NOT NULL , 
		  "SWITCH_WWN" CHAR(16) NOT NULL , 
		  "PORT_ID" {0} NOT NULL , 
		  "DETECTABLE" {0} , 
		  "UPDATE_TIMESTAMP" {3} )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_SWITCH2PORT"

CREATE INDEX "I_S2P_PORTID" ON "T_RES_SWITCH2PORT" 
		("PORT_ID" ASC)
;

-- DDL Statements for indexes on Table "T_RES_SWITCH2PORT"

CREATE UNIQUE INDEX "I_S2P_S2PID" ON "T_RES_SWITCH2PORT" 
		("SWITCH2PORT_ID" ASC)
;


-- DDL Statements for primary key on Table "T_RES_SWITCH2PORT"

ALTER TABLE "T_RES_SWITCH2PORT" 
	ADD PRIMARY KEY
		("SWITCH_WWN",
		 "PORT_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_SWITCH2PORT_ATTRIBUTE_SNAPSHOT"
------------------------------------------------
 
 CREATE TABLE "T_RES_SWITCH2PORT_ATTRIBUTE_SNAPSHOT"  (
		  "SWITCH2PORT_ID" {0} NOT NULL , 
		  "DETECTABLE" {1} )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_SWITCH2PORT_ATTRIBUTE_SNAPSHOT"

ALTER TABLE "T_RES_SWITCH2PORT_ATTRIBUTE_SNAPSHOT" 
	ADD PRIMARY KEY
		("SWITCH2PORT_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_PE2NODE"
------------------------------------------------
 
 CREATE TABLE "T_RES_PE2NODE"  (
		  "PE2NODE_ID" {0} NOT NULL , 
		  "PHY_PE_ID" {0} NOT NULL , 
		  "NODE_ID" {0} NOT NULL , 
		  "UPDATE_TIMESTAMP" {3} , 
		  "DETECTABLE" {1} )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_PE2NODE"

CREATE UNIQUE INDEX "I_P2N_P2NID" ON "T_RES_PE2NODE" 
		("PE2NODE_ID" ASC)
;


-- DDL Statements for primary key on Table "T_RES_PE2NODE"

ALTER TABLE "T_RES_PE2NODE" 
	ADD PRIMARY KEY
		("PHY_PE_ID",
		 "NODE_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_PE2NODE_ATTRIBUTE_SNAPSHOT"
------------------------------------------------
 
 CREATE TABLE "T_RES_PE2NODE_ATTRIBUTE_SNAPSHOT"  (
		  "PE2NODE_ID" {0} NOT NULL , 
		  "DETECTABLE" {1} )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_PE2NODE_ATTRIBUTE_SNAPSHOT"

ALTER TABLE "T_RES_PE2NODE_ATTRIBUTE_SNAPSHOT" 
	ADD PRIMARY KEY
		("PE2NODE_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_ZONE2ALIAS"
------------------------------------------------
 
 CREATE TABLE "T_RES_ZONE2ALIAS"  (
		  "ZONE2ALIAS_ID" {0} NOT NULL , 
		  "ZONE_ID" {0} NOT NULL , 
		  "ALIAS_ID" {0} NOT NULL )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_ZONE2ALIAS"

CREATE INDEX "I_Z2A_ALIASID" ON "T_RES_ZONE2ALIAS" 
		("ALIAS_ID" ASC)
;

-- DDL Statements for indexes on Table "T_RES_ZONE2ALIAS"

CREATE UNIQUE INDEX "I_Z2A_Z2AID" ON "T_RES_ZONE2ALIAS" 
		("ZONE2ALIAS_ID" ASC)
;


-- DDL Statements for primary key on Table "T_RES_ZONE2ALIAS"

ALTER TABLE "T_RES_ZONE2ALIAS" 
	ADD PRIMARY KEY
		("ZONE_ID",
		 "ALIAS_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_ALIAS2MEMBER"
------------------------------------------------
 
 CREATE TABLE "T_RES_ALIAS2MEMBER"  (
		  "ALIAS2MEMBER_ID" {0} NOT NULL , 
		  "ALIAS_ID" {0} NOT NULL , 
		  "ZONE_MEMBER_ID" {0} NOT NULL )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_ALIAS2MEMBER"

CREATE UNIQUE INDEX "I_A2M_A2MID" ON "T_RES_ALIAS2MEMBER" 
		("ALIAS2MEMBER_ID" ASC)
;

-- DDL Statements for indexes on Table "T_RES_ALIAS2MEMBER"

CREATE INDEX "I_A2M_ZMID" ON "T_RES_ALIAS2MEMBER" 
		("ZONE_MEMBER_ID" ASC)
;


-- DDL Statements for primary key on Table "T_RES_ALIAS2MEMBER"

ALTER TABLE "T_RES_ALIAS2MEMBER" 
	ADD PRIMARY KEY
		("ALIAS_ID",
		 "ZONE_MEMBER_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_CIMOM2NAMESPACE"
------------------------------------------------
 
 CREATE TABLE "T_RES_CIMOM2NAMESPACE"  (
		  "CIM_NAMESPACE_ID" {0} NOT NULL , 
		  "CIMOM_ID" {0} NOT NULL , 
		  "NAMESPACE" VARCHAR(255) NOT NULL , 
		  "UPDATE_TIMESTAMP" {3} )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_CIMOM2NAMESPACE"

CREATE UNIQUE INDEX "I_C2N_C2NID" ON "T_RES_CIMOM2NAMESPACE" 
		("CIM_NAMESPACE_ID" ASC)
;


-- DDL Statements for primary key on Table "T_RES_CIMOM2NAMESPACE"

ALTER TABLE "T_RES_CIMOM2NAMESPACE" 
	ADD PRIMARY KEY
		("CIMOM_ID",
		 "NAMESPACE")
;



------------------------------------------------
-- DDL Statements for table "T_RES_PHYSICAL_VOLUME"
------------------------------------------------
 
 CREATE TABLE "T_RES_PHYSICAL_VOLUME"  (
		  "PHYSICAL_VOLUME_ID" {0} NOT NULL , 
		  "VENDOR_ID" {1} NOT NULL WITH DEFAULT 0 , 
		  "MODEL_ID" {1} NOT NULL WITH DEFAULT 0 , 
		  "SERIAL_NUMBER" VARCHAR(255) , 
		  "FIRMWARE_REV" VARCHAR(8) , 
		  "MANUFACTURE_DATE" {3} , 
		  "USE_COUNT" {1} , 
		  "DEVICE_TYPE" {1} , 
		  "UNSUPPORTED_MODEL" CHAR(5) , 
		  "FLAGS" {1} , 
		  "REMOVABLE_MEDIUM" CHAR(5) , 
		  "MULTI_PORT" CHAR(5) , 
		  "DISCOVERED_TIME" {3} , 
		  "STORAGE_SYSTEM_TYPE" {1} , 
		  "DISK_GROUP_ID" {0} , 
		  "UPDATE_TIMESTAMP" {3} , 
		  "SYSTEM_CREATION_CLASS_NAME_ID" {1} , 
		  "CREATION_CLASS_NAME_ID" {1} , 
		  "SYSTEM_NAMES_ID" {1} NOT NULL WITH DEFAULT -1 , 
		  "SUBSYSTEM_ID" {0} NOT NULL , 
		  "DEVICE_ID" VARCHAR(255) NOT NULL , 
		  "NAME" VARCHAR(255) , 
		  "TAG" VARCHAR(255) , 
		  "DISPLAY_NAME" VARCHAR(255) , 
		  "CAPACITY" {111} , 
		  "SUBSYSTEM_SERIAL_NUMBER" VARCHAR(255) , 
		  "DETECTABLE" {1} , 
		  "OPERATIONAL_STATUS" {0} , 
		  "CONSOLIDATED_STATUS" {1} )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_PHYSICAL_VOLUME"

CREATE UNIQUE INDEX "I_PHYVOL_PVID" ON "T_RES_PHYSICAL_VOLUME" 
		("PHYSICAL_VOLUME_ID" ASC)
;


-- DDL Statements for primary key on Table "T_RES_PHYSICAL_VOLUME"

ALTER TABLE "T_RES_PHYSICAL_VOLUME" 
	ADD PRIMARY KEY
		("DEVICE_ID",
		 "SYSTEM_NAMES_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_PHYSICAL_VOLUME_ATTRIBUTE_SNAPSHOT"
------------------------------------------------
 
 CREATE TABLE "T_RES_PHYSICAL_VOLUME_ATTRIBUTE_SNAPSHOT"  (
		  "PHYSICAL_VOLUME_ID" {0} NOT NULL , 
		  "DETECTABLE" {1} , 
		  "OPERATIONAL_STATUS" {0} , 
		  "USE_COUNT" {1} )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_PHYSICAL_VOLUME_ATTRIBUTE_SNAPSHOT"

ALTER TABLE "T_RES_PHYSICAL_VOLUME_ATTRIBUTE_SNAPSHOT" 
	ADD PRIMARY KEY
		("PHYSICAL_VOLUME_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_SNMP_TRAP"
------------------------------------------------
 
 CREATE TABLE "T_RES_SNMP_TRAP"  (
		  "SNMP_TRAP_ID" {0} NOT NULL , 
		  "SPECIFIC_TRAP" {1} , 
		  "GENERIC_TRAP" {1} , 
		  "ENTERPRISE_TRAP" VARCHAR(255) )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_SNMP_TRAP"

ALTER TABLE "T_RES_SNMP_TRAP" 
	ADD PRIMARY KEY
		("SNMP_TRAP_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_SNMP_TRAP_OID"
------------------------------------------------
 
 CREATE TABLE "T_RES_SNMP_TRAP_OID"  (
		  "SNMP_TRAP_ID" {0} , 
		  "OBJECT_ID" VARCHAR(255) , 
		  "VALUE" VARCHAR(255) )   {22}
; 



------------------------------------------------
-- DDL Statements for table "T_RES_IP_ADDRESSES"
------------------------------------------------
 
 CREATE TABLE "T_RES_IP_ADDRESSES"  (
		  "OBJECT_ID" {0} NOT NULL , 
		  "OBJECT_TYPE" {1} NOT NULL , 
		  "IP_ADDRESS" VARCHAR(255) NOT NULL )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_IP_ADDRESSES"

ALTER TABLE "T_RES_IP_ADDRESSES" 
	ADD PRIMARY KEY
		("OBJECT_ID",
		 "IP_ADDRESS")
;



------------------------------------------------
-- DDL Statements for table "T_RES_IP_TARGET"
------------------------------------------------
 
 CREATE TABLE "T_RES_IP_TARGET"  (
		  "HOST_NAME" VARCHAR(255) NOT NULL , 
		  "IP_ADDRESS" VARCHAR(255) NOT NULL , 
		  "USER_ID" VARCHAR(64) , 
		  "PASSWORD" VARCHAR(64) , 
		  "READ_COMMUNITY_NAME" VARCHAR(255) NOT NULL WITH DEFAULT 'public' , 
		  "RW_COMMUNITY_NAME" VARCHAR(255) NOT NULL WITH DEFAULT 'private' )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_IP_TARGET"

ALTER TABLE "T_RES_IP_TARGET" 
	ADD PRIMARY KEY
		("IP_ADDRESS")
;



------------------------------------------------
-- DDL Statements for table "T_RES_SCANNER"
------------------------------------------------
 
 CREATE TABLE "T_RES_SCANNER"  (
		  "SCANNER_ID" VARCHAR(54) NOT NULL , 
		  "VERSION" VARCHAR(64) , 
		  "TYPE" CHAR(5) , 
		  "INACTIVE_PROCESSED" {0} NOT NULL WITH DEFAULT 1 , 
		  "PORT" {0} NOT NULL WITH DEFAULT 0 , 
		  "AGENT_NAME" VARCHAR(255) , 
		  "ENABLED" {1} NOT NULL WITH DEFAULT 1 , 
		  "BENCHMARK" {0} NOT NULL WITH DEFAULT -1 )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_SCANNER"

ALTER TABLE "T_RES_SCANNER" 
	ADD PRIMARY KEY
		("SCANNER_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_CIMKEY_HOST"
------------------------------------------------
 
 CREATE TABLE "T_RES_CIMKEY_HOST"  (
		  "HOST_ID" {0} NOT NULL , 
		  "CIM_NAMESPACE_ID" {0} NOT NULL , 
		  "NAME" VARCHAR(255) , 
		  "NAME_FORMAT" {1} , 
		  "CREATION_CLASS_NAME_ID" {1} , 
		  "ACTIVE" {1} WITH DEFAULT NULL )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_CIMKEY_HOST"

ALTER TABLE "T_RES_CIMKEY_HOST" 
	ADD PRIMARY KEY
		("HOST_ID",
		 "CIM_NAMESPACE_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_CIMKEY_SWITCH"
------------------------------------------------
 
 CREATE TABLE "T_RES_CIMKEY_SWITCH"  (
		  "CIMKEY_SWITCH_ID" {0} NOT NULL , 
		  "SWITCH_WWN" CHAR(16) NOT NULL , 
		  "CIM_NAMESPACE_ID" {0} NOT NULL , 
		  "NAME" VARCHAR(255) , 
		  "NAME_FORMAT" {1} , 
		  "CREATION_CLASS_NAME_ID" {1} , 
		  "ACTIVE" {1} WITH DEFAULT NULL )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_CIMKEY_SWITCH"

CREATE UNIQUE INDEX "I_CIMSW_CIMSWID" ON "T_RES_CIMKEY_SWITCH" 
		("CIMKEY_SWITCH_ID" ASC)
;


-- DDL Statements for primary key on Table "T_RES_CIMKEY_SWITCH"

ALTER TABLE "T_RES_CIMKEY_SWITCH" 
	ADD PRIMARY KEY
		("SWITCH_WWN",
		 "CIM_NAMESPACE_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_CIMKEY_SUBSYSTEM"
------------------------------------------------
 
 CREATE TABLE "T_RES_CIMKEY_SUBSYSTEM"  (
		  "CIMKEY_SUBSYSTEM_ID" {0} NOT NULL , 
		  "SUBSYSTEM_ID" {0} NOT NULL , 
		  "CIM_NAMESPACE_ID" {0} NOT NULL , 
		  "NAME" VARCHAR(255) , 
		  "NAME_FORMAT" {1} , 
		  "CREATION_CLASS_NAME_ID" {1} , 
		  "CAPABILITY_DATA_ID" {0} , 
		  "ACTIVE" {1} WITH DEFAULT NULL )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_CIMKEY_SUBSYSTEM"

CREATE UNIQUE INDEX "I_CIMSYS_CIMSYSID" ON "T_RES_CIMKEY_SUBSYSTEM" 
		("CIMKEY_SUBSYSTEM_ID" ASC)
;


-- DDL Statements for primary key on Table "T_RES_CIMKEY_SUBSYSTEM"

ALTER TABLE "T_RES_CIMKEY_SUBSYSTEM" 
	ADD PRIMARY KEY
		("SUBSYSTEM_ID",
		 "CIM_NAMESPACE_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_CIMKEY_TAPE_LIBRARY"
------------------------------------------------
 
 CREATE TABLE "T_RES_CIMKEY_TAPE_LIBRARY"  (
		  "CIMKEY_TAPE_LIBRARY_ID" {0} NOT NULL , 
		  "TAPE_LIBRARY_ID" {0} NOT NULL , 
		  "CIM_NAMESPACE_ID" {0} NOT NULL , 
		  "NAME" VARCHAR(255) , 
		  "NAME_FORMAT" {1} , 
		  "CREATION_CLASS_NAME_ID" {1} , 
		  "CAPABILITY_DATA_ID" {0} , 
		  "ACTIVE" {1} WITH DEFAULT NULL )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_CIMKEY_TAPE_LIBRARY"

CREATE UNIQUE INDEX "I_CTAPE_CTAPEID" ON "T_RES_CIMKEY_TAPE_LIBRARY" 
		("CIMKEY_TAPE_LIBRARY_ID" ASC)
;


-- DDL Statements for primary key on Table "T_RES_CIMKEY_TAPE_LIBRARY"

ALTER TABLE "T_RES_CIMKEY_TAPE_LIBRARY" 
	ADD PRIMARY KEY
		("TAPE_LIBRARY_ID",
		 "CIM_NAMESPACE_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_CIMKEY_PORT"
------------------------------------------------
 
 CREATE TABLE "T_RES_CIMKEY_PORT"  (
		  "CIMKEY_PORT_ID" {0} NOT NULL , 
		  "PORT_ID" {0} NOT NULL , 
		  "CIM_NAMESPACE_ID" {0} NOT NULL , 
		  "SYSTEM_CREATION_CLASS_NAME_ID" {1} , 
		  "SYSTEM_NAMES_ID" {1} , 
		  "CREATION_CLASS_NAME_ID" {1} , 
		  "DEVICE_ID" VARCHAR(255) , 
		  "ACTIVE" {1} WITH DEFAULT NULL , 
		  "UPDATE_TIMESTAMP" {3} )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_CIMKEY_PORT"

CREATE UNIQUE INDEX "I_CIMPRT_CPRTID" ON "T_RES_CIMKEY_PORT" 
		("CIMKEY_PORT_ID" ASC)
;


-- DDL Statements for primary key on Table "T_RES_CIMKEY_PORT"

ALTER TABLE "T_RES_CIMKEY_PORT" 
	ADD PRIMARY KEY
		("PORT_ID",
		 "CIM_NAMESPACE_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_CIMKEY_VOLUME"
------------------------------------------------
 
 CREATE TABLE "T_RES_CIMKEY_VOLUME"  (
		  "VOLUME_ID" {0} NOT NULL , 
		  "CIM_NAMESPACE_ID" {0} NOT NULL , 
		  "SYSTEM_NAMES_ID" {1} , 
		  "CREATION_CLASS_NAME_ID" {1} , 
		  "SYSTEM_CREATION_CLASS_NAME_ID" {1} , 
		  "DEVICE_ID" VARCHAR(255) , 
		  "ACTIVE" {1} WITH DEFAULT NULL , 
		  "UPDATE_TIMESTAMP" {3} )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_CIMKEY_VOLUME"

ALTER TABLE "T_RES_CIMKEY_VOLUME" 
	ADD PRIMARY KEY
		("VOLUME_ID",
		 "CIM_NAMESPACE_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_NAMES_SUBSYSTEM"
------------------------------------------------
 
 CREATE TABLE "T_RES_NAMES_SUBSYSTEM"  (
		  "NAMES_SUBSYSTEM_ID" {0} NOT NULL , 
		  "SUBSYSTEM_ID" {0} NOT NULL , 
		  "NAME" VARCHAR(255) NOT NULL , 
		  "NAME_FORMAT" {1} )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_NAMES_SUBSYSTEM"

ALTER TABLE "T_RES_NAMES_SUBSYSTEM" 
	ADD PRIMARY KEY
		("SUBSYSTEM_ID",
		 "NAME")
;



------------------------------------------------
-- DDL Statements for table "T_RES_SYSTEM_NAMES"
------------------------------------------------
 
 CREATE TABLE "T_RES_SYSTEM_NAMES"  (
		  "SYSTEM_NAMES_ID" {1} NOT NULL , 
		  "SYSTEM_NAME" VARCHAR(255) NOT NULL )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_SYSTEM_NAMES"

ALTER TABLE "T_RES_SYSTEM_NAMES" 
	ADD PRIMARY KEY
		("SYSTEM_NAME")
;



------------------------------------------------
-- DDL Statements for table "T_RES_VENDOR"
------------------------------------------------
 
 CREATE TABLE "T_RES_VENDOR"  (
		  "VENDOR_ID" {1} NOT NULL , 
		  "VENDOR_NAME" VARCHAR(128) NOT NULL , 
		  "VENDOR_DESCRIPTION" VARCHAR(255) )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_VENDOR"

CREATE UNIQUE INDEX "I_VENDOR_VENDORID" ON "T_RES_VENDOR" 
		("VENDOR_ID" ASC)
;


-- DDL Statements for primary key on Table "T_RES_VENDOR"

ALTER TABLE "T_RES_VENDOR" 
	ADD PRIMARY KEY
		("VENDOR_NAME")
;



------------------------------------------------
-- DDL Statements for table "T_RES_MODEL"
------------------------------------------------
 
 CREATE TABLE "T_RES_MODEL"  (
		  "MODEL_ID" {1} NOT NULL , 
		  "MODEL_NAME" VARCHAR(128) NOT NULL , 
		  "MODEL_DESCRIPTION" VARCHAR(255) )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_MODEL"

CREATE UNIQUE INDEX "I_MODEL_MODELID" ON "T_RES_MODEL" 
		("MODEL_ID" ASC)
;


-- DDL Statements for primary key on Table "T_RES_MODEL"

ALTER TABLE "T_RES_MODEL" 
	ADD PRIMARY KEY
		("MODEL_NAME")
;



------------------------------------------------
-- DDL Statements for table "T_RES_CREATION_CLASS_NAME"
------------------------------------------------
 
 CREATE TABLE "T_RES_CREATION_CLASS_NAME"  (
		  "ID" {1} NOT NULL , 
		  "NAME" VARCHAR(255) NOT NULL )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_CREATION_CLASS_NAME"

CREATE UNIQUE INDEX "I_CCN_CCNID" ON "T_RES_CREATION_CLASS_NAME" 
		("ID" ASC)
;


-- DDL Statements for primary key on Table "T_RES_CREATION_CLASS_NAME"

ALTER TABLE "T_RES_CREATION_CLASS_NAME" 
	ADD PRIMARY KEY
		("NAME")
;



------------------------------------------------
-- DDL Statements for table "T_RES_TAPE_LIBRARY"
------------------------------------------------
 
 CREATE TABLE "T_RES_TAPE_LIBRARY"  (
		  "TAPE_LIBRARY_ID" {0} NOT NULL , 
		  "NAME" VARCHAR(255) NOT NULL , 
		  "NAME_FORMAT" {1} NOT NULL , 
		  "CREATION_CLASS_NAME_ID" {1} , 
		  "ELEMENT_NAME" VARCHAR(255) , 
		  "PRIMARY_OWNER_NAME" VARCHAR(255) , 
		  "PRIMARY_OWNER_CONTACT" VARCHAR(255) , 
		  "ACCESS_INFO" VARCHAR(255) , 
		  "FIRMWARE_VERSION" VARCHAR(255) , 
		  "DETECTABLE" {1} , 
		  "OPERATIONAL_STATUS" {0} , 
		  "CONSOLIDATED_STATUS" {1} , 
		  "PROPAGATED_STATUS" {1} , 
		  "CHANGED_TIMESTAMP" {3} , 
		  "DISPLAY_NAME" VARCHAR(255) , 
		  "MAX_CARTRIDGES" {0} , 
		  "DESCRIPTION" VARCHAR(255) , 
		  "COLLECTION_STATUS" {0} , 
		  "GROUP_ID" {0} NOT NULL WITH DEFAULT 241 , 
		  "UPDATE_TIMESTAMP" {3} , 
		  "USER_PROVIDED_NAME" VARCHAR(255) , 
		  "USER_ATTRIB1" VARCHAR(255) , 
		  "USER_ATTRIB2" VARCHAR(255) , 
		  "USER_ATTRIB3" VARCHAR(255) )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_TAPE_LIBRARY"

CREATE INDEX "I_TAPELIB_CHGTSP" ON "T_RES_TAPE_LIBRARY" 
		("CHANGED_TIMESTAMP" ASC)
;

-- DDL Statements for indexes on Table "T_RES_TAPE_LIBRARY"

CREATE UNIQUE INDEX "I_TAPELIB_TLID" ON "T_RES_TAPE_LIBRARY" 
		("TAPE_LIBRARY_ID" ASC)
;


-- DDL Statements for primary key on Table "T_RES_TAPE_LIBRARY"

ALTER TABLE "T_RES_TAPE_LIBRARY" 
	ADD PRIMARY KEY
		("NAME",
		 "NAME_FORMAT")
;



------------------------------------------------
-- DDL Statements for table "T_RES_TAPE_LIBRARY_ATTRIBUTE_SNAPSHOT"
------------------------------------------------
 
 CREATE TABLE "T_RES_TAPE_LIBRARY_ATTRIBUTE_SNAPSHOT"  (
		  "TAPE_LIBRARY_ID" {0} NOT NULL , 
		  "DETECTABLE" {1} , 
		  "OPERATIONAL_STATUS" {0} )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_TAPE_LIBRARY_ATTRIBUTE_SNAPSHOT"

ALTER TABLE "T_RES_TAPE_LIBRARY_ATTRIBUTE_SNAPSHOT" 
	ADD PRIMARY KEY
		("TAPE_LIBRARY_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_TAPE_FRAME"
------------------------------------------------
 
 CREATE TABLE "T_RES_TAPE_FRAME"  (
		  "TAG" VARCHAR(255) NOT NULL , 
		  "CREATION_CLASS_NAME_ID" {1} , 
		  "LOCK_PRESENT" {1} , 
		  "SECURITY_BREACH" {1} , 
		  "IS_LOCKED" {1} , 
		  "ELEMENT_NAME" VARCHAR(255) , 
		  "VENDOR_ID" {1} NOT NULL WITH DEFAULT 0 , 
		  "MODEL_ID" {1} NOT NULL WITH DEFAULT 0 , 
		  "SERIAL_NUMBER" VARCHAR(255) , 
		  "TAPE_LIBRARY_ID" {0} NOT NULL , 
		  "UPDATE_TIMESTAMP" {3} )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_TAPE_FRAME"

ALTER TABLE "T_RES_TAPE_FRAME" 
	ADD PRIMARY KEY
		("TAG")
;



------------------------------------------------
-- DDL Statements for table "T_RES_TAPE_DRIVE"
------------------------------------------------
 
 CREATE TABLE "T_RES_TAPE_DRIVE"  (
		  "TAPE_DRIVE_ID" {0} NOT NULL , 
		  "SYSTEM_CREATION_CLASS_NAME_ID" {1} , 
		  "CREATION_CLASS_NAME_ID" {1} , 
		  "SYSTEM_NAMES_ID" {1} NOT NULL , 
		  "DEVICE_ID" VARCHAR(255) NOT NULL , 
		  "OPERATIONAL_STATUS" {0} , 
		  "NEEDS_CLEANING" {1} , 
		  "MOUNT_COUNT" {111} , 
		  "AVAILABILITY" {1} , 
		  "POWER_ON_HOURS" {111} , 
		  "TOTAL_POWER_ON_HOURS" {111} , 
		  "TAPE_LIBRARY_ID" {0} NOT NULL , 
		  "ELEMENT_NAME" VARCHAR(255) , 
		  "NODE_ID" {0} , 
		  "FIRMWARE_VERSION" VARCHAR(255) , 
		  "LOCATION_ID" {0} , 
		  "UPDATE_TIMESTAMP" {3} , 
		  "CONSOLIDATED_STATUS" {1} , 
		  "DETECTABLE" {1} , 
		  "DISPLAY_NAME" VARCHAR(64) , 
		  "PROPAGATED_STATUS" {1} , 
		  "USER_ATTRIB1" VARCHAR(255) , 
		  "USER_ATTRIB2" VARCHAR(255) , 
		  "USER_ATTRIB3" VARCHAR(255) )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_TAPE_DRIVE"

ALTER TABLE "T_RES_TAPE_DRIVE" 
	ADD PRIMARY KEY
		("TAPE_LIBRARY_ID",
		 "DEVICE_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_TAPE_DRIVE_ATTRIBUTE_SNAPSHOT"
------------------------------------------------
 
 CREATE TABLE "T_RES_TAPE_DRIVE_ATTRIBUTE_SNAPSHOT"  (
		  "TAPE_DRIVE_ID" {0} NOT NULL , 
		  "OPERATIONAL_STATUS" {0} , 
		  "NEEDS_CLEANING" {1} , 
		  "FIRMWARE_VERSION" VARCHAR(255) , 
		  "DETECTABLE" {1} )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_TAPE_DRIVE_ATTRIBUTE_SNAPSHOT"

ALTER TABLE "T_RES_TAPE_DRIVE_ATTRIBUTE_SNAPSHOT" 
	ADD PRIMARY KEY
		("TAPE_DRIVE_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_TAPE_IOPORT"
------------------------------------------------
 
 CREATE TABLE "T_RES_TAPE_IOPORT"  (
		  "SYSTEM_CREATION_CLASS_NAME_ID" {1} , 
		  "CREATION_CLASS_NAME_ID" {1} , 
		  "SYSTEM_NAMES_ID" {1} NOT NULL , 
		  "DEVICE_ID" VARCHAR(255) NOT NULL , 
		  "OPERATIONAL_STATUS" {0} , 
		  "ELEMENT_NAME" VARCHAR(255) , 
		  "TAPE_LIBRARY_ID" {0} NOT NULL , 
		  "EXTENDED" {1} , 
		  "CAPTION" VARCHAR(255) , 
		  "DESCRIPTION" VARCHAR(255) , 
		  "LOCATION_ID" {0} , 
		  "CONSOLIDATED_STATUS" {0} , 
		  "UPDATE_TIMESTAMP" {3} )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_TAPE_IOPORT"

ALTER TABLE "T_RES_TAPE_IOPORT" 
	ADD PRIMARY KEY
		("TAPE_LIBRARY_ID",
		 "DEVICE_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_TAPE_MEDIA_CHANGER"
------------------------------------------------
 
 CREATE TABLE "T_RES_TAPE_MEDIA_CHANGER"  (
		  "TAPE_MEDIA_CHANGER_ID" {0} NOT NULL , 
		  "SYSTEM_CREATION_CLASS_NAME_ID" {1} , 
		  "CREATION_CLASS_NAME_ID" {1} , 
		  "SYSTEM_NAMES_ID" {1} NOT NULL , 
		  "DEVICE_ID" VARCHAR(255) NOT NULL , 
		  "OPERATIONAL_STATUS" {0} , 
		  "ELEMENT_NAME" VARCHAR(255) , 
		  "TAPE_LIBRARY_ID" {0} NOT NULL , 
		  "MEDIA_FLIP_SUPPORTED" {1} , 
		  "CAPTION" VARCHAR(255) , 
		  "DESCRIPTION" VARCHAR(255) , 
		  "NODE_ID" {0} , 
		  "FIRMWARE_VERSION" VARCHAR(255) , 
		  "LOCATION_ID" {0} , 
		  "UPDATE_TIMESTAMP" {3} , 
		  "CONSOLIDATED_STATUS" {1} , 
		  "DETECTABLE" {1} , 
		  "DISPLAY_NAME" VARCHAR(64) , 
		  "PROPAGATED_STATUS" {1} , 
		  "USER_ATTRIB1" VARCHAR(255) , 
		  "USER_ATTRIB2" VARCHAR(255) , 
		  "USER_ATTRIB3" VARCHAR(255) )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_TAPE_MEDIA_CHANGER"

ALTER TABLE "T_RES_TAPE_MEDIA_CHANGER" 
	ADD PRIMARY KEY
		("TAPE_LIBRARY_ID",
		 "DEVICE_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_TAPE_MEDIA_CHANGER_ATTRIBUTE_SNAPSHOT"
------------------------------------------------
 
 CREATE TABLE "T_RES_TAPE_MEDIA_CHANGER_ATTRIBUTE_SNAPSHOT"  (
		  "TAPE_MEDIA_CHANGER_ID" {0} NOT NULL , 
		  "OPERATIONAL_STATUS" {0} , 
		  "FIRMWARE_VERSION" VARCHAR(255) , 
		  "DETECTABLE" {1} )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_TAPE_MEDIA_CHANGER_ATTRIBUTE_SNAPSHOT"

ALTER TABLE "T_RES_TAPE_MEDIA_CHANGER_ATTRIBUTE_SNAPSHOT" 
	ADD PRIMARY KEY
		("TAPE_MEDIA_CHANGER_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_TAPE_CARTRIDGE"
------------------------------------------------
 
 CREATE TABLE "T_RES_TAPE_CARTRIDGE"  (
		  "TAG" VARCHAR(255) NOT NULL , 
		  "CREATION_CLASS_NAME_ID" {1} , 
		  "CAPACITY" {111} , 
		  "MEDIA_TYPE" {1} , 
		  "CLEANER_MEDIA" {1} , 
		  "DUAL_SIDED" {1} , 
		  "PHYSICAL_LABEL" VARCHAR(255) , 
		  "LOCATION_ID" {0} , 
		  "TAPE_LIBRARY_ID" {0} NOT NULL , 
		  "MEDIA_DESCRIPTION" VARCHAR(255) , 
		  "UPDATE_TIMESTAMP" {3} )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_TAPE_CARTRIDGE"

ALTER TABLE "T_RES_TAPE_CARTRIDGE" 
	ADD PRIMARY KEY
		("TAG")
;



------------------------------------------------
-- DDL Statements for table "T_RES_TAPE_MEDIA_LOCATION"
------------------------------------------------
 
 CREATE TABLE "T_RES_TAPE_MEDIA_LOCATION"  (
		  "LOCATION_ID" {0} NOT NULL , 
		  "TAG" VARCHAR(255) NOT NULL , 
		  "CREATION_CLASS_NAME_ID" {1} , 
		  "LOCATION_TYPE" {1} , 
		  "LOCATION_COORDINATES" VARCHAR(255) , 
		  "MEDIA_CAPACITY" {0} , 
		  "TAPE_LIBRARY_ID" {0} NOT NULL , 
		  "UPDATE_TIMESTAMP" {3} )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_TAPE_MEDIA_LOCATION"

CREATE UNIQUE INDEX "I_TAPEML_MLID" ON "T_RES_TAPE_MEDIA_LOCATION" 
		("LOCATION_ID" ASC)
;


-- DDL Statements for primary key on Table "T_RES_TAPE_MEDIA_LOCATION"

ALTER TABLE "T_RES_TAPE_MEDIA_LOCATION" 
	ADD PRIMARY KEY
		("TAG")
;



------------------------------------------------
-- DDL Statements for table "T_RES_REDUNDANCY"
------------------------------------------------
 
 CREATE TABLE "T_RES_REDUNDANCY"  (
		  "REDUNDANCY_ID" {0} NOT NULL , 
		  "SUBSYSTEM_ID" {0} NOT NULL , 
		  "COMPONENT_ID" VARCHAR(255) NOT NULL , 
		  "IP_ADDRESS" VARCHAR(255) , 
		  "NODE_ID" {0} , 
		  "UPDATE_TIMESTAMP" {3} , 
		  "CREATION_CLASS_NAME_ID" {1} , 
		  "NAME" VARCHAR(255) , 
		  "NAME_FORMAT" {1} , 
		  "OPERATIONAL_STATUS" {0} , 
		  "WWN" CHAR(16) , 
		  "DISPLAY_NAME" VARCHAR(255) , 
		  "IO_GROUP_ID" {0} )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_REDUNDANCY"

CREATE UNIQUE INDEX "I_RED_REDID" ON "T_RES_REDUNDANCY" 
		("REDUNDANCY_ID" ASC)
;


-- DDL Statements for primary key on Table "T_RES_REDUNDANCY"

ALTER TABLE "T_RES_REDUNDANCY" 
	ADD PRIMARY KEY
		("SUBSYSTEM_ID",
		 "COMPONENT_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_CONFIG_DATA"
------------------------------------------------
 
 CREATE TABLE "T_RES_CONFIG_DATA"  (
		  "ATTRIBUTE" VARCHAR(255) NOT NULL , 
		  "VALUE" VARCHAR(255) NOT NULL , 
		  "CONTEXT" VARCHAR(32) )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_CONFIG_DATA"

CREATE INDEX "I_CFGDATA_CONTEXT" ON "T_RES_CONFIG_DATA" 
		("CONTEXT" ASC)
;


-- DDL Statements for primary key on Table "T_RES_CONFIG_DATA"

ALTER TABLE "T_RES_CONFIG_DATA" 
	ADD PRIMARY KEY
		("ATTRIBUTE")
;



------------------------------------------------
-- DDL Statements for table "T_RES_OUTBAND_AGENT"
------------------------------------------------
 
 CREATE TABLE "T_RES_OUTBAND_AGENT"  (
		  "OUTBAND_AGENT_ID" {0} NOT NULL , 
		  "HOST_NAME" VARCHAR(255) NOT NULL , 
		  "IP_ADDRESS" VARCHAR(255) NOT NULL , 
		  "USER_ID" VARCHAR(64) , 
		  "PASSWORD" VARCHAR(64) )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_OUTBAND_AGENT"

CREATE UNIQUE INDEX "I_OUTAGE_OAID" ON "T_RES_OUTBAND_AGENT" 
		("OUTBAND_AGENT_ID" ASC)
;


-- DDL Statements for primary key on Table "T_RES_OUTBAND_AGENT"

ALTER TABLE "T_RES_OUTBAND_AGENT" 
	ADD PRIMARY KEY
		("IP_ADDRESS")
;



------------------------------------------------
-- DDL Statements for table "T_RES_DEVICE_AGENT"
------------------------------------------------
 
 CREATE TABLE "T_RES_DEVICE_AGENT"  (
		  "DEVICE_AGENT_ID" {0} NOT NULL , 
		  "PORT" {0} NOT NULL , 
		  "POLICY_DOMAIN_ID" {0} , 
		  "STATUS_LAST_CHANGED" {3} , 
		  "STATUS" CHAR(5) , 
		  "VERSION" VARCHAR(10) , 
		  "HOST_ID" {0} NOT NULL )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_DEVICE_AGENT"

ALTER TABLE "T_RES_DEVICE_AGENT" 
	ADD PRIMARY KEY
		("DEVICE_AGENT_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_SWITCH_BLADE"
------------------------------------------------
 
 CREATE TABLE "T_RES_SWITCH_BLADE"  (
		  "SWITCH_BLADE_ID" {0} NOT NULL , 
		  "VENDOR_ID" {1} NOT NULL WITH DEFAULT 0 , 
		  "SERIAL_NUMBER" VARCHAR(255) NOT NULL , 
		  "SLOT" CHAR(64) , 
		  "SWITCH_BLADE_TYPE_ID" {1} , 
		  "MODEL_ID" {1} NOT NULL WITH DEFAULT 0 , 
		  "SWITCH_WWN" CHAR(16) , 
		  "FIRMWARE_REVISION" CHAR(64) , 
		  "UPDATE_TIMESTAMP" {3} , 
		  "DETECTABLE" {1} , 
		  "OPERATIONAL_STATUS" {0} , 
		  "CONSOLIDATED_STATUS" {1} , 
		  "PROPAGATED_STATUS" {1} )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_SWITCH_BLADE"

CREATE UNIQUE INDEX "I_SWBLADE_SBID" ON "T_RES_SWITCH_BLADE" 
		("SWITCH_BLADE_ID" ASC)
;


-- DDL Statements for primary key on Table "T_RES_SWITCH_BLADE"

ALTER TABLE "T_RES_SWITCH_BLADE" 
	ADD PRIMARY KEY
		("VENDOR_ID",
		 "SERIAL_NUMBER")
;



------------------------------------------------
-- DDL Statements for table "T_RES_SWITCH_BLADE_ATTRIBUTE_SNAPSHOT"
------------------------------------------------
 
 CREATE TABLE "T_RES_SWITCH_BLADE_ATTRIBUTE_SNAPSHOT"  (
		  "SWITCH_BLADE_ID" {0} NOT NULL , 
		  "OPERATIONAL_STATUS" {0} , 
		  "DETECTABLE" {1} )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_SWITCH_BLADE_ATTRIBUTE_SNAPSHOT"

ALTER TABLE "T_RES_SWITCH_BLADE_ATTRIBUTE_SNAPSHOT" 
	ADD PRIMARY KEY
		("SWITCH_BLADE_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_SWITCH_BLADE_TYPE"
------------------------------------------------
 
 CREATE TABLE "T_RES_SWITCH_BLADE_TYPE"  (
		  "SWITCH_BLADE_TYPE_ID" {1} NOT NULL , 
		  "TYPE_NAME" VARCHAR(255) NOT NULL )   {22}
; 
-- DDL Statements for indexes on Table "T_RES_SWITCH_BLADE_TYPE"

CREATE UNIQUE INDEX "I_SWBT_BTID" ON "T_RES_SWITCH_BLADE_TYPE" 
		("SWITCH_BLADE_TYPE_ID" ASC)
;


-- DDL Statements for primary key on Table "T_RES_SWITCH_BLADE_TYPE"

ALTER TABLE "T_RES_SWITCH_BLADE_TYPE" 
	ADD PRIMARY KEY
		("TYPE_NAME")
;



------------------------------------------------
-- DDL Statements for table "T_RES_USER_ATTRIBUTES"
------------------------------------------------
 
 CREATE TABLE "T_RES_USER_ATTRIBUTES"  (
		  "TABLE_NAME" VARCHAR(255) , 
		  "ATTRIBUTE" {0} , 
		  "ATTRIB_NAME" VARCHAR(255) )   {22}
; 

------------------------------------------------
-- DDL Statements for table "T_RES_CAPABILITY_DATA"
------------------------------------------------
 
 CREATE TABLE "T_RES_CAPABILITY_DATA"  (
		  "CAPABILITY_DATA_ID" {0} NOT NULL , 
		  "SMIS_VERSION" VARCHAR(64) , 
		  "SMIS_PROFILE" VARCHAR(64) , 
		  "SMIS_SUB_PROFILES" VARCHAR(64) , 
		  "VOLUME_CREATION" {1} , 
		  "VOLUME_DELETION" {1} , 
		  "ACCESS_ASSIGNMENT" {1} , 
		  "ACCESS_UNASSIGNMENT" {1} , 
		  "VOLUME_EXPANSION" {1} , 
		  "VOLUME_SHRINKING" {1} , 
		  "EXTENT_DATA" {1} , 
		  "DISK_DATA" {1} , 
		  "ACCESS_POINT" {1} , 
		  "NUM_VOLUMES" {111} , 
		  "RAID_LEVELS" VARCHAR(255) , 
		  "TARGET_PORT_RESTRICTION" {1} , 
		  "PORTS_PER_VIEW" {0} , 
		  "ONE_HW_ID_PER_VIEW" {1} , 
		  "CONTROLLER_REQ_IDENTITY" {1} , 
		  "CONTROLLER_SUPP_COLL" {1} , 
		  "UNIQUE_NUM_PER_PORT" {1} , 
		  "ATTACH_DEVICE" {1} , 
		  "EXPOSE_PATH" {1} , 
		  "SPC_ALLOWS_NO_LUS" {1} , 
		  "SPC_ALLOWS_NO_TGTS" {1} , 
		  "SPC_ALLOWS_NO_INITIATORS" {1} , 
		  "SPC_ALLOWS_DEFAULT_VIEWS" {1} , 
		  "VALID_HWID_TYPES" VARCHAR(20) , 
		  "CLNT_SELCTBL_DEVNO" {1} , 
		  "MAX_MAP_COUNT" {0} )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_CAPABILITY_DATA"

ALTER TABLE "T_RES_CAPABILITY_DATA" 
	ADD PRIMARY KEY
		("CAPABILITY_DATA_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_MASKING_INFO"
------------------------------------------------
 
 CREATE TABLE "T_RES_MASKING_INFO"  (
		  "MASKING_INFO_ID" {0} NOT NULL , 
		  "HOST_ID" VARCHAR(255) , 
		  "HOST_CAPTION" VARCHAR(255) , 
		  "HOST_ELEMENT_NAME" VARCHAR(255) , 
		  "COLLECTION_ID" VARCHAR(255) , 
		  "COLLECTION_NAME" VARCHAR(255) , 
		  "CONTOLLER_COP" VARCHAR(1024) , 
		  "SUBSYSTEM_ID" {0} , 
		  "SETTING_DATA_ID" {0} )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_MASKING_INFO"

ALTER TABLE "T_RES_MASKING_INFO" 
	ADD PRIMARY KEY
		("MASKING_INFO_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_CLIENT_SETTING_DATA"
------------------------------------------------
 
 CREATE TABLE "T_RES_CLIENT_SETTING_DATA"  (
		  "SETTING_DATA_ID" {0} NOT NULL , 
		  "INSTANCE_ID" VARCHAR(255) NOT NULL , 
		  "ELEMENT_NAME" VARCHAR(255) , 
		  "CLIENT_TYPES" VARCHAR(255) , 
		  "CLIENT_TYPE_DESCRIPTIONS" VARCHAR(255) , 
		  "CREATION_CLASS_NAME_ID" {1} , 
		  "SUBSYSTEM_ID" {0} NOT NULL )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_CLIENT_SETTING_DATA"

ALTER TABLE "T_RES_CLIENT_SETTING_DATA" 
	ADD PRIMARY KEY
		("INSTANCE_ID",
		 "SUBSYSTEM_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_BACKEND_CONTROLLER"
------------------------------------------------
 
 CREATE TABLE "T_RES_BACKEND_CONTROLLER"  (
		  "BACKEND_CONTROLLER_ID" {0} , 
		  "SYSTEM_CREATION_CLASS_NAME_ID" {1} , 
		  "SYSTEM_NAMES_ID" {1} NOT NULL , 
		  "CREATION_CLASS_NAME_ID" {1} , 
		  "DEVICE_ID" VARCHAR(255) NOT NULL , 
		  "OPERATIONAL_STATUS" {0} , 
		  "NODE_WWN" CHAR(16) , 
		  "WWPN_PATH_COUNT" VARCHAR(255) , 
		  "SERIAL_NUMBER" VARCHAR(255) , 
		  "VENDOR_ID" {1} NOT NULL WITH DEFAULT 0 , 
		  "OWNING_SUBSYSTEM_ID" {0} , 
		  "REFERENCED_SUBSYSTEM_ID" {0} , 
		  "PORT_WWNS" VARCHAR(300) )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_BACKEND_CONTROLLER"

ALTER TABLE "T_RES_BACKEND_CONTROLLER" 
	ADD PRIMARY KEY
		("DEVICE_ID",
		 "SYSTEM_NAMES_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_BACKEND_CONTROLLER_ATTRIBUTE_SNAPSHOT"
------------------------------------------------
 
 CREATE TABLE "T_RES_BACKEND_CONTROLLER_ATTRIBUTE_SNAPSHOT"  (
		  "BACKEND_CONTROLLER_ID" {0} NOT NULL , 
		  "OPERATIONAL_STATUS" {0} )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_BACKEND_CONTROLLER_ATTRIBUTE_SNAPSHOT"

ALTER TABLE "T_RES_BACKEND_CONTROLLER_ATTRIBUTE_SNAPSHOT" 
	ADD PRIMARY KEY
		("BACKEND_CONTROLLER_ID")
;

------------------------------------------------
-- DDL Statements for table "T_RES_ELEMENT_PROBE_STATUS"
------------------------------------------------
 
 CREATE TABLE "T_RES_ELEMENT_PROBE_STATUS"  (
		  "ELEMENT_ID" {0} NOT NULL , 
		  "ELEMENT_TYPE" {1} NOT NULL , 
		  "SCANNER_ID" VARCHAR(54) NOT NULL , 
		  "UPDATE_TIMESTAMP" {3} , 
		  "PROBE_FOUND" {1} )   {22}
; 

-- DDL Statements for primary key on Table "T_RES_ELEMENT_PROBE_STATUS"

ALTER TABLE "T_RES_ELEMENT_PROBE_STATUS" 
	ADD PRIMARY KEY
		("ELEMENT_ID",
		 "ELEMENT_TYPE",
		 "SCANNER_ID")
;



------------------------------------------------
-- DDL Statements for table "T_RES_SCANTYPE2TABLE"
------------------------------------------------
 
 CREATE TABLE "T_RES_SCANTYPE2TABLE"  (
		  "SCAN_TYPE" CHAR(5) NOT NULL , 
		  "TABLE_NAME" VARCHAR(255) NOT NULL )   {22}
; 

------------------------------------------------
-- DDL Statements for table "T_RES_RCSEV2DEVICE"
------------------------------------------------
 
 CREATE TABLE "T_RES_RCSEV2DEVICE"  (
		  "SEVERITY_CODE" {0} NOT NULL , 
		  "DEVICE_ID" VARCHAR(255) NOT NULL )   {22}
; 
 
------------------------------------------------
-- DDL Statements for table "T_VIEW_NODE2COMPUTER_ATTRIBUTE_SNAPSHOT"
------------------------------------------------
 
 CREATE TABLE "T_VIEW_NODE2COMPUTER_ATTRIBUTE_SNAPSHOT"  (
		  "NODE2HBA_ID" {0} NOT NULL , 
		  "DETECTABLE" {1} )   {22}
; 

-- DDL Statements for primary key on Table "T_VIEW_NODE2COMPUTER_ATTRIBUTE_SNAPSHOT"

ALTER TABLE "T_VIEW_NODE2COMPUTER_ATTRIBUTE_SNAPSHOT" 
	ADD PRIMARY KEY
		("NODE2HBA_ID")
;



------------------------------------------------
-- DDL Statements for table "T_VIEW_PORT2PORT2FABRIC_ATTRIBUTE_SNAPSHOT"
------------------------------------------------
 
 CREATE TABLE "T_VIEW_PORT2PORT2FABRIC_ATTRIBUTE_SNAPSHOT"  (
		  "PORT2PORT_ID" {0} NOT NULL , 
		  "DETECTABLE" {1} )   {22}
; 

-- DDL Statements for primary key on Table "T_VIEW_PORT2PORT2FABRIC_ATTRIBUTE_SNAPSHOT"

ALTER TABLE "T_VIEW_PORT2PORT2FABRIC_ATTRIBUTE_SNAPSHOT" 
	ADD PRIMARY KEY
		("PORT2PORT_ID")
;



------------------------------------------------
-- DDL Statements for table "T_VIEW_PORT2PARENT_ATTRIBUTE_SNAPSHOT"
------------------------------------------------
 
 CREATE TABLE "T_VIEW_PORT2PARENT_ATTRIBUTE_SNAPSHOT"  (
		  "PORT_ID" {0} NOT NULL , 
		  "DETECTABLE" {1} , 
		  "OPERATIONAL_STATUS" {1} )   {22}
; 

-- DDL Statements for primary key on Table "T_VIEW_PORT2PARENT_ATTRIBUTE_SNAPSHOT"

ALTER TABLE "T_VIEW_PORT2PARENT_ATTRIBUTE_SNAPSHOT" 
	ADD PRIMARY KEY
		("PORT_ID")
;



------------------------------------------------
-- DDL Statements for table "T_STAT_TOTALS"
------------------------------------------------
 
 CREATE TABLE "T_STAT_TOTALS"  (
		  "STATISTIC_TYPE" {1} NOT NULL , 
		  "UPDATE_TIME" {3} NOT NULL , 
		  "FS_CAPACITY" DECIMAL(31,0) NOT NULL , 
		  "USED_SPACE" DECIMAL(31,0) NOT NULL , 
		  "FREE_SPACE" DECIMAL(31,0) NOT NULL , 
		  "DISK_CAPACITY" DECIMAL(31,0) NOT NULL , 
		  "DISK_UNALLOCATED" DECIMAL(31,0) NOT NULL , 
		  "TOTAL_DIRECTORIES" {0} NOT NULL , 
		  "TOTAL_FILES" {0} NOT NULL , 
		  "TOTAL_FILESYSTEMS" {0} NOT NULL , 
		  "TOTAL_AGENTS" {0} NOT NULL , 
		  "TOTAL_COMPUTERS" {0} NOT NULL , 
		  "TOTAL_USERS" {0} NOT NULL , 
		  "TOTAL_DISKS" {0} NOT NULL , 
		  "ALL_ALERTS" {0} NOT NULL , 
		  "COMPUTER_ALERTS" {0} NOT NULL , 
		  "HARD_DISK_ALERTS" {0} NOT NULL , 
		  "FILESYSTEM_ALERTS" {0} NOT NULL , 
		  "DIRECTORY_ALERTS" {0} NOT NULL , 
		  "USER_QUOTA_ALERTS" {0} NOT NULL , 
		  "GRP_QUOTA_ALERTS" {0} NOT NULL , 
		  "USER_ALERTS" {0} NOT NULL , 
		  "COMPUTER_TYPE" {1} NOT NULL , 
		  "USER_NAME" VARCHAR(164) NOT NULL , 
		  "FILESYSTEM_NAME" VARCHAR(764) NOT NULL , 
		  "TOTAL_SS" {0} NOT NULL WITH DEFAULT -1 , 
		  "TOTAL_LUNS" {0} NOT NULL WITH DEFAULT -1 , 
		  "LUN_CAPACITY" DECIMAL(31,0) NOT NULL WITH DEFAULT -1 , 
		  "USABLE_LUN_CAP" DECIMAL(31,0) NOT NULL WITH DEFAULT -1 , 
		  "SS_ALERTS" {0} NOT NULL WITH DEFAULT 0 , 
		  "SWITCH_ALERTS" {0} NOT NULL WITH DEFAULT 0 , 
		  "FABRIC_ALERTS" {0} NOT NULL WITH DEFAULT 0 , 
		  "ENDPT_ALERTS" {0} NOT NULL WITH DEFAULT 0 , 
		  "TAPE_LIB_ALERTS" {0} NOT NULL WITH DEFAULT 0 , 
		  "EXTERNAL_ALERTS" {0} NOT NULL WITH DEFAULT 0 )   {22}
; 




------------------------------------------------
-- DDL Statements for table "T_RES_CLUSTER"
------------------------------------------------
 
 CREATE TABLE "T_RES_CLUSTER"  (
		  "CLUSTER_ID" {0} NOT NULL , 
		  "CLUSTER_NAME" VARCHAR(64) NOT NULL , 
		  "DOMAIN_NAME" VARCHAR(128) NOT NULL , 
		  "IP_ADDRESS" VARCHAR(15) NOT NULL , 
		  "DOMAIN_ID" {0} NOT NULL , 
		  "CLUSTER_TYPE" {1} NOT NULL , 
		  "DISCOVERED_TIME" {3} NOT NULL )   {22}
; 

----------------------------

-- DDL Statements for Views

----------------------------


create view t_view_group2res    (resource_id, group_id, res_type) as   
(select distinct resource_id, group_id, res_type    from   t_group2res
   where res_indicator in (5,2,1))
;



create view t_res_view_ssluncmp (computer_id, subsystem_id, physical_volume_id,
lun_id, svid) as( select   distinct c.computer_id    , ss.subsystem_id
   , pv.physical_volume_id    , pv.serial_number    , sv.svid from    
t_res_host c    , t_res_storage_subsystem ss    , t_res_storage_volume
sv    , t_res_physical_volume pv    , t_res_dev_access da    , t_res_controller
ctl where  lower(pv.subsystem_serial_number || '/' || pv.serial_number)
= lower(sv.unique_id)    and sv.subsystem_id = ss.subsystem_id    and pv.physical_volume_id
= da.device_id    and da.controller_id = ctl.controller_id    and ctl.computer_id
= c.computer_id)
;



CREATE VIEW T_VIEW_SUBSYSTEM2PORT AS  (  SELECT PORT.SUBSYSTEM_ID SUBSYSTEM_ID,
        PORT.PORT_ID PORT_ID   FROM T_RES_PORT PORT   WHERE PORT.SUBSYSTEM_ID
IS NOT NULL   UNION   SELECT SUBSYSTEM.SUBSYSTEM_ID SUBSYSTEM_ID,     
    PORT.PORT_ID PORT_ID   FROM T_RES_PORT PORT,         T_RES_PE2NODE
PE2NODE,         T_RES_PHY_PE PE,         T_RES_STORAGE_SUBSYSTEM SUBSYSTEM
   WHERE PORT.NODE_ID = PE2NODE.NODE_ID and         PE2NODE.PHY_PE_ID =
PE.PHY_PE_ID and         PE.SERIAL_NUMBER = SUBSYSTEM.SERIAL_NUMBER  )
;



CREATE VIEW T_VIEW_HOST2PORT_TEMP1 AS  (  SELECT HOST.COMPUTER_ID HOST_ID,
        HOST.HOST_URL HOST_URL,        PORT.PORT_ID PORT_ID  FROM T_RES_HOST
HOST,        T_RES_DEVICE_AGENT AGENT,     T_RES_HBA HBA,        T_RES_NODE2HBA
NODE2HBA,        T_RES_PORT PORT   WHERE AGENT.HOST_ID = HOST.COMPUTER_ID
and       HOST.COMPUTER_ID = HBA.HOST_ID and         HBA.HBA_ID = NODE2HBA.HBA_ID
and         NODE2HBA.NODE_ID = PORT.NODE_ID    UNION   SELECT CAST (NULL
AS {0}) HOST_ID,         PORT.HOST_URL_BY_SUBSYSTEM HOST_URL,     
   PORT.PORT_ID PORT_ID   FROM T_RES_PORT PORT         LEFT OUTER JOIN
T_RES_NODE AS NODE ON (PORT.NODE_ID = NODE.NODE_ID)        WHERE PORT.NODE_ID
IS NULL and          PORT.HOST_URL_BY_SUBSYSTEM IS NOT NULL   UNION  SELECT
HOST.COMPUTER_ID HOST_ID,          HOST.HOST_URL HOST_URL,        PORT.PORT_ID
PORT_ID   FROM T_RES_HOST HOST,        T_RES_AGENT AGENT,      T_RES_CONTROLLER
CONTROLLER,        T_RES_PORT PORT   WHERE AGENT.COMPUTER_ID = HOST.COMPUTER_ID
and       HOST.COMPUTER_ID = CONTROLLER.COMPUTER_ID and         CONTROLLER.WWN_STR
= PORT.NAME   )
;



CREATE VIEW T_VIEW_HOST2PORT_TEMP2 AS   (   SELECT DISTINCT DATA_PATH.INITIATOR_PORT_ID
PORT_ID,           DATA_PATH.UNKNOWN_HOST_NAME HOST_URL,          CAST
(NULL AS {0}) HOST_ID   FROM T_RES_DATA_PATH DATA_PATH  WHERE   DATA_PATH.INITIATOR_PORT_ID
NOT IN (SELECT DISTINCT PORT_ID FROM T_VIEW_HOST2PORT_TEMP1)   UNION  SELECT
DISTINCT DATA_PATH.INITIATOR_PORT_ID PORT_ID,           DATA_PATH.UNKNOWN_HOST_NAME
HOST_URL,          CAST (NULL AS {0}) HOST_ID   FROM T_RES_DATA_PATH
DATA_PATH,       T_VIEW_HOST2PORT_TEMP1 T1  WHERE   DATA_PATH.INITIATOR_PORT_ID
= T1.PORT_ID AND  T1.HOST_URL IS NULL   )
;



CREATE VIEW T_VIEW_HOST2PORT AS ( SELECT PORT_ID,         HOST_ID,     
   HOST_URL FROM T_VIEW_HOST2PORT_TEMP2 UNION SELECT PORT_ID,         HOST_ID,
       HOST_URL FROM T_VIEW_HOST2PORT_TEMP1  WHERE  PORT_ID NOT IN (SELECT
PORT_ID FROM T_VIEW_HOST2PORT_TEMP2) )
;



CREATE VIEW T_VIEW_SWITCH2PORT  AS  (  SELECT SWITCH.SWITCH_ID SWITCH_ID,
        PORT.PORT_ID PORT_ID  FROM T_RES_PORT PORT,        T_RES_SWITCH2PORT
SWITCH2PORT,        T_RES_SWITCH SWITCH   WHERE PORT.PORT_ID = SWITCH2PORT.PORT_ID
and          SWITCH2PORT.SWITCH_WWN = SWITCH.SWITCH_WWN  )
;



CREATE VIEW T_VIEW_PORT2PORT AS  (  SELECT PORT2PORT.PORT2PORT_ID PORT2PORT_ID,
         PORT2PORT.PORT_ID1 PORT_ID1,         PORT2PORT.PORT_ID2 PORT_ID2,
         PORT2PORT.DETECTABLE DETECTABLE  FROM T_RES_PORT2PORT PORT2PORT
 UNION   SELECT PORT2PORT.PORT2PORT_ID PORT2PORT_ID,          PORT2PORT.PORT_ID2
PORT_ID1,                 PORT2PORT.PORT_ID1 PORT_ID2,          PORT2PORT.DETECTABLE
DETECTABLE  FROM T_RES_PORT2PORT PORT2PORT  )
;



CREATE VIEW T_VIEW_SWITCH2FABRIC AS  (  SELECT SWITCH.SWITCH_ID SWITCH_ID,
        FABRIC.FABRIC_ID FABRIC_ID  FROM T_RES_FABRIC2SWITCH FABRIC2SWITCH,
       T_RES_FABRIC FABRIC,          T_RES_SWITCH SWITCH left outer join
T_RES_SWITCH SWITCH2 on             SWITCH.SWITCH_WWN = SWITCH2.PARENT_SWITCH_WWN
  WHERE SWITCH2.SWITCH_WWN IS NULL and         SWITCH.SWITCH_WWN = FABRIC2SWITCH.SWITCH_WWN
and        FABRIC2SWITCH.FABRIC_WWN = FABRIC.FABRIC_WWN   )
;



CREATE VIEW T_VIEW_SWITCH2SUBSYSTEM AS  (  SELECT SUBSYSTEM2PORT.SUBSYSTEM_ID
SUBSYSTEM_ID,         SUBSYSTEM2PORT.PORT_ID SUBSYSTEM_PORT_ID,       
  SWITCH2PORT.PORT_ID SWITCH_PORT_ID,          SWITCH.SWITCH_ID SWITCH_ID,
         PORT2PORT.DETECTABLE DETECTABLE,          PORT2PORT.PORT2PORT_ID
PORT2PORT_ID   FROM T_VIEW_SUBSYSTEM2PORT SUBSYSTEM2PORT,       T_VIEW_PORT2PORT
PORT2PORT,       T_RES_SWITCH2PORT SWITCH2PORT,        T_RES_SWITCH SWITCH
left outer join T_RES_SWITCH SWITCH2 on   		SWITCH.SWITCH_WWN = SWITCH2.PARENT_SWITCH_WWN
  WHERE SWITCH2.PARENT_SWITCH_WWN IS NULL and         SWITCH.SWITCH_WWN
= SWITCH2PORT.SWITCH_WWN and          SWITCH2PORT.PORT_ID = PORT2PORT.PORT_ID1
and         PORT2PORT.PORT_ID2 = SUBSYSTEM2PORT.PORT_ID  )
;



CREATE VIEW T_VIEW_SUBSYSTEM2FABRIC AS  (  SELECT distinct SWITCH2SUBSYSTEM.SUBSYSTEM_ID
SUBSYSTEM_ID,           SWITCH2FABRIC.FABRIC_ID FABRIC_ID   FROM T_VIEW_SWITCH2FABRIC
SWITCH2FABRIC,        T_VIEW_SWITCH2SUBSYSTEM SWITCH2SUBSYSTEM WHERE SWITCH2FABRIC.SWITCH_ID
= SWITCH2SUBSYSTEM.SWITCH_ID  )
;



CREATE VIEW T_VIEW_SWITCH2HOST AS   (  SELECT HOST2PORT.HOST_ID HOST_ID,
         HOST2PORT.HOST_URL HOST_URL,        HOST2PORT.PORT_ID HOST_PORT_ID,
         SWITCH.SWITCH_ID SWITCH_ID,         PORT2PORT.PORT2PORT_ID PORT2PORT_ID,
         PORT2PORT.DETECTABLE DETECTABLE,          PORT2.PORT_ID SWITCH_PORT_ID
  FROM T_VIEW_HOST2PORT HOST2PORT,       T_VIEW_PORT2PORT PORT2PORT,  
    T_RES_PORT PORT2,        T_RES_SWITCH2PORT SWITCH2PORT,       T_RES_SWITCH
SWITCH left outer join T_RES_SWITCH SWITCH2 on                     SWITCH.SWITCH_WWN
= SWITCH2.PARENT_SWITCH_WWN  WHERE       HOST2PORT.PORT_ID = PORT2PORT.PORT_ID1
and        PORT2PORT.PORT_ID2 = PORT2.PORT_ID and       PORT2.PORT_ID =
SWITCH2PORT.PORT_ID and       SWITCH2PORT.SWITCH_WWN = SWITCH.SWITCH_WWN
and       SWITCH2.SWITCH_WWN is NULL   )
;



CREATE VIEW T_VIEW_HOST2FABRIC AS  (  SELECT distinct SWITCH2HOST.HOST_ID
HOST_ID,          SWITCH2HOST.HOST_URL HOST_URL,         SWITCH2FABRIC.FABRIC_ID
FABRIC_ID  FROM T_VIEW_SWITCH2HOST SWITCH2HOST,        T_VIEW_SWITCH2FABRIC
SWITCH2FABRIC  WHERE SWITCH2HOST.SWITCH_ID = SWITCH2FABRIC.SWITCH_ID  )
;



CREATE VIEW T_VIEW_HOSTPORT2FABRIC AS   (  SELECT distinct HOST2PORT.HOST_ID
HOST_ID,          HOST2PORT.PORT_ID PORT_ID,        HOST2PORT.HOST_URL
HOST_URL,        FABRIC2SWITCH.FABRIC_WWN FROM T_VIEW_HOST2PORT HOST2PORT,
      T_VIEW_PORT2PORT PORT2PORT,       T_RES_SWITCH2PORT SWITCH2PORT,
      T_RES_FABRIC2SWITCH FABRIC2SWITCH,       T_RES_SWITCH SWITCH left
outer join T_RES_SWITCH SWITCH2 on             SWITCH.SWITCH_WWN = SWITCH2.PARENT_SWITCH_WWN
 WHERE       HOST2PORT.PORT_ID = PORT2PORT.PORT_ID1 and        PORT2PORT.PORT_ID2
= SWITCH2PORT.PORT_ID and       SWITCH2PORT.SWITCH_WWN = SWITCH.SWITCH_WWN
and      SWITCH2.SWITCH_WWN is NULL and           SWITCH.SWITCH_WWN = FABRIC2SWITCH.SWITCH_WWN
)
;



CREATE VIEW T_VIEW_HOST_SS_PORTS  (PORT_WWN, SUBSYSTEM_ID, HOST_URL, FABRIC_WWN,
SUBSYSTEM_TYPE, SUBSYSTEM_DISPLAY_NAME) AS (  SELECT PORT.NAME PORT_WWN,
        CAST (NULL AS {0}) SUBSYSTEM_ID,         HOSTPORT2FABRIC.HOST_URL
HOST_URL,         HOSTPORT2FABRIC.FABRIC_WWN FABRIC_WWN,         CAST (NULL
AS VARCHAR(255)) SUBSYSTEM_TYPE,         CAST (NULL AS VARCHAR(255)) SUBSYSTEM_DISPLAY_NAME
FROM T_RES_PORT PORT,       T_RES_FABRIC FABRIC,       T_VIEW_HOST2PORT
HOST2PORT,       T_VIEW_HOSTPORT2FABRIC HOSTPORT2FABRIC  WHERE PORT.PORT_ID
= HOSTPORT2FABRIC.PORT_ID UNION  SELECT PORT.NAME PORT_WWN,         PORT.SUBSYSTEM_ID
SUBSYTEM_ID,         CAST (NULL AS VARCHAR(255)) HOST_URL,         FABRIC.FABRIC_WWN
FABRIC_WWN,         SUBSYSTEM.TYPE SUBSYSTEM_TYPE,        SUBSYSTEM.DISPLAY_NAME
SUBSYSTEM_DISPLAY_NAME FROM T_RES_PORT PORT,      T_RES_FABRIC FABRIC,
     T_VIEW_SUBSYSTEM2PORT SUBSYSTEM2PORT,      T_VIEW_SWITCH2SUBSYSTEM
SWITCH2SUBSYSTEM,      T_VIEW_SWITCH2FABRIC SWITCH2FABRIC,      T_RES_STORAGE_SUBSYSTEM
SUBSYSTEM WHERE PORT.PORT_ID = SUBSYSTEM2PORT.PORT_ID and       SUBSYSTEM2PORT.PORT_ID
= SWITCH2SUBSYSTEM.SUBSYSTEM_PORT_ID and       SWITCH2SUBSYSTEM.SWITCH_ID
= SWITCH2FABRIC.SWITCH_ID and       SWITCH2FABRIC.FABRIC_ID = FABRIC.FABRIC_ID
and       SUBSYSTEM2PORT.SUBSYSTEM_ID = SUBSYSTEM.SUBSYSTEM_ID )
;



CREATE VIEW T_VIEW_DEAD_END_PORTS AS ( SELECT DISTINCT P2.NAME PORT_WWN,
              CAST (NULL AS {0}) SUBSYSTEM_ID,          CAST (NULL
AS VARCHAR(255)) HOST_URL,          FABRIC.FABRIC_WWN FABRIC_WWN,     
    CAST (NULL AS VARCHAR(255)) SUBSYSTEM_TYPE,          CAST (NULL AS
VARCHAR(255)) SUBSYSTEM_DISPLAY_NAME  FROM T_RES_FABRIC AS FABRIC,    
  T_RES_FABRIC2SWITCH AS F2S   JOIN T_RES_SWITCH AS SWITCH ON (F2S.SWITCH_WWN
= SWITCH.SWITCH_WWN)   JOIN T_RES_SWITCH2PORT AS S2P ON (S2P.SWITCH_WWN
= SWITCH.SWITCH_WWN)   JOIN T_RES_PORT AS P1 ON (S2P.PORT_ID = P1.PORT_ID)
 JOIN T_VIEW_PORT2PORT AS P2P ON (P1.PORT_ID = P2P.PORT_ID1) JOIN T_RES_PORT
AS P2 ON (P2P.PORT_ID2 = P2.PORT_ID) JOIN T_RES_NODE AS NODE ON (P2.NODE_ID
= NODE.NODE_ID)  LEFT OUTER JOIN T_RES_NODE2HBA AS N2HBA ON (NODE.NODE_ID
= N2HBA.NODE_ID)  LEFT OUTER JOIN T_RES_PE2NODE AS PE2N ON (NODE.NODE_ID
= PE2N.NODE_ID)  LEFT OUTER JOIN T_RES_TAPE_MEDIA_CHANGER AS TMC ON (NODE.NODE_ID
= TMC.NODE_ID)  LEFT OUTER JOIN T_RES_TAPE_DRIVE AS TAPE ON (NODE.NODE_ID
= TAPE.NODE_ID)  LEFT OUTER JOIN T_RES_CONTROLLER AS CON ON (P2.NAME=CON.WWN_STR)
 WHERE F2S.FABRIC_WWN = FABRIC.FABRIC_WWN and        N2HBA.NODE_ID IS NULL
and        NODE.BLADE_ID IS NULL and        NODE.SYSTEM_ID IS NULL and
       PE2N.NODE_ID IS NULL and        TAPE.NODE_ID IS NULL and       
TMC.NODE_ID IS NULL and        CON.WWN_STR IS NULL and        P2.SUBSYSTEM_ID
IS NULL )
;



CREATE VIEW T_VIEW_ALL_PORTS AS ( SELECT DISTINCT PORT_WWN,         SUBSYSTEM_ID,
        HOST_URL,         FABRIC_WWN,         SUBSYSTEM_TYPE,        SUBSYSTEM_DISPLAY_NAME
FROM T_VIEW_HOST_SS_PORTS UNION SELECT DISTINCT PORT_WWN,         SUBSYSTEM_ID,
        HOST_URL,         FABRIC_WWN,         SUBSYSTEM_TYPE,        SUBSYSTEM_DISPLAY_NAME
FROM T_VIEW_DEAD_END_PORTS )
;



create view t_view_ss_aggrinfo as (
(select t0.subsystem_id, 
t1.n_disks, t1.disk_capacity, t2.n_luns, t2.overhead, t2.lun_capacity, t5.disk_freespace,
t3.lgldisk_assigned_capacity, t4.lun_capacity_zos from 
(((((select s1.subsystem_id as subsystem_id from t_res_storage_subsystem s1 where s1.os_type = 21) as t0 left outer join
(select s1.subsystem_id as subsystem_id, count(se.storage_extent_id) as n_disks, sum(se.total_capacity) as disk_capacity from t_res_storage_extent se, t_res_storage_subsystem s1 where se.subsystem_id = s1.subsystem_id and s1.os_type = 21 group by s1.subsystem_id) as t1
on t0.subsystem_id = t1.subsystem_id) left outer join 
(select s1.subsystem_id as subsystem_id,count(sv.svid) as n_luns, sum(sv.overhead) as overhead, sum(sv.capacity) as lun_capacity from t_res_storage_volume sv, t_res_storage_subsystem s1 where sv.subsystem_id = s1.subsystem_id and s1.os_type = 21 group by s1.subsystem_id) as t2
on t0.subsystem_id = t2.subsystem_id) left outer join
(select s1.subsystem_id as subsystem_id, sum(sv.capacity) as lgldisk_assigned_capacity from t_res_storage_volume sv, t_res_storage_subsystem s1 where sv.subsystem_id = s1.subsystem_id and sv.is_assigned = 1 and s1.os_type = 21 group by s1.subsystem_id) as t3
on t0.subsystem_id = t3.subsystem_id) left outer join
(select s1.subsystem_id as subsystem_id, sum(sv.capacity) as lun_capacity_zos from t_res_storage_volume sv, t_res_storage_subsystem s1 where sv.subsystem_id = s1.subsystem_id and sv.format in (5,6,7) and s1.os_type = 21 group by s1.subsystem_id) as t4
on t0.subsystem_id = t4.subsystem_id) left outer join
(select s1.subsystem_id as subsystem_id, sum(h.free_space) as disk_freespace from t_stat_disk_hist h, t_res_storage_extent se, t_res_storage_subsystem s1 where se.subsystem_id = s1.subsystem_id and h.disk_id = se.storage_extent_id and  h.statistic_type = '3' and s1.os_type = 21 group by s1.subsystem_id) as t5
on t0.subsystem_id = t5.subsystem_id)
union
(select t0.subsystem_id, 
t1.n_disks, t5.disk_capacity, t2.n_luns, t2.overhead, t2.lun_capacity, t5.disk_freespace,
t3.lgldisk_assigned_capacity, t4.lun_capacity_zos from 
(((((select s1.subsystem_id as subsystem_id from t_res_storage_subsystem s1 where s1.os_type <> 21) as t0 left outer join
(select s1.subsystem_id as subsystem_id, count(pv.physical_volume_id) as n_disks from t_res_physical_volume pv, t_res_storage_subsystem s1 where pv.subsystem_id = s1.subsystem_id and s1.os_type <> 21 group by s1.subsystem_id) as t1
on t0.subsystem_id = t1.subsystem_id) left outer join 
(select s1.subsystem_id as subsystem_id,count(sv.svid) as n_luns, sum(sv.overhead) as overhead, sum(sv.capacity) as lun_capacity from t_res_storage_volume sv, t_res_storage_subsystem s1 where sv.subsystem_id = s1.subsystem_id and s1.os_type <> 21 group by s1.subsystem_id) as t2
on t0.subsystem_id = t2.subsystem_id) left outer join
(select s1.subsystem_id as subsystem_id, sum(sv.capacity) as lgldisk_assigned_capacity from t_res_storage_volume sv, t_res_storage_subsystem s1 where sv.subsystem_id = s1.subsystem_id and sv.is_assigned = 1 and s1.os_type <> 21 group by s1.subsystem_id) as t3
on t0.subsystem_id = t3.subsystem_id) left outer join
(select s1.subsystem_id as subsystem_id, sum(sv.capacity) as lun_capacity_zos from t_res_storage_volume sv, t_res_storage_subsystem s1 where sv.subsystem_id = s1.subsystem_id and sv.format in (5,6,7) and s1.os_type <> 21 group by s1.subsystem_id) as t4
on t0.subsystem_id = t4.subsystem_id) left outer join
(select s1.subsystem_id as subsystem_id, sum(h.free_space) as disk_freespace, sum(h.capacity) as disk_capacity from t_stat_disk_hist h, t_res_physical_volume  pv, t_res_storage_subsystem s1 where pv.subsystem_id = s1.subsystem_id and h.disk_id = pv.physical_volume_id and  h.statistic_type = '3' and pv.flags is NULL and s1.os_type <> 21 group by s1.subsystem_id) as t5
on t0.subsystem_id = t5.subsystem_id)
)
;


CREATE VIEW T_VIEW_NODE2COMPUTER AS    (   SELECT DISTINCT NODE2HBA.NODE2HBA_ID,
         NODE2HBA.NODE_ID,           NODE2HBA.HBA_ID,           NODE2HBA.DETECTABLE,
          HBA.HOST_ID   FROM   T_RES_NODE2HBA NODE2HBA, 	          T_RES_HBA
HBA   WHERE NODE2HBA.HBA_ID = HBA.HBA_ID   )
;



CREATE VIEW T_VIEW_PORT2PORT2FABRIC AS    (   SELECT DISTINCT PORT2PORT.PORT2PORT_ID,
         PORT2PORT.DETECTABLE,           FABRIC2SWITCH.FABRIC_WWN   FROM
  T_RES_PORT2PORT PORT2PORT, 	          T_RES_SWITCH2PORT SWITCH2PORT,
          T_RES_FABRIC2SWITCH FABRIC2SWITCH   WHERE (PORT2PORT.PORT_ID1
= SWITCH2PORT.PORT_ID OR           PORT2PORT.PORT_ID2 = SWITCH2PORT.PORT_ID)
AND           SWITCH2PORT.SWITCH_WWN = FABRIC2SWITCH.SWITCH_WWN   )
;



CREATE VIEW T_VIEW_PORT2PARENT AS    (   SELECT DISTINCT PORT.PORT_ID, 
         PORT.DETECTABLE,           PORT.OPERATIONAL_STATUS,          STORAGE_SUBSYSTEM.SUBSYSTEM_ID,
          '' SWITCH_WWN,           0 HOST_ID,           0 PHY_PE_ID   
FROM   T_RES_PORT PORT,           T_RES_STORAGE_SUBSYSTEM STORAGE_SUBSYSTEM
  WHERE PORT.SUBSYSTEM_ID = STORAGE_SUBSYSTEM.SUBSYSTEM_ID   UNION    SELECT
DISTINCT PORT.PORT_ID,           PORT.DETECTABLE,           PORT.OPERATIONAL_STATUS,
          0 SUBSYSTEM_ID,           SWITCH2PORT.SWITCH_WWN,           0
HOST_ID,           0 PHY_PE_ID   FROM   T_RES_PORT PORT,           T_RES_SWITCH2PORT
SWITCH2PORT    WHERE SWITCH2PORT.PORT_ID = PORT.PORT_ID   UNION    SELECT
DISTINCT PORT.PORT_ID,           PORT.DETECTABLE,           PORT.OPERATIONAL_STATUS,
          0 SUBSYSTEM_ID,           '' SWITCH_WWN,           NODE2COMPUTER.HOST_ID,
          0 PHY_PE_ID   FROM   T_RES_PORT PORT,           T_RES_NODE NODE,
          T_VIEW_NODE2COMPUTER NODE2COMPUTER    WHERE PORT.NODE_ID = NODE2COMPUTER.NODE_ID
  UNION    SELECT DISTINCT PORT.PORT_ID,           PORT.DETECTABLE,   
       PORT.OPERATIONAL_STATUS,           0 SUBSYSTEM_ID,           ''
SWITCH_WWN,           0 HOST_ID,           PE2NODE.PHY_PE_ID   FROM   T_RES_PORT
PORT,           T_RES_PE2NODE PE2NODE    WHERE PORT.NODE_ID = PE2NODE.NODE_ID
   )
;



CREATE VIEW T_VIEW_TEST_CIMOM2SS (CIMOM_URL, SUBSYSTEM_ID) AS (SELECT T_RES_REGISTERED_CIMOM.SERVICE_URL,
       T_RES_STORAGE_SUBSYSTEM.NAME FROM T_RES_REGISTERED_CIMOM,     T_RES_STORAGE_SUBSYSTEM
WHERE REG_CIMOM_ID =    (SELECT CIMOM_ID FROM T_RES_CIMOM2NAMESPACE WHERE
CIM_NAMESPACE_ID =    (SELECT DISTINCT CIM_NAMESPACE_ID FROM T_RES_CIMKEY_SUBSYSTEM
WHERE SUBSYSTEM_ID =     T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID AND ACTIVE
= 1)))
;



CREATE VIEW T_VIEW_VUNKNOWN AS (SELECT distinct     CASE WHEN PE.PHY_PE_ID
IS NOT NULL THEN 'pe:'          WHEN NODE.NODE_ID IS NOT NULL THEN 'node:'
         ELSE 'port:'     END PREFIX_ID,    CASE WHEN PE.PHY_PE_ID IS NOT
NULL THEN PE.PHY_PE_ID          WHEN NODE.NODE_ID IS NOT NULL THEN NODE.NODE_ID
         ELSE PORT2.PORT_ID     END UNKNOWN_ID ,    CASE WHEN PE.DISPLAY_NAME
IS NOT NULL AND RTRIM(PE.DISPLAY_NAME) != '' THEN PE.DISPLAY_NAME     
    WHEN PE.PE_NAME IS NOT NULL AND RTRIM(PE.PE_NAME) != '' THEN PE.PE_NAME
         WHEN NODE.DISPLAY_NAME IS NOT NULL AND RTRIM(NODE.DISPLAY_NAME)
!= '' THEN NODE.DISPLAY_NAME          WHEN NODE.NAME IS NOT NULL AND RTRIM(NODE.NAME)
!= '' THEN NODE.NAME          WHEN PORT2.DISPLAY_NAME IS NOT NULL AND RTRIM(PORT2.DISPLAY_NAME)
!= '' THEN PORT2.DISPLAY_NAME          ELSE PORT2.NAME     END DISPLAY_NAME,
    CASE WHEN NODE.NAME IS NOT NULL AND RTRIM(NODE.NAME) != '' THEN NODE.NAME
         ELSE PORT2.NAME     END WWN,     CASE WHEN NODE.MGMT_URL_ADDR
IS NOT NULL then NODE.MGMT_URL_ADDR          ELSE NULL     END ACCESS_INFO,
    PE.SERIAL_NUMBER SERIAL_NUMBER, 	 PE.MODEL_ID MODEL_ID,     PE.VENDOR_ID
VENDOR_ID ,CASE 	WHEN PE.PHY_PE_ID IS NOT NULL THEN PE.DETECTABLE 	WHEN
NODE.NODE_ID IS NOT NULL THEN NODE.DETECTABLE 	ELSE PORT2.DETECTABLE END
DETECTABLE, CASE     WHEN PE.PHY_PE_ID IS NOT NULL THEN 		 CASE 		 	WHEN
PE.DETECTABLE = 1 THEN NODE.PROPAGATED_STATUS 		 	WHEN PE.DETECTABLE =
0 THEN 3 		    ELSE CAST(NULL as {0}) 		 END 	WHEN NODE.NODE_ID IS
NOT NULL THEN NODE.PROPAGATED_STATUS    ELSE CASE 		 	WHEN PORT2.DETECTABLE
= 1 THEN PORT2.CONSOLIDATED_STATUS 		 	WHEN PORT2.DETECTABLE = 0 THEN 3
		    ELSE CAST(NULL as {0}) 		 END END PROPAGATED_STATUS,	CASE 	WHEN
(PE.PHY_PE_ID IS NOT NULL) THEN 	CASE  	WHEN (SUBSTR(VENDOR.VENDOR_NAME,1,3)='IBM'
and SUBSTR(MODEL.MODEL_NAME,1,4)='1750') then  10 	WHEN (SUBSTR(VENDOR.VENDOR_NAME,1,3)='IBM'
and SUBSTR(MODEL.MODEL_NAME,1,4)='2107') then  10 	WHEN (SUBSTR(VENDOR.VENDOR_NAME,1,3)='IBM'
and SUBSTR(MODEL.MODEL_NAME,2,4)='1750') then  10 	WHEN (SUBSTR(VENDOR.VENDOR_NAME,1,3)='IBM'
and SUBSTR(MODEL.MODEL_NAME,2,4)='2107') then  10 	WHEN (SUBSTR(VENDOR.VENDOR_NAME,1,3)='IBM'
and SUBSTR(MODEL.MODEL_NAME,1,4)='2105') then  10 	WHEN (SUBSTR(VENDOR.VENDOR_NAME,1,3)='IBM'
and SUBSTR(MODEL.MODEL_NAME,1,4)='2145') then  10 	WHEN (SUBSTR(VENDOR.VENDOR_NAME,1,3)='IBM'
and SUBSTR(MODEL.MODEL_NAME,2,4)='2105') then  10 	WHEN (SUBSTR(VENDOR.VENDOR_NAME,1,3)='IBM'
and SUBSTR(MODEL.MODEL_NAME,2,4)='2145') then  10 	WHEN (PE.SCSI_TYPE !=
34 )then PE.SCSI_TYPE 	WHEN (PE.PLATFORM_TYPE!= 1) then  PE.PLATFORM_TYPE
	WHEN (PE.RNID_TYPE!=  1) then  PE.RNID_TYPE 	else 34  	END  	WHEN (NODE.DISPLAY_ICON_TYPE
IS NOT NULL AND NODE.DISPLAY_ICON_TYPE != 109) then 		CASE 			WHEN (NODE.DISPLAY_ICON_TYPE
= 104) then 9 			WHEN (NODE.DISPLAY_ICON_TYPE = 105) then 10 			WHEN (NODE.DISPLAY_ICON_TYPE
= 107) then 7 			WHEN (NODE.DISPLAY_ICON_TYPE = 108) then 32 			ELSE 1
		END 	WHEN (SUBSTR(NODE.OTHER_NAME,1,3)='IBM' and SUBSTR(NODE.OTHER_NAME,8,4)='1750')
then  10 	WHEN (SUBSTR(NODE.OTHER_NAME,1,3)='IBM' and SUBSTR(NODE.OTHER_NAME,8,4)='2107')
then  10 	WHEN (SUBSTR(NODE.OTHER_NAME,1,3)='IBM' and SUBSTR(NODE.OTHER_NAME,9,4)='1750')
then  10 	WHEN (SUBSTR(NODE.OTHER_NAME,1,3)='IBM' and SUBSTR(NODE.OTHER_NAME,9,4)='2107')
then  10 	WHEN (SUBSTR(NODE.OTHER_NAME,1,3)='IBM' and SUBSTR(NODE.OTHER_NAME,8,4)='2105')
then  10 	WHEN (SUBSTR(NODE.OTHER_NAME,1,3)='IBM' and SUBSTR(NODE.OTHER_NAME,8,4)='2145')
then  10 	WHEN (SUBSTR(NODE.OTHER_NAME,1,3)='IBM' and SUBSTR(NODE.OTHER_NAME,9,4)='2105')
then  10 	WHEN (SUBSTR(NODE.OTHER_NAME,1,3)='IBM' and SUBSTR(NODE.OTHER_NAME,9,4)='2145')
then  10 	WHEN (NODE.PLATFORM_TYPE !=  1 ) then  NODE.PLATFORM_TYPE 	WHEN
(NODE.RNID_TYPE !=  1) then  NODE.RNID_TYPE  	WHEN (PORT2.DISPLAY_ICON_TYPE
IS NOT NULL AND PORT2.DISPLAY_ICON_TYPE != 109) then 		CASE 			WHEN (PORT2.DISPLAY_ICON_TYPE
= 104) then 9 			WHEN (PORT2.DISPLAY_ICON_TYPE = 105) then 10 			WHEN (PORT2.DISPLAY_ICON_TYPE
= 107) then 7 			WHEN (PORT2.DISPLAY_ICON_TYPE = 108) then 32 			ELSE 1
		END 	WHEN (PORT2.TYPE = 4 or PORT2.TYPE = 6 or PORT2.TYPE = 7 or PORT2.TYPE
= 9 or PORT2.TYPE = 10 or PORT2.TYPE = 11) then 7 	ELSE 1  		END OTHER_TYPE
FROM     T_VIEW_PORT2PORT PORT2PORT, 	 T_RES_PORT PORT2 left outer join
T_RES_NODE NODE     on PORT2.NODE_ID = NODE.NODE_ID left outer join T_RES_NODE2HBA
NODE2HBA     on NODE.NODE_ID = NODE2HBA.NODE_ID left outer join (SELECT
PE2NODE.NODE_ID, MAX(PE2NODE.PHY_PE_ID) PHY_PE_ID 	   FROM T_RES_PE2NODE
PE2NODE GROUP BY PE2NODE.NODE_ID) PE2NODE     on NODE.NODE_ID = PE2NODE.NODE_ID
left outer join T_RES_TAPE_LIBRARY TAPE     on NODE.TAPE_LIBRARY_ID = TAPE.TAPE_LIBRARY_ID
left outer join T_RES_SWITCH_BLADE BLADE     on NODE.BLADE_ID = BLADE.SWITCH_BLADE_ID
left outer join T_RES_PHY_PE PE     on PE2NODE.PHY_PE_ID = PE.PHY_PE_ID
left outer join T_RES_STORAGE_SUBSYSTEM SUBSYSTEM 	 on PE.SERIAL_NUMBER
= SUBSYSTEM.SERIAL_NUMBER left outer join T_RES_SWITCH2PORT SWITCH2PORT2
    on PORT2.PORT_ID = SWITCH2PORT2.PORT_ID left outer join T_RES_CONTROLLER
CONTROLLER     on PORT2.NAME = CONTROLLER.WWN_STR left outer join T_RES_VENDOR
VENDOR     on PE.VENDOR_ID = VENDOR.VENDOR_ID left outer join T_RES_MODEL
MODEL     on PE.MODEL_ID = MODEL.MODEL_ID WHERE     PORT2PORT.PORT_ID1
= PORT2.PORT_ID and 	 PORT2.SUBSYSTEM_ID IS NULL and 	 CONTROLLER.CONTROLLER_ID
IS NULL and     NODE2HBA.NODE2HBA_ID IS NULL and     SUBSYSTEM.SUBSYSTEM_ID
IS NULL and     TAPE.TAPE_LIBRARY_ID IS NULL and     SWITCH2PORT2.PORT_ID
IS NULL and     BLADE.SWITCH_BLADE_ID IS NULL)
;


CREATE VIEW T_VIEW_VUNKNOWN2PORT AS (SELECT distinct     CASE WHEN PE.PHY_PE_ID
IS NOT NULL THEN 'pe:'          WHEN NODE.NODE_ID IS NOT NULL THEN 'node:'
         ELSE 'port:'     END PREFIX_ID,    CASE WHEN PE.PHY_PE_ID IS NOT
NULL THEN PE.PHY_PE_ID          WHEN NODE.NODE_ID IS NOT NULL THEN NODE.NODE_ID
         ELSE PORT2.PORT_ID     END UNKNOWN_ID ,	 PORT2.PORT_ID PORT_ID,
CASE     WHEN PE.PHY_PE_ID IS NOT NULL THEN 		 CASE 		 	WHEN
PE.DETECTABLE = 1 THEN NODE.PROPAGATED_STATUS 		 	WHEN PE.DETECTABLE =
0 THEN 3 		    ELSE CAST(NULL as {0}) 		 END 	WHEN NODE.NODE_ID IS
NOT NULL THEN NODE.PROPAGATED_STATUS    ELSE CASE 		 	WHEN PORT2.DETECTABLE
= 1 THEN PORT2.CONSOLIDATED_STATUS 		 	WHEN PORT2.DETECTABLE = 0 THEN 3
		    ELSE CAST(NULL as {0}) 		 END END PROPAGATED_STATUS         
FROM     T_VIEW_PORT2PORT PORT2PORT, 	 T_RES_PORT PORT2 left outer join
T_RES_NODE NODE     on PORT2.NODE_ID = NODE.NODE_ID left outer join T_RES_NODE2HBA
NODE2HBA     on NODE.NODE_ID = NODE2HBA.NODE_ID left outer join T_RES_PE2NODE
PE2NODE     on NODE.NODE_ID = PE2NODE.NODE_ID left outer join T_RES_TAPE_LIBRARY
TAPE     on NODE.TAPE_LIBRARY_ID = TAPE.TAPE_LIBRARY_ID left outer join
T_RES_SWITCH_BLADE BLADE     on NODE.BLADE_ID = BLADE.SWITCH_BLADE_ID left
outer join T_RES_PHY_PE PE     on PE2NODE.PHY_PE_ID = PE.PHY_PE_ID left
outer join T_RES_STORAGE_SUBSYSTEM SUBSYSTEM 	 on PE.SERIAL_NUMBER = SUBSYSTEM.SERIAL_NUMBER
left outer join T_RES_SWITCH2PORT SWITCH2PORT2     on PORT2.PORT_ID = SWITCH2PORT2.PORT_ID
left outer join T_RES_CONTROLLER CONTROLLER     on PORT2.NAME = CONTROLLER.WWN_STR
left outer join T_RES_VENDOR VENDOR     on PE.VENDOR_ID = VENDOR.VENDOR_ID
left outer join T_RES_MODEL MODEL     on PE.MODEL_ID = MODEL.MODEL_ID WHERE
    PORT2PORT.PORT_ID1 = PORT2.PORT_ID and 	 PORT2.SUBSYSTEM_ID IS NULL
and 	 CONTROLLER.CONTROLLER_ID IS NULL and     NODE2HBA.NODE2HBA_ID IS
NULL and     SUBSYSTEM.SUBSYSTEM_ID IS NULL and     TAPE.TAPE_LIBRARY_ID
IS NULL and     SWITCH2PORT2.PORT_ID IS NULL and     BLADE.SWITCH_BLADE_ID
IS NULL)
;

CREATE VIEW T_VIEW_VOTHER AS (SELECT UNK1.UNKNOWN_ID OTHER_ID, UNK1.*
FROM 	T_VIEW_VUNKNOWN UNK1)
;

CREATE VIEW T_VIEW_VOTHER2PORT AS (SELECT 	UNKNOWN2PORT.PREFIX_ID PREFIX_ID,  
UNKNOWN2PORT.UNKNOWN_ID OTHER_ID,    UNKNOWN2PORT.PORT_ID, UNKNOWN2PORT.PROPAGATED_STATUS FROM 	T_VIEW_VUNKNOWN2PORT
UNKNOWN2PORT)
;


CREATE VIEW T_VIEW_VSTORAGE_SUBSYSTEM AS (SELECT     'subsystem:' PREFIX_ID,
	 SUBSYSTEM.SUBSYSTEM_ID SUBSYSTEM_ID , 	 CASE WHEN SUBSYSTEM.VG_CAPACITY
IS NOT NULL AND SUBSYSTEM.VG_FREESPACE IS NOT NULL           THEN (SUBSYSTEM.VG_CAPACITY
- SUBSYSTEM.VG_FREESPACE)           ELSE (SUBSYSTEM.ALLOCATED_CAPACITY)
    END  ALLOCATED_CAPACITY,     CASE WHEN SUBSYSTEM.VG_FREESPACE IS NOT
NULL          THEN (SUBSYSTEM.VG_FREESPACE)          ELSE (SUBSYSTEM.AVAILABLE_CAPACITY)
    END  AVAILABLE_CAPACITY,     SUBSYSTEM.BACKEND_STORAGE_CAPACITY,  
  SUBSYSTEM.VENDOR_ID,     SUBSYSTEM.MODEL_ID,     SUBSYSTEM.NAME,    
SUBSYSTEM.NAME_FORMAT,     SUBSYSTEM.CACHE,     SUBSYSTEM.OS_TYPE,    
SUBSYSTEM.TYPE,     SUBSYSTEM.IP_ADDRESS,     SUBSYSTEM.CODE_LEVEL,   
 SUBSYSTEM.SERIAL_NUMBER,     SUBSYSTEM.DISPLAY_NAME,     SUBSYSTEM.USER_PROVIDED_NAME,
    SUBSYSTEM.DETECTABLE,     SUBSYSTEM.OPERATIONAL_STATUS,     SUBSYSTEM.CONSOLIDATED_STATUS,
    SUBSYSTEM.PROPAGATED_STATUS,     SUBSYSTEM.USER_ATTRIB1,     SUBSYSTEM.USER_ATTRIB2,
    SUBSYSTEM.USER_ATTRIB3,     SUBSYSTEM.ACCESS_INFO FROM     T_RES_STORAGE_SUBSYSTEM
SUBSYSTEM 
)
;

CREATE VIEW T_VIEW_VHOST AS (SELECT     'server:' PREFIX_ID,     HOST.COMPUTER_ID,
    HOST.HOST_URL,     HOST.HOST_NAME,     HOST.GUID,     HOST.OS_TYPE,
    HOST.OS_VERSION,     HOST.TIME_ZONE,     HOST.IP_ADDRESS,     HOST.DETECTABLE,
    HOST.OPERATIONAL_STATUS,     HOST.CONSOLIDATED_STATUS,     HOST.PROPAGATED_STATUS,
    HOST.USER_ATTRIB1,     HOST.USER_ATTRIB2,     HOST.USER_ATTRIB3,  
  DEV_AGT.STATUS DEV_STATUS,     DAT_AGT.STATUS DAT_STATUS FROM     T_RES_HOST
HOST left outer join     (SELECT          DEV.HOST_ID HOST_ID,        
DEV.STATUS STATUS      FROM          T_RES_DEVICE_AGENT DEV) DEV_AGT on
    HOST.COMPUTER_ID = DEV_AGT.HOST_ID left outer join     (SELECT    
     AGT.COMPUTER_ID HOST_ID,          CASE WHEN AGT.STATE = '1' THEN 'AC'
     	    ELSE 'IA'          END STATUS      FROM      	T_RES_AGENT AGT)
DAT_AGT on  	HOST.COMPUTER_ID = DAT_AGT.HOST_ID WHERE     DAT_AGT.HOST_ID
IS NOT NULL or     DEV_AGT.HOST_ID IS NOT NULL )
;

CREATE VIEW T_VIEW_VSWITCH AS (SELECT      'switch:' PREFIX_ID,     SWITCH.SWITCH_ID,
    SWITCH.DISPLAY_NAME,     SWITCH.LOGICAL_NAME,    SWITCH.SWITCH_WWN,
    CASE WHEN SWITCH.SERIAL_NUMBER IS NULL THEN PARENT.SERIAL_NUMBER ELSE
SWITCH.SERIAL_NUMBER END SERIAL_NUMBER,     CASE WHEN SWITCH.DESCRIPTION
IS NULL THEN PARENT.DESCRIPTION ELSE SWITCH.DESCRIPTION END DESCRIPTION,
    CASE WHEN SWITCH.IP_ADDRESS IS NULL THEN PARENT.IP_ADDRESS ELSE SWITCH.IP_ADDRESS
END IP_ADDRESS,     SWITCH.DOMAIN,     CASE WHEN SWITCH.VERSION IS NULL
THEN PARENT.VERSION ELSE SWITCH.VERSION END VERSION,     SWITCH.MODEL_ID,
    SWITCH.VENDOR_ID,     SWITCH.PARENT_SWITCH_WWN,     SWITCH.MGMT_URL_ADDR,
    SWITCH.DETECTABLE,     SWITCH.OPERATIONAL_STATUS,     SWITCH.CONSOLIDATED_STATUS,
    SWITCH.PROPAGATED_STATUS,     SWITCH.USER_ATTRIB1,     SWITCH.USER_ATTRIB2,
    SWITCH.USER_ATTRIB3 FROM     T_RES_SWITCH SWITCH left outer join T_RES_SWITCH
PARENT on 	 SWITCH.PARENT_SWITCH_WWN = PARENT.SWITCH_WWN )
;

CREATE VIEW T_VIEW_VTAPE_LIBRARY AS (SELECT     'tapelibrary:' PREFIX_ID,
    TAPE.TAPE_LIBRARY_ID,     TAPE.DISPLAY_NAME,     TAPE.NAME,     TAPE.FIRMWARE_VERSION,
    TAPE.MAX_CARTRIDGES,     VENDOR.VENDOR_ID,     MODEL.MODEL_ID,    
FRAME.SERIAL_NUMBER,     TAPE.ACCESS_INFO,     TAPE.DETECTABLE,     TAPE.OPERATIONAL_STATUS,
    TAPE.CONSOLIDATED_STATUS,     TAPE.PROPAGATED_STATUS,     DRIVE_COUNT.TOTAL
TOTAL_DRIVES,     CARTRIDGE_COUNT.TOTAL TOTAL_CARTRIDGES,     TAPE.USER_ATTRIB1,
    TAPE.USER_ATTRIB2,     TAPE.USER_ATTRIB3 FROM     T_RES_TAPE_LIBRARY
TAPE left outer join T_RES_TAPE_FRAME FRAME on     TAPE.TAPE_LIBRARY_ID
= FRAME.TAPE_LIBRARY_ID left outer join T_RES_VENDOR VENDOR on     FRAME.VENDOR_ID
= VENDOR.VENDOR_ID left outer join T_RES_MODEL MODEL on     FRAME.MODEL_ID
= MODEL.MODEL_ID left outer join      (SELECT CARTRIDGE.TAPE_LIBRARY_ID,
count(CARTRIDGE.TAG) TOTAL     FROM      	T_RES_TAPE_CARTRIDGE CARTRIDGE
     GROUP BY CARTRIDGE.TAPE_LIBRARY_ID) CARTRIDGE_COUNT on      TAPE.TAPE_LIBRARY_ID
= CARTRIDGE_COUNT.TAPE_LIBRARY_ID left outer join     (SELECT DRIVE.TAPE_LIBRARY_ID,
count(DRIVE.TAPE_DRIVE_ID) TOTAL     FROM          T_RES_TAPE_DRIVE DRIVE
    GROUP BY DRIVE.TAPE_LIBRARY_ID) DRIVE_COUNT on          TAPE.TAPE_LIBRARY_ID
= DRIVE_COUNT.TAPE_LIBRARY_ID )
;


CREATE VIEW T_VIEW_VSWITCH2PORT AS (SELECT 	SWITCH2PORT.PORT_ID, 	'switch:'
PREFIX_ID, 	SWITCH.SWITCH_ID FROM    T_RES_SWITCH2PORT SWITCH2PORT, T_RES_SWITCH SWITCH
WHERE       
(SWITCH2PORT.DETECTABLE = 1 OR SWITCH2PORT.DETECTABLE IS NULL)
and       SWITCH2PORT.SWITCH_WWN = SWITCH.SWITCH_WWN
UNION
SELECT T0.PORT_ID,'switch:' PREFIX_ID, T0.SWITCH_ID FROM
(SELECT COUNT(SWITCH2PORT.SWITCH2PORT_ID)
TOTAL, SWITCH.SWITCH_ID, SWITCH2PORT.PORT_ID 	    FROM 	       T_RES_SWITCH
SWITCH, T_RES_SWITCH2PORT SWITCH2PORT 		WHERE 		    SWITCH.SWITCH_WWN =
SWITCH2PORT.SWITCH_WWN and 			SWITCH.PARENT_SWITCH_WWN IS NOT NULL and
			(SWITCH2PORT.DETECTABLE = 1 OR SWITCH2PORT.DETECTABLE IS NULL)	 	GROUP
BY SWITCH.SWITCH_ID, SWITCH2PORT.PORT_ID) AS T0 WHERE T0.TOTAL = 0 or T0.TOTAL IS NULL)
;



CREATE VIEW T_VIEW_VHOST2PORT AS (SELECT      HOST.PREFIX_ID PREFIX_ID,
    HOST.COMPUTER_ID HOST_ID,     PORT.PORT_ID PORT_ID, HOST.PROPAGATED_STATUS PROPAGATED_STATUS, HOST.DETECTABLE DETECTABLE FROM      T_VIEW_VHOST
HOST, T_RES_HBA HBA,     T_RES_PORT PORT WHERE      HOST.PREFIX_ID = 'server:'
and      HOST.COMPUTER_ID = HBA.HOST_ID and      HBA.HBA_ID = PORT.HBA_ID
UNION  SELECT      HOST.PREFIX_ID PREFIX_ID,     HOST.COMPUTER_ID HOST_ID,
    PORT.PORT_ID PORT_ID, HOST.PROPAGATED_STATUS PROPAGATED_STATUS, HOST.DETECTABLE DETECTABLE FROM      T_VIEW_VHOST HOST, T_RES_CONTROLLER
CONTROLLER,     T_RES_PORT PORT WHERE      HOST.PREFIX_ID = 'server:' and
     HOST.COMPUTER_ID = CONTROLLER.COMPUTER_ID and     CONTROLLER.WWN_STR
= PORT.NAME )
;

CREATE VIEW T_VIEW_VSUBSYSTEM2PORT AS (SELECT      PORT.PORT_ID PORT_ID,
      'subsystem:' PREFIX_ID,     PORT.SUBSYSTEM_ID SUBSYSTEM_ID, SUBSYSTEM.PROPAGATED_STATUS PROPAGATED_STATUS, SUBSYSTEM.DETECTABLE DETECTABLE FROM 
    T_RES_PORT PORT, T_RES_STORAGE_SUBSYSTEM SUBSYSTEM WHERE      PORT.SUBSYSTEM_ID = SUBSYSTEM.SUBSYSTEM_ID UNION SELECT
    PORT.PORT_ID PORT_ID,       'subsystem:' PREFIX_ID,     SUBSYSTEM.SUBSYSTEM_ID
SUBSYSTEM_ID, SUBSYSTEM.PROPAGATED_STATUS PROPAGATED_STATUS, SUBSYSTEM.DETECTABLE DETECTABLE FROM      T_RES_PORT PORT, T_RES_PE2NODE PE2NODE, T_RES_PHY_PE
PE, T_RES_STORAGE_SUBSYSTEM SUBSYSTEM WHERE      PORT.NODE_ID = PE2NODE.NODE_ID
and      PE2NODE.PHY_PE_ID = PE.PHY_PE_ID and      PE.SERIAL_NUMBER = SUBSYSTEM.SERIAL_NUMBER
)
;

CREATE VIEW T_VIEW_VTAPE2PORT AS (SELECT      PORT.PORT_ID PORT_ID,    
'tapelibrary:' PREFIX_ID,     TAPE.TAPE_LIBRARY_ID TAPE_LIBRARY_ID, TAPE.PROPAGATED_STATUS PROPAGATED_STATUS, TAPE.DETECTABLE DETECTABLE
FROM
     T_RES_PORT PORT, T_RES_NODE NODE,     T_RES_TAPE_LIBRARY TAPE WHERE
     PORT.NODE_ID = NODE.NODE_ID and      NODE.TAPE_LIBRARY_ID = TAPE.TAPE_LIBRARY_ID
 )
;

CREATE VIEW T_VIEW_VSWITCH2SUBSYSTEM AS (SELECT     SUBSYSTEM2PORT.PREFIX_ID
SUBSYSTEM_PREFIX_ID,     SUBSYSTEM2PORT.SUBSYSTEM_ID SUBSYSTEM_ID,    
 SUBSYSTEM2PORT.PORT_ID SUBSYSTEM_PORT_ID,     SWITCH2PORT.PORT_ID SWITCH_PORT_ID,
     'switch:' SWITCH_PREFIX_ID,     SWITCH.SWITCH_ID SWITCH_ID,
     PORT2PORT.DETECTABLE DETECTABLE,      PORT2PORT.PORT2PORT_ID PORT2PORT_ID, SUBSYSTEM2PORT.PROPAGATED_STATUS PROPAGATED_STATUS, SUBSYSTEM2PORT.DETECTABLE DETECTABLE2
FROM      T_VIEW_VSUBSYSTEM2PORT SUBSYSTEM2PORT ,     T_VIEW_PORT2PORT
PORT2PORT,      T_RES_SWITCH2PORT SWITCH2PORT,      T_RES_SWITCH SWITCH,
T_RES_SWITCH SWITCH2 
WHERE      ((SWITCH.PARENT_SWITCH_WWN is NULL and SWITCH.SWITCH_WWN NOT IN (SELECT PARENT_SWITCH_WWN FROM T_RES_SWITCH))
or (SWITCH.PARENT_SWITCH_WWN = SWITCH2.SWITCH_WWN
and SWITCH2.PARENT_SWITCH_WWN is NULL))
and     SWITCH.SWITCH_WWN = SWITCH2PORT.SWITCH_WWN AND     SWITCH2PORT.PORT_ID
= PORT2PORT.PORT_ID1 AND     PORT2PORT.PORT_ID2 = SUBSYSTEM2PORT.PORT_ID
)
;

CREATE VIEW T_VIEW_VSWITCH2TAPE AS (SELECT     TAPE2PORT.PREFIX_ID TAPE_PREFIX_ID,
    TAPE2PORT.TAPE_LIBRARY_ID TAPE_LIBRARY_ID,     TAPE2PORT.PORT_ID TAPE_PORT_ID,
     'switch:' SWITCH_PREFIX_ID,     SWITCH2PORT.PORT_ID SWITCH_PORT_ID,
    SWITCH.SWITCH_ID SWITCH_ID,      PORT2PORT.DETECTABLE DETECTABLE, 
    PORT2PORT.PORT2PORT_ID PORT2PORT_ID, TAPE2PORT.PROPAGATED_STATUS PROPAGATED_STATUS, TAPE2PORT.DETECTABLE DETECTABLE2
    FROM      T_VIEW_VTAPE2PORT TAPE2PORT
,      T_VIEW_PORT2PORT PORT2PORT,      T_RES_SWITCH2PORT SWITCH2PORT,
     T_RES_SWITCH SWITCH, T_RES_SWITCH SWITCH2 WHERE
((SWITCH.PARENT_SWITCH_WWN is NULL and SWITCH.SWITCH_WWN NOT IN (SELECT PARENT_SWITCH_WWN FROM T_RES_SWITCH))
or (SWITCH.PARENT_SWITCH_WWN = SWITCH2.SWITCH_WWN
and SWITCH2.PARENT_SWITCH_WWN is NULL))
and     SWITCH.SWITCH_WWN = SWITCH2PORT.SWITCH_WWN AND     SWITCH2PORT.PORT_ID
= PORT2PORT.PORT_ID1 AND     PORT2PORT.PORT_ID2 = TAPE2PORT.PORT_ID
)
;


CREATE VIEW T_VIEW_VSWITCH2HOST AS (SELECT      HOST2PORT.PREFIX_ID HOST_PREFIX_ID,
    HOST2PORT.HOST_ID HOST_ID,       HOST2PORT.PORT_ID HOST_PORT_ID,  
   'switch:' SWITCH_PREFIX_ID,     SWITCH.SWITCH_ID SWITCH_ID, 
    PORT2PORT.PORT2PORT_ID PORT2PORT_ID,     PORT2PORT.DETECTABLE DETECTABLE,
    PORT2.PORT_ID SWITCH_PORT_ID, HOST2PORT.PROPAGATED_STATUS PROPAGATED_STATUS, HOST2PORT.DETECTABLE DETECTABLE2
    FROM      T_VIEW_VHOST2PORT HOST2PORT,
     T_VIEW_PORT2PORT PORT2PORT,      T_RES_PORT PORT2, T_RES_SWITCH2PORT
SWITCH2PORT,      T_RES_SWITCH SWITCH, T_RES_SWITCH SWITCH2
WHERE      
((SWITCH.PARENT_SWITCH_WWN is NULL and SWITCH.SWITCH_WWN NOT IN 
(SELECT PARENT_SWITCH_WWN FROM T_RES_SWITCH))
or (SWITCH.PARENT_SWITCH_WWN = SWITCH2.SWITCH_WWN
and SWITCH2.PARENT_SWITCH_WWN is NULL))
and     SWITCH.SWITCH_WWN = SWITCH2PORT.SWITCH_WWN AND     SWITCH2PORT.PORT_ID
= PORT2PORT.PORT_ID1 AND     PORT2PORT.PORT_ID2 = HOST2PORT.PORT_ID
)
;



CREATE VIEW T_VIEW_VSWITCH2OTHER AS (SELECT      OTHER2PORT.OTHER_ID OTHER_ID,
    OTHER2PORT.PREFIX_ID OTHER_PREFIX_ID,     PORT2PORT.PORT_ID2 OTHER_PORT_ID,
	 PORT2PORT.PORT_ID1 SWITCH_PORT_ID,     PORT2PORT.PORT2PORT_ID PORT2PORT_ID,
    PORT2PORT.DETECTABLE DETECTABLE, 	 'switch:' SWITCH_PREFIX_ID,
	 SWITCH.SWITCH_ID SWITCH_ID, OTHER2PORT.PROPAGATED_STATUS PROPAGATED_STATUS FROM     T_RES_SWITCH SWITCH, T_RES_SWITCH SWITCH2,
    T_RES_SWITCH2PORT SWITCH2PORT,     T_VIEW_PORT2PORT PORT2PORT,  
  T_VIEW_VOTHER2PORT OTHER2PORT WHERE     
((SWITCH.PARENT_SWITCH_WWN is NULL 
and SWITCH.SWITCH_WWN NOT IN (SELECT PARENT_SWITCH_WWN FROM T_RES_SWITCH
WHERE PARENT_SWITCH_WWN IS NOT NULL))
or (SWITCH.PARENT_SWITCH_WWN = SWITCH2.SWITCH_WWN
and SWITCH2.PARENT_SWITCH_WWN is NULL))
and     SWITCH.SWITCH_WWN = SWITCH2PORT.SWITCH_WWN AND     SWITCH2PORT.PORT_ID
= PORT2PORT.PORT_ID1 AND     PORT2PORT.PORT_ID2 = OTHER2PORT.PORT_ID
)
;


CREATE VIEW T_VIEW_VSWITCH2FABRIC AS (SELECT       SWITCH.PREFIX_ID PREFIX_ID,
    SWITCH.SWITCH_ID SWITCH_ID,      FABRIC.FABRIC_ID FABRIC_ID, SWITCH.PROPAGATED_STATUS PROPAGATED_STATUS, FABRIC.FABRIC_WWN FABRIC_WWN FROM  
   T_RES_FABRIC2SWITCH FABRIC2SWITCH, T_RES_FABRIC FABRIC,      T_VIEW_VSWITCH
SWITCH left outer join T_RES_SWITCH SWITCH2 on     SWITCH.SWITCH_WWN =
SWITCH2.PARENT_SWITCH_WWN WHERE     SWITCH2.SWITCH_WWN IS NULL and    
  SWITCH.SWITCH_WWN = FABRIC2SWITCH.SWITCH_WWN and     FABRIC2SWITCH.FABRIC_WWN
= FABRIC.FABRIC_WWN)
;



CREATE VIEW T_VIEW_VSUBSYSTEM2FABRIC AS (SELECT distinct    SWITCH2SUBSYSTEM.SUBSYSTEM_PREFIX_ID
PREFIX_ID, 	SWITCH2SUBSYSTEM.SUBSYSTEM_ID SUBSYSTEM_ID, 	SWITCH2FABRIC.FABRIC_ID
FABRIC_ID, SWITCH2SUBSYSTEM.PROPAGATED_STATUS PROPAGATED_STATUS,  SWITCH2FABRIC.FABRIC_WWN FABRIC_WWN, SWITCH2SUBSYSTEM.DETECTABLE2 DETECTABLE
FROM 	T_VIEW_VSWITCH2FABRIC SWITCH2FABRIC, 	T_VIEW_VSWITCH2SUBSYSTEM
SWITCH2SUBSYSTEM WHERE    SWITCH2FABRIC.PREFIX_ID = SWITCH2SUBSYSTEM.SWITCH_PREFIX_ID
and 	SWITCH2FABRIC.SWITCH_ID = SWITCH2SUBSYSTEM.SWITCH_ID)
;



CREATE VIEW T_VIEW_VHOST2FABRIC AS (select distinct 	SWITCH2HOST.HOST_PREFIX_ID
PREFIX_ID, 	SWITCH2HOST.HOST_ID HOST_ID, 	SWITCH2FABRIC.FABRIC_ID FABRIC_ID, SWITCH2HOST.PROPAGATED_STATUS PROPAGATED_STATUS,  SWITCH2FABRIC.FABRIC_WWN FABRIC_WWN, SWITCH2HOST.DETECTABLE2 DETECTABLE
FROM 	T_VIEW_VSWITCH2HOST SWITCH2HOST, 	T_VIEW_VSWITCH2FABRIC SWITCH2FABRIC
where 	SWITCH2HOST.SWITCH_PREFIX_ID = SWITCH2FABRIC.PREFIX_ID and 	SWITCH2HOST.SWITCH_ID
= SWITCH2FABRIC.SWITCH_ID)
;



CREATE VIEW T_VIEW_VTAPE2FABRIC AS (SELECT distinct    SWITCH2TAPE.TAPE_PREFIX_ID
PREFIX_ID, 	SWITCH2TAPE.TAPE_LIBRARY_ID TAPE_LIBRARY_ID, 	SWITCH2FABRIC.FABRIC_ID FABRIC_ID, SWITCH2TAPE.PROPAGATED_STATUS PROPAGATED_STATUS,  SWITCH2FABRIC.FABRIC_WWN FABRIC_WWN, SWITCH2TAPE.DETECTABLE2 DETECTABLE
FROM 	T_VIEW_VSWITCH2FABRIC SWITCH2FABRIC, 	T_VIEW_VSWITCH2TAPE
SWITCH2TAPE WHERE    SWITCH2FABRIC.PREFIX_ID = SWITCH2TAPE.SWITCH_PREFIX_ID
and 	SWITCH2FABRIC.SWITCH_ID = SWITCH2TAPE.SWITCH_ID)
;



CREATE VIEW T_VIEW_VOTHER2FABRIC AS (SELECT DISTINCT  	SWITCH2OTHER.OTHER_ID
OTHER_ID,   SWITCH2OTHER.OTHER_PREFIX_ID PREFIX_ID,    SWITCH2FABRIC.FABRIC_ID FABRIC_ID, SWITCH2OTHER.PROPAGATED_STATUS PROPAGATED_STATUS,  SWITCH2FABRIC.FABRIC_WWN FABRIC_WWN
FROM 	T_VIEW_VSWITCH2OTHER SWITCH2OTHER,    T_VIEW_VSWITCH2FABRIC
SWITCH2FABRIC WHERE 	SWITCH2FABRIC.PREFIX_ID = SWITCH2OTHER.SWITCH_PREFIX_ID
and 	SWITCH2FABRIC.SWITCH_ID = SWITCH2OTHER.SWITCH_ID )
;




CREATE VIEW T_VIEW_VHOST2SUBSYSTEM AS (SELECT      HOST2PORT.PREFIX_ID HOST_PREFIX_ID,
    HOST2PORT.HOST_ID HOST_ID,       HOST2PORT.PORT_ID HOST_PORT_ID,  
    SUBSYSTEM2PORT.PREFIX_ID SUBSYSTEM_PREFIX_ID,     SUBSYSTEM2PORT.SUBSYSTEM_ID
SUBSYSTEM_ID,     SUBSYSTEM2PORT.PORT_ID SUBSYSTEM_PORT_ID,     PORT2PORT.PORT2PORT_ID
PORT2PORT_ID,     PORT2PORT.DETECTABLE DETECTABLE FROM      T_VIEW_VHOST2PORT
HOST2PORT,      T_VIEW_VSUBSYSTEM2PORT SUBSYSTEM2PORT,     T_VIEW_PORT2PORT
PORT2PORT WHERE      HOST2PORT.PORT_ID = PORT2PORT.PORT_ID1 and     PORT2PORT.PORT_ID2
= SUBSYSTEM2PORT.PORT_ID )
;


CREATE VIEW T_VIEW_MEMBER2ZONE AS (SELECT     ZONE2MEMBER.ZONE_MEMBER_ID,
   ZONE2MEMBER.ZONE_ID ZONE_ID FROM     T_RES_ZONE2MEMBER ZONE2MEMBER UNION
 SELECT     ALIAS2MEMBER.ZONE_MEMBER_ID,    ZONE2ALIAS.ZONE_ID ZONE_ID
FROM     T_RES_ZONE2ALIAS ZONE2ALIAS,     T_RES_ALIAS2MEMBER ALIAS2MEMBER
WHERE     ALIAS2MEMBER.ALIAS_ID = ZONE2ALIAS.ALIAS_ID)
;



CREATE VIEW T_VIEW_PORT2ZONE AS (SELECT      MEMBER.ZONE_MEMBER_ID, 	 MEMBER.MEMBER_NAME,
    PORT.PORT_ID,     MEMBER2ZONE.ZONE_ID FROM     T_VIEW_MEMBER2ZONE MEMBER2ZONE,
	 T_RES_ZONE_MEMBER MEMBER left outer join T_RES_PORT PORT on     MEMBER.MEMBER_NAME
= PORT.NAME WHERE     (MEMBER.TYPE = 11 or MEMBER.TYPE = 10) and 	 MEMBER.ZONE_MEMBER_ID
= MEMBER2ZONE.ZONE_MEMBER_ID UNION SELECT       MEMBER.ZONE_MEMBER_ID,
    MEMBER.MEMBER_NAME,      MEMBER2PORT.PORT_ID,     MEMBER2ZONE.ZONE_ID
 FROM       T_RES_ZONE_MEMBER MEMBER left outer join ( 	SELECT MEMBER2ZONE.ZONE_MEMBER_ID,
MEMBER2ZONE.ZONE_ID, PORT.PORT_ID, SWITCH.DOMAIN || ',' || PORT.PORT_NUMBER
DOMAIN_PORT 	FROM 	  T_VIEW_MEMBER2ZONE MEMBER2ZONE, T_RES_ZONE ZONE, T_RES_FABRIC2SWITCH
FABRIC2SWITCH, 	  T_RES_SWITCH SWITCH, T_VIEW_VSWITCH2PORT SWITCH2PORT,
T_RES_PORT PORT 	WHERE     	  MEMBER2ZONE.ZONE_ID = ZONE.ZONE_ID and  
    	  ZONE.FABRIC_WWN = FABRIC2SWITCH.FABRIC_WWN and      	  FABRIC2SWITCH.SWITCH_WWN
= SWITCH.SWITCH_WWN and       	  SWITCH.SWITCH_ID = SWITCH2PORT.SWITCH_ID
and      	  SWITCH2PORT.PORT_ID = PORT.PORT_ID and 		  SWITCH2PORT.PREFIX_ID
= 'switch:' 	) MEMBER2PORT on  MEMBER.ZONE_MEMBER_ID = MEMBER2PORT.ZONE_MEMBER_ID
and  MEMBER.MEMBER_NAME = DOMAIN_PORT, T_VIEW_MEMBER2ZONE MEMBER2ZONE WHERE
  MEMBER.TYPE = 12  and MEMBER.ZONE_MEMBER_ID = MEMBER2ZONE.ZONE_MEMBER_ID
 UNION SELECT     MEMBER.ZONE_MEMBER_ID,     MEMBER.MEMBER_NAME,     PORT.PORT_ID,
    MEMBER2ZONE.ZONE_ID FROM     T_VIEW_MEMBER2ZONE MEMBER2ZONE,     T_RES_ZONE_MEMBER
MEMBER left outer join T_RES_PORT PORT on 	 MEMBER.MEMBER_NAME = RTRIM(CAST(PORT.FC_PORT_ID
AS CHAR(16))) WHERE     MEMBER2ZONE.ZONE_MEMBER_ID = MEMBER.ZONE_MEMBER_ID
and     MEMBER.TYPE = 13 UNION SELECT      MEMBER.ZONE_MEMBER_ID,     MEMBER.MEMBER_NAME,
      NODE2PORT.PORT_ID,      MEMBER2ZONE.ZONE_ID  FROM      T_VIEW_MEMBER2ZONE
MEMBER2ZONE,      T_RES_ZONE_MEMBER MEMBER left outer join (SELECT NODE.NAME,
PORT.PORT_ID FROM T_RES_NODE NODE, T_RES_PORT PORT 	WHERE 	 NODE.NODE_ID
= PORT.NODE_ID ) NODE2PORT on     MEMBER.MEMBER_NAME = NODE2PORT.NAME 
  WHERE      MEMBER2ZONE.ZONE_MEMBER_ID = MEMBER.ZONE_MEMBER_ID and   
  MEMBER.TYPE = 14 UNION SELECT     MEMBER.ZONE_MEMBER_ID,     MEMBER.MEMBER_NAME,
	 SWITCH2PORT.PORT_ID,     MEMBER2ZONE.ZONE_ID FROM     T_VIEW_MEMBER2ZONE
MEMBER2ZONE,     T_RES_ZONE_MEMBER MEMBER left outer join (SELECT SWITCH.SWITCH_WWN,
SWITCH2PORT.PORT_ID FROM  T_VIEW_VSWITCH2PORT SWITCH2PORT, T_RES_SWITCH
SWITCH 	 WHERE SWITCH2PORT.SWITCH_ID = SWITCH.SWITCH_ID	 	AND SWITCH2PORT.PREFIX_ID
= 'switch:') SWITCH2PORT on 	 MEMBER.MEMBER_NAME = SWITCH2PORT.SWITCH_WWN
WHERE     MEMBER2ZONE.ZONE_MEMBER_ID = MEMBER.ZONE_MEMBER_ID and     MEMBER.TYPE
= 16 )
;



CREATE VIEW T_VIEW_ZONE2MEMBER AS (SELECT     FABRIC.FABRIC_ID FABRIC_ID,
    ZONE.ZONE_ID ZONE_ID,     SWITCH2PORT.PREFIX_ID, 	 SWITCH2PORT.SWITCH_ID
ENTITY_ID FROM T_VIEW_VSWITCH2PORT SWITCH2PORT,T_VIEW_PORT2ZONE PORT2ZONE,
   T_RES_ZONE ZONE, T_RES_FABRIC FABRIC WHERE     FABRIC.FABRIC_WWN = ZONE.FABRIC_WWN
and     ZONE.ZONE_ID = PORT2ZONE.ZONE_ID and     PORT2ZONE.PORT_ID = SWITCH2PORT.PORT_ID
UNION SELECT     FABRIC.FABRIC_ID FABRIC_ID,     ZONE.ZONE_ID ZONE_ID,
    HOST2PORT.PREFIX_ID, 	 HOST2PORT.HOST_ID ENTITY_ID FROM T_VIEW_VHOST2PORT
HOST2PORT,T_VIEW_PORT2ZONE PORT2ZONE,    T_RES_ZONE ZONE, T_RES_FABRIC
FABRIC WHERE     FABRIC.FABRIC_WWN = ZONE.FABRIC_WWN and     ZONE.ZONE_ID
= PORT2ZONE.ZONE_ID and     PORT2ZONE.PORT_ID = HOST2PORT.PORT_ID UNION
SELECT     FABRIC.FABRIC_ID FABRIC_ID,     ZONE.ZONE_ID ZONE_ID,     SUBSYSTEM2PORT.PREFIX_ID,
	 SUBSYSTEM2PORT.SUBSYSTEM_ID ENTITY_ID FROM T_VIEW_VSUBSYSTEM2PORT SUBSYSTEM2PORT,T_VIEW_PORT2ZONE
PORT2ZONE,    T_RES_ZONE ZONE, T_RES_FABRIC FABRIC WHERE     FABRIC.FABRIC_WWN
= ZONE.FABRIC_WWN and     ZONE.ZONE_ID = PORT2ZONE.ZONE_ID and     PORT2ZONE.PORT_ID
= PORT2ZONE.PORT_ID UNION SELECT     FABRIC.FABRIC_ID FABRIC_ID,     ZONE.ZONE_ID
ZONE_ID,     TAPE2PORT.PREFIX_ID, 	 TAPE2PORT.TAPE_LIBRARY_ID ENTITY_ID
FROM T_VIEW_VTAPE2PORT TAPE2PORT,T_VIEW_PORT2ZONE PORT2ZONE,    T_RES_ZONE
ZONE, T_RES_FABRIC FABRIC WHERE     FABRIC.FABRIC_WWN = ZONE.FABRIC_WWN
and     ZONE.ZONE_ID = PORT2ZONE.ZONE_ID and     PORT2ZONE.PORT_ID = TAPE2PORT.PORT_ID
UNION SELECT     FABRIC.FABRIC_ID FABRIC_ID,     ZONE.ZONE_ID ZONE_ID,
    OTHER2PORT.PREFIX_ID,	 OTHER2PORT.OTHER_ID ENTITY_ID FROM T_VIEW_VOTHER2PORT
OTHER2PORT,T_VIEW_PORT2ZONE PORT2ZONE,     T_RES_ZONE ZONE, T_RES_FABRIC
FABRIC WHERE     FABRIC.FABRIC_WWN = ZONE.FABRIC_WWN and     ZONE.ZONE_ID
= PORT2ZONE.ZONE_ID and     PORT2ZONE.PORT_ID = OTHER2PORT.PORT_ID)
;



CREATE VIEW T_VIEW_PORT2ZSET AS (SELECT 	PORT2ZONE.PORT_ID PORT_ID,    PORT2ZONE.ZONE_ID
ZONE_ID,    ZSET2ZONE.ZSET_ID ZSET_ID FROM T_VIEW_PORT2ZONE PORT2ZONE,
T_RES_ZSET2ZONE ZSET2ZONE WHERE     PORT2ZONE.ZONE_ID = ZSET2ZONE.ZONE_ID)
;



CREATE VIEW T_VIEW_ENTITY2PORT AS (  SELECT distinct      'other:' TYPE,
	OTHER2PORT.PORT_ID PORT_ID,      OTHER2PORT.PREFIX_ID,   	OTHER2PORT.OTHER_ID
ENTITY_ID  FROM   T_VIEW_VOTHER2PORT OTHER2PORT   UNION   SELECT distinct
     'switch:' TYPE,      SWITCH2PORT.PORT_ID PORT_ID,      SWITCH2PORT.PREFIX_ID,
    SWITCH2PORT.SWITCH_ID ENTITY_ID   FROM   T_VIEW_VSWITCH2PORT SWITCH2PORT
  UNION   SELECT distinct      'server:' TYPE,    HOST2PORT.PORT_ID PORT_ID,
     HOST2PORT.PREFIX_ID,  	HOST2PORT.HOST_ID ENTITY_ID   FROM   T_VIEW_VHOST2PORT
HOST2PORT    UNION   SELECT distinct      'subsystem:' TYPE,    SUBSYSTEM2PORT.PORT_ID
PORT_ID,      SUBSYSTEM2PORT.PREFIX_ID,  	SUBSYSTEM2PORT.SUBSYSTEM_ID ENTITY_ID
  FROM   T_VIEW_VSUBSYSTEM2PORT SUBSYSTEM2PORT    UNION   SELECT distinct
     'tapelibrary:' TYPE,    TAPE2PORT.PORT_ID PORT_ID,      TAPE2PORT.PREFIX_ID,
 	TAPE2PORT.TAPE_LIBRARY_ID ENTITY_ID   FROM   T_VIEW_VTAPE2PORT TAPE2PORT
  )
;



CREATE VIEW T_VIEW_PORTS_FROM_ENTITY AS (  SELECT distinct      'other:'
TYPE, 	OTHER2PORT1.PORT_ID PORT_ID1,      OTHER2PORT2.PORT_ID PORT_ID2,
     OTHER2PORT2.PREFIX_ID,   	OTHER2PORT2.OTHER_ID ENTITY_ID   FROM  
T_VIEW_VOTHER2PORT OTHER2PORT1,   T_VIEW_VOTHER2PORT OTHER2PORT2   WHERE
  	OTHER2PORT1.OTHER_ID = OTHER2PORT2.OTHER_ID and   	OTHER2PORT1.PREFIX_ID
= OTHER2PORT2.PREFIX_ID   UNION   SELECT distinct      'switch:' TYPE,
   SWITCH2PORT2.PORT_ID PORT_ID1,      SWITCH2PORT1.PORT_ID PORT_ID2, 
    SWITCH2PORT1.PREFIX_ID,     SWITCH2PORT1.SWITCH_ID ENTITY_ID   FROM
  T_VIEW_VSWITCH2PORT SWITCH2PORT1,   T_VIEW_VSWITCH2PORT SWITCH2PORT2
  WHERE      SWITCH2PORT2.PREFIX_ID = SWITCH2PORT1.PREFIX_ID and   	SWITCH2PORT2.SWITCH_ID
= SWITCH2PORT1.SWITCH_ID   UNION   SELECT distinct      'server:' TYPE,
   HOST2PORT1.PORT_ID PORT_ID1,      HOST2PORT2.PORT_ID PORT_ID2,     
HOST2PORT2.PREFIX_ID,  	HOST2PORT2.HOST_ID ENTITY_ID   FROM   T_VIEW_VHOST2PORT
HOST2PORT1,   T_VIEW_VHOST2PORT HOST2PORT2   WHERE      HOST2PORT1.PREFIX_ID
= HOST2PORT2.PREFIX_ID and   	HOST2PORT1.HOST_ID = HOST2PORT2.HOST_ID 
 UNION   SELECT distinct      'subsystem:' TYPE,    SUBSYSTEM2PORT1.PORT_ID
PORT_ID1,      SUBSYSTEM2PORT2.PORT_ID PORT_ID2,      SUBSYSTEM2PORT2.PREFIX_ID,
 	SUBSYSTEM2PORT2.SUBSYSTEM_ID ENTITY_ID   FROM   T_VIEW_VSUBSYSTEM2PORT
SUBSYSTEM2PORT1,   T_VIEW_VSUBSYSTEM2PORT SUBSYSTEM2PORT2   WHERE     
SUBSYSTEM2PORT1.PREFIX_ID = SUBSYSTEM2PORT2.PREFIX_ID and   	SUBSYSTEM2PORT1.SUBSYSTEM_ID
= SUBSYSTEM2PORT2.SUBSYSTEM_ID   UNION   SELECT distinct      'tapelibrary:'
TYPE,    TAPE2PORT1.PORT_ID PORT_ID1,      TAPE2PORT2.PORT_ID PORT_ID2,
     TAPE2PORT2.PREFIX_ID,  	TAPE2PORT2.TAPE_LIBRARY_ID ENTITY_ID   FROM
  T_VIEW_VTAPE2PORT TAPE2PORT1,   T_VIEW_VTAPE2PORT TAPE2PORT2   WHERE
     TAPE2PORT1.PREFIX_ID = TAPE2PORT2.PREFIX_ID and   	TAPE2PORT1.TAPE_LIBRARY_ID
= TAPE2PORT2.TAPE_LIBRARY_ID  )
;



CREATE VIEW T_VIEW_ENTITY_TO_PORT AS (  SELECT distinct      'other:' TYPE,
	OTHER2PORT.PORT_ID PORT_ID,      OTHER2PORT.PREFIX_ID,   	OTHER2PORT.OTHER_ID
ENTITY_ID,  	OTHER.DISPLAY_NAME DISPLAY_NAME,   	PORT2ZONE.ZONE_ID,   
  CASE WHEN T_RES_PORT.DISPLAY_NAME IS NOT NULL AND RTRIM(T_RES_PORT.DISPLAY_NAME)
!= '' THEN T_RES_PORT.DISPLAY_NAME   		  ELSE T_RES_PORT.NAME   	END PORT_DISPLAY_NAME
  FROM   T_VIEW_VOTHER2PORT OTHER2PORT, T_VIEW_PORT2ZONE PORT2ZONE, T_VIEW_VOTHER
OTHER, T_RES_PORT   WHERE   	T_RES_PORT.PORT_ID = PORT2ZONE.PORT_ID and
  	PORT2ZONE.PORT_ID = OTHER2PORT.PORT_ID and       OTHER2PORT.PREFIX_ID
= OTHER.PREFIX_ID and      OTHER2PORT.OTHER_ID = OTHER.OTHER_ID   UNION
  SELECT distinct      'switch:' TYPE,      SWITCH2PORT.PORT_ID PORT_ID,
     SWITCH2PORT.PREFIX_ID,     SWITCH2PORT.SWITCH_ID ENTITY_ID,      
CASE WHEN SWITCH.DISPLAY_NAME IS NOT NULL  and RTRIM(SWITCH.DISPLAY_NAME)
!= '' THEN SWITCH.DISPLAY_NAME   		  ELSE SWITCH.SWITCH_WWN   	 END DISPLAY_NAME,
  	PORT2ZONE.ZONE_ID,      CASE WHEN T_RES_PORT.DISPLAY_NAME IS NOT NULL
AND RTRIM(T_RES_PORT.DISPLAY_NAME) != '' THEN T_RES_PORT.DISPLAY_NAME 
 		  ELSE T_RES_PORT.NAME   	END PORT_DISPLAY_NAME   FROM   T_VIEW_VSWITCH2PORT
SWITCH2PORT, T_VIEW_PORT2ZONE PORT2ZONE, T_VIEW_VSWITCH SWITCH, T_RES_PORT
   WHERE   	T_RES_PORT.PORT_ID = PORT2ZONE.PORT_ID and   	PORT2ZONE.PORT_ID
= SWITCH2PORT.PORT_ID and       SWITCH2PORT.PREFIX_ID = SWITCH.PREFIX_ID
and      SWITCH2PORT.SWITCH_ID = SWITCH.SWITCH_ID   UNION   SELECT distinct
     'server:' TYPE,    HOST2PORT.PORT_ID PORT_ID,      HOST2PORT.PREFIX_ID,
 	HOST2PORT.HOST_ID ENTITY_ID,    	CASE WHEN HOST.HOST_NAME IS NOT NULL
THEN HOST.HOST_NAME   		 WHEN HOST.HOST_URL IS NOT NULL THEN HOST.HOST_URL
  		 ELSE CAST(HOST.COMPUTER_ID as CHAR(10))   	END  DISPLAY_NAME,   	PORT2ZONE.ZONE_ID,
     CASE WHEN T_RES_PORT.DISPLAY_NAME IS NOT NULL AND RTRIM(T_RES_PORT.DISPLAY_NAME)
!= '' THEN T_RES_PORT.DISPLAY_NAME   		  ELSE T_RES_PORT.NAME   	END PORT_DISPLAY_NAME
  FROM   T_VIEW_VHOST2PORT HOST2PORT, T_VIEW_PORT2ZONE PORT2ZONE, T_VIEW_VHOST
HOST, T_RES_PORT    WHERE   	T_RES_PORT.PORT_ID = PORT2ZONE.PORT_ID and
     PORT2ZONE.PORT_ID = HOST2PORT.PORT_ID and   	HOST2PORT.PREFIX_ID =
HOST.PREFIX_ID and   	HOST2PORT.HOST_ID = HOST.COMPUTER_ID   UNION   SELECT
distinct      'subsystem:' TYPE,    SUBSYSTEM2PORT.PORT_ID PORT_ID,   
  SUBSYSTEM2PORT.PREFIX_ID,  	SUBSYSTEM2PORT.SUBSYSTEM_ID ENTITY_ID,  
	CASE WHEN SUBSYSTEM.USER_PROVIDED_NAME IS NOT NULL AND RTRIM(SUBSYSTEM.USER_PROVIDED_NAME)
!= '' THEN SUBSYSTEM.USER_PROVIDED_NAME   		 WHEN SUBSYSTEM.DISPLAY_NAME
IS NOT NULL THEN SUBSYSTEM.DISPLAY_NAME   		 ELSE SUBSYSTEM.NAME   	END
 DISPLAY_NAME,   	PORT2ZONE.ZONE_ID,      CASE WHEN T_RES_PORT.DISPLAY_NAME
IS NOT NULL AND RTRIM(T_RES_PORT.DISPLAY_NAME) != '' THEN T_RES_PORT.DISPLAY_NAME
  		  ELSE T_RES_PORT.NAME   	END PORT_DISPLAY_NAME   FROM   T_VIEW_VSUBSYSTEM2PORT
SUBSYSTEM2PORT, T_VIEW_PORT2ZONE PORT2ZONE, T_VIEW_VSTORAGE_SUBSYSTEM SUBSYSTEM,
T_RES_PORT    WHERE    	T_RES_PORT.PORT_ID = PORT2ZONE.PORT_ID and    
 PORT2ZONE.PORT_ID = SUBSYSTEM2PORT.PORT_ID and   	SUBSYSTEM2PORT.PREFIX_ID
= SUBSYSTEM.PREFIX_ID and   	SUBSYSTEM2PORT.SUBSYSTEM_ID = SUBSYSTEM.SUBSYSTEM_ID
  UNION   SELECT distinct      'tapelibrary:' TYPE,    TAPE2PORT.PORT_ID
PORT_ID,      TAPE2PORT.PREFIX_ID,  	TAPE2PORT.TAPE_LIBRARY_ID ENTITY_ID,
     CASE WHEN TAPE.DISPLAY_NAME IS NOT NULL  and RTRIM(TAPE.DISPLAY_NAME)
!= '' THEN TAPE.DISPLAY_NAME      	  ELSE CAST (TAPE.TAPE_LIBRARY_ID as
CHAR)      END DISPLAY_NAME, 	PORT2ZONE.ZONE_ID,      CASE WHEN T_RES_PORT.DISPLAY_NAME
IS NOT NULL AND RTRIM(T_RES_PORT.DISPLAY_NAME) != '' THEN T_RES_PORT.DISPLAY_NAME
  		  ELSE T_RES_PORT.NAME   	END PORT_DISPLAY_NAME   FROM   T_VIEW_VTAPE2PORT
TAPE2PORT, T_VIEW_PORT2ZONE PORT2ZONE, T_VIEW_VTAPE_LIBRARY TAPE, T_RES_PORT
   WHERE    	T_RES_PORT.PORT_ID = PORT2ZONE.PORT_ID and      PORT2ZONE.PORT_ID
= TAPE2PORT.PORT_ID and   	TAPE2PORT.PREFIX_ID = TAPE.PREFIX_ID and   
TAPE2PORT.TAPE_LIBRARY_ID = TAPE.TAPE_LIBRARY_ID   )
;


--####################################################################
--# INSERT STATEMENTS FOR DATA TABLES
--# Add new rows for new discovery schedule and alert types
--####################################################################
--# Cimom discovery failed alert
INSERT INTO "T_ALERT_DEFINITION"
  VALUES (110, '{109}', '{112}', 
          '{113}', 0,
          '{109}', '1', 0, 8, 26, '0', -1, '0', '0',
          '0', '8', '0', {9}, -1, {9},'0','0')
;

--# Out of band discovery alert for new entities discovered
INSERT INTO "T_ALERT_DEFINITION"
  VALUES (111, '{109}', '{115}', 
          '{116}', 0,
          '{109}', '1', 0, 8, 26, '0', -1, '0', '0',
          '0', '8', '0', {9}, -1, {9},'0','0')
;

--# Netware discovery failed alert
INSERT INTO "T_ALERT_DEFINITION"
  VALUES (112, '{109}', '{118}', 
          '{119}', 0,
          '{109}', '1', 0, 8, 31, '0', -1, '0', '0',
          '0', '8', '0', {9}, -1, {9},'0','0')
;

--# External notification alert
INSERT INTO "T_ALERT_DEFINITION"
  VALUES (113, '{109}', '{126}', 
          '{127}', 0,
          '{109}', '1', 0, 35, 178, '0', -1, '0', '0',
          '0', '8', '0', {9}, -1, {9},'0','0')
;

--# New disk array discovered alert
INSERT INTO "T_ALERT_DEFINITION"
  VALUES (114, '{109}', '{128}', 
          '{129}', 0,
          '{109}', '1', 3, 20, 64, '0', -1, '0', '0',
          '0', '8', '0', {9}, -1, {9},'0','0')
;

--# Tape alert
INSERT INTO T_ALERT_DEFINITION
  VALUES (115, '{109}', '{130}', 
          '{131}', 0,
          '{109}', '1', 0, 34, 109, '0', -1, '0', '0',
          '0', '8', '0', {9}, -1, {9},'0','0')
;


INSERT INTO "T_SCHEDULE"
  VALUES (110, '{109}', '{112}','{114}', 0, 
          '{109}',
          '1', '3', 2001, 01, 01, 3, 30, '2', '4', 1, '2',
          '2', '2', '2', '2', '2', '2', '2', 
          '1', {9}, {9}, 114, 'J', 1, 0)
;

INSERT INTO "T_SCHEDULE"
  VALUES (111, '{109}', '{115}','{117}', 0, 
          '{109}',
          '1', '3', 2001, 01, 01, 3, 30, '2', '4', 1, '2',
          '2', '2', '2', '2', '2', '2', '2', 
          '1', {9}, {9}, 111, 'K', 1, 0)
;

--# insert Disk related schedule
INSERT INTO "T_SCHEDULE"
  VALUES (113, '{109}', '{124}','{124}', 0, 
          '{109}', '1', 
          '0', 2001, 01, 01, 3, 30, '2', '4', 1, '2',
          '2', '2', '2', '2', '2', '2', '2', 
          '1', {9}, {9}, 0, 'M', 1, 0)
;

--# insert fabric related schedule
INSERT INTO "T_SCHEDULE"
  VALUES (114, '{109}', '{125}','{125}', 0, 
          '{109}', '1', 
          '0', 2001, 01, 01, 3, 30, '2', '4', 1, '2',
          '2', '2', '2', '2', '2', '2', '2', 
          '1', {9}, {9}, 0, 'N', 1, 0)
;

INSERT INTO "T_GROUP" VALUES
  (9, '{109}', '{132}', '{133}',
   0, '{109}', '1', 113, 0)
;

INSERT INTO "T_GROUP" VALUES
  (241, '{109}', '{134}', '{135}',
   0, '{109}', '1', 133, 0)
;

INSERT INTO "T_IDENTIFIER" VALUES (1, 300)
;
INSERT INTO "T_IDENTIFIER" VALUES (2, 1)
;
INSERT INTO "T_IDENTIFIER" VALUES (3, 300)
;
INSERT INTO "T_IDENTIFIER" VALUES (4, 1)
;
INSERT INTO "T_IDENTIFIER" VALUES (5, 1)
;
INSERT INTO "T_IDENTIFIER" VALUES (6, 1)
;
INSERT INTO "T_IDENTIFIER" VALUES (7, 1)
;
INSERT INTO "T_IDENTIFIER" VALUES (8, 1)
;
INSERT INTO "T_IDENTIFIER" VALUES (9, 1)
;
INSERT INTO "T_IDENTIFIER" VALUES (10, 1)
;
INSERT INTO "T_IDENTIFIER" VALUES (11, 1)
;
INSERT INTO "T_IDENTIFIER" VALUES (12, 1)
;
INSERT INTO "T_IDENTIFIER" VALUES (13, 1)
;
INSERT INTO "T_IDENTIFIER" VALUES (14, 1)
;
INSERT INTO "T_IDENTIFIER" VALUES (15, 1)
;
INSERT INTO "T_IDENTIFIER" VALUES (16, 1)
;

INSERT INTO "T_RES_CONFIG_DATA" VALUES ('http.timeout',  '1200000', 'CIM')
;

INSERT INTO "T_RES_CONFIG_DATA" VALUES ('default.authorization.enabled',  'true', 'CIM')
;

INSERT INTO "T_RES_CONFIG_DATA" VALUES ('default.principal',  'default', 'CIM')
;

INSERT INTO "T_RES_CONFIG_DATA" VALUES ('default.credential',  'default', 'CIM')
;

INSERT INTO "T_RES_CONFIG_DATA" VALUES ('http.pool.size', '32', 'CIM')
;

INSERT INTO "T_RES_CONFIG_DATA" VALUES ('TapeAlertNotificationLevel',  '0', 'TapeManager')
;

INSERT INTO T_RES_CONFIG_DATA VALUES ('retries.number', '3', 'CIM')
;

INSERT INTO T_RES_CONFIG_DATA VALUES ('retries.content.enable', 'true', 'CIM')
;

INSERT INTO T_RES_CONFIG_DATA VALUES ('retries.content.length', '50', 'CIM')
;

INSERT INTO T_RES_CONFIG_DATA VALUES ('debug.xml.input', 'false', 'CIM')
;

INSERT INTO T_RES_CONFIG_DATA VALUES ('debug.xml.output', 'false', 'CIM')
;

INSERT INTO T_RES_CONFIG_DATA VALUES ('Indication.FilterList', 
'VolumeStatistics;VolumeSpaceStatistics;FCPortStatistics;StorageExtentStatistics;FlashCopyStorageSynchronized;PerfomanceStatisticsService;ListenerDestinationCIMXML', 
'DeviceServer')
;

insert into t_config_settings (snmp_server, snmp_port, snmp_community, smtp_server, smtp_port, smtp_reply_to, smtp_return, smtp_dflt_domain, retain_copies, retain_days)
  values ('SNMP', 162, 'public', 'mailhost', 25, 'root@mailhost',
          'root@mailhost', 'company.com', 5, 90)
;

insert into t_storm_settings ("KEEP_REMOVED_COMP"  , "KEEP_REMOVED_FS"  , "KEEP_REMOVED_DIR"  ,  "KEEP_REMOVED_DEV"  , 
		  "DISK_DAILY_HIST"  , "DISK_WEEKLY_HIST"  , "DISK_MONTHLY_HIST"  ,  "DIR_DAILY_HIST"  ,  "DIR_WEEKLY_HIST"  , 
		  "DIR_MONTHLY_HIST"  , "PING_DAILY_HIST"  ,  "PING_WEEKLY_HIST"  ,  "PING_MONTHLY_HIST"  ,  "COMP_DAILY_HIST"  , 
		  "COMP_WEEKLY_HIST"  ,  "COMP_MONTHLY_HIST"  ,  "FS_DAILY_HIST"  ,   "FS_WEEKLY_HIST"  ,  "FS_MONTHLY_HIST"  , 
		  "DISK_AWRE"  ,  "DISK_ARRE"  ,  "DISK_NOERRRCVRY"  ,  "EMAIL_ADDR_RULES" ) 
   values (30, 14, 7, 14, 6, 4, 2, 6, 4, 2, 6, 4, 2, 6, 4, 2, 6, 4, 2, '1', '1', '1', 'LASTNAME + SUBSTRING(FIRSTNAME, 0, 1)')
;

insert into t_group values
  (3, '{109}', '{68}', 
   '{28}', 0,
   '{109}', '1', 2, 0)
;
insert into t_group values
  (4, '{109}', '{69}', 
   '{29}', 0,
   '{109}', '1', 0, 0)
;

insert into t_group values
  (8, '{109}', '{107}', '{108}',
   0, '{109}', '1', 77, 0)
;

insert into t_schedule
  values (100, '{109}', '{70}', '{31}', 0,
          '{109}', '1', '3', 2000, 12, 10, 2, 30, '1', 
          '4', 1, '0', '0', '0', '0', '0', '0', 
          '0', '2', '1', {9}, {9}, 100, '6', 1, 0)
;

insert into t_schedule
  values (101, '{109}', '{71}','{33}', 0, 
          '{109}',
          '1', '3', 2001, 01, 01, 3, 30, '2', '4', 1, '2',
          '2', '2', '2', '2', '2', '2', '2', 
          '1', {9}, {9}, 101, '5', 1, 0)
;

insert into t_schedule values
   (102, '{109}', '{99}', '{64}', 0,
    '{109}', '1', '3', 2000, 6, 29, 11, 24, '1', '1', 30, '0', '0', '0',
    '0', '0', '0', '0', '2', '1', {9}, '7 0', 102, '2', 1, 0)
;

insert into t_schedule values
   (103, '{109}', '{100}', '{41}', 0,
    '{109}', '1', '3', 2000, 6, 29, 1, 45, '1', '3', 1, '0', '0', '0',
    '0', '0', '0', '0', '1', '1', {9}, {9}, 103, '3', 1, 0)
;


insert into t_alert_definition (alert_id, creator, name, description, last_modified, last_mod_user, enabled, product_id, alert_type, condition, threshold_type, threshold_value, snmp_trap, os_log, os_log_severity, syslog_facility, email, notify_on_login, script_computer_id, script_name)
  values (100, '{109}', '{70}', '{30}', 0, 
          '{109}', '1', 0, 8, 31, '0', -1, '0', '0',
          '0', '8', '0', {9}, -1, {9})
;


insert into t_alert_definition (alert_id, creator, name, description, last_modified, last_mod_user, enabled, product_id, alert_type, condition, threshold_type, threshold_value, snmp_trap, os_log, os_log_severity, syslog_facility, email, notify_on_login, script_computer_id, script_name)
  values (101, '{109}', '{71}', 
          '{32}', 0,
          '{109}', '1', 0, 9, 27, '0', -1, '0', '0',
          '0', '8', '0', {9}, -1, {9})
;


insert into t_alert_definition (alert_id, creator, name, description, last_modified, last_mod_user, enabled, product_id, alert_type, condition, threshold_type, threshold_value, snmp_trap, os_log, os_log_severity, syslog_facility, email, notify_on_login, script_computer_id, script_name)
values
   (106, '{109}', '{78}', '{40}', 0, '{109}',
    '1', 2, 11, 33, '0', -1, '0', '0', '0', '8', '0', {9}, -1, {9})
;

insert into t_alert_definition (alert_id, creator, name, description, last_modified, last_mod_user, enabled, product_id, alert_type, condition, threshold_type, threshold_value, snmp_trap, os_log, os_log_severity, syslog_facility, email, notify_on_login, script_computer_id, script_name)
values
   (107, '{109}', '{79}', '{42}', 0, '{109}', 
    '1', 2, 13, 40, '0', -1, '0', '0', '0', '8', '0', {9}, -1, {9})
;

insert into t_alert_definition (alert_id, creator, name, description, last_modified, last_mod_user, enabled, product_id, alert_type, condition, threshold_type, threshold_value, snmp_trap, os_log, os_log_severity, syslog_facility, email, notify_on_login, script_computer_id, script_name)
values
   (60, '{109}', '{95}', '{57}', 0,
    '{109}', '1', 0, 5, 22, '3', 1, '0', '0', '0', '8', '0', {9}, -1, {9})
;

insert into t_alert_definition (alert_id, creator, name, description, last_modified, last_mod_user, enabled, product_id, alert_type, condition, threshold_type, threshold_value, snmp_trap, os_log, os_log_severity, syslog_facility, email, notify_on_login, script_computer_id, script_name)
values
   (61, '{109}', '{97}', '{59}', 0,
    '{109}', '1', 0, 5, 22, '3', 1, '0', '0', '0', '8', '0', {9}, -1, {9})
;

insert into t_alert_definition (alert_id, creator, name, description, last_modified, last_mod_user, enabled, product_id, alert_type, condition, threshold_type, threshold_value, snmp_trap, os_log, os_log_severity, syslog_facility, email, notify_on_login, script_computer_id, script_name)
values
   (62, '{109}', '{98}', '{61}', 0,
    '{109}', '1', 0, 5, 22, '3', 1, '0', '0', '0', '8', '0', {9}, -1, {9})
;

insert into t_alert_definition (alert_id, creator, name, description, last_modified, last_mod_user, enabled, product_id, alert_type, condition, threshold_type, threshold_value, snmp_trap, os_log, os_log_severity, syslog_facility, email, notify_on_login, script_computer_id, script_name)
values
   (102, '{109}', '{99}', '{63}', 0, '{109}',
    '1', 0, 2, 15, '1', 4, '0', '0', '0', '8', '0', {9}, -1, {9})
;

insert into t_res_attribute (resource_id, resource_type, attribute_id, attribute_type, exclude) values
   (4, 0, 102, 17, '0')
;

insert into t_alert_definition (alert_id, creator, name, description, last_modified, last_mod_user, enabled, product_id, alert_type, condition, threshold_type, threshold_value, snmp_trap, os_log, os_log_severity, syslog_facility, email, notify_on_login, script_computer_id, script_name)
values
   (103, '{109}', '{100}', '{40}', 0, '{109}',
    '1', 0, 0, 0, '0', -1, '0', '0', '0', '8', '0', {9}, -1, {9})
;

insert into t_res_attribute (resource_id, resource_type, attribute_id, attribute_type, exclude) values
   (4, 0, 103, 16, '0')
;

insert into t_alert_definition (alert_id, creator, name, description, last_modified, last_mod_user, enabled, product_id, alert_type, condition, threshold_type, threshold_value, snmp_trap, os_log, os_log_severity, syslog_facility, email, notify_on_login, script_computer_id, script_name)
values
   (104, '{109}', '{101}', '{42}', 0, '{109}', '1', 0,
    1, 11, '0', -1, '0', '0', '0', '8', '0', {9}, -1, {9})
;


INSERT INTO T_RES_VENDOR (VENDOR_ID, VENDOR_NAME) VALUES(0, 'Unknown')
;

INSERT INTO T_RES_MODEL (MODEL_ID, MODEL_NAME) VALUES(0, 'Unknown')
;

INSERT INTO T_ALERT_DEFINITION 
  VALUES (116, '{109}', '{115}', 
          '{116}', 0,
          '{109}', '1', 0, 30, 103, '0', -1, '0', '0',
          '0', '8', '0', {9}, -1, {9},'0','0')
;

INSERT INTO T_ALERT_DEFINITION
  VALUES (117, '{109}', '{115}', 
          '{116}', 0,
          '{109}', '1', 0, 31, 107, '0', -1, '0', '0',
          '0', '8', '0', {9}, -1, {9},'0','0')
;

INSERT INTO T_ALERT_DEFINITION
  VALUES (118, '{109}', '{115}', 
          '{116}', 0,
          '{109}', '1', 0, 32, 106, '0', -1, '0', '0',
          '0', '8', '0', {9}, -1, {9},'0','0')
;



		
