/****************************************** {COPYRIGHT-TOP} **
* Aperi Storage Manager
* (C) Copyright Eclipse contributors and others. 2007
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
******************************************* {COPYRIGHT-END} **/
var controls;
var state_machine;
function disableControl(control) {
	control.disabled = true;
	control.checked = false;
}
function disableAllCBs() {
	for (var prop in controls) {
		if (prop.match(/CB$/)) {
			disableControl(controls[prop]);
		}
	}
}
function enableAllCBs() {
	for (var prop in controls) {
		if (prop.match(/CB$/)) {
			controls[prop].disabled = false;
		}
	}
}

dojo.addOnLoad(function (){
	controls = {
		noRestrictionsRadio: document.getElementById('noRestrictionRadio'), 
		restrictedRadio: document.getElementById('restrictedRadio'),
		superUserCB: document.getElementById('superUser'),
		aperiAdminCB: document.getElementById('aperiAdmin'),
		diskAdminCB: document.getElementById('diskAdmin'),
		fabricAdminCB: document.getElementById('fabricAdmin'),
		dataAdminCB: document.getElementById('dataAdmin'),
		tapeAdminCB: document.getElementById('tapeAdmin'),
		diskOperCB: document.getElementById('diskOper'),
		fabricOperCB: document.getElementById('fabricOper'),
		dataOperCB: document.getElementById('dataOper'),
		tapeOperCB: document.getElementById('tapeOper')
	};
	state_machine = {
		noRestrictions: function() {
			controls.noRestrictionsRadio.disabled = reportAppConfig.readOnly;
			controls.noRestrictionsRadio.checked = true;
			controls.noRestrictionsRadio.onclick = disableAllCBs;
			controls.restrictedRadio.disabled = reportAppConfig.readOnly;
			controls.restrictedRadio.onclick = state_machine.openRestrictions;
			controls.restrictedRadio.checked= false;
			disableAllCBs();
			controls.superUserCB.onclick = state_machine.superUser;
			controls.aperiAdminCB.onclick = state_machine.aperiAdmin;
			controls.diskAdminCB.onclick = state_machine.theRest;
			controls.fabricAdminCB.onclick = state_machine.theRest;
			controls.dataAdminCB.onclick = state_machine.theRest;
			controls.tapeAdminCB.onclick = state_machine.theRest;
			controls.diskOperCB.onclick = state_machine.theRest;
			controls.fabricOperCB.onclick = state_machine.theRest;
			controls.dataOperCB.onclick = state_machine.theRest;
			controls.tapeOperCB.onclick = state_machine.theRest;
		},
		openRestrictions: function () {
			enableAllCBs();
		},
		superUser: function (){
			if (controls.superUserCB.checked) {
				for (var prop in controls) {
					if (prop.match(/(AdminCB|OperCB)$/)) {
						disableControl(controls[prop]);
					}
				}
			} else {
				for (var prop in controls) {
					if (prop.match(/(AdminCB|OperCB)$/)) {
						controls[prop].disabled=false;
					}
				}
			}
		},
		aperiAdmin: function (){
			if (controls.aperiAdminCB.checked) {
				disableControl(controls.superUserCB);
				for (var prop in controls) {
					if (prop.match(/(AdminCB|OperCB)$/) && controls[prop] != controls.aperiAdminCB) {
						disableControl(controls[prop]);
					}
				}
			} else {
				controls.superUserCB.disabled=false;
				for (var prop in controls) {
					if (prop.match(/(AdminCB|OperCB)$/) && controls[prop] != controls.aperiAdminCB) {
						controls[prop].disabled = false;
					}
				}
			}
		},
		theRest: function(event) {
			// figure out the control that originated the event
			if (event) { // DOM Event Model
				// dojo.debug("DOM Event Model");
				var source = event.target;
			} else if (window.event) { // IE Event Model
				// dojo.debug("IE Event Model");
				var source = window.event.srcElement;
			} else {
				alert("Unknown browser event model. Try IE or Mozilla.");
			}
			// figure out who my 'other' controls is e.g. if the source is diskAdmin then other is diskOper
			// dojo.debug("theRest: "+source.id);
			if (source.id.match(/(Admin|Oper)/)) {
				var bd = source.id.match(/(.*)(Admin|Oper)/);
			} else { // Firefox hack the global event doesn't get updated for CB's
				var bd = hackage.match(/(.*)(Admin|Oper)/);
			}
			if (bd[2] == "Admin") {
				var other = controls[bd[1]+"OperCB"];
			} else {
				var other = controls[bd[1]+"AdminCB"];
			}
			// are we coming or going?
			if (source.checked) {
				disableControl(controls.superUserCB);
				disableControl(controls.aperiAdminCB);
				disableControl(other);
			} else {
				other.disabled = false;
				// if none of the siblings are checked we need to activate the superUser and aperiAdmin CBs
				var others=false;
				for (var prop in controls) {
					if (prop.match(/(AdminCB|OperCB)$/)) {
						if (controls[prop].checked) {
							others = true;
							break;
						}
					}
				}
				if (!others) {
					controls.superUserCB.disabled = false;
					controls.aperiAdminCB.disabled = false;
				}
			}
		}
	};
	state_machine.noRestrictions();
});

reportAppConfig.consumers.push(
	function() {
		if (reportAppConfig.report) with (reportAppConfig.report) {
			if (roles.length > 0) {
				if (controls.restrictedRadio) {
					if (reportAppConfig.readOnly) {
						controls.restrictedRadio.checked = true;
					} else {
						controls.restrictedRadio.click();
					}
				}
				for (role in roles) {
					// dojo.debug(roles[role]+"CB");
					hackage = roles[role];
					if (reportAppConfig.readOnly) {
						controls[roles[role]+"CB"].checked = true;
					} else {
						controls[roles[role]+"CB"].click();
					}
				}
			} else {
				if (controls.noRestrictionsRadio) {
					if (reportAppConfig.readOnly) {
						controls.noRestrictionsRadio.checked = true;
					} else {
						controls.noRestrictionsRadio.click();
					}
				}
			}
		}
	}
);

reportAppConfig.validators.push(
	function(targetForm) {
		return true;
	}
);


