/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.eclipse.equinox.http.servlet.internal.DefaultHttpContext;
import org.eclipse.equinox.http.servlet.internal.ProxyServlet;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

public class HttpServiceImpl
implements HttpService {
    private Bundle bundle;
    private ProxyServlet proxy;
    Set aliases = new HashSet();

    public HttpServiceImpl(Bundle bundle, ProxyServlet proxyServlet) {
        this.bundle = bundle;
        this.proxy = proxyServlet;
    }

    public synchronized void unregisterAliases() {
        for (String string : this.aliases) {
            this.proxy.unregister(string, false);
        }
        this.aliases.clear();
    }

    public synchronized void registerServlet(String string, Servlet servlet, Dictionary dictionary, HttpContext httpContext) throws ServletException, NamespaceException {
        if (httpContext == null) {
            httpContext = this.createDefaultHttpContext();
        }
        this.proxy.registerServlet(string, servlet, dictionary, httpContext, this.bundle);
        this.aliases.add(string);
    }

    public synchronized void registerResources(String string, String string2, HttpContext httpContext) throws NamespaceException {
        if (httpContext == null) {
            httpContext = this.createDefaultHttpContext();
        }
        this.proxy.registerResources(string, string2, httpContext);
        this.aliases.add(string);
    }

    public synchronized void unregister(String string) {
        if (!this.aliases.remove(string)) {
            throw new IllegalArgumentException("Alias not found.");
        }
        this.proxy.unregister(string, true);
    }

    public HttpContext createDefaultHttpContext() {
        return new DefaultHttpContext(this.bundle);
    }
}

