/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.eclipse.equinox.http.servlet.internal.ProxyContext;
import org.eclipse.equinox.http.servlet.internal.RequestDispatcherAdaptor;
import org.osgi.service.http.HttpContext;

public class ServletContextAdaptor
implements ServletContext {
    private ServletContext servletContext;
    HttpContext httpContext;
    private AccessControlContext acc;
    private ProxyContext proxyContext;

    public ServletContextAdaptor(ProxyContext proxyContext, ServletContext servletContext, HttpContext httpContext, AccessControlContext accessControlContext) {
        this.servletContext = servletContext;
        this.httpContext = httpContext;
        this.acc = accessControlContext;
        this.proxyContext = proxyContext;
    }

    public Set getResourcePaths(String string) {
        if (string == null || !string.startsWith("/")) {
            return null;
        }
        try {
            Method method = this.httpContext.getClass().getMethod("getResourcePaths", String.class);
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return (Set)method.invoke((Object)this.httpContext, string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object getAttribute(String string) {
        Dictionary dictionary = this.proxyContext.getContextAttributes(this.httpContext);
        return dictionary.get(string);
    }

    public Enumeration getAttributeNames() {
        Dictionary dictionary = this.proxyContext.getContextAttributes(this.httpContext);
        return dictionary.keys();
    }

    public void setAttribute(String string, Object object) {
        Dictionary dictionary = this.proxyContext.getContextAttributes(this.httpContext);
        dictionary.put(string, object);
    }

    public void removeAttribute(String string) {
        Dictionary dictionary = this.proxyContext.getContextAttributes(this.httpContext);
        dictionary.remove(string);
    }

    public String getMimeType(String string) {
        String string2 = this.httpContext.getMimeType(string);
        return string2 != null ? string2 : this.servletContext.getMimeType(string);
    }

    public URL getResource(final String string) {
        try {
            return (URL)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return ServletContextAdaptor.this.httpContext.getResource(string);
                }
            }, this.acc);
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.log(privilegedActionException.getException().getMessage(), privilegedActionException.getException());
            return null;
        }
    }

    public InputStream getResourceAsStream(String string) {
        URL uRL = this.getResource(string);
        if (uRL != null) {
            try {
                return uRL.openStream();
            }
            catch (IOException iOException) {
                this.log("Error opening stream for resource '" + string + "'", iOException);
            }
        }
        return null;
    }

    public ServletContext getContext(String string) {
        return this.servletContext.getContext(string);
    }

    public String getInitParameter(String string) {
        return this.servletContext.getInitParameter(string);
    }

    public Enumeration getInitParameterNames() {
        return this.servletContext.getInitParameterNames();
    }

    public int getMajorVersion() {
        return this.servletContext.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.servletContext.getMinorVersion();
    }

    public RequestDispatcher getNamedDispatcher(String string) {
        return new RequestDispatcherAdaptor(this.servletContext.getNamedDispatcher(string));
    }

    public String getRealPath(String string) {
        return this.servletContext.getRealPath(string);
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        return new RequestDispatcherAdaptor(this.servletContext.getRequestDispatcher(String.valueOf(this.proxyContext.getServletPath()) + string));
    }

    public String getServerInfo() {
        return this.servletContext.getServerInfo();
    }

    public Servlet getServlet(String string) throws ServletException {
        return this.servletContext.getServlet(string);
    }

    public String getServletContextName() {
        return this.servletContext.getServletContextName();
    }

    public Enumeration getServletNames() {
        return this.servletContext.getServletNames();
    }

    public Enumeration getServlets() {
        return this.servletContext.getServlets();
    }

    public void log(Exception exception, String string) {
        this.servletContext.log(exception, string);
    }

    public void log(String string, Throwable throwable) {
        this.servletContext.log(string, throwable);
    }

    public void log(String string) {
        this.servletContext.log(string);
    }

    public String getContextPath() {
        try {
            Method method = this.servletContext.getClass().getMethod("getContextPath", null);
            return String.valueOf((String)method.invoke((Object)this.servletContext, null)) + this.proxyContext.getServletPath();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

