/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v2;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentWriter;
import org.eclipse.birt.report.engine.internal.document.IPageHintWriter;
import org.eclipse.birt.report.engine.presentation.IPageHint;

public class PageHintWriterV2
implements IPageHintWriter {
    protected ReportDocumentWriter document;
    protected RAOutputStream indexStream;
    protected RAOutputStream hintsStream;
    private ByteArrayOutputStream writeBuffer = new ByteArrayOutputStream();
    private DataOutputStream hintBuffer = new DataOutputStream(this.writeBuffer);

    public PageHintWriterV2(ReportDocumentWriter document) {
        this.document = document;
    }

    public void open() throws IOException {
        IDocArchiveWriter writer = this.document.getArchive();
        this.hintsStream = writer.createRandomAccessStream("/pages");
        this.indexStream = writer.createRandomAccessStream("/pages_index");
    }

    public void close() {
        try {
            if (this.hintsStream != null) {
                this.hintsStream.close();
                this.hintsStream = null;
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            if (this.indexStream != null) {
                this.indexStream.close();
                this.indexStream = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writePageHint(IPageHint pageHint) throws IOException {
        long offset = this.hintsStream.getOffset();
        this.indexStream.seek(pageHint.getPageNumber() * 8L);
        this.indexStream.writeLong(offset);
        this.writeBuffer.reset();
        pageHint.writeObject(this.hintBuffer);
        this.hintsStream.write(this.writeBuffer.toByteArray());
    }

    public void writeTotalPage(long totalPage) throws IOException {
        this.indexStream.seek(0L);
        this.indexStream.writeLong(totalPage);
    }
}

