/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.layout.ILayoutContext;
import org.eclipse.birt.report.engine.layout.IStackingLayoutManager;
import org.eclipse.birt.report.engine.layout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.layout.pdf.PDFAbstractLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;

public abstract class PDFStackingLM
extends PDFAbstractLM
implements IStackingLayoutManager,
ILayoutContext {
    protected int nMaxWidth = -1;
    protected int nMaxHeight = -1;
    protected int maxAvaWidth = 0;
    protected int maxAvaHeight = 0;
    protected int currentIP = 0;
    protected int currentBP = 0;
    protected int offsetX = 0;
    protected int offsetY = 0;
    protected ContainerArea root;
    protected PDFAbstractLM child;
    protected int minHeight = 0;
    protected int minWidth = 0;

    public int getMaxAvaWidth() {
        return this.maxAvaWidth;
    }

    public int getMaxAvaHeight() {
        return this.maxAvaHeight;
    }

    public int getCurrentIP() {
        return this.currentIP;
    }

    public int getCurrentBP() {
        return this.currentBP;
    }

    public void setCurrentBP(int bp) {
        this.currentBP = bp;
    }

    public void setCurrentIP(int ip) {
        this.currentIP = ip;
    }

    public void setMaxAvaHeight(int height) {
        this.maxAvaHeight = height;
    }

    public void setMaxAvaWidth(int width) {
        this.maxAvaWidth = width;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(int x) {
        this.offsetX = x;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(int y) {
        this.offsetY = y;
    }

    public PDFStackingLM(PDFLayoutEngineContext context, PDFStackingLM parent, IContent content, IReportItemExecutor executor) {
        super(context, parent, content, executor);
    }

    protected boolean layoutChildren() {
        this.newContext();
        boolean childBreak = false;
        childBreak = this.traverseChildren();
        if (!childBreak) {
            this.isLast = true;
        }
        if (!this.isRootEmpty()) {
            this.closeLayout();
            childBreak = !this.submitRoot(childBreak) || childBreak;
        }
        return childBreak;
    }

    protected boolean isRootEmpty() {
        return this.root == null || this.root.getChildrenCount() <= 0;
    }

    protected abstract boolean traverseChildren();

    protected boolean submitRoot(boolean childBreak) {
        boolean ret = true;
        if (this.parent != null) {
            ret = this.parent.addArea(this.root);
            if (ret) {
                this.root = null;
            }
        } else if (this.content != null) {
            this.content.setExtension(1, this.root);
            this.root = null;
        }
        return ret;
    }

    protected abstract void newContext();

    protected abstract void closeLayout();

    protected abstract void createRoot();

    public boolean isPageEmpty() {
        if (!this.isRootEmpty()) {
            return false;
        }
        if (this.parent != null) {
            return this.parent.isPageEmpty();
        }
        return true;
    }
}

