/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import org.eclipse.birt.report.engine.content.IBandContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IElement;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.executor.dom.DOMReportItemExecutor;
import org.eclipse.birt.report.engine.layout.IBlockStackingLayoutManager;
import org.eclipse.birt.report.engine.layout.IPDFTableLayoutManager;
import org.eclipse.birt.report.engine.layout.area.IArea;
import org.eclipse.birt.report.engine.layout.pdf.PDFBlockStackingLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFStackingLM;

public class PDFTableBandLM
extends PDFBlockStackingLM
implements IBlockStackingLayoutManager {
    protected IPDFTableLayoutManager tbl = this.getTableLayoutManager();
    protected int groupLevel;
    protected int type;
    protected boolean repeatHeader = false;

    public PDFTableBandLM(PDFLayoutEngineContext context, PDFStackingLM parent, IContent content, IReportItemExecutor executor) {
        super(context, parent, content, executor);
        IElement pContent = content.getParent();
        if (pContent instanceof IGroupContent) {
            IGroupContent groupContent = (IGroupContent)pContent;
            this.groupLevel = groupContent.getGroupLevel();
            this.repeatHeader = groupContent.isHeaderRepeat();
            this.type = ((IBandContent)content).getBandType();
            if (this.type == 3 && !(executor instanceof DOMReportItemExecutor) && this.repeatHeader) {
                this.execute(executor, content);
                executor.close();
                groupContent.getChildren().add(content);
                this.executor = new DOMReportItemExecutor(content);
                this.executor.execute();
            }
        } else if (pContent instanceof ITableContent) {
            ITableContent tableContent = (ITableContent)pContent;
            this.repeatHeader = tableContent.isHeaderRepeat();
            this.type = ((IBandContent)content).getBandType();
            if (this.type == 1 && !(executor instanceof DOMReportItemExecutor) && this.repeatHeader) {
                this.execute(executor, content);
                executor.close();
                tableContent.getChildren().add(content);
                this.executor = new DOMReportItemExecutor(content);
                this.executor.execute();
            }
        }
    }

    protected boolean checkAvailableSpace() {
        boolean availableSpace = super.checkAvailableSpace();
        if (availableSpace && this.tbl != null) {
            this.tbl.setTableCloseStateAsForced();
        }
        return availableSpace;
    }

    protected boolean traverseChildren() {
        if (this.isFirst && this.groupLevel >= 0 && this.type == 4) {
            this.tbl.updateUnresolvedCell(this.groupLevel, false);
        }
        this.isFirst = false;
        boolean childBreak = super.traverseChildren();
        if (!childBreak && this.groupLevel >= 0 && this.type == 4) {
            this.tbl.updateUnresolvedCell(this.groupLevel, true);
        }
        return childBreak;
    }

    public int getCurrentBP() {
        return this.parent.getCurrentBP();
    }

    protected boolean submitRoot(boolean childBreak) {
        return true;
    }

    public int getCurrentIP() {
        return this.parent.getCurrentIP();
    }

    public int getMaxAvaHeight() {
        return this.parent.getMaxAvaHeight();
    }

    public int getMaxAvaWidth() {
        return this.parent.getMaxAvaWidth();
    }

    public int getOffsetX() {
        return this.parent.getOffsetX();
    }

    public int getOffsetY() {
        return this.parent.getOffsetY();
    }

    public void setCurrentBP(int bp) {
        this.parent.setCurrentBP(bp);
    }

    public void setCurrentIP(int ip) {
        this.parent.setCurrentIP(ip);
    }

    public void setMaxAvaHeight(int height) {
        this.parent.setMaxAvaHeight(height);
    }

    public void setMaxAvaWidth(int width) {
        this.parent.setMaxAvaWidth(width);
    }

    public void setOffsetX(int x) {
        this.parent.setOffsetX(x);
    }

    public void setOffsetY(int y) {
        this.parent.setOffsetY(y);
    }

    public boolean addArea(IArea area) {
        return this.parent.addArea(area);
    }

    protected void createRoot() {
    }

    protected void newContext() {
    }

    protected IReportItemExecutor createExecutor() {
        return this.executor;
    }

    protected boolean canPageBreak() {
        if (!this.allowPageBreak()) {
            return false;
        }
        return super.canPageBreak();
    }

    protected boolean allowPageBreak() {
        if (this.type == 3 || this.type == 1) {
            return !this.repeatHeader;
        }
        return true;
    }
}

