/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.layout.IBlockStackingLayoutManager;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.layout.pdf.PDFBlockStackingLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFStackingLM;

public class PDFTextInlineBlockLM
extends PDFBlockStackingLM
implements IBlockStackingLayoutManager {
    public PDFTextInlineBlockLM(PDFLayoutEngineContext context, PDFStackingLM parent, IContent content, IReportItemExecutor executor) {
        super(context, parent, content, executor);
    }

    protected void newContext() {
        this.createRoot();
        IStyle areaStyle = this.root.getStyle();
        this.validateBoxProperty(areaStyle, this.parent.getMaxAvaWidth(), this.context.getMaxHeight());
        this.setOffsetX(this.root.getContentX());
        this.setOffsetY(this.isFirst ? this.root.getContentY() : 0);
        if (null != this.parent) {
            int maxWidth = this.parent.getMaxAvaWidth();
            int leftWidth = maxWidth - this.parent.getCurrentIP();
            this.calculateSpecifiedWidth();
            int width = 0;
            width = this.specifiedWidth > 0 ? Math.min(this.specifiedWidth, maxWidth) : (leftWidth > maxWidth / 4 ? leftWidth : maxWidth);
            this.root.setAllocatedWidth(width);
            this.setMaxAvaWidth(this.root.getContentWidth());
            this.root.setAllocatedHeight(this.parent.getMaxAvaHeight() - this.parent.getCurrentBP());
            this.setMaxAvaHeight(this.root.getContentHeight());
        }
        this.setCurrentBP(0);
        this.setCurrentIP(0);
    }

    protected void createRoot() {
        this.root = (ContainerArea)AreaFactory.createBlockContainer(this.content);
    }
}

