/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import org.eclipse.birt.report.model.api.AutoTextHandle;
import org.eclipse.birt.report.model.api.CascadingParameterGroupHandle;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.FreeFormHandle;
import org.eclipse.birt.report.model.api.GraphicMasterPageHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.IllegalOperationException;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.LineHandle;
import org.eclipse.birt.report.model.api.ListGroupHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.RectangleHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.ScriptDataSetHandle;
import org.eclipse.birt.report.model.api.ScriptDataSourceHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TextDataHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.command.ExtendsException;
import org.eclipse.birt.report.model.api.command.InvalidParentException;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.AutoText;
import org.eclipse.birt.report.model.elements.CascadingParameterGroup;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.DataItem;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.FreeForm;
import org.eclipse.birt.report.model.elements.GraphicMasterPage;
import org.eclipse.birt.report.model.elements.GridItem;
import org.eclipse.birt.report.model.elements.ImageItem;
import org.eclipse.birt.report.model.elements.JointDataSet;
import org.eclipse.birt.report.model.elements.Label;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.LineItem;
import org.eclipse.birt.report.model.elements.ListGroup;
import org.eclipse.birt.report.model.elements.ListItem;
import org.eclipse.birt.report.model.elements.OdaDataSet;
import org.eclipse.birt.report.model.elements.OdaDataSource;
import org.eclipse.birt.report.model.elements.ParameterGroup;
import org.eclipse.birt.report.model.elements.RectangleItem;
import org.eclipse.birt.report.model.elements.ScalarParameter;
import org.eclipse.birt.report.model.elements.ScriptDataSet;
import org.eclipse.birt.report.model.elements.ScriptDataSource;
import org.eclipse.birt.report.model.elements.SimpleMasterPage;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.elements.TableColumn;
import org.eclipse.birt.report.model.elements.TableGroup;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.elements.TableRow;
import org.eclipse.birt.report.model.elements.TextDataItem;
import org.eclipse.birt.report.model.elements.TextItem;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.elements.interfaces.IOdaExtendableElementModel;
import org.eclipse.birt.report.model.extension.oda.ODAProviderFactory;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PeerExtensionElementDefn;
import org.eclipse.birt.report.model.util.ContentIterator;
import org.eclipse.birt.report.model.util.ElementStructureUtil;
import org.eclipse.birt.report.model.util.ModelUtil;

public class ElementFactory {
    protected final Module module;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ElementFactory(Module module) {
        this.module = module;
    }

    public DesignElementHandle newElement(String elementTypeName, String name) {
        ElementDefn elemDefn = (ElementDefn)MetaDataDictionary.getInstance().getElement(elementTypeName);
        if (elemDefn == null) {
            return this.newExtensionElement(elementTypeName, name);
        }
        DesignElement element = ModelUtil.newElement(this.module, elementTypeName, name);
        if (element == null) {
            return null;
        }
        return element.getHandle(this.module);
    }

    private DesignElementHandle newExtensionElement(String elementTypeName, String name) {
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        ExtensionElementDefn extDefn = (ExtensionElementDefn)dd.getExtension(elementTypeName);
        if (extDefn == null) {
            return null;
        }
        String extensionPoint = extDefn.getExtensionPoint();
        if ("org.eclipse.birt.report.model.reportItemModel".equalsIgnoreCase(extensionPoint)) {
            return this.newExtendedItem(name, elementTypeName);
        }
        return null;
    }

    public FreeFormHandle newFreeForm(String name) {
        FreeForm element = new FreeForm(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public DataItemHandle newDataItem(String name) {
        DataItem element = new DataItem(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public LabelHandle newLabel(String name) {
        Label element = new Label(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public AutoTextHandle newAutoText(String name) {
        AutoText element = new AutoText(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public ImageHandle newImage(String name) {
        ImageItem element = new ImageItem(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public ListGroupHandle newListGroup() {
        ListGroup element = new ListGroup();
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public ListHandle newList(String name) {
        ListItem element = new ListItem(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public GraphicMasterPageHandle newGraphicMasterPage(String name) {
        GraphicMasterPage element = new GraphicMasterPage(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public SimpleMasterPageHandle newSimpleMasterPage(String name) {
        SimpleMasterPage element = new SimpleMasterPage(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public ParameterGroupHandle newParameterGroup(String name) {
        ParameterGroup element = new ParameterGroup(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public CascadingParameterGroupHandle newCascadingParameterGroup(String name) {
        CascadingParameterGroup element = new CascadingParameterGroup(name);
        this.module.makeUniqueName(element);
        return (CascadingParameterGroupHandle)element.handle(this.module);
    }

    public ScalarParameterHandle newScalarParameter(String name) {
        ScalarParameter element = new ScalarParameter(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public SharedStyleHandle newStyle(String name) {
        Style element = new Style(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public TextItemHandle newTextItem(String name) {
        TextItem element = new TextItem(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public TableHandle newTableItem(String name) {
        TableItem element = new TableItem(name);
        this.module.makeUniqueName(element);
        element.refreshRenderModel(this.module);
        return element.handle(this.module);
    }

    public TableHandle newTableItem(String name, int columnNum) {
        return this.newTableItem(name, columnNum, 1, 1, 1);
    }

    public TableHandle newTableItem(String name, int columnNum, int headerRow, int detailRow, int footerRow) {
        TableRow row;
        int i;
        TableHandle tableHandle = this.newTableItem(name);
        TableItem table = (TableItem)tableHandle.getElement();
        columnNum = columnNum >= 0 ? columnNum : 0;
        headerRow = headerRow >= 0 ? headerRow : 0;
        footerRow = footerRow >= 0 ? footerRow : 0;
        detailRow = detailRow >= 0 ? detailRow : 0;
        for (i = 0; i < columnNum; ++i) {
            TableColumn column = new TableColumn();
            table.getSlot(4).add(column);
            column.setContainer(table, 4);
        }
        for (i = 0; i < headerRow; ++i) {
            row = (TableRow)this.newTableRow(columnNum).getElement();
            table.getSlot(0).add(row);
            row.setContainer(table, 0);
        }
        for (i = 0; i < footerRow; ++i) {
            row = (TableRow)this.newTableRow(columnNum).getElement();
            table.getSlot(3).add(row);
            row.setContainer(table, 3);
        }
        for (i = 0; i < detailRow; ++i) {
            row = (TableRow)this.newTableRow(columnNum).getElement();
            table.getSlot(2).add(row);
            row.setContainer(table, 2);
        }
        table.refreshRenderModel(this.module);
        return tableHandle;
    }

    public TableGroupHandle newTableGroup() {
        TableGroup element = new TableGroup();
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public ColumnHandle newTableColumn() {
        TableColumn element = new TableColumn();
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public RowHandle newTableRow() {
        TableRow element = new TableRow();
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public RowHandle newTableRow(int cellNum) {
        RowHandle rowHandle = this.newTableRow();
        TableRow row = (TableRow)rowHandle.getElement();
        for (int j = 0; j < cellNum; ++j) {
            Cell cell = new Cell();
            row.getSlot(0).add(cell);
            cell.setContainer(row, 0);
        }
        return rowHandle;
    }

    public CellHandle newCell() {
        Cell element = new Cell();
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public GridHandle newGridItem(String name) {
        GridItem element = new GridItem(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public GridHandle newGridItem(String name, int columnNum, int rowNum) {
        int i;
        GridHandle gridHandle = this.newGridItem(name);
        GridItem grid = (GridItem)gridHandle.getElement();
        columnNum = columnNum >= 0 ? columnNum : 0;
        rowNum = rowNum >= 0 ? rowNum : 0;
        for (i = 0; i < columnNum; ++i) {
            TableColumn column = new TableColumn();
            grid.getSlot(0).add(column);
            column.setContainer(grid, 0);
        }
        for (i = 0; i < rowNum; ++i) {
            TableRow row = (TableRow)this.newTableRow(columnNum).getElement();
            grid.getSlot(1).add(row);
            row.setContainer(grid, 1);
        }
        return gridHandle;
    }

    public LineHandle newLineItem(String name) {
        LineItem element = new LineItem(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public RectangleHandle newRectangle(String name) {
        RectangleItem element = new RectangleItem(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public TextDataHandle newTextData(String name) {
        TextDataItem element = new TextDataItem(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public ExtendedItemHandle newExtendedItem(String name, String extensionName) {
        try {
            return this.newExtendedItem(name, extensionName, null);
        }
        catch (ExtendsException e) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
    }

    private ExtendedItemHandle newExtendedItem(String name, String extensionName, ExtendedItemHandle parent) throws ExtendsException {
        ExtendedItemHandle handle;
        block6: {
            MetaDataDictionary dd = MetaDataDictionary.getInstance();
            ExtensionElementDefn extDefn = (ExtensionElementDefn)dd.getExtension(extensionName);
            if (extDefn == null) {
                return null;
            }
            if (parent != null && !$assertionsDisabled && ((ExtendedItem)parent.getElement()).getExtDefn() != extDefn) {
                throw new AssertionError();
            }
            if (!(extDefn instanceof PeerExtensionElementDefn)) {
                throw new IllegalOperationException("Only report item extension can be created through this method.");
            }
            ExtendedItem element = new ExtendedItem(name);
            if (parent != null) {
                element.getHandle(this.module).setExtends(parent);
            }
            element.setProperty("extensionName", (Object)extensionName);
            this.module.makeUniqueName(element);
            handle = element.handle(this.module);
            try {
                handle.loadExtendedElement();
            }
            catch (ExtendedElementException e) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        return handle;
    }

    public ScriptDataSourceHandle newScriptDataSource(String name) {
        ScriptDataSource element = new ScriptDataSource(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public ScriptDataSetHandle newScriptDataSet(String name) {
        ScriptDataSet element = new ScriptDataSet(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public OdaDataSourceHandle newOdaDataSource(String name) {
        OdaDataSource element = new OdaDataSource(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public OdaDataSourceHandle newOdaDataSource(String name, String extensionID) {
        if (extensionID != null) {
            if (ODAProviderFactory.getInstance().createODAProvider(null, extensionID) == null) {
                return null;
            }
            if (!ODAProviderFactory.getInstance().createODAProvider(null, extensionID).isValidODADataSourceExtensionID(extensionID)) {
                return null;
            }
        }
        OdaDataSource element = new OdaDataSource(name);
        this.module.makeUniqueName(element);
        element.setProperty("extensionID", (Object)extensionID);
        return element.handle(this.module);
    }

    public OdaDataSetHandle newOdaDataSet(String name) {
        OdaDataSet element = new OdaDataSet(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public JointDataSetHandle newJointDataSet(String name) {
        JointDataSet element = new JointDataSet(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    public OdaDataSetHandle newOdaDataSet(String name, String extensionID) {
        if (extensionID != null) {
            if (ODAProviderFactory.getInstance().createODAProvider(null, extensionID) == null) {
                return null;
            }
            if (!ODAProviderFactory.getInstance().createODAProvider(null, extensionID).isValidODADataSetExtensionID(extensionID)) {
                return null;
            }
        }
        OdaDataSet element = new OdaDataSet(name);
        this.module.makeUniqueName(element);
        element.setProperty("extensionID", (Object)extensionID);
        return element.handle(this.module);
    }

    public DesignElementHandle newElementFrom(DesignElementHandle baseElement, String name) throws ExtendsException {
        if (baseElement == null) {
            return null;
        }
        if (baseElement.getRoot().getElement() == this.module) {
            return this.newElementFrom(name, baseElement);
        }
        Module root = (Module)baseElement.getRoot().getElement();
        if (root instanceof Library) {
            Library lib = this.module.getLibraryByLocation(root.getLocation());
            if (lib == null) {
                throw new InvalidParentException(null, baseElement.getElement(), "Error.InvalidParentException.PARENT_NOT_INCLUDE");
            }
            DesignElement base = lib.getElementByID(baseElement.getID());
            if (base == null || base.getDefn() != baseElement.getElement().getDefn()) {
                throw new InvalidParentException(null, baseElement.getName(), "Error.InvalidParentException.PARENT_NOT_FOUND");
            }
            return this.newElementFrom(name, base.getHandle(lib));
        }
        return null;
    }

    private DesignElementHandle newElementFrom(String name, DesignElementHandle baseElement) throws ExtendsException {
        DesignElementHandle childElement = null;
        if (baseElement instanceof ExtendedItemHandle) {
            String extensionName = baseElement.getStringProperty("extensionName");
            childElement = this.newExtendedItem(name, extensionName, (ExtendedItemHandle)baseElement);
            ElementStructureUtil.refreshStructureFromParent(this.module, childElement.getElement());
        } else {
            childElement = this.newElement(baseElement.getElement().getElementName(), name);
            if (childElement.getElement() instanceof IOdaExtendableElementModel) {
                String extensionId = (String)baseElement.getProperty("extensionID");
                childElement.getElement().setProperty("extensionID", (Object)extensionId);
            }
            childElement.setExtends(baseElement);
            ElementStructureUtil.refreshStructureFromParent(this.module, childElement.getElement());
            this.renameForVirtualElements(childElement.getElement());
        }
        return childElement;
    }

    private void renameForVirtualElements(DesignElement element) {
        ContentIterator contentIter = new ContentIterator(element);
        while (contentIter.hasNext()) {
            DesignElement virtualElement = (DesignElement)contentIter.next();
            this.module.makeUniqueName(virtualElement);
        }
    }

    public ThemeHandle newTheme(String name) {
        Theme element = new Theme(name);
        this.module.makeUniqueName(element);
        return element.handle(this.module);
    }

    static {
        $assertionsDisabled = !ElementFactory.class.desiredAssertionStatus();
    }
}

