/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.command;

import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.i18n.ModelMessages;

public class ContentException
extends SemanticException {
    private static final long serialVersionUID = 6436296237110208952L;
    protected int slot = 0;
    protected DesignElement content = null;
    public static final String DESIGN_EXCEPTION_STRUCTURE_CHANGE_FORBIDDEN = "Error.ContentException.STRUCTURE_CHANGE_FORBIDDEN";
    public static final String DESIGN_EXCEPTION_SLOT_NOT_FOUND = "Error.ContentException.SLOT_NOT_FOUND";
    public static final String DESIGN_EXCEPTION_WRONG_TYPE = "Error.ContentException.WRONG_TYPE";
    public static final String DESIGN_EXCEPTION_DROP_FORBIDDEN = "Error.ContentException.DROP_FORBIDDEN";
    public static final String DESIGN_EXCEPTION_CONTENT_NOT_FOUND = "Error.ContentException.CONTENT_NOT_FOUND";
    public static final String DESIGN_EXCEPTION_NOT_CONTAINER = "Error.ContentException.NOT_CONTAINER";
    public static final String DESIGN_EXCEPTION_SLOT_IS_FULL = "Error.ContentException.SLOT_IS_FULL";
    public static final String DESIGN_EXCEPTION_RECURSIVE = "Error.ContentException.RECURSIVE";
    public static final String DESIGN_EXCEPTION_HAS_NO_CONTAINER = "Error.ContentException.HAS_NO_CONTAINER";
    public static final String DESIGN_EXCEPTION_MOVE_FORBIDDEN = "Error.ContentException.MOVE_FORBIDDEN";
    public static final String DESIGN_EXCEPTION_HAS_DESCENDENTS = "Error.ContentException.HAS_DESCENDENTS";
    public static final String DESIGN_EXCEPTION_INVALID_CONTEXT_CONTAINMENT = "Error.ContentException.INVALID_CONTEXT_CONTAINMENT";
    public static final String DESIGN_EXCEPTION_CONTENT_NAME_REQUIRED = "Error.ContentException.CONTENT_NAME_REQUIRED";
    public static final String DESIGN_EXCEPTION_INVALID_TEMPLATE_ELEMENT = "Error.ContentException.INVALID_TEMPLATE_ELEMENT";
    public static final String DESIGN_EXCEPTION_TEMPLATE_TRANSFORM_FORBIDDEN = "Error.ContentException.TEMPLATE_TRANSFORM_FORBIDDEN";

    public ContentException(DesignElement element, int slotID, String errCode) {
        super(element, errCode);
        this.slot = slotID;
    }

    public ContentException(DesignElement element, int slotID, DesignElement content, String errCode) {
        super(element, errCode);
        this.slot = slotID;
        this.content = content;
    }

    public int getSlot() {
        return this.slot;
    }

    public String getLocalizedMessage() {
        if (this.sResourceKey == DESIGN_EXCEPTION_SLOT_NOT_FOUND) {
            return ModelMessages.getMessage(this.sResourceKey, new String[]{ContentException.getElementName(this.element), String.valueOf(this.slot)});
        }
        if (this.sResourceKey == DESIGN_EXCEPTION_NOT_CONTAINER || this.sResourceKey == DESIGN_EXCEPTION_HAS_NO_CONTAINER || this.sResourceKey == DESIGN_EXCEPTION_MOVE_FORBIDDEN || this.sResourceKey == DESIGN_EXCEPTION_HAS_DESCENDENTS) {
            return ModelMessages.getMessage(this.sResourceKey, new String[]{ContentException.getElementName(this.element)});
        }
        if (this.sResourceKey == DESIGN_EXCEPTION_CONTENT_NOT_FOUND) {
            return ModelMessages.getMessage(this.sResourceKey, new String[]{ContentException.getElementName(this.content), this.element.getDefn().getSlot(this.slot).getName(), ContentException.getElementName(this.element)});
        }
        if (this.sResourceKey == DESIGN_EXCEPTION_RECURSIVE) {
            return ModelMessages.getMessage(this.sResourceKey, new String[]{ContentException.getElementName(this.content), ContentException.getElementName(this.element)});
        }
        if (this.sResourceKey == DESIGN_EXCEPTION_SLOT_IS_FULL) {
            return ModelMessages.getMessage(this.sResourceKey, new String[]{this.element.getDefn().getSlot(this.slot).getName(), ContentException.getElementName(this.element)});
        }
        if (this.sResourceKey == DESIGN_EXCEPTION_INVALID_CONTEXT_CONTAINMENT) {
            return ModelMessages.getMessage(this.sResourceKey, new String[]{ContentException.getElementName(this.content), this.element.getElementName(), this.element.getDefn().getSlot(this.slot).getName()});
        }
        if (this.sResourceKey == DESIGN_EXCEPTION_STRUCTURE_CHANGE_FORBIDDEN) {
            return ModelMessages.getMessage(this.sResourceKey, new String[]{ContentException.getElementName(this.element)});
        }
        if (this.sResourceKey == DESIGN_EXCEPTION_CONTENT_NAME_REQUIRED) {
            return ModelMessages.getMessage(this.sResourceKey, new String[]{ContentException.getElementName(this.content), this.element.getElementName(), this.element.getDefn().getSlot(this.slot).getName()});
        }
        if (this.sResourceKey == DESIGN_EXCEPTION_INVALID_TEMPLATE_ELEMENT) {
            return ModelMessages.getMessage(this.sResourceKey, new String[]{ContentException.getElementName(this.content), ContentException.getElementName(this.element), this.element.getDefn().getSlot(this.slot).getName()});
        }
        if (this.sResourceKey == DESIGN_EXCEPTION_WRONG_TYPE || this.sResourceKey == DESIGN_EXCEPTION_DROP_FORBIDDEN) {
            return ModelMessages.getMessage(this.sResourceKey, new String[]{ContentException.getElementName(this.element), ContentException.getElementName(this.content), this.element.getDefn().getSlot(this.slot).getName()});
        }
        return ModelMessages.getMessage(this.sResourceKey);
    }
}

