/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.Iterator;
import org.eclipse.birt.report.model.activity.AbstractElementCommand;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.command.TemplateException;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.command.ContentCommand;
import org.eclipse.birt.report.model.command.PropertyCommand;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.SimpleDataSet;
import org.eclipse.birt.report.model.elements.TemplateDataSet;
import org.eclipse.birt.report.model.elements.TemplateElement;
import org.eclipse.birt.report.model.elements.TemplateFactory;
import org.eclipse.birt.report.model.elements.TemplateParameterDefinition;
import org.eclipse.birt.report.model.elements.TemplateReportItem;
import org.eclipse.birt.report.model.elements.strategy.CopyForTemplatePolicy;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.util.ModelUtil;

public class TemplateCommand
extends AbstractElementCommand {
    static final /* synthetic */ boolean $assertionsDisabled;

    public TemplateCommand(Module module, DesignElement obj) {
        super(module, obj);
    }

    public void checkProperty(ElementPropertyDefn prop, Object value) throws PropertyValueException {
        TemplateParameterDefinition templateParam;
        if (value == null) {
            return;
        }
        if ((this.element instanceof ReportItem || this.element instanceof TemplateReportItem) && "refTemplateParameter".equals(prop.getName())) {
            if (!$assertionsDisabled && !(value instanceof ElementRefValue)) {
                throw new AssertionError();
            }
            if (((ElementRefValue)value).getElement() == null && !((templateParam = this.resolveTemplateParameterDefinition(this.module, ((ElementRefValue)value).getName())).getDefaultElement() instanceof ReportItem)) {
                throw new PropertyValueException(this.element, prop.getName(), value, "Error.PropertyValueException.INVALID_VALUE");
            }
        }
        if ((this.element instanceof SimpleDataSet || this.element instanceof TemplateDataSet) && "refTemplateParameter".equals(prop.getName())) {
            if (!$assertionsDisabled && !(value instanceof ElementRefValue)) {
                throw new AssertionError();
            }
            if (((ElementRefValue)value).getElement() == null && !((templateParam = this.resolveTemplateParameterDefinition(this.module, ((ElementRefValue)value).getName())).getDefaultElement() instanceof SimpleDataSet)) {
                throw new PropertyValueException(this.element, prop.getName(), value, "Error.PropertyValueException.INVALID_VALUE");
            }
        }
    }

    private TemplateParameterDefinition resolveTemplateParameterDefinition(Module module, String name) {
        ElementPropertyDefn prop = this.element.getPropertyDefn("refTemplateParameter");
        if (prop == null) {
            return null;
        }
        ElementDefn targetDefn = (ElementDefn)prop.getTargetElementType();
        DesignElement resolvedElement = module.resolveElement(name, targetDefn.getNameSpaceID(), (PropertyDefn)prop);
        return (TemplateParameterDefinition)resolvedElement;
    }

    public void checkAdd(Object content, int slotID) throws ContentException {
        Object obj = null;
        if (content instanceof DesignElement) {
            DesignElement element = (DesignElement)content;
            obj = element.getProperty(this.module, "refTemplateParameter");
            if (obj == null) {
                int count = ((DesignElement)content).getDefn().getSlotCount();
                for (int i = 0; i < count; ++i) {
                    ContainerSlot slot = ((DesignElement)content).getSlot(i);
                    Iterator iter = slot.iterator();
                    while (iter.hasNext()) {
                        Object eleObj = iter.next();
                        this.checkAdd(eleObj, slotID);
                    }
                }
            } else {
                this.addTemplateParameterDefinition(obj, (DesignElement)content, slotID);
            }
        }
    }

    private void addTemplateParameterDefinition(Object obj, DesignElement content, int slotID) throws ContentException {
        block16: {
            if (!$assertionsDisabled && !(obj instanceof ElementRefValue)) {
                throw new AssertionError();
            }
            ElementRefValue templateParam = (ElementRefValue)obj;
            if (templateParam.getElement() == null) {
                block14: {
                    if (content instanceof TemplateElement) {
                        throw new ContentException(this.element, slotID, content, "Error.ContentException.INVALID_TEMPLATE_ELEMENT");
                    }
                    try {
                        PropertyCommand cmd = new PropertyCommand(this.module, content);
                        cmd.clearProperty("refTemplateParameter");
                    }
                    catch (SemanticException e) {
                        if ($assertionsDisabled) break block14;
                        throw new AssertionError();
                    }
                }
                return;
            }
            if (!(content instanceof TemplateElement)) {
                block15: {
                    try {
                        if (this.needClearParameterDefinition(content, templateParam.getName())) {
                            PropertyCommand cmd = new PropertyCommand(this.module, content);
                            cmd.clearProperty("refTemplateParameter");
                        }
                    }
                    catch (SemanticException e) {
                        if ($assertionsDisabled) break block15;
                        throw new AssertionError();
                    }
                }
                return;
            }
            TemplateParameterDefinition definition = (TemplateParameterDefinition)templateParam.getElement();
            if (this.module.findTemplateParameterDefinition(templateParam.getName()) != definition) {
                try {
                    DesignElement copyTemplateParam = ModelUtil.getCopy(definition);
                    this.module.makeUniqueName(copyTemplateParam);
                    ContentCommand cmd = new ContentCommand(this.module, this.module);
                    cmd.add(copyTemplateParam, 8);
                    PropertyCommand propertyCmd = new PropertyCommand(this.module, content);
                    propertyCmd.setProperty("refTemplateParameter", (Object)copyTemplateParam);
                }
                catch (NameException e) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
                catch (SemanticException e) {
                    if ($assertionsDisabled) break block16;
                    throw new AssertionError();
                }
            }
        }
    }

    private boolean needClearParameterDefinition(DesignElement content, String parameterDefinitionName) {
        if (!($assertionsDisabled || content != null && parameterDefinitionName != null)) {
            throw new AssertionError();
        }
        TemplateParameterDefinition templateParam = this.module.findTemplateParameterDefinition(parameterDefinitionName);
        if (templateParam != null) {
            String type = templateParam.getAllowedType(this.module);
            IElementDefn allowedDefn = MetaDataDictionary.getInstance().getElement(type);
            if (content.getDefn().isKindOf(allowedDefn)) {
                return false;
            }
        }
        return true;
    }

    public TemplateElement createTemplateElement(DesignElement base, int slotID, String name) throws SemanticException {
        if (!$assertionsDisabled && base == null) {
            throw new AssertionError();
        }
        TemplateElement template = TemplateFactory.createTemplate(this.module, base, name);
        if (template == null) {
            throw new TemplateException(base, "Error.TemplateException.INVALID_TEMPLATE_ELEMENT_TYPE");
        }
        if (!(this.module instanceof ReportDesign)) {
            throw new TemplateException(this.module, "Error.TemplateException.TEMPLATE_ELEMENT_NOT_SUPPORTED");
        }
        ActivityStack stack = this.getActivityStack();
        stack.startTrans();
        try {
            this.createTemplateFromDesignElement(template, base);
            ContentCommand cmd = new ContentCommand(this.module, this.element);
            cmd.transformTemplate(base, template, slotID, true);
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
        return template;
    }

    private void createTemplateFromDesignElement(TemplateElement template, DesignElement base) {
        block17: {
            if (!($assertionsDisabled || base instanceof ReportItem || base instanceof SimpleDataSet)) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && template == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !(this.module instanceof ReportDesign)) {
                throw new AssertionError();
            }
            try {
                TemplateParameterDefinition templateParam = new TemplateParameterDefinition();
                this.module.makeUniqueName(templateParam);
                PropertyCommand propertyCmd = new PropertyCommand(this.module, templateParam);
                if (base instanceof SimpleDataSet) {
                    propertyCmd.setProperty("allowedType", (Object)"DataSet");
                } else {
                    propertyCmd.setProperty("allowedType", (Object)base.getElementName());
                }
                ContainerSlot defaultSlot = templateParam.getSlot(0);
                if (!$assertionsDisabled && defaultSlot == null) {
                    throw new AssertionError();
                }
                DesignElement defaultElement = null;
                defaultElement = (DesignElement)base.doClone(CopyForTemplatePolicy.getInstance());
                if (!$assertionsDisabled && defaultElement == null) {
                    throw new AssertionError();
                }
                ContentCommand contentCmd = null;
                TemplateParameterDefinition temp = defaultElement.getTemplateParameterElement(this.module);
                if (temp != null) {
                    propertyCmd = new PropertyCommand(this.module, defaultElement);
                    propertyCmd.setProperty("refTemplateParameter", null);
                    propertyCmd = new PropertyCommand(this.module, base);
                    propertyCmd.setProperty("refTemplateParameter", null);
                    if (!temp.hasReferences()) {
                        contentCmd = new ContentCommand(this.module, this.module);
                        contentCmd.remove(temp, 8);
                    }
                }
                contentCmd = new ContentCommand(this.module, templateParam);
                contentCmd.add(defaultElement, 0);
                contentCmd = new ContentCommand(this.module, this.module);
                contentCmd.add(templateParam, 8);
                propertyCmd = new PropertyCommand(this.module, template);
                propertyCmd.setProperty("refTemplateParameter", (Object)templateParam.getName());
            }
            catch (ContentException e) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            catch (NameException e) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            catch (SemanticException e) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            catch (CloneNotSupportedException e) {
                if ($assertionsDisabled) break block17;
                throw new AssertionError();
            }
        }
    }

    public void transformToReportItem(TemplateReportItem templateItem, ReportItem reportItem, int slotID) throws SemanticException {
        TemplateParameterDefinition templateparam = templateItem.getTemplateParameterElement(this.module);
        if (templateparam == null) {
            throw new TemplateException(templateItem, "Error.TemplateException.TRANSFORM_TO_REPORT_ITEM_FORBIDDEN");
        }
        this.module.rename(reportItem);
        ActivityStack stack = this.getActivityStack();
        stack.startTrans();
        try {
            PropertyCommand pcmd = new PropertyCommand(this.module, reportItem);
            pcmd.setProperty("refTemplateParameter", (Object)templateparam.getName());
            ContentCommand cmd = new ContentCommand(this.module, this.element);
            cmd.transformTemplate(templateItem, reportItem, slotID, false);
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    public void transformToDataSet(TemplateDataSet templateDataSet, SimpleDataSet dataSet, int slotID) throws SemanticException {
        TemplateParameterDefinition templateparam = templateDataSet.getTemplateParameterElement(this.module);
        if (templateparam == null) {
            throw new TemplateException(templateDataSet, "Error.TemplateException.TRANSFORM_TO_DATA_SET_FORBIDDEN");
        }
        ActivityStack stack = this.getActivityStack();
        stack.startTrans();
        try {
            PropertyCommand pcmd = new PropertyCommand(this.module, dataSet);
            pcmd.setProperty("refTemplateParameter", (Object)templateparam.getName());
            ContentCommand cmd = new ContentCommand(this.module, this.element);
            cmd.transformTemplate(templateDataSet, dataSet, slotID, false);
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    public TemplateElement revertToTemplate(DesignElement base, int slotID, String name) throws SemanticException {
        TemplateElement template;
        block6: {
            if (!$assertionsDisabled && base == null) {
                throw new AssertionError();
            }
            template = TemplateFactory.createTemplate(this.module, base, name);
            if (template == null) {
                throw new TemplateException(base, "Error.TemplateException.INVALID_TEMPLATE_ELEMENT_TYPE");
            }
            if (!(this.module instanceof ReportDesign)) {
                throw new TemplateException(this.module, "Error.TemplateException.TEMPLATE_ELEMENT_NOT_SUPPORTED");
            }
            TemplateParameterDefinition templateParam = base.getTemplateParameterElement(this.module);
            if (templateParam == null) {
                throw new TemplateException(base, "Error.TemplateException.REVERT_TO_TEMPLATE_FORBIDDEN");
            }
            try {
                PropertyCommand propertyCmd = new PropertyCommand(this.module, template);
                propertyCmd.setProperty("refTemplateParameter", (Object)templateParam.getName());
            }
            catch (SemanticException e) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        ContentCommand cmd = new ContentCommand(this.module, this.element);
        cmd.transformTemplate(base, template, slotID, false);
        return template;
    }

    static {
        $assertionsDisabled = !TemplateCommand.class.desiredAssertionStatus();
    }
}

