/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.metadata.ElementDefn;

public final class NameSpace
implements Cloneable {
    private HashMap names = new LinkedHashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public void insert(DesignElement element) {
        if (!$assertionsDisabled && element.getName() == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.names.get(element.getName()) != null) {
            throw new AssertionError();
        }
        this.names.put(element.getName(), element);
    }

    public void remove(DesignElement element) {
        if (!$assertionsDisabled && element.getName() == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.names.get(element.getName()) != element) {
            throw new AssertionError();
        }
        this.names.remove(element.getName());
    }

    public void rename(DesignElement element, String oldName, String newName) {
        if (oldName != null) {
            if (!$assertionsDisabled && this.names.get(oldName) != element) {
                throw new AssertionError();
            }
            this.names.remove(oldName);
        }
        if (newName != null) {
            if (!$assertionsDisabled && this.names.get(newName) != null) {
                throw new AssertionError();
            }
            this.names.put(newName, element);
        }
    }

    public boolean contains(String name) {
        return this.names.containsKey(name);
    }

    public DesignElement getElement(String name) {
        return (DesignElement)this.names.get(name);
    }

    public int getCount() {
        return this.names.size();
    }

    public List getElements() {
        return new ArrayList(this.names.values());
    }

    public Object clone() throws CloneNotSupportedException {
        NameSpace ns = (NameSpace)super.clone();
        ns.names = new LinkedHashMap();
        return ns;
    }

    public static void rebuildNamespace(ReportDesign design) throws CloneNotSupportedException {
        for (int i = 0; i < 9; ++i) {
            ContainerSlot slot = design.getSlot(i);
            for (int j = 0; j < slot.getCount(); ++j) {
                DesignElement element = slot.getContent(j);
                ElementDefn elementDefn = (ElementDefn)element.getDefn();
                int namespaceId = elementDefn.getNameSpaceID();
                design.getNameSpace((int)namespaceId).names.put(element.name, element);
            }
        }
    }

    static {
        $assertionsDisabled = !NameSpace.class.desiredAssertionStatus();
    }
}

