/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.datafeed;

import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.birt.chart.computation.DataSetIterator;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.datafeed.DataSetAdapter;
import org.eclipse.birt.chart.datafeed.IResultSetDataSet;
import org.eclipse.birt.chart.engine.extension.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.DateTimeDataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.impl.DateTimeDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;

public class DataSetProcessorImpl
extends DataSetAdapter {
    public Object getMaximum(DataSet ds) throws ChartException {
        DataSetIterator dsi = null;
        try {
            dsi = new DataSetIterator(ds);
            dsi.reset();
        }
        catch (IllegalArgumentException uiex) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, (Throwable)uiex);
        }
        if (dsi.size() == 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "exception.empty.dataset", Messages.getResourceBundle(this.getULocale()));
        }
        if (ds instanceof NumberDataSet) {
            boolean bAnyNonNull = false;
            double dMax = 0.0;
            while (dsi.hasNext()) {
                Object o = dsi.next();
                if (o == null) continue;
                double d = ((Number)o).doubleValue();
                if (!bAnyNonNull) {
                    dMax = d;
                    bAnyNonNull = true;
                    continue;
                }
                if (!(dMax < d)) continue;
                dMax = d;
            }
            if (!bAnyNonNull) {
                throw new ChartException("org.eclipse.birt.chart.engine.extension", 20, "exception.null.values", Messages.getResourceBundle(this.getULocale()));
            }
            return new Double(dMax);
        }
        if (ds instanceof DateTimeDataSet) {
            boolean bAnyNonNull = false;
            Calendar calMax = null;
            while (dsi.hasNext()) {
                Calendar cal = (Calendar)dsi.next();
                if (cal == null) continue;
                if (!bAnyNonNull) {
                    calMax = cal;
                    bAnyNonNull = true;
                    continue;
                }
                if (!calMax.before((Object)cal)) continue;
                calMax = cal;
            }
            if (!bAnyNonNull) {
                throw new ChartException("org.eclipse.birt.chart.engine.extension", 20, "exception.null.values", Messages.getResourceBundle(this.getULocale()));
            }
            return calMax;
        }
        return null;
    }

    public Object getMinimum(DataSet ds) throws ChartException {
        DataSetIterator dsi = null;
        try {
            dsi = new DataSetIterator(ds);
            dsi.reset();
        }
        catch (IllegalArgumentException uiex) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, (Throwable)uiex);
        }
        if (dsi.size() == 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "exception.empty.dataset", Messages.getResourceBundle(this.getULocale()));
        }
        if (ds instanceof NumberDataSet) {
            boolean bAnyNonNull = false;
            double dMin = 0.0;
            while (dsi.hasNext()) {
                Object o = dsi.next();
                if (o == null) continue;
                double d = ((Number)o).doubleValue();
                if (!bAnyNonNull) {
                    dMin = d;
                    bAnyNonNull = true;
                    continue;
                }
                if (!(dMin > d)) continue;
                dMin = d;
            }
            return new Double(dMin);
        }
        if (ds instanceof DateTimeDataSet) {
            boolean bAnyNonNull = false;
            Calendar calMin = null;
            while (dsi.hasNext()) {
                Calendar cal = (Calendar)dsi.next();
                if (cal == null) continue;
                if (!bAnyNonNull) {
                    calMin = cal;
                    bAnyNonNull = true;
                    continue;
                }
                if (!calMin.after((Object)cal)) continue;
                calMin = cal;
            }
            if (!bAnyNonNull) {
                throw new ChartException("org.eclipse.birt.chart.engine.extension", 20, "exception.null.values", Messages.getResourceBundle(this.getULocale()));
            }
            return calMin;
        }
        return null;
    }

    public DataSet populate(Object oResultSetDef, DataSet ds) throws ChartException {
        if (oResultSetDef instanceof IResultSetDataSet) {
            IResultSetDataSet rsds = (IResultSetDataSet)oResultSetDef;
            long lRowCount = rsds.getSize();
            if (lRowCount <= 0L) {
                throw new ChartException("org.eclipse.birt.chart.engine.extension", 16, "exception.empty.dataset", Messages.getResourceBundle(this.getULocale()));
            }
            int i = 0;
            switch (rsds.getDataType()) {
                case 16: {
                    String[] saDataSet = new String[(int)lRowCount];
                    while (rsds.hasNext()) {
                        saDataSet[i++] = (String)rsds.next()[0];
                    }
                    if (ds == null) {
                        ds = TextDataSetImpl.create((Object)saDataSet);
                        break;
                    }
                    ds.setValues((Object)saDataSet);
                    break;
                }
                case 1: {
                    Double[] doaDataSet = new Double[(int)lRowCount];
                    while (rsds.hasNext()) {
                        doaDataSet[i++] = Methods.asDouble((Object)rsds.next()[0]);
                    }
                    if (ds == null) {
                        ds = NumberDataSetImpl.create((Object)doaDataSet);
                        break;
                    }
                    ds.setValues((Object)doaDataSet);
                    break;
                }
                case 8: {
                    Calendar[] caDataSet = new Calendar[(int)lRowCount];
                    while (rsds.hasNext()) {
                        caDataSet[i++] = Methods.asDateTime((Object)rsds.next()[0]);
                    }
                    if (ds == null) {
                        ds = DateTimeDataSetImpl.create((Object)caDataSet);
                        break;
                    }
                    ds.setValues((Object)caDataSet);
                    break;
                }
                default: {
                    boolean allNullValues = true;
                    while (rsds.hasNext()) {
                        if (rsds.next()[0] == null) continue;
                        allNullValues = false;
                        break;
                    }
                    if (!allNullValues) {
                        throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "exception.unknown.datatype", Messages.getResourceBundle(this.getULocale()));
                    }
                    Double[] dummyDataSet = new Double[(int)lRowCount];
                    if (ds == null) {
                        ds = NumberDataSetImpl.create((Object)dummyDataSet);
                        break;
                    }
                    ds.setValues((Object)dummyDataSet);
                    break;
                }
            }
        } else {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "exception.unknown.custom.dataset", Messages.getResourceBundle(this.getULocale()));
        }
        return ds;
    }

    public DataSet fromString(String sDataSetRepresentation, DataSet ds) throws ChartException {
        if (sDataSetRepresentation == null) {
            return ds;
        }
        ArrayList<Object> vData = new ArrayList<Object>();
        String[] strTok = this.getStringTokens(sDataSetRepresentation);
        int iType = 0;
        block14: for (int i = 0; i < strTok.length; ++i) {
            String strDataElement = strTok[i];
            if (strDataElement.startsWith("'")) {
                iType = 3;
            }
            SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
            NumberFormat nf = NumberFormat.getNumberInstance();
            switch (iType) {
                case 0: {
                    Calendar cal;
                    Date dateElement;
                    try {
                        dateElement = sdf.parse(strDataElement);
                        cal = Calendar.getInstance();
                        cal.setTime(dateElement);
                        ds = DateTimeDataSetImpl.create(null);
                        vData.add(cal);
                        iType = 1;
                    }
                    catch (ParseException e) {
                        try {
                            Number numberElement = nf.parse(strDataElement);
                            ds = NumberDataSetImpl.create(null);
                            vData.add(new Double(numberElement.doubleValue()));
                            iType = 2;
                        }
                        catch (ParseException e1) {
                            ds = TextDataSetImpl.create(null);
                            vData.add(strDataElement);
                            iType = 3;
                        }
                    }
                    continue block14;
                }
                case 1: {
                    if (ds == null) {
                        ds = DateTimeDataSetImpl.create(null);
                    }
                    Date dateElement = null;
                    try {
                        dateElement = sdf.parse(strDataElement);
                    }
                    catch (ParseException e1) {
                        dateElement = new Date();
                    }
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(dateElement);
                    vData.add(cal);
                    continue block14;
                }
                case 2: {
                    if (ds == null) {
                        ds = NumberDataSetImpl.create(null);
                    }
                    Number numberElement = null;
                    try {
                        numberElement = nf.parse(strDataElement);
                    }
                    catch (ParseException e2) {
                        numberElement = null;
                    }
                    vData.add(numberElement == null ? null : new Double(numberElement.doubleValue()));
                    continue block14;
                }
                case 3: {
                    if (ds == null) {
                        ds = TextDataSetImpl.create(null);
                    }
                    if (strDataElement.startsWith("'")) {
                        strDataElement = strDataElement.substring(1, strDataElement.length() - 1);
                    }
                    vData.add(strDataElement);
                }
            }
        }
        if (ds == null) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "exception.cannot.parse.sample", Messages.getResourceBundle(this.getULocale()));
        }
        ds.setValues(vData);
        return ds;
    }

    protected String[] getStringTokens(String str) {
        if (str.indexOf("\\,") < 0) {
            return str.split(",");
        }
        ArrayList<String> list = new ArrayList<String>();
        char[] charArray = (str + ",").toCharArray();
        int startIndex = 0;
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (c != ',' || charArray[i - 1] == '\\' || i <= 0) continue;
            list.add(str.substring(startIndex, i).replaceAll("\\\\,", ",").trim());
            startIndex = i + 1;
        }
        return list.toArray(new String[list.size()]);
    }

    public String getExpectedStringFormat() {
        return Messages.getString("info.sample.formats", this.getULocale());
    }
}

