/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.parser;

import java.io.StringReader;
import java.util.Hashtable;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.ObjectResponse;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.discovery.parser.DESaxParser;
import org.eclipse.aperi.discovery.parser.Parser;
import org.eclipse.aperi.discovery.parser.TSANMLegacyProcessor;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response;
import org.eclipse.aperi.util.queue.IJobQueue;
import org.eclipse.aperi.util.queue.KeyedJobQueue;
import org.eclipse.aperi.util.queue.QueueController;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class TSANMLegacyParser
extends Thread {
    boolean shutdown = false;
    Thread thread = null;
    public static String queueName;
    public static SAXParserFactory saxFactory;
    public static final String MESSAGE_NAME = "aperi.logger.message.TSANMLegacy";
    public static final String TRACE_NAME = "aperi.logger.trace.TSANMLegacy";
    public static String MSG_FILE;
    public static ILogger msgLogger;
    public static ILogger traceLogger;
    public static final String TopologyScanner = "TopologyScanner";
    private static Hashtable scanners;
    private static String className;

    static {
        Class<?> clazz;
        queueName = "TSANMLegacyParser";
        saxFactory = SAXParserFactory.newInstance();
        MSG_FILE = "org.eclipse.aperi.discovery.parser.resources.MsgLoggingTMS";
        msgLogger = null;
        traceLogger = null;
        scanners = new Hashtable();
        try {
            clazz = Class.forName("org.eclipse.aperi.discovery.parser.TSANMLegacyParser");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
        msgLogger.setMessageFile(MSG_FILE);
        saxFactory.setValidating(false);
    }

    public TSANMLegacyParser() {
        this.setName(String.valueOf(queueName) + " (" + this.getName() + ")");
        QueueController.getInstance().addQueue(queueName, (IJobQueue)new KeyedJobQueue(true));
        this.start();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        String string = "run";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        msgLogger.message(IRecordType.TYPE_INFO, (Object)className, string, "TSANMLegacy_Started");
        this.thread = Thread.currentThread();
        Worker worker = new Worker();
        while (true) {
            String string2;
            block19: {
                Object var8_8;
                Object object;
                Object object2;
                if (this.shutdown) {
                    return;
                }
                if (traceLogger.isLogging()) {
                    object2 = String.valueOf(queueName) + ": waiting for a job";
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string, (String)object2);
                }
                object2 = QueueController.getInstance().getNextJob(queueName);
                if (this.shutdown) continue;
                if (object2 == null) {
                    if (!traceLogger.isLogging()) continue;
                    object = String.valueOf(queueName) + ":Error - got a NULL job from the queue";
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, (String)object);
                    continue;
                }
                object = object2.getRequest();
                if (!(object instanceof ObjectResponse)) break block19;
                if (traceLogger.isLogging()) {
                    string2 = String.valueOf(queueName) + ": Received an Object response";
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, string2);
                }
                string2 = null;
                Request request = null;
                try {
                    try {
                        request = Router.getRouter().getRequest(object2.getDiscoverRequest());
                        if (request != null) {
                            string2 = request.getJobLogger();
                        }
                        worker.processJob((JobInfo)object2);
                        if (object2.isSuccessful()) {
                            object2.setReturnCode(0);
                            object2.complete(true);
                        } else {
                            if (string2 != null && request != null) {
                                string2.message(IRecordType.TYPE_ERROR, (Object)className, string, "TSANMLegacyParserJob_Error", (Object[])new String[]{request.getDeviceServerRunNumber(), String.valueOf(request.getId()), ""});
                            }
                            object2.setReturnCode(99);
                            object2.complete(false);
                            if (traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "TSANMLegacyParser Error");
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        if (string2 != null && request != null) {
                            string2.message(IRecordType.TYPE_ERROR_EXC, (Object)className, string, "TSANMLegacyParserJob_Error", (Object[])new String[]{request.getDeviceServerRunNumber(), String.valueOf(request.getId()), throwable.getMessage()});
                        }
                        msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, throwable);
                        object2.setReturnCode(99);
                        object2.complete(false);
                        if (traceLogger.isLogging()) {
                            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, throwable);
                        }
                    }
                }
                catch (Throwable throwable) {
                    var8_8 = null;
                    object.close();
                    throw throwable;
                }
                {
                    var8_8 = null;
                }
                object.close();
            }
            if (traceLogger.isLogging()) {
                string2 = String.valueOf(queueName) + ": Finishing job";
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, string2);
            }
            if (!traceLogger.isLogging()) continue;
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    public void shutdown() {
        String string;
        block5: {
            this.shutdown = true;
            string = "shutdown";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
            }
            if (this.thread != null) {
                msgLogger.message(IRecordType.TYPE_INFO, (Object)className, string, "TSANMLegacy_Shutdown");
                try {
                    this.thread.interrupt();
                    this.thread.join(30000L);
                    this.thread = null;
                }
                catch (Exception exception) {
                    msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
                    if (!traceLogger.isLogging()) break block5;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
                }
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    class Worker
    extends Parser {
        String className;

        Worker() {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.discovery.parser.TSANMLegacyParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            this.className = clazz.getName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void parse(JobInfo jobInfo) {
            String string;
            block29: {
                string = "parse";
                ILogger iLogger = null;
                Request request = Router.getRouter().getRequest(jobInfo.getDiscoverRequest());
                if (request != null) {
                    iLogger = request.getJobLogger();
                }
                if (traceLogger.isLogging()) {
                    traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this.className, string);
                }
                String string2 = null;
                String string3 = null;
                String string4 = null;
                Object object = jobInfo.getRequest().getData();
                if (!(object instanceof org.eclipse.aperi.discovery.snmp.scanner.interfaces.Response)) {
                    if (object instanceof Response) {
                        string2 = ((Response)jobInfo.getRequest().getData()).getData();
                        string4 = ((Response)jobInfo.getRequest().getData()).getHeader().getScannerName();
                        string3 = ((Response)jobInfo.getRequest().getData()).getHeader().getAgentAddress();
                        int n = string4.lastIndexOf(".");
                        if (n > -1) {
                            string4 = string4.substring(n + 1);
                        }
                    } else {
                        System.out.println("Error getting XML scan data from Response.");
                    }
                }
                TSANMLegacyProcessor tSANMLegacyProcessor = new TSANMLegacyProcessor();
                try {
                    if (tSANMLegacyProcessor.start(jobInfo)) {
                        tSANMLegacyProcessor.setInactiveProcessed(jobInfo, 0);
                        try {
                            block28: {
                                try {
                                    SAXParser sAXParser = null;
                                    Object object2 = saxFactory;
                                    synchronized (object2) {
                                        sAXParser = saxFactory.newSAXParser();
                                    }
                                    object2 = new DESaxParser(tSANMLegacyProcessor, jobInfo);
                                    if (traceLogger.isLogging()) {
                                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this.className, string, string2);
                                    }
                                    if (iLogger != null) {
                                        iLogger.message(IRecordType.TYPE_INFORMATION, (Object)this.className, string, "TSANMLegacyParserJob_Run", (Object[])new String[]{string4, string3});
                                    }
                                    sAXParser.parse(new InputSource(new StringReader(string2)), (DefaultHandler)object2);
                                    if (iLogger != null) {
                                        iLogger.message(IRecordType.TYPE_INFORMATION, (Object)this.className, string, "TSANMLegacyParserJob_Successful", (Object[])new String[]{string4, string3});
                                    }
                                }
                                catch (Exception exception) {
                                    jobInfo.setSuccessful(false);
                                    if (iLogger != null) {
                                        iLogger.message(IRecordType.TYPE_ERROR_EXC, (Object)this.className, string, "TSANMLegacyParserJob_Error", (Object[])new String[]{string4, string3, exception.getMessage()});
                                    }
                                    msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this.className, string, (Throwable)exception);
                                    if (!traceLogger.isLogging()) break block28;
                                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this.className, string, (Throwable)exception);
                                }
                            }
                            Object var12_16 = null;
                            tSANMLegacyProcessor.updateLevel(jobInfo);
                        }
                        catch (Throwable throwable) {
                            Object var12_15 = null;
                            tSANMLegacyProcessor.updateLevel(jobInfo);
                            tSANMLegacyProcessor.end(Integer.parseInt(jobInfo.getDiscoverRequest()));
                            throw throwable;
                        }
                        tSANMLegacyProcessor.end(Integer.parseInt(jobInfo.getDiscoverRequest()));
                    } else if (jobInfo.getRequest() != null && jobInfo.getRequest().getData() != null && jobInfo.getRequest().getData() instanceof Response && ((Response)jobInfo.getRequest().getData()).getReturnCode() != Response.RETURN_CODE_OK) {
                        tSANMLegacyProcessor.end(Integer.parseInt(jobInfo.getDiscoverRequest()));
                        tSANMLegacyProcessor.updateLevel(jobInfo, true);
                        tSANMLegacyProcessor.setInactiveProcessed(jobInfo, 1);
                    } else if (iLogger != null) {
                        iLogger.message(IRecordType.TYPE_INFORMATION, (Object)this.className, string, "TSANMLegacyParserJob_SameBenchmark", (Object[])new String[]{string4, string3});
                    }
                    Object var14_19 = null;
                    if (tSANMLegacyProcessor == null) break block29;
                }
                catch (Throwable throwable) {
                    Object var14_18 = null;
                    if (tSANMLegacyProcessor != null) {
                        tSANMLegacyProcessor.shutdown();
                        tSANMLegacyProcessor = null;
                    }
                    throw throwable;
                }
                tSANMLegacyProcessor.shutdown();
                tSANMLegacyProcessor = null;
            }
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this.className, string);
            }
        }
    }
}

