/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.internal.model;

import org.eclipse.birt.chart.internal.computations.Matrix;

public class FittingCalculator {
    private double[] fittedValue;

    public FittingCalculator() {
    }

    public FittingCalculator(double[] xa, double[] ya, double windowProportion) {
        this.calculate(xa, ya, windowProportion);
    }

    public double[] getFittedValue() {
        return this.fittedValue;
    }

    public void calculate(double[] xa, double[] ya, double windowProportion) {
        this.fittedValue = new double[xa.length];
        int window = (int)Math.round((double)xa.length * windowProportion);
        if (window > 1) {
            double[] windowXa = new double[window];
            double[] windowYa = new double[window];
            double[] weights = new double[window];
            Matrix X = new Matrix(window, 2);
            Matrix Y = new Matrix(window, 1);
            Matrix W = new Matrix(window, window);
            for (int index = 0; index < xa.length; ++index) {
                Matrix L;
                int i;
                int i2;
                int total = xa.length;
                int windowStart = 0;
                double maxDistance = 0.0;
                if (index < window) {
                    for (i2 = 0; i2 < window; ++i2) {
                        if (!(xa[index] - xa[i2] <= xa[window + i2] - xa[index])) continue;
                        windowStart = i2;
                        maxDistance = Math.max(xa[index] - xa[windowStart], xa[windowStart + window - 1] - xa[index]);
                        break;
                    }
                } else if (index >= window && index < total - window) {
                    for (i2 = 0; i2 < window; ++i2) {
                        if (!(xa[index] - xa[index - window + 1 + i2] <= xa[index + 1 + i2] - xa[index])) continue;
                        windowStart = index - window + 1 + i2;
                        maxDistance = Math.max(xa[index] - xa[windowStart], xa[windowStart + window - 1] - xa[index]);
                        break;
                    }
                } else {
                    for (i2 = 0; i2 < window; ++i2) {
                        if (!(xa[total - 1 - i2] - xa[index] <= xa[index] - xa[total - window - 1 - i2])) continue;
                        windowStart = total - window - i2;
                        maxDistance = Math.max(xa[index] - xa[windowStart], xa[windowStart + window - 1] - xa[index]);
                        break;
                    }
                }
                System.arraycopy(xa, windowStart, windowXa, 0, window);
                System.arraycopy(ya, windowStart, windowYa, 0, window);
                int windowIndex = index - windowStart;
                for (i = 0; i < window; ++i) {
                    double distance = Math.abs(windowXa[windowIndex] - windowXa[i]);
                    weights[i] = Math.pow(1.0 - Math.pow(distance / maxDistance, 3.0), 3.0);
                }
                for (i = 0; i < window; ++i) {
                    X.set(i, 0, 1.0);
                    X.set(i, 1, windowXa[i]);
                    Y.set(i, 0, windowYa[i]);
                    W.set(i, i, weights[i]);
                }
                Matrix XTW = X.transpose().times(W);
                try {
                    L = XTW.times(X).inverse().times(XTW.times(Y));
                }
                catch (Exception ex) {
                    L = new Matrix(2, 1);
                    L.set(0, 0, ya[index]);
                    L.set(1, 0, 0.0);
                }
                this.fittedValue[index] = L.get(0, 0) + L.get(1, 0) * xa[index];
            }
        } else {
            for (int i = 0; i < xa.length; ++i) {
                this.fittedValue[i] = ya[i];
            }
        }
    }
}

