/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.attribute;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class AngleType
extends AbstractEnumerator {
    public static final int NONE = 0;
    public static final int X = 1;
    public static final int Y = 2;
    public static final int Z = 3;
    public static final AngleType NONE_LITERAL = new AngleType(0, "None", "None");
    public static final AngleType X_LITERAL = new AngleType(1, "X", "X");
    public static final AngleType Y_LITERAL = new AngleType(2, "Y", "Y");
    public static final AngleType Z_LITERAL = new AngleType(3, "Z", "Z");
    private static final AngleType[] VALUES_ARRAY = new AngleType[]{NONE_LITERAL, X_LITERAL, Y_LITERAL, Z_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static AngleType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            AngleType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static AngleType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            AngleType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static AngleType get(int value) {
        switch (value) {
            case 0: {
                return NONE_LITERAL;
            }
            case 1: {
                return X_LITERAL;
            }
            case 2: {
                return Y_LITERAL;
            }
            case 3: {
                return Z_LITERAL;
            }
        }
        return null;
    }

    private AngleType(int value, String name, String literal) {
        super(value, name, literal);
    }
}

