/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.dscache;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.querydefn.ComputedColumn;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.DataSetCacheManager;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.ResultFieldMetadata;
import org.eclipse.birt.data.engine.executor.ResultObject;
import org.eclipse.birt.data.engine.executor.cache.ResultObjectUtil;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.odaconsumer.ResultSet;
import org.eclipse.birt.data.engine.odi.ICustomDataSet;
import org.eclipse.birt.data.engine.odi.IDataSetPopulator;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;

public class DataSetResultCache {
    private IResultClass rsMeta;
    private ResultSet odaDataSet;
    private ICustomDataSet customDataSet;
    private IDataSetPopulator populator;
    private int cacheCount;
    private SaveUtil saveUtil;
    private boolean isSaved;
    private LoadUtil loadUtil;
    private boolean isLoad;
    private List addedTempComputedColumn;
    private int realColumnCount;
    private DataEngineSession session;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DataSetResultCache(ResultSet odaDataSet, IResultClass rsMeta, DataEngineSession session) {
        if (!$assertionsDisabled && odaDataSet == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && rsMeta == null) {
            throw new AssertionError();
        }
        this.odaDataSet = odaDataSet;
        this.init(rsMeta, session);
    }

    public DataSetResultCache(IDataSetPopulator populator, IResultClass rsMeta, DataEngineSession session) {
        if (!$assertionsDisabled && populator == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && rsMeta == null) {
            throw new AssertionError();
        }
        this.populator = populator;
        this.init(rsMeta, session);
    }

    public DataSetResultCache(ICustomDataSet customDataSet, IResultClass rsMeta, DataEngineSession session) {
        if (!$assertionsDisabled && customDataSet == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && rsMeta == null) {
            throw new AssertionError();
        }
        this.customDataSet = customDataSet;
        this.init(rsMeta, session);
    }

    private void init(IResultClass rsMeta, DataEngineSession session) {
        this.rsMeta = rsMeta;
        this.isLoad = false;
        this.isSaved = false;
        this.session = session;
        this.cacheCount = this.getCacheCount();
    }

    public DataSetResultCache(DataEngineSession session) {
        this.isLoad = true;
        this.session = session;
    }

    public void setTempComputedColumn(List addedTempComputedColumn) {
        this.addedTempComputedColumn = addedTempComputedColumn;
    }

    public IResultObject fetch() throws DataException {
        if (!this.isLoad) {
            if (this.cacheCount <= 0) {
                if (this.odaDataSet != null) {
                    return this.odaDataSet.fetch();
                }
                if (this.customDataSet != null) {
                    return this.customDataSet.fetch();
                }
                return this.populator.next();
            }
            if (!this.isSaved) {
                this.cacheDataSet();
                this.isSaved = true;
            }
            return this.loadObject();
        }
        return this.loadObject();
    }

    private void cacheDataSet() throws DataException {
        int index = 0;
        IResultObject resultObject = null;
        this.saveInit();
        do {
            if ((resultObject = this.odaDataSet != null ? this.odaDataSet.fetch() : (this.customDataSet != null ? this.customDataSet.fetch() : this.populator.next())) == null) continue;
            this.saveUtil.saveObject(resultObject);
            if (++index >= this.cacheCount) break;
        } while (resultObject != null);
        this.saveClose();
    }

    public IResultClass getResultClass() throws DataException {
        if (this.isLoad && this.rsMeta == null) {
            this.rsMeta = this.loadResultClass();
            if (this.addedTempComputedColumn != null && this.addedTempComputedColumn.size() > 0) {
                this.processResultClass();
            }
        }
        return this.rsMeta;
    }

    private void processResultClass() throws DataException {
        ArrayList<ResultFieldMetadata> metadataList = new ArrayList<ResultFieldMetadata>();
        this.realColumnCount = 0;
        ResultFieldMetadata metadata = null;
        int i = 0;
        for (i = 0; i < this.rsMeta.getFieldCount(); ++i) {
            if (this.isTempComputedColumn(this.rsMeta.getFieldName(i + 1))) continue;
            metadata = new ResultFieldMetadata(0, this.rsMeta.getFieldName(i + 1), this.rsMeta.getFieldLabel(i + 1), this.rsMeta.getFieldValueClass(i + 1), this.rsMeta.getFieldNativeTypeName(i + 1), this.rsMeta.isCustomField(i + 1));
            metadata.setAlias(this.rsMeta.getFieldAlias(i + 1));
            metadataList.add(metadata);
            ++this.realColumnCount;
        }
        ComputedColumn tempComputedColumn = null;
        for (i = 0; i < this.addedTempComputedColumn.size(); ++i) {
            tempComputedColumn = (ComputedColumn)this.addedTempComputedColumn.get(i);
            metadata = new ResultFieldMetadata(0, tempComputedColumn.getName(), null, DataType.getClass((int)tempComputedColumn.getDataType()), null, true);
            metadataList.add(metadata);
        }
        this.rsMeta = new ResultClass(metadataList);
    }

    private boolean isTempComputedColumn(String name) {
        return name.matches("\\Q_{$TEMP_GROUP_\\E\\d*\\Q$}_\\E") || name.matches("\\Q_{$TEMP_SORT_\\E\\d*\\Q$}_\\E") || name.matches("\\Q_{$TEMP_FILTER_\\E\\d*\\Q$}_\\E");
    }

    public void close() throws DataException {
        if (this.loadUtil != null) {
            this.loadUtil.close();
            this.loadUtil = null;
        }
    }

    private void saveInit() {
        this.saveUtil = new SaveUtil(new File(this.getSaveFolder() + "/data.data"), new File(this.getSaveFolder() + "/metaData.data"), this.rsMeta);
    }

    private void saveClose() throws DataException {
        if (this.saveUtil != null) {
            this.saveUtil.close();
            this.saveUtil = null;
        }
    }

    private IResultObject loadObject() throws DataException {
        IResultObject cacheObject;
        if (this.loadUtil == null) {
            this.loadUtil = new LoadUtil(new File(this.getLoadFolder() + "/data.data"), new File(this.getLoadFolder() + "/metaData.data"));
        }
        if ((cacheObject = this.loadUtil.loadObject()) == null) {
            return cacheObject;
        }
        if (this.addedTempComputedColumn != null && this.addedTempComputedColumn.size() > 0) {
            ResultObject resultObject = new ResultObject(this.getResultClass(), this.getAllObjects(cacheObject));
            return resultObject;
        }
        return cacheObject;
    }

    private Object[] getAllObjects(IResultObject cacheObject) throws DataException {
        Object[] objects = new Object[this.realColumnCount + this.addedTempComputedColumn.size()];
        for (int i = 0; i < this.realColumnCount; ++i) {
            objects[i] = cacheObject.getFieldValue(i + 1);
        }
        return objects;
    }

    private IResultClass loadResultClass() throws DataException {
        if (this.loadUtil == null) {
            this.loadUtil = new LoadUtil(new File(this.getLoadFolder() + "/data.data"), new File(this.getLoadFolder() + "/metaData.data"));
        }
        return this.loadUtil.loadResultClass();
    }

    private String getSaveFolder() {
        return this.getDataSetCacheManager().getSaveFolder();
    }

    private DataSetCacheManager getDataSetCacheManager() {
        return this.session.getDataSetCacheManager();
    }

    private int getCacheCount() {
        return this.getDataSetCacheManager().getCacheRowCount();
    }

    private String getLoadFolder() {
        return this.getDataSetCacheManager().getLoadFolder();
    }

    static {
        $assertionsDisabled = !DataSetResultCache.class.desiredAssertionStatus();
    }

    private class LoadUtil {
        private File file;
        private File metaFile;
        private FileInputStream fis;
        private BufferedInputStream bis;
        private ResultObjectUtil roUtil;
        private IResultClass rsClass;
        private int rowCount;
        private int currIndex;
        static final /* synthetic */ boolean $assertionsDisabled;

        private LoadUtil(File file, File metaFile) {
            if (!$assertionsDisabled && file == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && metaFile == null) {
                throw new AssertionError();
            }
            this.file = file;
            this.metaFile = metaFile;
            this.rowCount = 0;
            this.currIndex = -1;
        }

        private IResultObject loadObject() throws DataException {
            if (this.roUtil == null) {
                this.init();
            }
            try {
                if (this.currIndex == this.rowCount - 1) {
                    return null;
                }
                ++this.currIndex;
                return this.roUtil.readData(this.bis, 1)[0];
            }
            catch (IOException e) {
                throw new DataException("data.engine.datasetcache.load.error", e);
            }
        }

        private IResultClass loadResultClass() throws DataException {
            if (this.roUtil == null) {
                this.init();
            }
            return this.rsClass;
        }

        private void init() throws DataException {
            try {
                FileInputStream fis1 = new FileInputStream(this.metaFile);
                BufferedInputStream bis1 = new BufferedInputStream(fis1);
                this.rowCount = IOUtil.readInt((InputStream)bis1);
                this.rsClass = new ResultClass(bis1);
                bis1.close();
                fis1.close();
                if (this.rowCount > 0) {
                    this.roUtil = ResultObjectUtil.newInstance(this.rsClass);
                    this.fis = new FileInputStream(this.file);
                    this.bis = new BufferedInputStream(this.fis);
                }
            }
            catch (FileNotFoundException e) {
                throw new DataException("data.engine.datasetcache.load.error", e);
            }
            catch (IOException e) {
                throw new DataException("data.engine.datasetcache.load.error", e);
            }
        }

        private void close() throws DataException {
            if (this.bis != null) {
                try {
                    this.bis.close();
                    this.fis.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        static {
            $assertionsDisabled = !(class$org$eclipse$birt$data$engine$executor$dscache$DataSetResultCache == null ? (class$org$eclipse$birt$data$engine$executor$dscache$DataSetResultCache = DataSetResultCache.class$("org.eclipse.birt.data.engine.executor.dscache.DataSetResultCache")) : class$org$eclipse$birt$data$engine$executor$dscache$DataSetResultCache).desiredAssertionStatus();
        }
    }

    private class SaveUtil {
        private File file;
        private File metaFile;
        private FileOutputStream fos;
        private BufferedOutputStream bos;
        private IResultClass rsClass;
        private ResultObjectUtil roUtil;
        private int rowCount;
        static final /* synthetic */ boolean $assertionsDisabled;

        private SaveUtil(File file, File metaFile, IResultClass rsClass) {
            if (!$assertionsDisabled && file == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && metaFile == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && rsClass == null) {
                throw new AssertionError();
            }
            this.file = file;
            this.file.deleteOnExit();
            this.metaFile = metaFile;
            this.metaFile.deleteOnExit();
            this.rsClass = rsClass;
            this.rowCount = 0;
        }

        private void saveObject(IResultObject resultObject) throws DataException {
            if (!$assertionsDisabled && resultObject == null) {
                throw new AssertionError();
            }
            if (this.roUtil == null) {
                this.roUtil = ResultObjectUtil.newInstance(this.rsClass);
                try {
                    this.fos = new FileOutputStream(this.file);
                    this.bos = new BufferedOutputStream(this.fos);
                }
                catch (FileNotFoundException e) {
                    throw new DataException("data.engine.datasetcache.save.error", e);
                }
            }
            try {
                ++this.rowCount;
                this.roUtil.writeData(this.bos, resultObject);
            }
            catch (IOException e) {
                throw new DataException("data.engine.datasetcache.save.error", e);
            }
        }

        private void close() throws DataException {
            try {
                if (this.bos != null) {
                    this.bos.close();
                    this.fos.close();
                }
                FileOutputStream fos1 = new FileOutputStream(this.metaFile);
                BufferedOutputStream bos1 = new BufferedOutputStream(fos1);
                IOUtil.writeInt((OutputStream)bos1, (int)this.rowCount);
                HashMap metaMap = new HashMap();
                this.populateDataSetRowMapping(metaMap);
                ((ResultClass)this.rsClass).doSave(bos1, metaMap);
                bos1.close();
                fos1.close();
            }
            catch (IOException e) {
                throw new DataException("data.engine.datasetcache.save.error", e);
            }
        }

        private void populateDataSetRowMapping(Map metaMap) throws DataException {
            for (int i = 0; i < this.rsClass.getFieldCount(); ++i) {
                metaMap.put(this.rsClass.getFieldName(i + 1), new ScriptExpression(ExpressionUtil.createJSDataSetRowExpression((String)this.rsClass.getFieldName(i + 1))));
            }
        }

        static {
            $assertionsDisabled = !(class$org$eclipse$birt$data$engine$executor$dscache$DataSetResultCache == null ? (class$org$eclipse$birt$data$engine$executor$dscache$DataSetResultCache = DataSetResultCache.class$("org.eclipse.birt.data.engine.executor.dscache.DataSetResultCache")) : class$org$eclipse$birt$data$engine$executor$dscache$DataSetResultCache).desiredAssertionStatus();
        }
    }
}

