/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform.pass;

import java.util.List;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.transform.OdiResultSetWrapper;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.executor.transform.pass.ComputedColumnCalculator;
import org.eclipse.birt.data.engine.executor.transform.pass.ComputedColumnsState;
import org.eclipse.birt.data.engine.executor.transform.pass.PassStatusController;
import org.eclipse.birt.data.engine.executor.transform.pass.PassUtil;
import org.eclipse.birt.data.engine.executor.transform.pass.RowProcessUtil;
import org.eclipse.birt.data.engine.impl.ComputedColumnHelper;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.FilterByRow;

class DataSetProcessUtil
extends RowProcessUtil {
    private DataSetProcessUtil(ResultSetPopulator populator, ComputedColumnsState iccState, ComputedColumnHelper computedColumnHelper, FilterByRow filterByRow, PassStatusController psController, DataEngineSession session) {
        super(populator, iccState, computedColumnHelper, filterByRow, psController, session);
    }

    public static void doPopulate(ResultSetPopulator populator, ComputedColumnsState iccState, ComputedColumnHelper computedColumnHelper, FilterByRow filterByRow, PassStatusController psController, DataEngineSession session) throws DataException {
        DataSetProcessUtil instance = new DataSetProcessUtil(populator, iccState, computedColumnHelper, filterByRow, psController, session);
        instance.populateDataSet();
    }

    private void populateDataSet() throws DataException {
        List aggCCList = this.prepareComputedColumns(0);
        this.doDataSetFilter();
        this.populateComputedColumns(aggCCList);
    }

    private void doDataSetFilter() throws DataException {
        if (!this.psController.needDoOperation(1)) {
            return;
        }
        boolean changeMaxRows = this.filterByRow.getFilterList(2).size() + this.filterByRow.getFilterList(5).size() > 0;
        this.applyFilters(1, changeMaxRows);
    }

    private void populateComputedColumns(List aggCCList) throws DataException {
        if (!this.psController.needDoOperation(2)) {
            return;
        }
        if (!this.psController.needDoOperation(1)) {
            PassUtil.pass(this.populator, new OdiResultSetWrapper(this.populator.getResultIterator()), false, this.session);
        }
        this.computedColumnHelper.getComputedColumnList().clear();
        this.computedColumnHelper.getComputedColumnList().addAll(aggCCList);
        this.computedColumnHelper.setModel(0);
        this.iccState.setModel(0);
        if (this.iccState.getCount() > 0) {
            ComputedColumnCalculator.populateComputedColumns(this.populator, new OdiResultSetWrapper(this.populator.getResultIterator()), this.iccState, this.computedColumnHelper, this.session);
        }
        this.computedColumnHelper.setModel(4);
    }
}

