/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.DataSetCacheManager;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.DataSetCacheUtil;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.impl.DataSourceRuntime;
import org.eclipse.birt.data.engine.impl.IPreparedQueryService;
import org.eclipse.birt.data.engine.impl.ParameterUtil;
import org.eclipse.birt.data.engine.impl.PreparedQuery;
import org.eclipse.birt.data.engine.impl.QueryExecutor;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.mozilla.javascript.Scriptable;

abstract class PreparedDataSourceQuery
implements IPreparedQuery,
IPreparedQueryService {
    private IBaseDataSetDesign dataSetDesign;
    protected DataEngineImpl dataEngine;
    protected IQueryDefinition queryDefn;
    protected PreparedQuery preparedQuery;
    protected Map appContext;
    protected static Logger logger = Logger.getLogger(DataEngineImpl.class.getName());
    static /* synthetic */ Class class$org$eclipse$birt$data$engine$impl$PreparedDataSourceQuery;

    PreparedDataSourceQuery(DataEngineImpl dataEngine, IQueryDefinition queryDefn, IBaseDataSetDesign dataSetDesign, Map appContext) throws DataException {
        this.dataSetDesign = dataSetDesign;
        this.queryDefn = queryDefn;
        this.dataEngine = dataEngine;
        this.appContext = appContext;
        this.preparedQuery = new PreparedQuery(dataEngine.getSession(), dataEngine.getContext(), queryDefn, this, appContext);
    }

    PreparedDataSourceQuery(DataEngineImpl dataEngine, IBaseQueryDefinition baseQueryDefn, IQueryDefinition queryDefn, IBaseDataSetDesign dataSetDesign, Map appContext) throws DataException {
        this.dataSetDesign = dataSetDesign;
        this.queryDefn = queryDefn;
        this.dataEngine = dataEngine;
        this.appContext = appContext;
        this.preparedQuery = new PreparedQuery(dataEngine.getSession(), dataEngine.getContext(), baseQueryDefn, this, appContext);
    }

    public IQueryDefinition getReportQueryDefn() {
        return this.queryDefn;
    }

    public PreparedDataSourceQuery getDataSourceQuery() {
        return this;
    }

    public IQueryResults execute(Scriptable scope) throws DataException {
        return this.execute(null, scope);
    }

    public IQueryResults execute(IQueryResults outerResults, Scriptable scope) throws DataException {
        this.configureDataSetCache(this.queryDefn, this.appContext, scope != null ? scope : this.dataEngine.getSession().getSharedScope());
        return this.preparedQuery.doPrepare(outerResults, scope, this.newExecutor(), this);
    }

    private void configureDataSetCache(IQueryDefinition querySpec, Map appContext, Scriptable scope) throws DataException {
        if (querySpec == null) {
            return;
        }
        String queryResultID = querySpec.getQueryResultsID();
        if (queryResultID != null) {
            return;
        }
        String dataSetName = querySpec.getDataSetName();
        IBaseDataSetDesign dataSetDesign = this.dataEngine.getDataSetDesign(dataSetName);
        if (dataSetDesign == null) {
            return;
        }
        if (!this.getDataSetCacheManager().needsToCache(dataSetDesign, DataSetCacheUtil.getCacheOption(this.dataEngine.getContext(), appContext), this.dataEngine.getContext().getCacheCount())) {
            return;
        }
        Collection parameterHints = null;
        IBaseDataSourceDesign dataSourceDesign = null;
        DataSourceRuntime dsRuntime = this.dataEngine.getDataSourceRuntime(dataSetDesign.getDataSourceName());
        if (dsRuntime != null) {
            dataSourceDesign = dsRuntime.getDesign();
            DataSetRuntime dataSet = DataSetRuntime.newInstance(dataSetDesign, null);
            parameterHints = new ParameterUtil(null, dataSet, this.queryDefn, scope).resolveDataSetParameters(true);
        }
        this.getDataSetCacheManager().setDataSourceAndDataSet(dataSourceDesign, dataSetDesign, parameterHints);
        if (this.dataEngine.getContext().getCacheOption() == 3) {
            this.getDataSetCacheManager().setAlwaysCacheRowCount(this.dataEngine.getContext().getCacheCount());
        }
        this.getDataSetCacheManager().setCacheOption(DataSetCacheUtil.getCacheOption(this.dataEngine.getContext(), appContext));
    }

    protected DataSetCacheManager getDataSetCacheManager() {
        return this.dataEngine.getSession().getDataSetCacheManager();
    }

    protected abstract QueryExecutor newExecutor();

    public IQueryResults execSubquery(IResultIterator iterator, String subQueryName, Scriptable subScope) throws DataException {
        return this.preparedQuery.execSubquery(iterator, subQueryName, subScope);
    }

    abstract class DSQueryExecutor
    extends QueryExecutor {
        static final /* synthetic */ boolean $assertionsDisabled;

        public DSQueryExecutor() {
            super(PreparedDataSourceQuery.this.preparedQuery.getSharedScope(), PreparedDataSourceQuery.this.preparedQuery.getBaseQueryDefn(), PreparedDataSourceQuery.this.preparedQuery.getAggrTable(), PreparedDataSourceQuery.this.dataEngine.getSession());
        }

        protected DataSourceRuntime findDataSource() throws DataException {
            if (!$assertionsDisabled && PreparedDataSourceQuery.this.dataSetDesign == null) {
                throw new AssertionError();
            }
            DataSourceRuntime dsRT = PreparedDataSourceQuery.this.dataEngine.getDataSourceRuntime(PreparedDataSourceQuery.this.dataSetDesign.getDataSourceName());
            return dsRT;
        }

        protected DataSetRuntime newDataSetRuntime() throws DataException {
            return DataSetRuntime.newInstance(PreparedDataSourceQuery.this.dataSetDesign, this);
        }

        static {
            $assertionsDisabled = !(class$org$eclipse$birt$data$engine$impl$PreparedDataSourceQuery == null ? (class$org$eclipse$birt$data$engine$impl$PreparedDataSourceQuery = PreparedDataSourceQuery.class$("org.eclipse.birt.data.engine.impl.PreparedDataSourceQuery")) : class$org$eclipse$birt$data$engine$impl$PreparedDataSourceQuery).desiredAssertionStatus();
        }
    }
}

