/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.document.ExprUtil;

public class FilterDefnUtil {
    static void saveFilterDefn(OutputStream outputStream, List filterList) throws DataException {
        DataOutputStream dos = new DataOutputStream(outputStream);
        int size = filterList == null ? 0 : filterList.size();
        try {
            IOUtil.writeInt((OutputStream)dos, (int)size);
            for (int i = 0; i < size; ++i) {
                IFilterDefinition filterDefn = (IFilterDefinition)filterList.get(i);
                ExprUtil.saveBaseExpr(dos, filterDefn.getExpression());
            }
            dos.flush();
        }
        catch (IOException e) {
            throw new DataException("data.engine.SaveReportDocumentError", e);
        }
    }

    static List loadFilterDefn(InputStream inputStream) throws DataException {
        ArrayList<FilterDefinition> filterList = new ArrayList<FilterDefinition>();
        DataInputStream dis = new DataInputStream(inputStream);
        try {
            int size = IOUtil.readInt((InputStream)inputStream);
            for (int i = 0; i < size; ++i) {
                IBaseExpression baseExpr = ExprUtil.loadBaseExpr(dis);
                filterList.add(new FilterDefinition(baseExpr));
            }
        }
        catch (IOException e) {
            throw new DataException("data.engine.LoadReportDocumentError", e);
        }
        return filterList;
    }

    public static boolean isEqualFilter(IFilterDefinition filterDefn1, IFilterDefinition filterDefn2) {
        if (filterDefn1 == filterDefn2) {
            return true;
        }
        if (filterDefn1 == null || filterDefn2 == null) {
            return false;
        }
        return ExprUtil.isEqualExpression(filterDefn1.getExpression(), filterDefn2.getExpression());
    }

    public static boolean isEqualFilter(List filters1, List filters2) {
        if (filters1 == null && filters2 == null) {
            return true;
        }
        if (filters1 == null && filters2 != null) {
            return false;
        }
        if (filters1 != null && filters2 == null) {
            return false;
        }
        if (filters1.size() != filters2.size()) {
            return false;
        }
        for (int i = 0; i < filters1.size(); ++i) {
            if (FilterDefnUtil.isEqualFilter((IFilterDefinition)filters1.get(i), (IFilterDefinition)filters2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isConflictFilter(List oldFilterList, List newFilterList) {
        if (oldFilterList == null || oldFilterList.size() == 0) {
            return false;
        }
        if (newFilterList == null || newFilterList.size() < oldFilterList.size()) {
            return true;
        }
        for (int i = 0; i < oldFilterList.size(); ++i) {
            IFilterDefinition newFilter;
            IFilterDefinition oldFilter = (IFilterDefinition)oldFilterList.get(i);
            if (FilterDefnUtil.isEqualFilter(oldFilter, newFilter = (IFilterDefinition)newFilterList.get(i))) continue;
            return true;
        }
        return false;
    }

    public static List getRealFilterList(List oldFilterList, List newFilterList) throws DataException {
        if (oldFilterList == null || oldFilterList.size() == 0) {
            return newFilterList;
        }
        if (newFilterList == null || newFilterList.size() < oldFilterList.size()) {
            throw new DataException("data.engine.rd.errorfilters");
        }
        for (int i = 0; i < oldFilterList.size(); ++i) {
            IFilterDefinition newFilter;
            IFilterDefinition oldFilter = (IFilterDefinition)oldFilterList.get(i);
            if (FilterDefnUtil.isEqualFilter(oldFilter, newFilter = (IFilterDefinition)newFilterList.get(i))) continue;
            throw new DataException("data.engine.rd.errorfilters");
        }
        ArrayList updatedList = new ArrayList();
        for (int i = oldFilterList.size(); i < newFilterList.size(); ++i) {
            updatedList.add(newFilterList.get(i));
        }
        return updatedList;
    }

    public static int hashCode(List filterList) {
        int hashValue = 0;
        if (filterList == null || filterList.size() == 0) {
            hashValue = 0;
        } else {
            for (int i = 0; i < filterList.size(); ++i) {
                IFilterDefinition filterDefn = (IFilterDefinition)filterList.get(i);
                IBaseExpression baesExpr = filterDefn.getExpression();
                hashValue += ExprUtil.hashCode(baesExpr);
            }
        }
        return hashValue;
    }
}

