/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document.util;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.document.RowSaveUtil;
import org.eclipse.birt.data.engine.impl.document.util.IExprDataReader;
import org.eclipse.birt.data.engine.impl.document.viewing.RowIndexUtil;

class ExprDataReader2
implements IExprDataReader {
    private RAInputStream rowExprsIs;
    private RAInputStream rowLenIs;
    private DataInputStream rowExprsDis;
    protected int rowCount;
    private int lastRowIndex;
    private int currRowIndex;
    private int currRowLenReadIndex;
    private RowIndexUtil rowIndexUtil;
    private int nextDestIndex;
    private Map exprValueMap;
    private Map rowIDMap;
    private List exprKeys;
    private int metaOffset;

    ExprDataReader2(RAInputStream rowExprsIs, RAInputStream rowLenIs) throws DataException {
        try {
            IOUtil.readInt((InputStream)rowExprsIs);
            int exprCount = IOUtil.readInt((InputStream)rowExprsIs);
            this.exprKeys = new ArrayList();
            this.rowExprsDis = new DataInputStream((InputStream)rowExprsIs);
            for (int i = 0; i < exprCount; ++i) {
                this.exprKeys.add(IOUtil.readString((DataInputStream)this.rowExprsDis));
            }
            this.metaOffset = 4 + IOUtil.readInt((InputStream)this.rowExprsDis) + 4;
        }
        catch (IOException e) {
            throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, "Result Data");
        }
        this.rowExprsIs = rowExprsIs;
        this.rowLenIs = rowLenIs;
        this.currRowIndex = -1;
        this.lastRowIndex = -1;
        this.currRowLenReadIndex = 0;
        this.rowIDMap = new HashMap();
    }

    ExprDataReader2(RAInputStream rowExprsIs, RAInputStream rowLenIs, RAInputStream rowInfoIs) throws DataException {
        this(rowExprsIs, rowLenIs);
        this.rowIndexUtil = new RowIndexUtil((InputStream)rowInfoIs);
        try {
            this.rowCount = (int)(rowInfoIs.length() / 4L);
        }
        catch (IOException e) {
            throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, "Result Data");
        }
    }

    public int getCount() {
        return this.rowCount;
    }

    public int getRowId() {
        int destIndex = (Integer)this.rowIDMap.get(new Integer(this.currRowIndex));
        return destIndex;
    }

    public int getRowIndex() {
        if (this.currRowIndex >= this.rowCount) {
            return this.rowCount;
        }
        return this.currRowIndex;
    }

    public boolean next() {
        boolean hasNext;
        ++this.currRowIndex;
        boolean bl = hasNext = this.currRowIndex < this.rowCount;
        if (hasNext) {
            this.nextDestIndex = this.getNextDestIndex(this.currRowIndex);
            this.rowIDMap.put(new Integer(this.currRowIndex), new Integer(this.nextDestIndex));
        }
        return hasNext;
    }

    protected int getNextDestIndex(int currIndex) {
        return this.rowIndexUtil.read();
    }

    public Map getRowValue() throws DataException {
        if (this.lastRowIndex == this.currRowIndex) {
            return this.exprValueMap;
        }
        this.lastRowIndex = this.currRowIndex;
        try {
            this.skipTo(this.nextDestIndex);
            this.exprValueMap = this.getValueMap();
        }
        catch (IOException e) {
            throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, "Result Data");
        }
        return this.exprValueMap;
    }

    private void skipTo(int absoluteIndex) throws IOException, DataException {
        if (this.currRowLenReadIndex == absoluteIndex) {
            return;
        }
        this.currRowLenReadIndex = absoluteIndex + 1;
        this.rowLenIs.seek((long)(absoluteIndex * 4));
        this.rowExprsIs.seek((long)(IOUtil.readInt((InputStream)this.rowLenIs) + this.metaOffset));
        this.rowExprsDis = new DataInputStream((InputStream)this.rowExprsIs);
    }

    private Map getValueMap() throws IOException {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        int exprCount = IOUtil.readInt((InputStream)this.rowExprsDis);
        for (int i = 0; i < exprCount; ++i) {
            String exprID = this.exprKeys.get(i).toString();
            Object exprValue = IOUtil.readObject((DataInputStream)this.rowExprsDis);
            if (RowSaveUtil.EXCEPTION_INDICATOR.equals(exprValue)) {
                exprValue = null;
            }
            valueMap.put(exprID, exprValue);
        }
        return valueMap;
    }

    public void close() {
        try {
            if (this.rowExprsDis != null) {
                this.rowExprsDis.close();
                this.rowExprsDis = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

