/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp.data;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.aperi.snmp.data.OID;

public class Mib {
    private Vector mibObjs = new Vector();

    public Object getObject(OID oID) {
        Object object = null;
        int[] nArray = new int[1];
        int n = this.findOid(oID, nArray);
        if (n >= 0) {
            object = ((MibObj)this.mibObjs.elementAt((int)n)).value;
        }
        return object;
    }

    public void setObject(OID oID, Object object) {
        this.createObject(oID, object, true);
    }

    public void createObject(OID oID, Object object) {
        this.createObject(oID, object, false);
    }

    public void createObject(OID oID, Object object, boolean bl) {
        int[] nArray = new int[1];
        int n = this.findOid(oID, nArray);
        MibObj mibObj = new MibObj(oID, object);
        if (n >= 0) {
            if (bl) {
                this.mibObjs.setElementAt(mibObj, n);
            } else {
                System.out.println("Create object failed: already in MIB");
            }
        } else {
            int n2 = nArray[0];
            if (n2 < 0) {
                this.mibObjs.addElement(mibObj);
            } else {
                this.mibObjs.insertElementAt(mibObj, n2);
            }
        }
    }

    public void deleteObject(OID oID) {
        int[] nArray = new int[1];
        int n = this.findOid(oID, nArray);
        if (n >= 0) {
            this.mibObjs.removeElementAt(n);
        }
    }

    public Object getNextObject(OID oID) {
        Object object = null;
        int[] nArray = new int[1];
        this.findOid(oID, nArray);
        if (nArray[0] >= 0) {
            object = ((MibObj)this.mibObjs.elementAt((int)nArray[0])).value;
        }
        return object;
    }

    public int indexOf(OID oID) {
        int[] nArray = new int[1];
        return this.findOid(oID, nArray);
    }

    private int findOid(OID oID, int[] nArray) {
        int n = -1;
        int n2 = 0;
        int n3 = this.mibObjs.size() - 1;
        int n4 = 0;
        if (this.mibObjs.size() == 0) {
            nArray[0] = -1;
            return -1;
        }
        if (oID.compareTo(((MibObj)this.mibObjs.lastElement()).oid) > 0) {
            nArray[0] = -1;
            return -1;
        }
        if (oID.compareTo(((MibObj)this.mibObjs.firstElement()).oid) < 0) {
            nArray[0] = 0;
            return -1;
        }
        int n5 = 0;
        while (n2 <= n3) {
            n4 = (n3 - n2) / 2 + n2;
            MibObj mibObj = (MibObj)this.mibObjs.elementAt(n4);
            int n6 = oID.compareTo(mibObj.oid);
            if (n6 == 0) {
                n = n4;
                n5 = n4 + 1;
                break;
            }
            if (n6 < 0) {
                n3 = n4 - 1;
                n5 = n4;
                continue;
            }
            n5 = n2 = n4 + 1;
        }
        if (n5 >= this.mibObjs.size()) {
            n5 = -1;
        }
        nArray[0] = n5;
        return n;
    }

    public int size() {
        return this.mibObjs.size();
    }

    public void removeElementAt(int n) {
        this.mibObjs.removeElementAt(n);
    }

    public void removeAll() {
        this.mibObjs.removeAllElements();
    }

    public OID getOidAt(int n) {
        OID oID = null;
        MibObj mibObj = (MibObj)this.mibObjs.elementAt(n);
        if (mibObj != null) {
            oID = mibObj.oid;
        }
        return oID;
    }

    public Object getValueAt(int n) {
        Object object = null;
        MibObj mibObj = (MibObj)this.mibObjs.elementAt(n);
        if (mibObj != null) {
            object = mibObj.value;
        }
        return object;
    }

    public void dump() {
        System.out.println(String.valueOf(this.mibObjs.size()) + " MIB Objects:");
        Enumeration enumeration = this.mibObjs.elements();
        while (enumeration.hasMoreElements()) {
            MibObj mibObj = (MibObj)enumeration.nextElement();
            System.out.print("\t" + mibObj.oid + ":  " + mibObj.value.toString());
        }
    }

    class MibObj {
        public OID oid;
        public Object value;

        public MibObj(OID oID, Object object) {
            this.oid = oID;
            this.value = object;
        }
    }
}

