/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.StructureIterator;
import org.eclipse.birt.report.model.api.ValueHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.command.PropertyCommand;
import org.eclipse.birt.report.model.core.CachedMemberRef;
import org.eclipse.birt.report.model.core.MemberRef;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.metadata.PropertyDefn;

public abstract class SimpleValueHandle
extends ValueHandle {
    public SimpleValueHandle(DesignElementHandle element) {
        super(element);
    }

    public abstract IPropertyDefn getDefn();

    public abstract Object getValue();

    public int getIntValue() {
        return ((PropertyDefn)this.getDefn()).getIntValue(this.getModule(), this.getValue());
    }

    public String getStringValue() {
        return ((PropertyDefn)this.getDefn()).getStringValue(this.getModule(), this.getValue());
    }

    public double getFloatValue() {
        return ((PropertyDefn)this.getDefn()).getFloatValue(this.getModule(), this.getValue());
    }

    public BigDecimal getNumberValue() {
        return ((PropertyDefn)this.getDefn()).getNumberValue(this.getModule(), this.getValue());
    }

    public ArrayList getListValue() {
        if (this.getDefn().getTypeCode() == 16 && this.getDefn().isList()) {
            return (ArrayList)this.getValue();
        }
        return null;
    }

    public String getDisplayValue() {
        return ((PropertyDefn)this.getDefn()).getDisplayValue(this.getModule(), this.getValue());
    }

    public StructureHandle getAt(int n) {
        CachedMemberRef structRef;
        Structure struct;
        if (this.isList() && (struct = ((MemberRef)(structRef = new CachedMemberRef(this.getReference(), n))).getStructure(this.getModule(), this.getElement())) != null) {
            return struct.getHandle(this, n);
        }
        return null;
    }

    public int getTypeCode() {
        return this.getDefn().getTypeCode();
    }

    public Iterator iterator() {
        if (this.isList()) {
            return new StructureIterator(this);
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public void setIntValue(int value) throws SemanticException {
        this.setValue(new Integer(value));
    }

    public void setStringValue(String value) throws SemanticException {
        this.setValue(value);
    }

    public void setFloatValue(double value) throws SemanticException {
        this.setValue(new Double(value));
    }

    public void setNumberValue(BigDecimal value) throws SemanticException {
        this.setValue(value);
    }

    public void clearValue() throws SemanticException {
        this.setValue(null);
    }

    public abstract void setValue(Object var1) throws SemanticException;

    public void removeItem(int posn) throws PropertyValueException {
        PropertyCommand cmd = new PropertyCommand(this.getModule(), this.getElement());
        cmd.removeItem(this.getReference(), posn);
    }

    public void removeItem(IStructure item) throws PropertyValueException {
        PropertyCommand cmd = new PropertyCommand(this.getModule(), this.getElement());
        cmd.removeItem(this.getReference(), item);
    }

    public void removeItems(List items) throws PropertyValueException {
        int i;
        if (items == null) {
            return;
        }
        ActivityStack stack = this.getModule().getActivityStack();
        ArrayList<IStructure> newItems = new ArrayList<IStructure>();
        for (i = 0; i < items.size(); ++i) {
            newItems.add(((StructureHandle)items.get(i)).getStructure());
        }
        stack.startTrans();
        try {
            for (i = 0; i < newItems.size(); ++i) {
                IStructure item = (IStructure)newItems.get(i);
                this.removeItem(item);
            }
        }
        catch (PropertyValueException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    public void replaceItem(IStructure oldItem, IStructure newItem) throws SemanticException {
        PropertyCommand cmd = new PropertyCommand(this.getModule(), this.getElement());
        cmd.replaceItem(this.getReference(), oldItem, newItem);
    }

    public StructureHandle addItem(IStructure item) throws SemanticException {
        if (item == null) {
            return null;
        }
        PropertyCommand cmd = new PropertyCommand(this.getModule(), this.getElement());
        cmd.addItem(this.getReference(), item);
        return ((Structure)item).getHandle(this);
    }

    public StructureHandle insertItem(IStructure item, int posn) throws SemanticException {
        if (item == null) {
            return null;
        }
        PropertyCommand cmd = new PropertyCommand(this.getModule(), this.getElement());
        cmd.insertItem(this.getReference(), item, posn);
        return ((Structure)item).getHandle(this);
    }

    public void moveItem(int from, int to) throws PropertyValueException {
        PropertyCommand cmd = new PropertyCommand(this.getModule(), this.getElement());
        cmd.moveItem(this.getReference(), from, to);
    }

    public IChoice[] getChoices() {
        IPropertyDefn propDefn = this.getDefn();
        return propDefn.getChoices() == null ? null : propDefn.getChoices().getChoices();
    }

    protected boolean isList() {
        return this.getDefn().getTypeCode() == 16 && this.getDefn().isList();
    }

    public String getDefaultUnit() {
        if (this.getTypeCode() == 3) {
            PropertyDefn defn = (PropertyDefn)this.getDefn();
            String unit = defn.getDefaultUnit();
            if (!StringUtil.isBlank(unit)) {
                return unit;
            }
            unit = this.getModule().getUnits();
            if (!StringUtil.isBlank(unit)) {
                return unit;
            }
            if (this.getModule().getSession() != null) {
                return this.getModule().getSession().getUnits();
            }
        }
        return "";
    }

    public abstract boolean isVisible();

    public abstract boolean isReadOnly();
}

