/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.elements.table;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.elements.table.LayoutCell;
import org.eclipse.birt.report.model.api.elements.table.LayoutSlot;
import org.eclipse.birt.report.model.elements.Cell;

public class LayoutRow {
    private int rowId;
    private List cells;
    private LayoutSlot container = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    LayoutRow(LayoutSlot container, int rowId) {
        this.container = container;
        this.rowId = rowId;
        this.cells = new ArrayList();
    }

    public LayoutCell getLayoutCell(int colId) {
        if (colId < 0 || colId > this.cells.size() - 1) {
            return null;
        }
        return (LayoutCell)this.cells.get(colId);
    }

    protected LayoutCell getLayoutCell(CellHandle cell) {
        for (int i = 0; i < this.cells.size(); ++i) {
            LayoutCell layoutCell = (LayoutCell)this.cells.get(i);
            if (layoutCell.getContent() != cell.getElement()) continue;
            return layoutCell;
        }
        return null;
    }

    protected void addCell(LayoutCell cell) {
        this.cells.add(cell);
    }

    protected List checkOverlappedLayoutCells(int colId, int colSpan) {
        ArrayList<LayoutCell> retValue = new ArrayList<LayoutCell>();
        for (int i = 0; i < colSpan; ++i) {
            LayoutCell cell = this.getLayoutCell(colId + i);
            if (!cell.isUsed()) continue;
            retValue.add(cell);
        }
        return retValue;
    }

    protected void fillCells(int cellId, int colId, int colSpan, int rowSpanOffset, Cell content, boolean isEffectualDrop) {
        for (int i = 0; i < colSpan; ++i) {
            this.cells.set(colId + i, new LayoutCell(this, cellId, content, rowSpanOffset, i, isEffectualDrop));
        }
    }

    protected void fillDropSpannedCells(int cellId, int colId, int colSpan, int rowSpanOffset, Cell content) {
        for (int i = 0; i < colSpan; ++i) {
            this.cells.set(colId + i, new LayoutCell(this, cellId, content, rowSpanOffset, i));
        }
    }

    protected int findCellColumnPos(Cell cell) {
        for (int i = 0; i < this.cells.size(); ++i) {
            LayoutCell tmpCell = (LayoutCell)this.cells.get(i);
            if (!tmpCell.isUsed() || !cell.equals(tmpCell.getContent())) continue;
            if (!$assertionsDisabled && !tmpCell.isCellStartPosition()) {
                throw new AssertionError();
            }
            return i + 1;
        }
        return 0;
    }

    protected int getColumnCount() {
        return this.cells.size();
    }

    protected int getOccupiedColumnCount() {
        int retCount = 0;
        for (int i = 0; i < this.cells.size(); ++i) {
            if (!this.getLayoutCell(i).isUsed()) continue;
            ++retCount;
        }
        return retCount;
    }

    public String getLayoutString() {
        if (this.cells.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.cells.size(); ++i) {
            LayoutCell cell = (LayoutCell)this.cells.get(i);
            sb.append(cell.getLayoutString());
        }
        sb.append("\r\n");
        return sb.toString();
    }

    public RowHandle getRow() {
        int rowCount = this.container.getRowCount();
        if (this.rowId + 1 > rowCount) {
            return null;
        }
        SlotHandle slot = this.container.getSlot();
        return (RowHandle)slot.get(this.rowId);
    }

    protected LayoutSlot getContainer() {
        return this.container;
    }

    public Iterator layoutCellsIterator() {
        return new ArrayList(this.cells).iterator();
    }

    public Iterator cellsIterator() {
        LinkedHashSet<CellHandle> retValue = new LinkedHashSet<CellHandle>();
        for (int i = 0; i < this.cells.size(); ++i) {
            LayoutCell cell = (LayoutCell)this.cells.get(i);
            if (!cell.isUsed() || !cell.isCellStartPosition()) continue;
            retValue.add(cell.getCell());
        }
        return retValue.iterator();
    }

    protected int getRowPosn() {
        for (int i = 0; i < this.container.getRowCount(); ++i) {
            if (this.container.getLayoutRow(i) != this) continue;
            return i + 1;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return -1;
    }

    static {
        $assertionsDisabled = !LayoutRow.class.desiredAssertionStatus();
    }
}

